/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.folding;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.modules.web.core.syntax.JspSettings;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.folding.JspFoldTypes;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;

public class JspFoldManager
implements FoldManager,
SettingsChangeListener {
    private static final boolean SHOW_TIMES = Boolean.getBoolean("org.netbeans.modules.web.core.folding.measure");
    private FoldOperation operation;
    private JspSyntaxSupport sup;
    private Timer timer;
    private TimerTask timerTask;
    private int foldsUpdateInterval = -1;
    private long foldsGenerationTime = -1L;
    private boolean documentDirty = true;
    private ArrayList preparedFolds = new ArrayList();
    private ArrayList thisRunFolders = new ArrayList();
    private BaseDocument doc = null;
    private static final boolean debug = false;
    private static final boolean lightDebug = false;

    protected FoldOperation getOperation() {
        return this.operation;
    }

    public void init(FoldOperation operation) {
        this.operation = operation;
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
        this.foldsUpdateInterval = this.getSetting("code-folding-update-interval");
    }

    public void initFolds(FoldHierarchyTransaction transaction) {
        Document doc = this.getOperation().getHierarchy().getComponent().getDocument();
        if (doc instanceof BaseDocument) {
            this.doc = (BaseDocument)doc;
            this.sup = new JspSyntaxSupport(this.getDocument());
            this.timer = new Timer();
            this.restartTimer();
        }
    }

    private void restartTimer() {
        this.documentDirty = true;
        if (this.timer == null) {
            return;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = this.createTimerTask();
        this.timer.schedule(this.timerTask, this.foldsUpdateInterval);
    }

    private TimerTask createTimerTask() {
        return new TimerTask(){

            public void run() {
                Thread thr = new Thread(new Runnable(){

                    public void run() {
                        try {
                            JspFoldManager.this.documentDirty = false;
                            JspFoldManager.this.updateFolds();
                        }
                        catch (ParsingCancelledException parsingCancelledException) {
                            // empty catch block
                        }
                    }
                });
                thr.setPriority(2);
                thr.start();
                try {
                    thr.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    public void release() {
        Settings.removeSettingsChangeListener((SettingsChangeListener)this);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.restartTimer();
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.restartTimer();
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeEmptyNotify(Fold epmtyFold) {
    }

    public void removeDamagedNotify(Fold damagedFold) {
    }

    public void expandNotify(Fold expandedFold) {
    }

    public void settingsChange(SettingsChangeEvent evt) {
        if (evt.getSettingName() == "code-folding-update-interval") {
            this.foldsUpdateInterval = this.getSetting("code-folding-update-interval");
            this.restartTimer();
        }
    }

    private List generateFolds() throws BadLocationException, ParsingCancelledException {
        int prevSelOffset;
        BaseDocument bdoc = this.getDocument();
        JspSyntaxSupport jspsup = (JspSyntaxSupport)bdoc.getSyntaxSupport().get(JspSyntaxSupport.class);
        HTMLSyntaxSupport htmlsup = (HTMLSyntaxSupport)bdoc.getSyntaxSupport().get(HTMLSyntaxSupport.class);
        int htmlSEEnd = -1;
        ArrayList<FoldInfo> found = new ArrayList<FoldInfo>(this.getDocument().getLength() / 100);
        SyntaxElement sel = jspsup.getElementChain(1);
        Stack stack = new Stack();
        org.netbeans.editor.ext.html.SyntaxElement htmlCommentStartElement = null;
        int n = prevSelOffset = sel != null ? sel.getElementOffset() : 0;
        while (sel != null) {
            if (this.documentDirty) {
                throw new ParsingCancelledException();
            }
            if (sel.getCompletionContext() == 4) {
                found.add(new FoldInfo(sel.getElementOffset(), sel.getElementOffset() + sel.getElementLength(), JspFoldTypes.COMMENT, "<%--...--%>"));
            } else if (sel.getCompletionContext() == 7) {
                found.add(new FoldInfo(sel.getElementOffset(), sel.getElementOffset() + sel.getElementLength(), JspFoldTypes.SCRIPTLET, "<%...%>"));
            } else if (sel.getCompletionContext() == 6) {
                org.netbeans.editor.ext.html.SyntaxElement htmlsel = htmlsup.getElementChain(sel.getElementOffset());
                while (htmlsel != null) {
                    if (this.documentDirty) {
                        throw new ParsingCancelledException();
                    }
                    if (htmlsel.getElementOffset() >= sel.getElementOffset()) {
                        TagSE tse;
                        if (htmlsel.getType() == 0) {
                            if (htmlCommentStartElement == null && htmlsel.getText().startsWith("<!--")) {
                                if (htmlsel.getText().endsWith("-->")) {
                                    found.add(new FoldInfo(htmlsel.getElementOffset(), htmlsel.getElementOffset() + htmlsel.getElementLength(), JspFoldTypes.HTML_COMMENT, "<!--...-->"));
                                } else {
                                    htmlCommentStartElement = htmlsel;
                                }
                            } else if (htmlCommentStartElement != null && htmlsel.getText().endsWith("-->")) {
                                found.add(new FoldInfo(htmlCommentStartElement.getElementOffset(), htmlsel.getElementOffset() + htmlsel.getElementLength(), JspFoldTypes.HTML_COMMENT, "<!--...-->"));
                                htmlCommentStartElement = null;
                            }
                        } else if (htmlsel.getType() == 4 && !htmlsel.getText().startsWith("<")) {
                            tse = new TagSE(htmlsel);
                            this.handleOpenTagElement(tse, found, stack);
                        } else if (htmlsel.getType() == 5 && !htmlsel.getText().startsWith("</")) {
                            tse = new TagSE(htmlsel);
                            this.handleEndTagElement(tse, found, stack);
                        }
                    }
                    htmlSEEnd = htmlsel.getElementOffset() + htmlsel.getElementLength();
                    if ((htmlsel = htmlsel.getNext()) == null) continue;
                    if (prevSelOffset >= htmlsel.getElementOffset()) {
                        this.notifyLoop((Document)bdoc, prevSelOffset);
                        return Collections.EMPTY_LIST;
                    }
                    prevSelOffset = htmlsel.getElementOffset();
                }
            } else if (sel.getCompletionContext() == 1) {
                TagSE tse = new TagSE(sel);
                this.handleOpenTagElement(tse, found, stack);
            } else if (sel.getCompletionContext() == 2) {
                TagSE tse = new TagSE(sel);
                this.handleEndTagElement(tse, found, stack);
            }
            sel = sel.getNext();
            if (htmlSEEnd != -1 && sel != null) {
                int psoffs = sel.getElementOffset();
                while (sel != null && sel.getElementOffset() + sel.getElementLength() <= htmlSEEnd) {
                    if ((sel = sel.getNext()) == null) continue;
                    if (psoffs >= sel.getElementOffset()) {
                        this.notifyLoop((Document)bdoc, psoffs);
                        return Collections.EMPTY_LIST;
                    }
                    psoffs = sel.getElementOffset();
                }
                htmlSEEnd = -1;
            }
            if (sel == null) continue;
            if (prevSelOffset >= sel.getElementOffset()) {
                this.notifyLoop((Document)bdoc, prevSelOffset);
                return Collections.EMPTY_LIST;
            }
            prevSelOffset = sel.getElementOffset();
        }
        return found;
    }

    private void notifyLoop(Document doc, int offset) throws BadLocationException {
        StringBuffer sb = new StringBuffer();
        sb.append("A loop in SyntaxElement-s detected around offset " + offset + " when scanning the document. Please report this and attach the dumped document content:\n");
        sb.append(">>>>>\n");
        sb.append(doc.getText(0, doc.getLength()));
        sb.append("\n<<<<<\n");
        ErrorManager.getDefault().log(16, sb.toString());
    }

    private void handleOpenTagElement(TagSE tse, List found, Stack stack) {
        if (tse.isSingletonTag()) {
            found.add(new FoldInfo(tse.getElementOffset(), tse.getElementOffset() + tse.getElementLength(), JspFoldTypes.TAG, this.getSingletonTagFoldName(tse.getTagName())));
        } else {
            stack.push(tse);
        }
    }

    private void handleEndTagElement(TagSE tse, List found, Stack stack) {
        if (!stack.isEmpty()) {
            TagSE top = (TagSE)stack.peek();
            assert (top.isOpenTag());
            if (tse.getTagName().equalsIgnoreCase(top.getTagName())) {
                found.add(new FoldInfo(top.getElementOffset(), tse.getElementOffset() + tse.getElementLength(), JspFoldTypes.TAG, this.getTagFoldName(top.getTagName())));
                stack.pop();
            } else {
                ArrayList<TagSE> savedElements = new ArrayList<TagSE>();
                boolean foundStartTag = false;
                while (!stack.isEmpty()) {
                    TagSE start = (TagSE)stack.pop();
                    savedElements.add(start);
                    assert (start.isOpenTag());
                    if (!start.getTagName().equalsIgnoreCase(tse.getTagName())) continue;
                    found.add(new FoldInfo(start.getElementOffset(), tse.getElementOffset() + tse.getElementLength(), JspFoldTypes.TAG, this.getTagFoldName(start.getTagName())));
                    foundStartTag = true;
                    break;
                }
                if (!foundStartTag) {
                    for (int i = savedElements.size() - 1; i >= 0; --i) {
                        stack.push(savedElements.get(i));
                    }
                }
            }
        }
    }

    private String getSingletonTagFoldName(String tagName) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(tagName);
        sb.append("/>");
        return sb.toString();
    }

    private String getTagFoldName(String tagName) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(tagName);
        sb.append(">...</");
        sb.append(tagName);
        sb.append(">");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateFolds() throws ParsingCancelledException {
        FoldHierarchy fh = this.getOperation().getHierarchy();
        long startTime = System.currentTimeMillis();
        try {
            List generated = this.generateFolds();
            if (SHOW_TIMES) {
                System.out.println("[jsp folding] parsing of text of " + this.getDocument().getProperty((Object)"title") + " done in " + (System.currentTimeMillis() - startTime) + " millis.");
            }
            Iterator itr = generated.iterator();
            HashSet<FoldInfo> olfs = new HashSet<FoldInfo>();
            while (itr.hasNext()) {
                FoldInfo elem = (FoldInfo)itr.next();
                if (!this.isOneLineElement(elem)) continue;
                olfs.add(elem);
            }
            generated.removeAll(olfs);
            List existingFolds = FoldUtilities.findRecursive((Fold)fh.getRootFold());
            assert (existingFolds != null) : "Existing folds is null!";
            final HashSet<FoldInfo> newborns = new HashSet<FoldInfo>(generated.size() / 2);
            final HashSet<Fold> zombies = new HashSet<Fold>(generated.size() / 2);
            Iterator genItr = generated.iterator();
            Hashtable<Integer, FoldInfo> newbornsLinesCache = new Hashtable<Integer, FoldInfo>();
            HashSet<FoldInfo> duplicateNewborns = new HashSet<FoldInfo>();
            while (genItr.hasNext()) {
                FoldInfo fi = (FoldInfo)genItr.next();
                int fiLineOffset = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)fi.startOffset);
                FoldInfo found = (FoldInfo)newbornsLinesCache.get(new Integer(fiLineOffset));
                if (found != null && found.endOffset < fi.endOffset) {
                    duplicateNewborns.add(found);
                }
                newbornsLinesCache.put(new Integer(fiLineOffset), fi);
                Fold fs = FoldUtilities.findNearestFold((FoldHierarchy)fh, (int)fi.startOffset);
                if (fs != null && fs.getStartOffset() == fi.startOffset && fs.getEndOffset() == fi.endOffset) {
                    if (fi.foldType == fs.getType() && fi.description.equals(fs.getDescription())) continue;
                    zombies.add(fs);
                    newborns.add(fi);
                    continue;
                }
                newborns.add(fi);
            }
            newborns.removeAll(duplicateNewborns);
            existingFolds.removeAll(zombies);
            Hashtable<Integer, Fold> linesToFoldsCache = new Hashtable<Integer, Fold>();
            for (Fold f : existingFolds) {
                Iterator genItr2 = generated.iterator();
                boolean found = false;
                while (genItr2.hasNext()) {
                    FoldInfo fi = (FoldInfo)genItr2.next();
                    if (f.getStartOffset() != fi.startOffset || f.getEndOffset() != fi.endOffset) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    zombies.add(f);
                    continue;
                }
                int lineoffset = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)f.getStartOffset());
                linesToFoldsCache.put(new Integer(lineoffset), f);
            }
            Iterator newbornsItr = newborns.iterator();
            HashSet<FoldInfo> newbornsToRemove = new HashSet<FoldInfo>();
            while (newbornsItr.hasNext()) {
                FoldInfo fi = (FoldInfo)newbornsItr.next();
                Fold existing = (Fold)linesToFoldsCache.get(new Integer(Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)fi.startOffset)));
                if (existing == null) continue;
                if (existing.getEndOffset() < fi.endOffset) {
                    zombies.add(existing);
                    continue;
                }
                newbornsToRemove.add(fi);
            }
            newborns.removeAll(newbornsToRemove);
            if (SHOW_TIMES) {
                System.out.println("[jsp folding] parsing and mangles with elements for " + this.getDocument().getProperty((Object)"title") + " done in " + (System.currentTimeMillis() - startTime) + " millis.");
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    JspFoldManager.this.getDocument().readLock();
                    try {
                        FoldHierarchy fh = JspFoldManager.this.getOperation().getHierarchy();
                        fh.lock();
                        try {
                            FoldHierarchyTransaction fhTran = JspFoldManager.this.getOperation().openTransaction();
                            try {
                                for (Fold f : zombies) {
                                    if (JspFoldManager.this.getDocument().getLength() == 0) break;
                                    JspFoldManager.this.getOperation().removeFromHierarchy(f, fhTran);
                                }
                                for (FoldInfo f : newborns) {
                                    if (JspFoldManager.this.getDocument().getLength() == 0) {
                                        break;
                                    }
                                    if (f.startOffset < 0 || f.endOffset < 0 || f.startOffset >= f.endOffset || f.endOffset > JspFoldManager.this.getDocument().getLength()) continue;
                                    JspFoldManager.this.getOperation().addToHierarchy(f.foldType, f.description, false, f.startOffset, f.endOffset, 0, 0, null, fhTran);
                                }
                            }
                            catch (BadLocationException ble) {
                                Document fhDoc = JspFoldManager.this.getOperation().getHierarchy().getComponent().getDocument();
                                if (fhDoc.getLength() > 0) {
                                    ErrorManager.getDefault().notify((Throwable)ble);
                                }
                            }
                            finally {
                                fhTran.commit();
                            }
                        }
                        finally {
                            fh.unlock();
                        }
                    }
                    finally {
                        JspFoldManager.this.getDocument().readUnlock();
                    }
                }
            });
        }
        catch (BadLocationException e) {
            Document fhDoc = this.getOperation().getHierarchy().getComponent().getDocument();
            if (fhDoc.getLength() > 0) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        catch (InterruptedException ie) {
        }
        catch (InvocationTargetException ite) {
            ErrorManager.getDefault().notify((Throwable)ite);
        }
        catch (ParsingCancelledException pce) {
            throw new ParsingCancelledException();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        long foldsGenerationTime = System.currentTimeMillis() - startTime;
        if (SHOW_TIMES) {
            System.out.println("jsp folding] folds for " + this.getDocument().getProperty((Object)"title") + " generated in " + foldsGenerationTime + " millis.");
        }
    }

    private boolean isOneLineElement(FoldInfo fi) throws BadLocationException {
        return Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)fi.startOffset) == Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)fi.endOffset);
    }

    private boolean foldsBoundariesEquals(Fold f1, Fold f2) {
        return f1.getStartOffset() == f2.getStartOffset() && f1.getEndOffset() == f2.getEndOffset();
    }

    private int getSetting(String settingName) {
        JTextComponent tc = this.getOperation().getHierarchy().getComponent();
        return SettingsUtil.getInteger((Class)Utilities.getKitClass((JTextComponent)tc), (String)settingName, (Integer)JspSettings.defaultCodeFoldingUpdateInterval);
    }

    private BaseDocument getDocument() {
        return this.doc;
    }

    public long getLastFoldsGenerationTime() {
        return this.foldsGenerationTime;
    }

    private static class ParsingCancelledException
    extends Exception {
    }

    private static class TagSE {
        private SyntaxElement.Named htmlse = null;
        private SyntaxElement.TagLikeElement jspse = null;

        public TagSE(Object se) {
            if (se instanceof SyntaxElement.Named) {
                this.htmlse = (SyntaxElement.Named)se;
            } else if (se instanceof SyntaxElement.TagLikeElement) {
                this.jspse = (SyntaxElement.TagLikeElement)se;
            } else {
                throw new IllegalArgumentException("Object " + se + " is not a Tag SyntaxElement!");
            }
        }

        public boolean wrapsHTML() {
            return this.htmlse != null;
        }

        public boolean wrapsJSP() {
            return !this.wrapsHTML();
        }

        public int getElementOffset() {
            return this.wrapsHTML() ? this.htmlse.getElementOffset() - 1 : this.jspse.getElementOffset();
        }

        public int getElementLength() {
            return this.wrapsHTML() ? this.htmlse.getElementLength() + 1 : this.jspse.getElementLength();
        }

        public int getType() {
            return this.wrapsHTML() ? this.htmlse.getType() : this.jspse.getCompletionContext();
        }

        public boolean isOpenTag() {
            return this.wrapsHTML() ? this.htmlse.getType() == 4 : this.jspse.getCompletionContext() == 1;
        }

        public String getTagName() {
            return this.wrapsHTML() ? this.htmlse.getName() : this.jspse.getName();
        }

        public boolean isSingletonTag() {
            if (!this.isOpenTag()) {
                return false;
            }
            return this.wrapsHTML() ? ((SyntaxElement.Tag)this.htmlse).isEmpty() : ((SyntaxElement.Tag)this.jspse).isClosed();
        }
    }

    private static class FoldInfo {
        public int startOffset;
        public int endOffset;
        public FoldType foldType = null;
        public String description = null;

        public FoldInfo(int startOffset, int endOffset, FoldType foldType, String description) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.foldType = foldType;
            this.description = description;
        }

        public String toString() {
            return "FoldInfo[start=" + this.startOffset + ", end=" + this.endOffset + ", descr=" + this.description + ", type=" + this.foldType + "]";
        }
    }
}

