/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.TokenCategory;
import org.netbeans.modules.web.core.syntax.ELLayerTokenContext;
import org.netbeans.modules.web.core.syntax.ELTokenContext;

public class ELDrawLayerFactory {
    public static final String EL_LAYER_NAME = "jsp-el-layer";
    public static final int EL_LAYER_VISIBILITY = 1010;

    public static class LParenWatcher
    implements DocumentListener {
        NonWhitespaceBwdFinder nwFinder = new NonWhitespaceBwdFinder();

        private void check(DocumentEvent evt) {
            if (evt.getDocument() instanceof BaseDocument) {
                BaseDocument doc = (BaseDocument)evt.getDocument();
                BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
                char[] chars = bevt.getChars();
                if (chars != null) {
                    boolean found = false;
                    for (int i = chars.length - 1; i >= 0; --i) {
                        if (chars[i] != '(') continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        int offset = evt.getOffset();
                        int redrawOffset = 0;
                        if (offset > 0) {
                            try {
                                redrawOffset = doc.find((Finder)this.nwFinder, offset - 1, 0);
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace(System.out);
                            }
                            if (redrawOffset < 0) {
                                redrawOffset = 0;
                            }
                        }
                        doc.repaintBlock(redrawOffset, offset);
                    }
                }
            }
        }

        public void insertUpdate(DocumentEvent evt) {
            this.check(evt);
        }

        public void removeUpdate(DocumentEvent evt) {
            this.check(evt);
        }

        public void changedUpdate(DocumentEvent evt) {
        }
    }

    public static class NonWhitespaceBwdFinder
    extends FinderFactory.GenericBwdFinder {
        private char foundChar;

        public char getFoundChar() {
            return this.foundChar;
        }

        protected int scan(char ch, boolean lastChar) {
            if (!Character.isWhitespace(ch)) {
                this.found = true;
                this.foundChar = ch;
                return 0;
            }
            return -1;
        }
    }

    static class NonWhitespaceFwdFinder
    extends FinderFactory.GenericFwdFinder {
        private char foundChar;

        NonWhitespaceFwdFinder() {
        }

        public char getFoundChar() {
            return this.foundChar;
        }

        protected int scan(char ch, boolean lastChar) {
            if (!Character.isWhitespace(ch)) {
                this.found = true;
                this.foundChar = ch;
                return 0;
            }
            return 1;
        }
    }

    public static class ELLayer
    extends DrawLayer.AbstractLayer {
        private int resolvedEndOffset;
        private boolean resolvedValue;
        private NonWhitespaceFwdFinder nwFinder = new NonWhitespaceFwdFinder();

        public ELLayer() {
            super(ELDrawLayerFactory.EL_LAYER_NAME);
        }

        public void init(DrawContext ctx) {
            this.resolvedEndOffset = 0;
        }

        public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
            int nextOffset = ctx.getTokenOffset() + ctx.getTokenLength();
            this.setNextActivityChangeOffset(nextOffset);
            return true;
        }

        protected Coloring getMethodColoring(DrawContext ctx) {
            return ctx.getEditorUI().getColoring(ELLayerTokenContext.contextPath.getFullTokenName((TokenCategory)ELLayerTokenContext.METHOD));
        }

        private boolean isMethod(DrawContext ctx) {
            int idEndOffset = ctx.getTokenOffset() + ctx.getTokenLength();
            if (idEndOffset > this.resolvedEndOffset) {
                this.resolvedEndOffset = idEndOffset;
                int endOffset = ctx.getEndOffset();
                int bufferStartOffset = ctx.getBufferStartOffset();
                char[] buffer = ctx.getBuffer();
                int nwOffset = Analyzer.findFirstNonWhite((char[])buffer, (int)(idEndOffset - bufferStartOffset), (int)(endOffset - idEndOffset));
                if (nwOffset >= 0) {
                    this.resolvedValue = buffer[nwOffset] == '(';
                } else {
                    try {
                        this.resolvedValue = ctx.getEditorUI().getDocument().find((Finder)this.nwFinder, endOffset, -1) >= 0 && this.nwFinder.getFoundChar() == '(';
                    }
                    catch (BadLocationException e) {
                        this.resolvedValue = false;
                    }
                }
            }
            return this.resolvedValue;
        }

        public void updateContext(DrawContext ctx) {
            Coloring mc;
            if (ctx.getTokenID() == ELTokenContext.IDENTIFIER && this.isMethod(ctx) && (mc = this.getMethodColoring(ctx)) != null) {
                mc.apply(ctx);
            }
        }
    }
}

