/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbfreeform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.metadata.MetadataUnit;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarFactory;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarsInProject;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

public class EJBModules
implements EjbJarProvider,
EjbJarsInProject,
AntProjectListener,
ClassPathProvider {
    private ArrayList modules = new ArrayList();
    private HashMap cache = new HashMap();
    private Project project;
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EJBModules(Project project, AntProjectHelper helper, PropertyEvaluator evaluator) {
        if (!$assertionsDisabled && project == null) {
            throw new AssertionError();
        }
        this.project = project;
        this.helper = helper;
        this.evaluator = evaluator;
        helper.addAntProjectListener((AntProjectListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EjbJar findEjbJar(FileObject file) {
        Project owner = FileOwnerQuery.getOwner((FileObject)file);
        EJBModules eJBModules = this;
        synchronized (eJBModules) {
            if (this.project.equals(owner)) {
                if (this.modules.isEmpty()) {
                    this.readAuxData();
                }
                Iterator iter = this.modules.iterator();
                while (iter.hasNext()) {
                    FFEJBModule wm = (FFEJBModule)iter.next();
                    if (!wm.contais(file)) continue;
                    if (this.cache.get(wm) == null) {
                        this.cache.put(wm, EjbJarFactory.createEjbJar((EjbJarImplementation)wm));
                    }
                    return (EjbJar)this.cache.get(wm);
                }
            }
            return null;
        }
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (!"classpath/source".equals(type)) {
            return null;
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)file);
        if (owner != null && owner.equals(this.project)) {
            if (this.modules == null) {
                this.readAuxData();
            }
            Iterator iter = this.modules.iterator();
            while (iter.hasNext()) {
                FFEJBModule wm = (FFEJBModule)iter.next();
                if (!wm.contais(file)) continue;
                return wm.findClassPath(file, type);
            }
        }
        return null;
    }

    public synchronized void readAuxData() {
        this.modules.clear();
        this.cache.clear();
        AuxiliaryConfiguration aux = (AuxiliaryConfiguration)this.project.getLookup().lookup(AuxiliaryConfiguration.class);
        if (!$assertionsDisabled && aux == null) {
            throw new AssertionError();
        }
        Element ejb = aux.getConfigurationFragment("ejb-data", "http://www.netbeans.org/ns/freeform-project-ejb/2", true);
        String namespace = "http://www.netbeans.org/ns/freeform-project-ejb/2";
        if (ejb == null) {
            ejb = aux.getConfigurationFragment("ejb-data", "http://www.netbeans.org/ns/freeform-project-ejb/1", true);
            namespace = "http://www.netbeans.org/ns/freeform-project-ejb/1";
        }
        if (ejb == null) {
            return;
        }
        List ejbModules = org.netbeans.modules.ant.freeform.spi.support.Util.findSubElements((Element)ejb);
        Iterator it = ejbModules.iterator();
        while (it.hasNext()) {
            Element ejbModulesEl = (Element)it.next();
            if (!$assertionsDisabled && !ejbModulesEl.getLocalName().equals("ejb-module")) {
                throw new AssertionError(ejbModulesEl);
            }
            FileObject configFilesFO = this.getFile(ejbModulesEl, "config-files");
            Element j2eeSpecEl = org.netbeans.modules.ant.freeform.spi.support.Util.findElement((Element)ejbModulesEl, (String)"j2ee-spec-level", (String)namespace);
            String j2eeSpec = j2eeSpecEl == null ? null : this.evaluator.evaluate(org.netbeans.modules.ant.freeform.spi.support.Util.findText((Element)j2eeSpecEl));
            Element classpathEl = org.netbeans.modules.ant.freeform.spi.support.Util.findElement((Element)ejbModulesEl, (String)"classpath", (String)namespace);
            FileObject[] sources = this.getSources(classpathEl);
            ClassPath cp = classpathEl == null ? null : this.createClasspath(classpathEl, sources);
            File[] j2eePlatformClasspath = Util.getJ2eePlatformClasspathEntries((Project)this.project);
            this.modules.add(new FFEJBModule(configFilesFO, j2eeSpec, sources, cp, j2eePlatformClasspath));
        }
    }

    private FileObject getFile(Element parent, String fileElName) {
        String fname;
        String locationEval;
        Element el = org.netbeans.modules.ant.freeform.spi.support.Util.findElement((Element)parent, (String)fileElName, (String)"http://www.netbeans.org/ns/freeform-project-ejb/2");
        if (el == null) {
            el = org.netbeans.modules.ant.freeform.spi.support.Util.findElement((Element)parent, (String)fileElName, (String)"http://www.netbeans.org/ns/freeform-project-ejb/1");
        }
        if ((locationEval = this.evaluator.evaluate(fname = org.netbeans.modules.ant.freeform.spi.support.Util.findText((Element)el))) != null) {
            File locationFile = this.helper.resolveFile(locationEval);
            return FileUtil.toFileObject((File)locationFile);
        }
        return null;
    }

    private FileObject[] getSources(Element classpathEl) {
        String cpEval;
        String cp = org.netbeans.modules.ant.freeform.spi.support.Util.findText((Element)classpathEl);
        if (cp == null) {
            cp = "";
        }
        if ((cpEval = this.evaluator.evaluate(cp)) == null) {
            return null;
        }
        String[] path = PropertyUtils.tokenizePath((String)cpEval);
        HashSet<FileObject> srcRootSet = new HashSet<FileObject>();
        for (int i = 0; i < path.length; ++i) {
            URL entry;
            File entryFile = this.helper.resolveFile(path[i]);
            try {
                entry = entryFile.toURI().toURL();
                if (!entryFile.exists() && !entry.toExternalForm().endsWith("/")) {
                    entry = new URL(entry.toExternalForm() + "/");
                }
            }
            catch (MalformedURLException x) {
                throw new AssertionError((Object)x);
            }
            if (FileUtil.isArchiveFile((URL)entry)) {
                entry = FileUtil.getArchiveRoot((URL)entry);
            }
            SourceForBinaryQuery.Result res = SourceForBinaryQuery.findSourceRoots((URL)entry);
            FileObject[] srcForBin = res.getRoots();
            for (int j = 0; j < srcForBin.length; ++j) {
                srcRootSet.add(srcForBin[j]);
            }
            if (srcForBin.length != 0) continue;
            srcRootSet.add(FileUtil.toFileObject((File)entryFile));
        }
        SourceGroup[] sg = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        HashSet<FileObject> filteredSources = new HashSet<FileObject>();
        for (int i = 0; i < sg.length; ++i) {
            if (path.length != 0 && !srcRootSet.contains(sg[i].getRootFolder())) continue;
            filteredSources.add(sg[i].getRootFolder());
        }
        return filteredSources.toArray(new FileObject[filteredSources.size()]);
    }

    private ClassPath createClasspath(Element classpathEl, FileObject[] sources) {
        int i;
        String cpEval;
        String cp = org.netbeans.modules.ant.freeform.spi.support.Util.findText((Element)classpathEl);
        if (cp == null) {
            cp = "";
        }
        if ((cpEval = this.evaluator.evaluate(cp)) == null) {
            return null;
        }
        String[] path = PropertyUtils.tokenizePath((String)cpEval);
        HashSet<File> entries = new HashSet<File>();
        for (i = 0; i < path.length; ++i) {
            entries.add(this.helper.resolveFile(path[i]));
        }
        if (entries.size() == 0) {
            for (i = 0; i < sources.length; ++i) {
                entries.add(FileUtil.toFile((FileObject)sources[i]));
            }
        }
        URL[] pathURL = new URL[entries.size()];
        int i2 = 0;
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            URL entry;
            File entryFile = (File)it.next();
            try {
                entry = entryFile.toURI().toURL();
                if (FileUtil.isArchiveFile((URL)entry)) {
                    entry = FileUtil.getArchiveRoot((URL)entry);
                } else {
                    String s = entry.toExternalForm();
                    if (!s.endsWith("/")) {
                        entry = new URL(s + '/');
                    }
                }
            }
            catch (MalformedURLException x) {
                throw new AssertionError((Object)x);
            }
            pathURL[i2++] = entry;
        }
        return ClassPathSupport.createClassPath((URL[])pathURL);
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.readAuxData();
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    public EjbJar[] getEjbJars() {
        if (this.modules.isEmpty()) {
            this.readAuxData();
        }
        EjbJar[] results = new EjbJar[this.modules.size()];
        int i = 0;
        Iterator iter = this.modules.iterator();
        while (iter.hasNext()) {
            FFEJBModule ejbm = (FFEJBModule)iter.next();
            if (this.cache.get(ejbm) == null) {
                results[i] = EjbJarFactory.createEjbJar((EjbJarImplementation)ejbm);
                this.cache.put(ejbm, results[i]);
                continue;
            }
            results[i] = (EjbJar)this.cache.get(ejbm);
        }
        return results;
    }

    static {
        $assertionsDisabled = !EJBModules.class.desiredAssertionStatus();
    }

    private static final class FFEJBModule
    implements EjbJarImplementation {
        public static final String FILE_DD = "ejb-jar.xml";
        private FileObject configFilesFO;
        private FileObject[] sourcesFOs;
        private ClassPath classPath;
        private String j2eeSpec;
        private MetadataUnit metadataUnit;
        private ClassPath metadataClassPath;
        private File[] j2eePlatformClasspath;

        FFEJBModule(FileObject configFilesFO, String j2eeSpec, FileObject[] sourcesFOs, ClassPath classPath, File[] j2eePlatformClasspath) {
            this.configFilesFO = configFilesFO;
            this.j2eeSpec = j2eeSpec;
            this.sourcesFOs = sourcesFOs;
            this.classPath = classPath;
            this.j2eePlatformClasspath = j2eePlatformClasspath;
        }

        boolean contais(FileObject fo) {
            if (this.configFilesFO == fo || FileUtil.isParentOf((FileObject)this.configFilesFO, (FileObject)fo)) {
                return true;
            }
            for (int i = 0; i < this.sourcesFOs.length; ++i) {
                if (this.sourcesFOs[i] != fo && !FileUtil.isParentOf((FileObject)this.sourcesFOs[i], (FileObject)fo)) continue;
                return true;
            }
            return false;
        }

        public ClassPath findClassPath(FileObject file, String type) {
            return this.classPath;
        }

        public String getJ2eePlatformVersion() {
            return this.j2eeSpec;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("EJB module in freeform project\n\tconfig files:" + this.configFilesFO.getPath() + "\n\tj2ee version:" + this.j2eeSpec);
            for (int i = 0; i < this.sourcesFOs.length; ++i) {
                sb.append("\n\tsource root:" + this.sourcesFOs[i].getPath());
            }
            return sb.toString();
        }

        public FileObject getDeploymentDescriptor() {
            return this.getMetaInf().getFileObject(FILE_DD);
        }

        public FileObject getMetaInf() {
            return this.configFilesFO;
        }

        public FileObject[] getJavaSources() {
            return this.sourcesFOs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MetadataUnit getMetadataUnit() {
            FFEJBModule fFEJBModule = this;
            synchronized (fFEJBModule) {
                if (this.metadataUnit == null) {
                    this.metadataUnit = new MetadataUnitImpl();
                }
                return this.metadataUnit;
            }
        }

        private class MetadataUnitImpl
        implements MetadataUnit {
            private MetadataUnitImpl() {
            }

            public ClassPath getClassPath() {
                return FFEJBModule.this.classPath;
            }

            public FileObject getDeploymentDescriptor() {
                return FFEJBModule.this.getDeploymentDescriptor();
            }
        }
    }
}

