/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.lang.reflect.Method;
import java.util.Iterator;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.text.IndentEngine;
import org.openide.util.Lookup;

class IndentationModel {
    private boolean originalExpandedTabs = this.isExpandTabs();
    private boolean originalAddStar = this.getJavaFormatLeadingStarInComment();
    private boolean originalNewLine = this.getJavaFormatNewlineBeforeBrace();
    private boolean originalSpace = this.getJavaFormatSpaceBeforeParenthesis();
    private int originalStatementIndent = this.getJavaFormatStatementContinuationIndent();
    private int originalIndent = this.getSpacesPerTab();
    private boolean changed = false;
    private IndentEngine javaIndentEngine;
    private ClassLoader classLoader;

    IndentationModel() {
    }

    boolean isExpandTabs() {
        return (Boolean)this.getParameter("isExpandTabs", Boolean.FALSE);
    }

    void setExpandTabs(boolean expand) {
        this.setParameter("setExpandTabs", expand, Boolean.TYPE);
        this.updateChanged();
    }

    boolean getJavaFormatLeadingStarInComment() {
        return (Boolean)this.getParameter("getJavaFormatLeadingStarInComment", Boolean.FALSE);
    }

    void setJavaFormatLeadingStarInComment(boolean star) {
        this.setParameter("setJavaFormatLeadingStarInComment", star, Boolean.TYPE);
        this.updateChanged();
    }

    boolean getJavaFormatSpaceBeforeParenthesis() {
        return (Boolean)this.getParameter("getJavaFormatSpaceBeforeParenthesis", Boolean.FALSE);
    }

    void setJavaFormatSpaceBeforeParenthesis(boolean space) {
        this.setParameter("setJavaFormatSpaceBeforeParenthesis", space, Boolean.TYPE);
        this.updateChanged();
    }

    boolean getJavaFormatNewlineBeforeBrace() {
        return (Boolean)this.getParameter("getJavaFormatNewlineBeforeBrace", Boolean.FALSE);
    }

    void setJavaFormatNewlineBeforeBrace(boolean newLine) {
        this.setParameter("setJavaFormatNewlineBeforeBrace", newLine, Boolean.TYPE);
        this.updateChanged();
    }

    Integer getJavaFormatStatementContinuationIndent() {
        return (Integer)this.getParameter("getJavaFormatStatementContinuationIndent", new Integer(4));
    }

    void setJavaFormatStatementContinuationIndent(Integer continuation) {
        if (continuation > 0) {
            this.setParameter("setJavaFormatStatementContinuationIndent", continuation, Integer.TYPE);
        }
        this.updateChanged();
    }

    Integer getSpacesPerTab() {
        return (Integer)this.getParameter("getSpacesPerTab", new Integer(4));
    }

    void setSpacesPerTab(Integer spaces) {
        if (spaces > 0) {
            this.setParameter("setSpacesPerTab", spaces, Integer.TYPE);
        }
        this.updateChanged();
    }

    boolean isChanged() {
        return this.changed;
    }

    void revertChanges() {
        if (!this.changed) {
            return;
        }
        if (this.getJavaFormatLeadingStarInComment() != this.originalAddStar) {
            this.setJavaFormatLeadingStarInComment(this.originalAddStar);
        }
        if (this.getJavaFormatNewlineBeforeBrace() != this.originalNewLine) {
            this.setJavaFormatNewlineBeforeBrace(this.originalNewLine);
        }
        if (this.getJavaFormatSpaceBeforeParenthesis() != this.originalSpace) {
            this.setJavaFormatSpaceBeforeParenthesis(this.originalSpace);
        }
        if (this.isExpandTabs() != this.originalExpandedTabs) {
            this.setExpandTabs(this.originalExpandedTabs);
        }
        if (this.getJavaFormatStatementContinuationIndent() != this.originalStatementIndent && this.originalStatementIndent > 0) {
            this.setJavaFormatStatementContinuationIndent(new Integer(this.originalStatementIndent));
        }
        if (this.getSpacesPerTab() != this.originalIndent && this.originalIndent > 0) {
            this.setSpacesPerTab(new Integer(this.originalIndent));
        }
    }

    private void updateChanged() {
        this.changed = this.isExpandTabs() != this.originalExpandedTabs || this.getJavaFormatLeadingStarInComment() != this.originalAddStar || this.getJavaFormatNewlineBeforeBrace() != this.originalNewLine || this.getJavaFormatSpaceBeforeParenthesis() != this.originalSpace || this.getJavaFormatStatementContinuationIndent() != this.originalStatementIndent || this.getSpacesPerTab() != this.originalIndent;
    }

    private Object getParameter(String parameterName, Object defaultValue) {
        if (this.javaIndentEngine == null) {
            BaseOptions options = IndentationModel.getOptions("text/x-java");
            if (options == null) {
                options = IndentationModel.getOptions("text/plain");
            }
            if (options == null) {
                return defaultValue;
            }
            this.javaIndentEngine = options.getIndentEngine();
        }
        try {
            Method method = this.javaIndentEngine.getClass().getMethod(parameterName, new Class[0]);
            return method.invoke((Object)this.javaIndentEngine, new Object[0]);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    private void setParameter(String parameterName, Object parameterValue, Class parameterType) {
        Iterator it = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        while (it.hasNext()) {
            Class optionsClass = (Class)it.next();
            BaseOptions baseOptions = (BaseOptions)BaseOptions.findObject((Class)optionsClass, (boolean)true);
            IndentEngine indentEngine = baseOptions.getIndentEngine();
            try {
                if (baseOptions.getClass().getName().equals("org.netbeans.modules.java.editor.options.JavaOptions") && !indentEngine.getClass().getName().equals("org.netbeans.modules.editor.java.JavaIndentEngine")) {
                    Class<?> javaIndentEngineClass = this.getClassLoader().loadClass("org.netbeans.modules.editor.java.JavaIndentEngine");
                    indentEngine = (IndentEngine)Lookup.getDefault().lookup(javaIndentEngineClass);
                    baseOptions.setIndentEngine(indentEngine);
                }
                if (baseOptions.getClass().getName().equals("org.netbeans.modules.web.core.syntax.JSPOptions") && !indentEngine.getClass().getName().equals("org.netbeans.modules.web.core.syntax.JspIndentEngine")) {
                    Class<?> jspIndentEngineClass = this.getClassLoader().loadClass("org.netbeans.modules.web.core.syntax.JspIndentEngine");
                    indentEngine = (IndentEngine)Lookup.getDefault().lookup(jspIndentEngineClass);
                    baseOptions.setIndentEngine(indentEngine);
                }
                Method method = indentEngine.getClass().getMethod(parameterName, parameterType);
                method.invoke((Object)indentEngine, parameterValue);
            }
            catch (Exception ex) {}
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        }
        return this.classLoader;
    }

    private static BaseOptions getOptions(String mimeType) {
        Iterator it = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        while (it.hasNext()) {
            Class optionsClass = (Class)it.next();
            BaseOptions baseOptions = (BaseOptions)BaseOptions.findObject((Class)optionsClass, (boolean)true);
            BaseKit kit = BaseKit.getKit((Class)baseOptions.getKitClass());
            if (!kit.getContentType().equals(mimeType)) continue;
            return baseOptions;
        }
        return null;
    }
}

