/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.general;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.core.IDESettings;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;

class GeneralOptionsModel {
    GeneralOptionsModel() {
    }

    int getProxyType() {
        IDESettings ideSettings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
        if (ideSettings.getProxyType() == 0) {
            return 0;
        }
        if (ideSettings.getProxyType() == 1) {
            return 1;
        }
        return 2;
    }

    void setProxyType(int proxyType) {
        IDESettings ideSettings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
        switch (proxyType) {
            case 0: {
                ideSettings.setProxyType(0);
                break;
            }
            case 1: {
                ideSettings.setProxyType(1);
                break;
            }
            default: {
                ideSettings.setProxyType(2);
            }
        }
    }

    String getProxyHost() {
        IDESettings ideSettings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
        return ideSettings.getUserProxyHost();
    }

    void setProxyHost(String proxyHost) {
        IDESettings ideSettings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
        ideSettings.setUserProxyHost(proxyHost);
    }

    int getProxyPort() {
        IDESettings ideSettings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
        try {
            return Integer.parseInt(ideSettings.getUserProxyPort());
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    void setProxyPort(int proxyPort) {
        IDESettings ideSettings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
        ideSettings.setUserProxyPort("" + proxyPort);
    }

    String getUserNonProxy() {
        IDESettings ideSettings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
        return GeneralOptionsModel.code2view(ideSettings.getUserNonProxyHosts());
    }

    void setUserNonProxy(String nonProxy) {
        IDESettings ideSettings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
        ideSettings.setUserNonProxyHosts(GeneralOptionsModel.view2code(nonProxy));
    }

    boolean getAutoUpdateAskBeforeCheck() {
        Settings settings = (Settings)Settings.findObject((Class)Settings.class, (boolean)true);
        return settings.isAskBefore();
    }

    void setAutoUpdateAskBeforeCheck(boolean ask) {
        Settings settings = (Settings)Settings.findObject((Class)Settings.class, (boolean)true);
        settings.setAskBefore(ask);
    }

    int getAutoUpdatePeriod() {
        Settings settings = (Settings)Settings.findObject((Class)Settings.class, (boolean)true);
        return settings.getPeriod();
    }

    void setAutoUpdatePeriod(int period) {
        Settings settings = (Settings)Settings.findObject((Class)Settings.class, (boolean)true);
        settings.setPeriod(period);
    }

    boolean isTextAntialiasing() {
        return AllOptionsFolder.getDefault().isTextAntialiasing();
    }

    void setTextAntialiasing(boolean textAntialiasing) {
        AllOptionsFolder.getDefault().setTextAntialiasing(textAntialiasing);
    }

    Map getCodeFoldingProperties() {
        return (Map)GeneralOptionsModel.getEditorOption("getCodeFoldingProps", "text/x-java");
    }

    void setCodeFoldingProperties(Map properties) {
        GeneralOptionsModel.setEditorOption("setCodeFoldingProps", Map.class, properties);
    }

    boolean getAutoPopupCompletion() {
        Boolean b = (Boolean)GeneralOptionsModel.getEditorOption("getCompletionAutoPopup", "text/x-java");
        if (b == null) {
            return true;
        }
        return b;
    }

    void setAutoPopupCompletion(boolean auto) {
        GeneralOptionsModel.setEditorOption("setCompletionAutoPopup", Boolean.TYPE, new Boolean(auto));
    }

    boolean getAutoPopupJavaDoc() {
        Boolean b = (Boolean)GeneralOptionsModel.getEditorOption("getJavaDocAutoPopup", "text/x-java");
        if (b == null) {
            return true;
        }
        return b;
    }

    void setAutoPopupJavaDoc(boolean auto) {
        GeneralOptionsModel.setEditorOption("setJavaDocAutoPopup", Boolean.TYPE, new Boolean(auto));
    }

    private static Object getEditorOption(String methodName, String mimeType) {
        BaseOptions options = GeneralOptionsModel.getOptions(mimeType);
        try {
            Method m = options.getClass().getMethod(methodName, new Class[0]);
            return m.invoke((Object)options, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static void setEditorOption(String methodName, Class paramType, Object value) {
        Iterator it = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        while (it.hasNext()) {
            Class optionsClass = (Class)it.next();
            BaseOptions baseOptions = (BaseOptions)BaseOptions.findObject((Class)optionsClass, (boolean)true);
            try {
                Method m = baseOptions.getClass().getMethod(methodName, paramType);
                m.invoke((Object)baseOptions, value);
            }
            catch (NoSuchMethodException ex) {
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {}
        }
    }

    private static BaseOptions getOptions(String mimeType) {
        Iterator it = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        while (it.hasNext()) {
            Class optionsClass = (Class)it.next();
            BaseOptions baseOptions = (BaseOptions)BaseOptions.findObject((Class)optionsClass, (boolean)true);
            BaseKit kit = BaseKit.getKit((Class)baseOptions.getKitClass());
            if (!kit.getContentType().equals(mimeType)) continue;
            return baseOptions;
        }
        return null;
    }

    private static String code2view(String code) {
        return code == null ? code : code.replaceAll("\\|", ",\\ ");
    }

    private static String view2code(String view) {
        return view == null ? view : view.replaceAll(",\\ ", "\\|");
    }
}

