/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.Action;
import javax.xml.parsers.DocumentBuilder;
import org.openide.ErrorManager;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.Environment;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.XMLDataObjectImpl;
import org.openide.loaders.XMLEntityResolverChain;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.windows.CloneableOpenSupport;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDataObject
extends MultiDataObject {
    static final long serialVersionUID = 8757854986453256578L;
    public static final String XMLINFO_DTD_PUBLIC_ID_FORTE = "-//Forte for Java//DTD xmlinfo//EN";
    public static final String XMLINFO_DTD_PUBLIC_ID = "-//NetBeans IDE//DTD xmlinfo//EN";
    public static final String MIME = "text/xml";
    public static final int STATUS_NOT = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_WARNING = 2;
    public static final int STATUS_ERROR = 3;
    public static final String PROP_DOCUMENT = "document";
    public static final String PROP_INFO = "info";
    private static ErrorPrinter errorHandler = new ErrorPrinter();
    private static XMLEntityResolverChain chainingEntityResolver;
    private static HashMap infos;
    private static Object emgrLock;
    private DelDoc doc;
    private int status;
    private EditorCookie editor = null;
    private InfoParser infoParser;
    private static final ErrorManager ERR;
    private static final boolean LOG;
    private static final StopSaxException STOP;
    private static XMLReader sharedParserImpl;
    private static final Lookup.Template TEMPLATE;
    private static final String NULL = "";
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$openide$loaders$XMLDataObject$Processor;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$actions$OpenAction;
    static /* synthetic */ Class class$org$openide$loaders$XMLDataObject$DelDoc;
    static /* synthetic */ Class class$org$w3c$dom$DocumentType;

    public XMLDataObject(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
        fo.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.getIP(), (Object)fo));
        this.status = 0;
        CookieSet.Factory factory = new CookieSet.Factory(){

            public Node.Cookie createCookie(Class klass) {
                if (klass.isAssignableFrom(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = XMLDataObject.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie) || klass.isAssignableFrom(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = XMLDataObject.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie) || klass.isAssignableFrom(class$org$openide$cookies$CloseCookie == null ? (class$org$openide$cookies$CloseCookie = XMLDataObject.class$("org.openide.cookies.CloseCookie")) : class$org$openide$cookies$CloseCookie) || klass.isAssignableFrom(class$org$openide$cookies$PrintCookie == null ? (class$org$openide$cookies$PrintCookie = XMLDataObject.class$("org.openide.cookies.PrintCookie")) : class$org$openide$cookies$PrintCookie)) {
                    if (XMLDataObject.this.editor == null) {
                        XMLDataObject.this.editor = XMLDataObject.this.createEditorCookie();
                    }
                    if (XMLDataObject.this.editor == null) {
                        return null;
                    }
                    return klass.isAssignableFrom(XMLDataObject.this.editor.getClass()) ? XMLDataObject.this.editor : null;
                }
                return null;
            }
        };
        CookieSet cookies = this.getCookieSet();
        cookies.add(EditorCookie.class, factory);
        cookies.add(OpenCookie.class, factory);
        cookies.add(CloseCookie.class, factory);
        cookies.add(PrintCookie.class, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InfoParser getIP() {
        Object object = emgrLock;
        synchronized (object) {
            if (this.infoParser == null) {
                this.infoParser = new InfoParser();
            }
        }
        return this.infoParser;
    }

    protected Node createNodeDelegate() {
        XMLNode xn = new XMLNode(this);
        xn.setShortDescription(NbBundle.getMessage((Class)XMLDataObject.class, (String)"HINT_XMLDataObject"));
        return xn;
    }

    protected void updateIconBase(String res) {
    }

    protected void handleDelete() throws IOException {
        this.getIP().waitFinished();
        super.handleDelete();
    }

    public HelpCtx getHelpCtx() {
        try {
            if (this.getPrimaryFile().getFileSystem().isDefault() && this.getCookie(InstanceCookie.class) != null) {
                return HelpCtx.DEFAULT_HELP;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return new HelpCtx(XMLDataObject.class);
    }

    public Node.Cookie getCookie(Class cls) {
        this.getIP().waitFinished();
        Node.Cookie cake = (Node.Cookie)this.getIP().lookupCookie(cls);
        if (LOG) {
            ERR.log("Query for " + cls + " for " + this);
            ERR.log("Gives a cake " + cake + " for " + this);
        }
        if (cake instanceof InstanceCookie) {
            cake = this.ofCookie((InstanceCookie)cake, cls);
        }
        if (LOG) {
            ERR.log("After ofCookie: " + cake + " for " + this);
        }
        if (cake == null) {
            cake = super.getCookie(cls);
        }
        if (LOG) {
            ERR.log("getCookie returns " + cake + " for " + this);
        }
        return cake;
    }

    private InstanceCookie ofCookie(InstanceCookie ic, Class cls) {
        if (ic instanceof InstanceCookie.Of) {
            return ic;
        }
        if (!cls.isAssignableFrom(ICDel.class)) {
            return ic;
        }
        ICDel d = new ICDel(this, ic);
        return d;
    }

    private void notifyEx(Exception e) {
        ErrorManager emgr = ErrorManager.getDefault();
        emgr.annotate((Throwable)e, "Cannot resolve following class in xmlinfo.");
        emgr.notify((Throwable)e);
    }

    protected EditorCookie createEditorCookie() {
        return new XMLEditorSupport(this);
    }

    private final void addSaveCookie(SaveCookie save) {
        this.getCookieSet().add((Node.Cookie)save);
    }

    private final void removeSaveCookie(SaveCookie save) {
        this.getCookieSet().remove((Node.Cookie)save);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Document getDocument() throws IOException, SAXException {
        if (LOG) {
            ERR.log("getDocument for " + this);
        }
        XMLDataObject xMLDataObject = this;
        synchronized (xMLDataObject) {
            DelDoc d = this.doc;
            if (d == null) {
                this.doc = d = new DelDoc();
            }
            return d.getProxyDocument();
        }
    }

    final void clearDocument() {
        if (LOG) {
            ERR.log("clearDocument for " + this);
        }
        this.doc = null;
        this.firePropertyChange(PROP_DOCUMENT, null, null);
    }

    public final int getStatus() {
        return this.status;
    }

    public final Info getInfo() {
        return null;
    }

    public final synchronized void setInfo(Info ii) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Document parsePrimaryFile() throws IOException, SAXException {
        if (LOG) {
            ERR.log("parsePrimaryFile for " + this);
        }
        String loc = this.getPrimaryFile().getURL().toExternalForm();
        try {
            return XMLUtil.parse((InputSource)new InputSource(loc), (boolean)false, (boolean)true, (ErrorHandler)errorHandler, (EntityResolver)XMLDataObject.getSystemResolver());
        }
        catch (IOException e) {
            Document document;
            InputStream is = this.getPrimaryFile().getInputStream();
            try {
                document = XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)true, (ErrorHandler)errorHandler, (EntityResolver)XMLDataObject.getSystemResolver());
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                is.close();
                throw throwable;
            }
            is.close();
            return document;
        }
    }

    public static Document parse(URL url) throws IOException, SAXException {
        return XMLDataObject.parse(url, errorHandler, false);
    }

    public static Document parse(URL url, boolean validate) throws IOException, SAXException {
        return XMLDataObject.parse(url, errorHandler, validate);
    }

    public static Document parse(URL url, ErrorHandler eh) throws IOException, SAXException {
        return XMLDataObject.parse(url, eh, false);
    }

    public static Document parse(URL url, ErrorHandler eh, boolean validate) throws IOException, SAXException {
        DocumentBuilder builder = XMLDataObjectImpl.makeBuilder(validate);
        builder.setErrorHandler(eh);
        builder.setEntityResolver(XMLDataObject.getChainingEntityResolver());
        return builder.parse(new InputSource(url.toExternalForm()));
    }

    public static Parser createParser() {
        return XMLDataObject.createParser(false);
    }

    public static Parser createParser(boolean validate) {
        Parser parser = XMLDataObjectImpl.makeParser(validate);
        parser.setEntityResolver(XMLDataObject.getChainingEntityResolver());
        return parser;
    }

    public static Document createDocument() {
        XMLDataObject.deprecated();
        try {
            return XMLDataObjectImpl.makeBuilder(false).newDocument();
        }
        catch (IOException ex) {
            return null;
        }
        catch (SAXException ex) {
            return null;
        }
    }

    public static void write(Document doc, Writer writer) throws IOException {
        XMLDataObject.deprecated();
        String FAILURE = "org.openide.xml.XMLUtilImpl.write() invocation failed.";
        try {
            Class<?> clzz = Class.forName("org.openide.xml.XMLUtilImpl");
            Method impl = clzz.getDeclaredMethod("write", Document.class, Object.class, String.class);
            impl.setAccessible(true);
            impl.invoke(null, doc, writer, null);
        }
        catch (IllegalAccessException ex) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (IllegalArgumentException ex) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (NoSuchMethodException ex) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
    }

    public static void write(Document doc, OutputStream out, String enc) throws IOException {
        XMLUtil.write((Document)doc, (OutputStream)out, (String)enc);
    }

    public static InputSource createInputSource(URL url) throws IOException {
        return new InputSource(url.toExternalForm());
    }

    public static void registerCatalogEntry(String publicId, String uri) {
        if (publicId == null) {
            throw new IllegalArgumentException("null public ID is not allowed.");
        }
        XMLDataObjectImpl.registerCatalogEntry(publicId, uri);
    }

    public static void registerCatalogEntry(String publicId, String resourceName, ClassLoader loader) {
        if (publicId == null) {
            throw new IllegalArgumentException("null public ID is not allowed.");
        }
        XMLDataObjectImpl.registerCatalogEntry(publicId, "nbres:/" + resourceName);
    }

    public static final boolean addEntityResolver(EntityResolver resolver) {
        return XMLDataObject.getChainingEntityResolver().addEntityResolver(resolver);
    }

    public static final EntityResolver removeEntityResolver(EntityResolver resolver) {
        return XMLDataObject.getChainingEntityResolver().removeEntityResolver(resolver);
    }

    private static synchronized XMLEntityResolverChain getChainingEntityResolver() {
        if (chainingEntityResolver == null) {
            chainingEntityResolver = new XMLEntityResolverChain();
            chainingEntityResolver.addEntityResolver(XMLDataObject.getSystemResolver());
        }
        return chainingEntityResolver;
    }

    private static EntityResolver getSystemResolver() {
        return EntityCatalog.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerInfo(String publicId, Info info) {
        HashMap hashMap = infos;
        synchronized (hashMap) {
            if (info == null) {
                infos.remove(publicId);
            } else {
                infos.put(publicId, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Info getRegisteredInfo(String publicId) {
        HashMap hashMap = infos;
        synchronized (hashMap) {
            Info ret = (Info)infos.get(publicId);
            return ret == null ? null : (Info)ret.clone();
        }
    }

    private static void deprecated() {
        StringWriter wr = new StringWriter();
        PrintWriter pr = new PrintWriter(wr);
        new Exception(NULL).printStackTrace(pr);
        pr.flush();
        String stack = wr.toString().trim();
        int start = stack.indexOf("\n");
        int end = stack.indexOf("\n", start + 1);
        while (stack.indexOf("XMLDataObject", start + 1) > 0) {
            start = end;
            end = stack.indexOf("\n", start + 1);
        }
        String line = stack.substring(start + 1, end).trim();
        System.out.println("Warning: deprecated method called " + line);
    }

    static Lookup createInfoLookup(XMLDataObject obj, Info info) {
        return new InfoLkp(obj, info);
    }

    private Node findNode() {
        Node n = (Node)this.getIP().lookupCookie(Node.class);
        if (n == null) {
            return new PlainDataNode();
        }
        return n;
    }

    static /* synthetic */ XMLReader access$500() {
        return sharedParserImpl;
    }

    static {
        infos = new HashMap();
        emgrLock = new Object();
        ERR = ErrorManager.getDefault().getInstance(XMLDataObject.class.getName());
        LOG = ERR.isLoggable(1);
        STOP = new StopSaxException();
        sharedParserImpl = null;
        try {
            sharedParserImpl = XMLUtil.createXMLReader();
            sharedParserImpl.setEntityResolver(new EmptyEntityResolver());
        }
        catch (SAXException ex) {
            ErrorManager err = ErrorManager.getDefault();
            err.annotate((Throwable)ex, "System does not contain JAXP 1.1 compliant parser!");
            err.notify(65536, (Throwable)ex);
        }
        try {
            Properties props = System.getProperties();
            String SAX2_KEY = "org.xml.sax.driver";
            if (props.getProperty("org.xml.sax.driver") == null) {
                props.put("org.xml.sax.driver", sharedParserImpl.getClass().getName());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TEMPLATE = new Lookup.Template(Node.Cookie.class);
    }

    private final class DelDoc
    implements InvocationHandler {
        private Reference xmlDocument;
        private final Document proxyDocument = (Document)Proxy.newProxyInstance((class$org$openide$loaders$XMLDataObject$DelDoc == null ? (class$org$openide$loaders$XMLDataObject$DelDoc = XMLDataObject.class$("org.openide.loaders.XMLDataObject$DelDoc")) : class$org$openide$loaders$XMLDataObject$DelDoc).getClassLoader(), new Class[]{class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = XMLDataObject.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document}, (InvocationHandler)this);

        DelDoc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Document getDocumentImpl(boolean force) {
            DelDoc delDoc = this;
            synchronized (delDoc) {
                Object doc;
                Object v0 = doc = this.xmlDocument == null ? null : this.xmlDocument.get();
                if (doc instanceof Document) {
                    return doc;
                }
                if (!force) {
                    return null;
                }
                XMLDataObject.this.status = 1;
                try {
                    Document d = XMLDataObject.this.parsePrimaryFile();
                    this.xmlDocument = new SoftReference<Document>(d);
                    return d;
                }
                catch (SAXException e) {
                    ERR.notify(1, (Throwable)e);
                }
                catch (IOException e) {
                    ERR.notify(1, (Throwable)e);
                }
                XMLDataObject.this.status = 3;
                Document d = XMLUtil.createDocument((String)"brokenDocument", null, null, null);
                this.xmlDocument = new SoftReference<Document>(d);
                XMLDataObject.this.firePropertyChange(XMLDataObject.PROP_DOCUMENT, null, null);
                return d;
            }
        }

        public Document getProxyDocument() {
            return this.proxyDocument;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getDoctype") && args == null) {
                return Proxy.newProxyInstance((class$org$openide$loaders$XMLDataObject$DelDoc == null ? (class$org$openide$loaders$XMLDataObject$DelDoc = XMLDataObject.class$("org.openide.loaders.XMLDataObject$DelDoc")) : class$org$openide$loaders$XMLDataObject$DelDoc).getClassLoader(), new Class[]{class$org$w3c$dom$DocumentType == null ? (class$org$w3c$dom$DocumentType = XMLDataObject.class$("org.w3c.dom.DocumentType")) : class$org$w3c$dom$DocumentType}, (InvocationHandler)this);
            }
            if (method.getName().equals("getPublicId") && args == null) {
                Document d = this.getDocumentImpl(false);
                if (d != null) {
                    DocumentType doctype = d.getDoctype();
                    return doctype == null ? null : doctype.getPublicId();
                }
                return XMLDataObject.this.getIP().getPublicId();
            }
            return method.invoke((Object)this.getDocumentImpl(true), args);
        }
    }

    private static class ICDel
    implements InstanceCookie.Of {
        private XMLDataObject obj;
        private InstanceCookie ic;

        public ICDel(XMLDataObject obj, InstanceCookie ic) {
            this.obj = obj;
            this.ic = ic;
        }

        public String instanceName() {
            return this.ic.instanceName();
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return this.ic.instanceClass();
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            return this.ic.instanceCreate();
        }

        public boolean instanceOf(Class cls2) {
            if (this.ic instanceof InstanceCookie.Of) {
                return ((InstanceCookie.Of)this.ic).instanceOf(cls2);
            }
            try {
                return cls2.isAssignableFrom(this.instanceClass());
            }
            catch (IOException ioe) {
                return false;
            }
            catch (ClassNotFoundException cnfe) {
                return false;
            }
        }

        public int hashCode() {
            return 2 * this.obj.hashCode() + this.ic.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ICDel) {
                ICDel d = (ICDel)obj;
                return d.obj == obj && d.ic == this.ic;
            }
            return false;
        }
    }

    private final class XMLNode
    extends FilterNode {
        public XMLNode(XMLDataObject obj) {
            this(obj.findNode());
        }

        private XMLNode(Node del) {
            super(del, (Children)new FilterNode.Children(del));
        }

        private void update() {
            this.changeOriginal(XMLDataObject.this.findNode(), true);
        }
    }

    private final class PlainDataNode
    extends DataNode {
        public PlainDataNode() {
            super(XMLDataObject.this, Children.LEAF);
            this.setIconBaseWithExtension("org/openide/loaders/xmlObject.gif");
        }

        public Action getPreferredAction() {
            return SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = XMLDataObject.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction));
        }
    }

    private static final class InfoLkp
    extends AbstractLookup {
        public final Info info;

        public InfoLkp(XMLDataObject obj, Info info) {
            this.info = info;
            Iterator it = info.processorClasses();
            ArrayList<InfoPair> arr = new ArrayList<InfoPair>(info.processors.size());
            while (it.hasNext()) {
                Class c = (Class)it.next();
                arr.add(new InfoPair(obj, c));
            }
            this.setPairs(arr);
        }

        private static final class InfoPair
        extends AbstractLookup.Pair {
            private Class clazz;
            private Object obj;

            protected InfoPair(XMLDataObject obj, Class c) {
                this.obj = obj;
                this.clazz = c;
            }

            protected boolean instanceOf(Class c) {
                Class temp = this.clazz;
                if (temp == null) {
                    return c.isInstance(this.obj);
                }
                return c.isAssignableFrom(temp);
            }

            protected boolean creatorOf(Object obj) {
                return this.obj == obj;
            }

            public synchronized Object getInstance() {
                if (this.clazz == null) {
                    return this.obj;
                }
                XMLDataObject xmlDataObject = (XMLDataObject)this.obj;
                this.obj = null;
                Class next = this.clazz;
                this.clazz = null;
                try {
                    if ((class$org$openide$loaders$XMLDataObject$Processor == null ? (class$org$openide$loaders$XMLDataObject$Processor = XMLDataObject.class$("org.openide.loaders.XMLDataObject$Processor")) : class$org$openide$loaders$XMLDataObject$Processor).isAssignableFrom(next)) {
                        this.obj = next.newInstance();
                        Processor proc = (Processor)this.obj;
                        proc.attachTo(xmlDataObject);
                        return this.obj;
                    }
                    Constructor<?>[] arr = next.getConstructors();
                    for (int i = 0; i < arr.length; ++i) {
                        Class<?>[] params = arr[i].getParameterTypes();
                        if (params.length != 1 || params[0] != (class$org$openide$loaders$DataObject == null ? XMLDataObject.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject) && params[0] != (class$org$openide$loaders$XMLDataObject == null ? XMLDataObject.class$("org.openide.loaders.XMLDataObject") : class$org$openide$loaders$XMLDataObject)) continue;
                        this.obj = arr[i].newInstance(xmlDataObject);
                        return this.obj;
                    }
                    throw new InternalError("XMLDataObject processor class " + next + " invalid");
                }
                catch (InvocationTargetException e) {
                    xmlDataObject.notifyEx(e);
                }
                catch (InstantiationException e) {
                    xmlDataObject.notifyEx(e);
                }
                catch (IllegalAccessException e) {
                    xmlDataObject.notifyEx(e);
                }
                return this.obj;
            }

            public Class getType() {
                Class<?> temp = this.clazz;
                return temp != null ? temp : this.obj.getClass();
            }

            public String getId() {
                return "Info[" + this.getType().getName();
            }

            public String getDisplayName() {
                return this.getType().getName();
            }
        }
    }

    public static final class Info
    implements Cloneable {
        List processors = new ArrayList();
        String iconBase = null;

        public Object clone() {
            Info ii = new Info();
            Iterator it = this.processors.iterator();
            while (it.hasNext()) {
                Class proc = (Class)it.next();
                ii.processors.add(proc);
            }
            ii.iconBase = this.iconBase;
            return ii;
        }

        public synchronized void addProcessorClass(Class proc) {
            if (!(class$org$openide$loaders$XMLDataObject$Processor == null ? (class$org$openide$loaders$XMLDataObject$Processor = XMLDataObject.class$("org.openide.loaders.XMLDataObject$Processor")) : class$org$openide$loaders$XMLDataObject$Processor).isAssignableFrom(proc)) {
                Constructor<?>[] arr = proc.getConstructors();
                for (int i = 0; i < arr.length; ++i) {
                    Class<?>[] params = arr[i].getParameterTypes();
                    if (params.length != 1 || params[0] != (class$org$openide$loaders$DataObject == null ? XMLDataObject.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject) && params[0] != (class$org$openide$loaders$XMLDataObject == null ? XMLDataObject.class$("org.openide.loaders.XMLDataObject") : class$org$openide$loaders$XMLDataObject)) continue;
                    arr = null;
                    break;
                }
                if (arr != null) {
                    throw new IllegalArgumentException();
                }
            }
            this.processors.add(proc);
        }

        public boolean removeProcessorClass(Class proc) {
            return this.processors.remove(proc);
        }

        public Iterator processorClasses() {
            return this.processors.iterator();
        }

        public void setIconBase(String base) {
            this.iconBase = base;
        }

        public String getIconBase() {
            return this.iconBase;
        }

        public void write(Writer writer) throws IOException {
            throw new IOException("Not supported anymore");
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Info)) {
                return false;
            }
            Info i = (Info)obj;
            return (this.iconBase != null && this.iconBase.equals(i.iconBase) || i.iconBase == this.iconBase) && ((Object)this.processors).equals(i.processors);
        }
    }

    public static interface Processor
    extends Node.Cookie {
        public void attachTo(XMLDataObject var1);
    }

    static final class Loader
    extends MultiFileLoader {
        static final long serialVersionUID = 3917883920409453930L;

        public Loader() {
            super("org.openide.loaders.XMLDataObject");
        }

        protected String actionsContext() {
            return "Loaders/text/xml/Actions";
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage((Class)(class$org$openide$loaders$XMLDataObject == null ? (class$org$openide$loaders$XMLDataObject = XMLDataObject.class$("org.openide.loaders.XMLDataObject")) : class$org$openide$loaders$XMLDataObject), (String)"PROP_XmlLoader_Name");
        }

        protected FileObject findPrimaryFile(FileObject fo) {
            String mime = fo.getMIMEType();
            if (mime.endsWith("/xml") || mime.endsWith("+xml")) {
                return fo;
            }
            return null;
        }

        protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException {
            return new XMLDataObject(primaryFile, this);
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
            return new FileEntry(obj, primaryFile);
        }

        protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
            return new FileEntry(obj, secondaryFile);
        }
    }

    private static class EmptyEntityResolver
    implements EntityResolver {
        EmptyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemID) {
            InputSource ret = new InputSource(new StringReader(XMLDataObject.NULL));
            ret.setSystemId("StringReader");
            return ret;
        }
    }

    private final class InfoParser
    extends DefaultHandler
    implements FileChangeListener,
    LexicalHandler,
    LookupListener {
        private String parsedId;
        private Lookup lookup;
        private Lookup.Result result;
        private ThreadLocal QUERY = new ThreadLocal();

        InfoParser() {
        }

        public String getPublicId() {
            String id = this.waitFinished();
            return id == XMLDataObject.NULL ? null : id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lookupCookie(final Class clazz) {
            if (this.QUERY.get() == clazz) {
                if (LOG) {
                    ERR.log("Cyclic deps on queried class: " + clazz + " for " + XMLDataObject.this);
                }
                return new InstanceCookie(){

                    public Class instanceClass() {
                        return clazz;
                    }

                    public Object instanceCreate() throws IOException {
                        throw new IOException("Cyclic reference, sorry: " + clazz);
                    }

                    public String instanceName() {
                        return clazz.getName();
                    }
                };
            }
            Object previous = this.QUERY.get();
            try {
                Lookup.Result r;
                Lookup l;
                block18: {
                    this.QUERY.set(clazz);
                    if (LOG) {
                        ERR.log("Will do query for class: " + clazz + " for " + XMLDataObject.this);
                    }
                    do {
                        String id = this.waitFinished();
                        InfoParser infoParser = this;
                        synchronized (infoParser) {
                            l = this.lookup != null ? this.lookup : null;
                        }
                        if (LOG) {
                            ERR.log("Lookup is " + l + " for id: " + id);
                        }
                        if (l == null) {
                            l = this.updateLookup(null, id);
                            if (LOG) {
                                ERR.log("Updating lookup: " + l);
                            }
                        }
                        if (LOG) {
                            ERR.log("Wait lookup is over: " + l + XMLDataObject.this);
                        }
                        if (l != null) break block18;
                    } while (this.parsedId != null);
                    l = Lookup.EMPTY;
                }
                if ((r = this.result) != null) {
                    if (LOG) {
                        ERR.log("Querying the result: " + r);
                    }
                    r.allItems();
                } else if (LOG) {
                    ERR.log("No result for lookup: " + this.lookup);
                }
                Object ret = l.lookup(clazz);
                if (LOG) {
                    ERR.log("Returning value: " + ret + " for " + XMLDataObject.this);
                }
                Object object = ret;
                Object var8_8 = null;
                this.QUERY.set(previous);
                return object;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.QUERY.set(previous);
                throw throwable;
            }
        }

        public String waitFinished() {
            return this.waitFinished(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String waitFinished(String ignorePreviousId) {
            if (XMLDataObject.access$500() == null) {
                XMLDataObject.access$400().log("No sharedParserImpl, exiting");
                return "";
            }
            parser = XMLDataObject.access$500();
            myFileObject = XMLDataObject.this.getPrimaryFile();
            newID = null;
            if (XMLDataObject.access$300()) {
                XMLDataObject.access$400().log("Going to read parsedId for " + XMLDataObject.this);
            }
            var6_5 = this;
            synchronized (var6_5) {
                previousID = this.parsedId;
                ** if (previousID == null) goto lbl16
            }
lbl-1000:
            // 1 sources

            {
                if (XMLDataObject.access$300() == false) return previousID;
                XMLDataObject.access$400().log("Has already been parsed: " + this.parsedId + " for " + XMLDataObject.this);
                return previousID;
            }
lbl16:
            // 1 sources

            url = null;
            in = null;
            try {
                url = myFileObject.getURL();
            }
            catch (IOException ex) {
                this.warning(ex, "I/O exception while retrieving xml FileObject URL.");
                return "";
            }
            var8_9 = this;
            synchronized (var8_9) {
                block70: {
                    block58: {
                        block68: {
                            block69: {
                                block53: {
                                    block59: {
                                        block52: {
                                            try {
                                                if (!myFileObject.isValid()) {
                                                    if (XMLDataObject.access$300()) {
                                                        XMLDataObject.access$400().log("Invalid file object: " + myFileObject);
                                                    }
                                                    var9_10 = "";
                                                    var16_17 = null;
                                                    break block52;
                                                }
                                                this.parsedId = "";
                                                if (XMLDataObject.access$300()) {
                                                    XMLDataObject.access$400().log("parsedId set to NULL for " + XMLDataObject.this);
                                                }
                                                try {
                                                    in = myFileObject.getInputStream();
                                                    break block53;
                                                }
                                                catch (IOException ex) {
                                                    this.warning(ex, "I/O exception while openning xml.");
                                                    var10_25 = "";
                                                    var16_18 = null;
                                                    try {
                                                        if (in == null) return var10_25;
                                                        in.close();
                                                    }
                                                    catch (IOException ex) {
                                                        v0 = XMLDataObject.access$400();
                                                        XMLDataObject.access$400();
                                                        v0.notify(1, (Throwable)ex);
                                                    }
                                                    return var10_25;
                                                }
                                            }
                                            catch (Throwable var15_42) {
                                                var16_20 = null;
                                                ** try [egrp 11[TRYBLOCK] [22 : 762->775)] { 
lbl60:
                                                // 1 sources

                                                if (in == null) throw var15_42;
                                                in.close();
                                                throw var15_42;
lbl63:
                                                // 1 sources

                                                catch (IOException ex) {
                                                    v1 = XMLDataObject.access$400();
                                                    XMLDataObject.access$400();
                                                    v1.notify(1, (Throwable)ex);
                                                }
                                                throw var15_42;
                                            }
                                        }
                                        ** try [egrp 11[TRYBLOCK] [22 : 762->775)] { 
lbl71:
                                        // 1 sources

                                        if (in == null) return var9_10;
                                        in.close();
                                        break block59;
lbl74:
                                        // 1 sources

                                        catch (IOException ex) {
                                            v2 = XMLDataObject.access$400();
                                            XMLDataObject.access$400();
                                            v2.notify(1, (Throwable)ex);
                                        }
                                    }
                                    return var9_10;
                                }
                                try {
                                    block55: {
                                        try {
                                            ex = XMLDataObject.access$500();
                                            synchronized (ex) {
                                                this.configureParser(parser, false, this);
                                                parser.setContentHandler(this);
                                                parser.setErrorHandler(this);
                                                input = new InputSource(url.toExternalForm());
                                                input.setByteStream(in);
                                                parser.parse(input);
                                                if (!XMLDataObject.access$300()) break block55;
                                            }
                                            XMLDataObject.access$400().log("Parse finished for " + XMLDataObject.this);
                                        }
                                        catch (StopSaxException stopped) {
                                            newID = this.parsedId;
                                            XMLDataObject.access$400().log("Parsing successfully stopped: " + this.parsedId + " for " + XMLDataObject.this);
                                            var13_29 = null;
                                            if (Boolean.getBoolean("netbeans.profile.memory")) {
                                                parser.setContentHandler(NullHandler.INSTANCE);
                                                parser.setErrorHandler(NullHandler.INSTANCE);
                                                try {
                                                    parser.setProperty("http://xml.org/sax/properties/lexical-handler", NullHandler.INSTANCE);
                                                }
                                                catch (SAXException ignoreIt /* !! */ ) {
                                                    // empty catch block
                                                }
                                                try {
                                                    parser.parse((InputSource)null);
                                                }
                                                catch (Exception ignoreIt /* !! */ ) {
                                                    // empty catch block
                                                }
                                            }
                                            parser = null;
                                            break block58;
                                        }
                                        catch (SAXException checkStop) {
                                            block60: {
                                                block61: {
                                                    if (XMLDataObject.access$600().getMessage().equals(checkStop.getMessage())) {
                                                        newID = this.parsedId;
                                                        XMLDataObject.access$400().log("Parsing stopped with STOP message: " + this.parsedId + " for " + XMLDataObject.this);
                                                    } else {
                                                        msg = "Thread:" + Thread.currentThread().getName();
                                                        XMLDataObject.access$400().annotate((Throwable)checkStop, "DocListener should not throw SAXException but STOP one.\n" + msg);
                                                        v3 = XMLDataObject.access$400();
                                                        XMLDataObject.access$400();
                                                        v3.notify(1, (Throwable)checkStop);
                                                        ex = checkStop.getException();
                                                        if (ex != null) {
                                                            v4 = XMLDataObject.access$400();
                                                            XMLDataObject.access$400();
                                                            v4.notify(1, (Throwable)ex);
                                                        }
                                                    }
                                                    var13_30 = null;
                                                    if (!Boolean.getBoolean("netbeans.profile.memory")) break block60;
                                                    parser.setContentHandler(NullHandler.INSTANCE);
                                                    parser.setErrorHandler(NullHandler.INSTANCE);
                                                    ** try [egrp 8[TRYBLOCK] [16 : 711->725)] { 
lbl141:
                                                    // 1 sources

                                                    parser.setProperty("http://xml.org/sax/properties/lexical-handler", NullHandler.INSTANCE);
                                                    break block61;
lbl143:
                                                    // 1 sources

                                                    catch (SAXException ignoreIt /* !! */ ) {
                                                        // empty catch block
                                                    }
                                                }
                                                ** try [egrp 9[TRYBLOCK] [17 : 727->740)] { 
lbl147:
                                                // 1 sources

                                                parser.parse((InputSource)null);
                                                break block60;
lbl149:
                                                // 1 sources

                                                catch (Exception ignoreIt /* !! */ ) {
                                                    // empty catch block
                                                }
                                            }
                                            parser = null;
                                            break block58;
                                        }
                                        catch (FileNotFoundException ex) {
                                            block62: {
                                                block63: {
                                                    v5 = XMLDataObject.access$400();
                                                    XMLDataObject.access$400();
                                                    v5.notify(1, (Throwable)ex);
                                                    var13_31 = null;
                                                    if (!Boolean.getBoolean("netbeans.profile.memory")) break block62;
                                                    parser.setContentHandler(NullHandler.INSTANCE);
                                                    parser.setErrorHandler(NullHandler.INSTANCE);
                                                    ** try [egrp 8[TRYBLOCK] [16 : 711->725)] { 
lbl165:
                                                    // 1 sources

                                                    parser.setProperty("http://xml.org/sax/properties/lexical-handler", NullHandler.INSTANCE);
                                                    break block63;
lbl167:
                                                    // 1 sources

                                                    catch (SAXException ignoreIt /* !! */ ) {
                                                        // empty catch block
                                                    }
                                                }
                                                ** try [egrp 9[TRYBLOCK] [17 : 727->740)] { 
lbl171:
                                                // 1 sources

                                                parser.parse((InputSource)null);
                                                break block62;
lbl173:
                                                // 1 sources

                                                catch (Exception ignoreIt /* !! */ ) {
                                                    // empty catch block
                                                }
                                            }
                                            parser = null;
                                            break block58;
                                        }
                                        catch (IOException ex) {
                                            block64: {
                                                block65: {
                                                    v6 = XMLDataObject.access$400();
                                                    XMLDataObject.access$400();
                                                    v6.notify(1, (Throwable)ex);
                                                    var13_32 = null;
                                                    if (!Boolean.getBoolean("netbeans.profile.memory")) break block64;
                                                    parser.setContentHandler(NullHandler.INSTANCE);
                                                    parser.setErrorHandler(NullHandler.INSTANCE);
                                                    ** try [egrp 8[TRYBLOCK] [16 : 711->725)] { 
lbl189:
                                                    // 1 sources

                                                    parser.setProperty("http://xml.org/sax/properties/lexical-handler", NullHandler.INSTANCE);
                                                    break block65;
lbl191:
                                                    // 1 sources

                                                    catch (SAXException ignoreIt /* !! */ ) {
                                                        // empty catch block
                                                    }
                                                }
                                                ** try [egrp 9[TRYBLOCK] [17 : 727->740)] { 
lbl195:
                                                // 1 sources

                                                parser.parse((InputSource)null);
                                                break block64;
lbl197:
                                                // 1 sources

                                                catch (Exception ignoreIt /* !! */ ) {
                                                    // empty catch block
                                                }
                                            }
                                            parser = null;
                                            break block58;
                                        }
                                    }
                                    var13_28 = null;
                                }
                                catch (Throwable var12_41) {
                                    block66: {
                                        block67: {
                                            var13_33 = null;
                                            if (!Boolean.getBoolean("netbeans.profile.memory")) break block66;
                                            parser.setContentHandler(NullHandler.INSTANCE);
                                            parser.setErrorHandler(NullHandler.INSTANCE);
                                            ** try [egrp 8[TRYBLOCK] [16 : 711->725)] { 
lbl212:
                                            // 1 sources

                                            parser.setProperty("http://xml.org/sax/properties/lexical-handler", NullHandler.INSTANCE);
                                            break block67;
lbl214:
                                            // 1 sources

                                            catch (SAXException ignoreIt /* !! */ ) {
                                                // empty catch block
                                            }
                                        }
                                        ** try [egrp 9[TRYBLOCK] [17 : 727->740)] { 
lbl218:
                                        // 1 sources

                                        parser.parse((InputSource)null);
                                        break block66;
lbl220:
                                        // 1 sources

                                        catch (Exception ignoreIt /* !! */ ) {
                                            // empty catch block
                                        }
                                    }
                                    parser = null;
                                    throw var12_41;
                                }
                                if (!Boolean.getBoolean("netbeans.profile.memory")) break block68;
                                parser.setContentHandler(NullHandler.INSTANCE);
                                parser.setErrorHandler(NullHandler.INSTANCE);
                                ** try [egrp 8[TRYBLOCK] [16 : 711->725)] { 
lbl229:
                                // 1 sources

                                parser.setProperty("http://xml.org/sax/properties/lexical-handler", NullHandler.INSTANCE);
                                break block69;
lbl231:
                                // 1 sources

                                catch (SAXException ignoreIt /* !! */ ) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 9[TRYBLOCK] [17 : 727->740)] { 
lbl235:
                            // 1 sources

                            parser.parse((InputSource)null);
                            break block68;
lbl237:
                            // 1 sources

                            catch (Exception ignoreIt /* !! */ ) {
                                // empty catch block
                            }
                        }
                        parser = null;
                    }
                    var16_19 = null;
                    ** try [egrp 11[TRYBLOCK] [22 : 762->775)] { 
lbl244:
                    // 1 sources

                    if (in != null) {
                        in.close();
                    }
                    break block70;
lbl248:
                    // 1 sources

                    catch (IOException ex) {
                        v7 = XMLDataObject.access$400();
                        XMLDataObject.access$400();
                        v7.notify(1, (Throwable)ex);
                    }
                }
                ** if (ignorePreviousId == null || !newID.equals((Object)ignorePreviousId)) goto lbl258
            }
lbl-1000:
            // 1 sources

            {
                if (XMLDataObject.access$300() == false) return newID;
                XMLDataObject.access$400().log("No update to ID: " + ignorePreviousId + " for " + XMLDataObject.this);
                return newID;
            }
lbl258:
            // 1 sources

            if (XMLDataObject.access$300()) {
                XMLDataObject.access$400().log("New id: " + newID + " for " + XMLDataObject.this);
            }
            if (newID == null) return newID;
            this.updateLookup(previousID, newID);
            return newID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Lookup updateLookup(String previousID, String id) {
            Lookup newLookup;
            InfoParser infoParser = this;
            synchronized (infoParser) {
                if (previousID != null && previousID.equals(id) && this.lookup != null) {
                    ERR.log("No need to update lookup: " + id + " for " + XMLDataObject.this);
                    return this.lookup;
                }
            }
            Info info = XMLDataObject.getRegisteredInfo(id);
            if (info != null) {
                newLookup = XMLDataObject.createInfoLookup(XMLDataObject.this, info);
                if (LOG) {
                    ERR.log("Lookup from info: " + newLookup + " for " + XMLDataObject.this);
                }
            } else {
                newLookup = Environment.findForOne(XMLDataObject.this);
                if (LOG) {
                    ERR.log("Lookup from env: " + newLookup + " for " + XMLDataObject.this);
                }
                if (newLookup == null) {
                    newLookup = Lookup.EMPTY;
                }
            }
            InfoParser infoParser2 = this;
            synchronized (infoParser2) {
                Lookup.Result prevRes = this.result;
                this.lookup = newLookup;
                if (LOG) {
                    ERR.log("Shared lookup updated: " + this.lookup + " for " + XMLDataObject.this);
                }
                this.result = this.lookup.lookup(TEMPLATE);
                this.result.addLookupListener((LookupListener)this);
                if (prevRes != null) {
                    prevRes.removeLookupListener((LookupListener)this);
                    if (LOG) {
                        ERR.log("Firing property change for " + XMLDataObject.this);
                    }
                    XMLDataObject.this.firePropertyChange("cookie", null, null);
                    if (LOG) {
                        ERR.log("Firing done for " + XMLDataObject.this);
                    }
                }
                return newLookup;
            }
        }

        private void configureParser(XMLReader parser, boolean validation, LexicalHandler lex) {
            try {
                parser.setFeature("http://xml.org/sax/features/validation", validation);
            }
            catch (SAXException sex) {
                ERR.log("Warning: XML parser does not support validation feature.");
            }
            try {
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", lex);
            }
            catch (SAXException sex) {
                ERR.log("Warning: XML parser does not support lexical-handler feature.");
            }
        }

        public void warning(Throwable ex) {
            this.warning(ex, null);
        }

        public void warning(Throwable ex, String annotation) {
            ErrorManager emgr = ERR;
            if (annotation != null) {
                emgr.annotate(ex, annotation);
            }
            emgr.notify(1, ex);
        }

        public void startDTD(String root, String pID, String sID) throws SAXException {
            this.parsedId = pID == null ? XMLDataObject.NULL : pID;
            ERR.log("Parsed to " + this.parsedId);
            this.stop();
        }

        public void endDTD() throws SAXException {
            this.stop();
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
        }

        public void error(SAXParseException p1) throws SAXException {
            this.stop();
        }

        public void fatalError(SAXParseException p1) throws SAXException {
            this.stop();
        }

        public void endDocument() throws SAXException {
            this.stop();
        }

        public void startElement(String uri, String lName, String qName, Attributes atts) throws SAXException {
            this.stop();
        }

        private void stop() throws SAXException {
            throw STOP;
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        private void fileCreated(FileObject fo) {
        }

        public void fileChanged(FileEvent fe) {
            if (XMLDataObject.this.getPrimaryFile().equals(fe.getFile())) {
                XMLDataObject.this.clearDocument();
                String prevId = this.parsedId;
                this.parsedId = null;
                ERR.log("cleared parsedId");
                this.waitFinished(prevId);
            }
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            XMLDataObject.this.firePropertyChange("cookie", null, null);
            Node n = XMLDataObject.this.getNodeDelegateOrNull();
            if (n instanceof XMLNode) {
                ((XMLNode)n).update();
            }
        }
    }

    private static class NullHandler
    extends DefaultHandler
    implements LexicalHandler {
        static final NullHandler INSTANCE = new NullHandler();

        NullHandler() {
        }

        public void startDTD(String root, String pID, String sID) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
        }
    }

    private static class StopSaxException
    extends SAXException {
        public StopSaxException() {
            super("STOP");
        }
    }

    static class ErrorPrinter
    implements ErrorHandler {
        ErrorPrinter() {
        }

        private void message(String level, SAXParseException e) {
            ErrorManager em = ErrorManager.getDefault().getInstance("org.openide.loaders.XMLDataObject");
            if (!em.isLoggable(1)) {
                return;
            }
            String msg = NbBundle.getMessage((Class)(class$org$openide$loaders$XMLDataObject == null ? (class$org$openide$loaders$XMLDataObject = XMLDataObject.class$("org.openide.loaders.XMLDataObject")) : class$org$openide$loaders$XMLDataObject), (String)"PROP_XmlMessage", (Object[])new Object[]{level, e.getMessage(), e.getSystemId() == null ? XMLDataObject.NULL : e.getSystemId(), XMLDataObject.NULL + e.getLineNumber(), XMLDataObject.NULL + e.getColumnNumber()});
            em.log(msg);
        }

        public void error(SAXParseException e) {
            this.message(NbBundle.getMessage((Class)(class$org$openide$loaders$XMLDataObject == null ? (class$org$openide$loaders$XMLDataObject = XMLDataObject.class$("org.openide.loaders.XMLDataObject")) : class$org$openide$loaders$XMLDataObject), (String)"PROP_XmlError"), e);
        }

        public void warning(SAXParseException e) {
            this.message(NbBundle.getMessage((Class)(class$org$openide$loaders$XMLDataObject == null ? (class$org$openide$loaders$XMLDataObject = XMLDataObject.class$("org.openide.loaders.XMLDataObject")) : class$org$openide$loaders$XMLDataObject), (String)"PROP_XmlWarning"), e);
        }

        public void fatalError(SAXParseException e) {
            this.message(NbBundle.getMessage((Class)(class$org$openide$loaders$XMLDataObject == null ? (class$org$openide$loaders$XMLDataObject = XMLDataObject.class$("org.openide.loaders.XMLDataObject")) : class$org$openide$loaders$XMLDataObject), (String)"PROP_XmlFatalError"), e);
        }
    }

    private static class XMLEditorSupport
    extends DataEditorSupport
    implements OpenCookie,
    EditorCookie.Observable,
    PrintCookie,
    CloseCookie {
        public XMLEditorSupport(XMLDataObject obj) {
            super(obj, new XMLEditorEnv(obj));
            this.setMIMEType(XMLDataObject.MIME);
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            if (this.getDataObject().getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = XMLDataObject.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) == null) {
                ((XMLDataObject)this.getDataObject()).addSaveCookie(new Save());
                this.getDataObject().setModified(true);
            }
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            SaveCookie save = (SaveCookie)this.getDataObject().getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = XMLDataObject.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            if (save != null) {
                ((XMLDataObject)this.getDataObject()).removeSaveCookie(save);
                this.getDataObject().setModified(false);
            }
        }

        private static class XMLEditorEnv
        extends DataEditorSupport.Env {
            private static final long serialVersionUID = 6593415381104273008L;

            public XMLEditorEnv(DataObject obj) {
                super(obj);
            }

            protected FileObject getFile() {
                return this.getDataObject().getPrimaryFile();
            }

            protected FileLock takeLock() throws IOException {
                return ((XMLDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
            }

            public CloneableOpenSupport findCloneableOpenSupport() {
                return (CloneableOpenSupport)this.getDataObject().getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = XMLDataObject.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            }
        }

        class Save
        implements SaveCookie {
            Save() {
            }

            public void save() throws IOException {
                XMLEditorSupport.this.saveDocument();
                XMLEditorSupport.this.getDataObject().setModified(false);
            }
        }
    }
}

