/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.classpath;

import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.classpath.RefactoringClassPathImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class Util {
    private static WeakHashMap superProjectsCache = null;

    private static WeakHashMap getSuperProjectsCache() {
        if (superProjectsCache == null) {
            superProjectsCache = new WeakHashMap();
        }
        return superProjectsCache;
    }

    public static Set getSuperprojects(Project project) {
        HashSet<Project> result = (HashSet<Project>)Util.getSuperProjectsCache().get(project);
        if (result != null) {
            return result;
        }
        result = new HashSet<Project>();
        Project[] openedProjects = OpenProjects.getDefault().getOpenProjects();
        HashSet<FileObject> sourcePath = new HashSet<FileObject>();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroup = sources.getSourceGroups("java");
        for (int sourceGroupsIndex = 0; sourceGroupsIndex < sourceGroup.length; ++sourceGroupsIndex) {
            ClassPath cp = ClassPath.getClassPath((FileObject)sourceGroup[sourceGroupsIndex].getRootFolder(), (String)"classpath/source");
            sourcePath.addAll(Arrays.asList(cp.getRoots()));
        }
        for (int i = 0; i < openedProjects.length; ++i) {
            Project p = openedProjects[i];
            Sources src = ProjectUtils.getSources((Project)p);
            SourceGroup[] groups = src.getSourceGroups("java");
            for (int j = 0; j < groups.length; ++j) {
                ClassPath cp = ClassPath.getClassPath((FileObject)groups[j].getRootFolder(), (String)"classpath/compile");
                List entries = cp.entries();
                Iterator it = cp.entries().iterator();
                while (it.hasNext()) {
                    URL binURL = ((ClassPath.Entry)it.next()).getURL();
                    FileObject[] roots = SourceForBinaryQuery.findSourceRoots((URL)binURL).getRoots();
                    for (int z = 0; z < roots.length; ++z) {
                        if (!sourcePath.contains(roots[z])) continue;
                        result.add(p);
                    }
                }
            }
        }
        Util.getSuperProjectsCache().put(project, result);
        return result;
    }

    static void resetCache() {
        superProjectsCache = null;
    }

    public static void setDefaultClassPath() {
        Util.setClassPath(RefactoringClassPathImplementation.getDefault());
    }

    public static void setClassPath(Element el) {
        if (el == null) {
            ErrorManager.getDefault().log(1, "Refactoring: setClassPath(null) should not be called. Setting default classpath");
            Util.setDefaultClassPath();
            return;
        }
        if (el != null && el.isValid()) {
            if (el instanceof JavaPackage) {
                Util.setDefaultClassPath();
            } else {
                Resource resource = el.getResource();
                if (resource == null) {
                    ErrorManager.getDefault().log(1, "Refactoring: el.getResource() returned null. el = " + el);
                    Util.setDefaultClassPath();
                    return;
                }
                if (Util.isLocal(el)) {
                    JavaModel.setClassPath((Resource)resource);
                    return;
                }
                FileObject fo = JavaModel.getFileObject((Resource)resource);
                if (fo == null) {
                    ErrorManager.getDefault().log(1, "Refactoring: JavaModel.getFileObject(res) returned null. res = " + resource.getName());
                    Util.setDefaultClassPath();
                    return;
                }
                Util.setClassPath(RefactoringClassPathImplementation.getCustom(Collections.singleton(fo)));
            }
        }
    }

    public static void setClassPath(Collection elements) {
        HashSet<FileObject> s = new HashSet<FileObject>(elements.size());
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            Element el = (Element)i.next();
            Resource resource = el.getResource();
            if (resource == null) {
                ErrorManager.getDefault().log(1, "Refactoring: el.getResource() returned null. el = " + el);
                Util.setDefaultClassPath();
                return;
            }
            FileObject fo = JavaModel.getFileObject((Resource)resource);
            if (fo == null) {
                ErrorManager.getDefault().log(1, "Refactoring: JavaModel.getFileObject(res) returned null. res = " + resource.getName());
                Util.setDefaultClassPath();
                return;
            }
            s.add(fo);
        }
        Util.setClassPath(RefactoringClassPathImplementation.getCustom(s));
    }

    private static void setClassPath(ClassPath cp) {
        JavaModel.setClassPath((ClassPath)cp);
        JMManager.getTransactionMutex().setSearchScope(Collections.singletonList(cp));
    }

    public static boolean isUnderSourceRootOfOpenProjects(FileObject fo) {
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p == null) {
            return false;
        }
        Project[] opened = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < opened.length; ++i) {
            if (p != opened[i]) continue;
            SourceGroup[] gr = ProjectUtils.getSources((Project)p).getSourceGroups("java");
            for (int j = 0; j < gr.length; ++j) {
                if (fo == gr[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)gr[j].getRootFolder(), (FileObject)fo)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isClassPathRoot(FileObject fo) {
        return fo.equals(((JMManager)JMManager.getManager()).getMergedClassPath().findOwnerRoot(fo));
    }

    private static boolean isLocal(Element el) {
        if (el instanceof ClassMember) {
            return Modifier.isPrivate(((ClassMember)el).getModifiers());
        }
        return el instanceof Variable;
    }
}

