/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class DocumentFinder {
    private static FalseBlocksFinder falseBlocksFinder;
    private static FalseFinder falseFinder;
    private static WholeWordsBlocksFinder wholeWordsBlocksFinder;
    private static RegExpBlocksFinder regExpBlocksFinder;
    private static StringBlocksFinder stringBlocksFinder;
    private static WholeWordsBwdFinder wholeWordsBwdFinder;
    private static WholeWordsFwdFinder wholeWordsFwdFinder;
    private static RegExpBwdFinder regExpBwdFinder;
    private static RegExpFwdFinder regExpFwdFinder;
    private static StringBwdFinder stringBwdFinder;
    private static StringFwdFinder stringFwdFinder;

    private DocumentFinder() {
    }

    /*
     * Unable to fully structure code
     */
    private static DocFinder getFinder(BaseDocument doc, Map searchProps, boolean oppositeDir, boolean blocksFinder) {
        text = (String)searchProps.get("find-what");
        if (text == null || text.length() == 0) {
            if (blocksFinder) {
                if (DocumentFinder.falseBlocksFinder == null) {
                    DocumentFinder.falseBlocksFinder = new FalseBlocksFinder();
                }
                return DocumentFinder.falseBlocksFinder;
            }
            if (DocumentFinder.falseFinder == null) {
                DocumentFinder.falseFinder = new FalseFinder();
            }
            return DocumentFinder.falseFinder;
        }
        b = (Boolean)searchProps.get("find-backward-search");
        v0 = bwdSearch = b != null && b != false;
        if (oppositeDir) {
            bwdSearch = bwdSearch == false;
        }
        matchCase = (b = (Boolean)searchProps.get("find-match-case")) != null && b != false;
        b = (Boolean)searchProps.get("find-smart-case");
        smartCase = b != null && b != false;
        b = (Boolean)searchProps.get("find-whole-words");
        v1 = wholeWords = b != null && b != false;
        if (smartCase && !matchCase) {
            cnt = text.length();
            for (i = 0; i < cnt; ++i) {
                if (!Character.isUpperCase(text.charAt(i))) continue;
                matchCase = true;
            }
        }
        regExpSearch = (b = (Boolean)searchProps.get("find-reg-exp")) != null && b != false;
        pattern = null;
        if (regExpSearch) {
            try {
                pattern = PatternCache.getPattern(text, matchCase);
                if (pattern != null) ** GOTO lbl43
                pattern = matchCase != false ? Pattern.compile(text, 8) : Pattern.compile(text, 10);
                PatternCache.putPattern(text, matchCase, pattern);
            }
            catch (PatternSyntaxException pse) {
                if (!blocksFinder) {
                    msg = new NotifyDescriptor.Message((Object)pse.getDescription(), 0);
                    msg.setTitle(NbBundle.getBundle((Class)BaseKit.class).getString("pattern-error-dialog-title"));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                }
                PatternCache.putPattern(text, matchCase, null);
                return null;
            }
        } else {
            PatternCache.clear();
        }
lbl43:
        // 3 sources

        if (blocksFinder) {
            if (wholeWords && !regExpSearch) {
                if (DocumentFinder.wholeWordsBlocksFinder == null) {
                    DocumentFinder.wholeWordsBlocksFinder = new WholeWordsBlocksFinder();
                }
                DocumentFinder.wholeWordsBlocksFinder.setParams(doc, text, matchCase);
                return DocumentFinder.wholeWordsBlocksFinder;
            }
            if (regExpSearch) {
                if (DocumentFinder.regExpBlocksFinder == null) {
                    DocumentFinder.regExpBlocksFinder = new RegExpBlocksFinder();
                }
                DocumentFinder.regExpBlocksFinder.setParams(pattern, matchCase);
                return DocumentFinder.regExpBlocksFinder;
            }
            if (DocumentFinder.stringBlocksFinder == null) {
                DocumentFinder.stringBlocksFinder = new StringBlocksFinder();
            }
            DocumentFinder.stringBlocksFinder.setParams(text, matchCase);
            return DocumentFinder.stringBlocksFinder;
        }
        if (wholeWords && !regExpSearch) {
            if (bwdSearch) {
                if (DocumentFinder.wholeWordsBwdFinder == null) {
                    DocumentFinder.wholeWordsBwdFinder = new WholeWordsBwdFinder();
                }
                DocumentFinder.wholeWordsBwdFinder.setParams(doc, text, matchCase);
                return DocumentFinder.wholeWordsBwdFinder;
            }
            if (DocumentFinder.wholeWordsFwdFinder == null) {
                DocumentFinder.wholeWordsFwdFinder = new WholeWordsFwdFinder();
            }
            DocumentFinder.wholeWordsFwdFinder.setParams(doc, text, matchCase);
            return DocumentFinder.wholeWordsFwdFinder;
        }
        if (regExpSearch) {
            if (bwdSearch) {
                if (DocumentFinder.regExpBwdFinder == null) {
                    DocumentFinder.regExpBwdFinder = new RegExpBwdFinder();
                }
                DocumentFinder.regExpBwdFinder.setParams(pattern, matchCase);
                return DocumentFinder.regExpBwdFinder;
            }
            if (DocumentFinder.regExpFwdFinder == null) {
                DocumentFinder.regExpFwdFinder = new RegExpFwdFinder();
            }
            DocumentFinder.regExpFwdFinder.setParams(pattern, matchCase);
            return DocumentFinder.regExpFwdFinder;
        }
        if (bwdSearch) {
            if (DocumentFinder.stringBwdFinder == null) {
                DocumentFinder.stringBwdFinder = new StringBwdFinder();
            }
            DocumentFinder.stringBwdFinder.setParams(text, matchCase);
            return DocumentFinder.stringBwdFinder;
        }
        if (DocumentFinder.stringFwdFinder == null) {
            DocumentFinder.stringFwdFinder = new StringFwdFinder();
        }
        DocumentFinder.stringFwdFinder.setParams(text, matchCase);
        return DocumentFinder.stringFwdFinder;
    }

    private static FindReplaceResult findReplaceImpl(String replaceText, BaseDocument doc, int startOffset, int endOffset, Map props, boolean oppositeDir) throws BadLocationException {
        Matcher matcher;
        DocFinder finder;
        int[] ret = new int[2];
        if (endOffset == -1) {
            endOffset = doc.getLength();
        }
        if (startOffset > endOffset) {
            int temp = startOffset;
            startOffset = endOffset;
            endOffset = temp;
        }
        if ((finder = DocumentFinder.getFinder(doc, props, oppositeDir, false)) == null) {
            return null;
        }
        finder.reset();
        String cs = doc.getText(startOffset, endOffset - startOffset);
        if (cs == null) {
            return null;
        }
        int findRet = finder.find(startOffset, cs);
        if (!finder.isFound()) {
            ret[0] = -1;
            return new FindReplaceResult(ret, replaceText);
        }
        ret[0] = startOffset + findRet;
        if (finder instanceof StringFinder) {
            int length = ((StringFinder)finder).getFoundLength();
            ret[1] = ret[0] + length;
        }
        if (finder instanceof RegExpFinder && (matcher = ((RegExpFinder)finder).getMatcher()) != null && replaceText != null) {
            CharSequence foundString = cs.subSequence(ret[0] - startOffset, ret[1] - startOffset);
            matcher.reset(foundString);
            if (matcher.find()) {
                try {
                    replaceText = matcher.replaceFirst(replaceText);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ioobe.getLocalizedMessage(), 0);
                    msg.setTitle(NbBundle.getBundle((Class)BaseKit.class).getString("pattern-error-dialog-title"));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    return null;
                }
            }
        }
        return new FindReplaceResult(ret, replaceText);
    }

    public static int[] find(BaseDocument doc, int startOffset, int endOffset, Map props, boolean oppositeDir) throws BadLocationException {
        FindReplaceResult result = DocumentFinder.findReplaceImpl(null, doc, startOffset, endOffset, props, oppositeDir);
        if (result == null) {
            return null;
        }
        return result.getFoundPositions();
    }

    public static int[] findBlocks(BaseDocument doc, int startOffset, int endOffset, Map props, int[] blocks) throws BadLocationException {
        BlocksFinder finder = (BlocksFinder)DocumentFinder.getFinder(doc, props, false, true);
        if (finder == null) {
            return blocks;
        }
        finder.reset();
        finder.setBlocks(blocks);
        String cs = doc.getText(startOffset, endOffset - startOffset);
        if (cs == null) {
            return null;
        }
        finder.find(startOffset, cs);
        int[] ret = finder.getBlocks();
        return ret;
    }

    public static FindReplaceResult findReplaceResult(String replaceString, BaseDocument doc, int startOffset, int endOffset, Map props, boolean oppositeDir) throws BadLocationException {
        return DocumentFinder.findReplaceImpl(replaceString, doc, startOffset, endOffset, props, oppositeDir);
    }

    public static class FindReplaceResult {
        private int[] positions;
        private String replacedString;

        public FindReplaceResult(int[] positions, String replacedString) {
            this.positions = positions;
            this.replacedString = replacedString;
        }

        public String getReplacedString() {
            return this.replacedString;
        }

        public int[] getFoundPositions() {
            return this.positions;
        }
    }

    private static class PatternCache {
        private static String cache_str;
        private static boolean cache_matchCase;
        private static Pattern cache_pattern;

        private PatternCache() {
        }

        public static void putPattern(String str, boolean matchCase, Pattern pattern) {
            cache_str = str;
            cache_matchCase = matchCase;
            cache_pattern = pattern;
        }

        public static Pattern getPattern(String str, boolean matchCase) {
            if (str == null) {
                return null;
            }
            if (str.equals(cache_str) && matchCase == cache_matchCase) {
                return cache_pattern;
            }
            return null;
        }

        public static void clear() {
            cache_str = null;
            cache_matchCase = false;
            cache_pattern = null;
        }
    }

    private static final class RegExpBlocksFinder
    extends AbstractBlocksFinder {
        Pattern pattern;
        int stringInd;
        boolean matchCase;

        public void setParams(Pattern pattern, boolean matchCase) {
            this.pattern = pattern;
            this.matchCase = matchCase;
        }

        public void reset() {
            super.reset();
            this.stringInd = 0;
        }

        public int find(int initOffset, CharSequence data) {
            Matcher matcher = this.pattern.matcher(data);
            int ret = 0;
            while (matcher.find()) {
                int start = initOffset + matcher.start();
                int end = initOffset + matcher.end();
                this.addBlock(start, end);
                ret = start;
            }
            return ret;
        }
    }

    private static final class RegExpFwdFinder
    extends RegExpFinder {
        Pattern pattern;
        boolean matchCase;
        int length = 0;
        Matcher matcher;

        public Matcher getMatcher() {
            return this.matcher;
        }

        public void setParams(Pattern pattern, boolean matchCase) {
            this.matchCase = matchCase;
            this.pattern = pattern;
        }

        public int getFoundLength() {
            return this.length;
        }

        public void reset() {
            super.reset();
            this.length = 0;
        }

        public int find(int initOffset, CharSequence chars) {
            this.matcher = this.pattern.matcher(chars);
            if (this.matcher.find()) {
                this.found = true;
                int start = this.matcher.start();
                int end = this.matcher.end();
                this.length = end - start;
                if (this.length <= 0) {
                    this.found = false;
                    return -1;
                }
                return start;
            }
            return -1;
        }
    }

    private static class RegExpBwdFinder
    extends RegExpFinder {
        boolean matchCase;
        Pattern pattern;
        int length = 0;
        Matcher matcher;

        public Matcher getMatcher() {
            return this.matcher;
        }

        public void setParams(Pattern pattern, boolean matchCase) {
            this.matchCase = matchCase;
            this.pattern = pattern;
        }

        public int getFoundLength() {
            return this.length;
        }

        public void reset() {
            super.reset();
            this.length = 0;
        }

        private int lineFind(int lineStart, int lineEnd, CharSequence chars) {
            this.matcher = this.pattern.matcher(chars.subSequence(lineStart, lineEnd));
            int ret = -1;
            while (this.matcher.find()) {
                int start = this.matcher.start();
                int end = this.matcher.end();
                this.length = end - start;
                if (this.length <= 0) {
                    this.found = false;
                    return -1;
                }
                ret = start;
            }
            return ret;
        }

        public int find(int initOffset, CharSequence chars) {
            int charsEnd;
            int lineEnd = charsEnd = chars.length() - 1;
            int lineStart = charsEnd;
            for (int i = charsEnd; i >= 0; --i) {
                char ch = chars.charAt(i);
                if (ch == '\n' || i == 0) {
                    int retFind = this.lineFind(lineStart + (i == 0 ? 0 : 1), lineEnd + 1, chars);
                    if (retFind != -1) {
                        this.found = true;
                        return i + retFind + (i == 0 ? 0 : 1);
                    }
                    lineEnd = --lineStart;
                    continue;
                }
                --lineStart;
            }
            return -1;
        }
    }

    private static abstract class RegExpFinder
    extends AbstractFinder
    implements StringFinder {
        private RegExpFinder() {
        }

        public abstract Matcher getMatcher();
    }

    private static final class StringFwdFinder
    extends GenericFwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;

        public void setParams(String s, boolean matchCase) {
            this.matchCase = matchCase;
            this.chars = (matchCase ? s : s.toLowerCase()).toCharArray();
        }

        public int getFoundLength() {
            return this.chars.length;
        }

        public void reset() {
            super.reset();
            this.stringInd = 0;
        }

        protected int scan(char ch, boolean lastChar) {
            if (!this.matchCase) {
                ch = Character.toLowerCase(ch);
            }
            if (ch == this.chars[this.stringInd]) {
                ++this.stringInd;
                if (this.stringInd == this.chars.length) {
                    this.found = true;
                    return 1 - this.stringInd;
                }
                return 1;
            }
            if (this.stringInd == 0) {
                return 1;
            }
            int back = 1 - this.stringInd;
            this.stringInd = 0;
            return back;
        }
    }

    private static class StringBwdFinder
    extends GenericBwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        int endInd;

        public void setParams(String s, boolean matchCase) {
            this.matchCase = matchCase;
            this.chars = (matchCase ? s : s.toLowerCase()).toCharArray();
            this.endInd = this.chars.length - 1;
        }

        public int getFoundLength() {
            return this.chars.length;
        }

        public void reset() {
            super.reset();
            this.stringInd = this.endInd;
        }

        protected int scan(char ch, boolean lastChar) {
            if (!this.matchCase) {
                ch = Character.toLowerCase(ch);
            }
            if (ch == this.chars[this.stringInd]) {
                --this.stringInd;
                if (this.stringInd == -1) {
                    this.found = true;
                    return 0;
                }
                return -1;
            }
            if (this.stringInd == this.endInd) {
                return -1;
            }
            int back = this.chars.length - 2 - this.stringInd;
            this.stringInd = this.endInd;
            return back;
        }
    }

    private static final class WholeWordsFwdFinder
    extends GenericFwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        BaseDocument doc;
        boolean insideWord;
        boolean firstCharWordPart;
        boolean wordFound;

        public void setParams(BaseDocument doc, String s, boolean matchCase) {
            this.doc = doc;
            this.matchCase = matchCase;
            this.chars = (matchCase ? s : s.toLowerCase()).toCharArray();
            this.firstCharWordPart = doc.isIdentifierPart(this.chars[0]);
        }

        public int getFoundLength() {
            return this.chars.length;
        }

        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = 0;
        }

        protected int scan(char ch, boolean lastChar) {
            if (!this.matchCase) {
                ch = Character.toLowerCase(ch);
            }
            if (this.wordFound) {
                if (this.doc.isIdentifierPart(ch)) {
                    this.wordFound = false;
                    this.insideWord = this.firstCharWordPart;
                    this.stringInd = 0;
                    return 1 - this.chars.length;
                }
                this.found = true;
                return -this.chars.length;
            }
            if (this.stringInd == 0) {
                if (ch != this.chars[0] || this.insideWord) {
                    this.insideWord = this.doc.isIdentifierPart(ch);
                    return 1;
                }
                this.stringInd = 1;
                if (this.chars.length == 1) {
                    if (lastChar) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return 1;
                }
                return 1;
            }
            if (ch == this.chars[this.stringInd]) {
                ++this.stringInd;
                if (this.stringInd == this.chars.length) {
                    if (lastChar) {
                        this.found = true;
                        return 1 - this.chars.length;
                    }
                    this.wordFound = true;
                    return 1;
                }
                return 1;
            }
            int back = 1 - this.stringInd;
            this.stringInd = 0;
            this.insideWord = this.firstCharWordPart;
            return back;
        }
    }

    private static abstract class GenericBwdFinder
    extends AbstractFinder {
        private GenericBwdFinder() {
        }

        public final int find(int initOffset, CharSequence chars) {
            int offset;
            boolean limitPos = false;
            int limitOffset = chars.length();
            for (offset = chars.length() - 1; offset >= 0 && offset < limitOffset; offset += this.scan(chars.charAt(offset), offset == limitOffset)) {
                if (!this.found) continue;
                break;
            }
            return offset;
        }

        protected abstract int scan(char var1, boolean var2);
    }

    private static abstract class GenericFwdFinder
    extends AbstractFinder {
        private GenericFwdFinder() {
        }

        public final int find(int initOffset, CharSequence chars) {
            int offset;
            int limitPos = chars.length();
            int limitOffset = limitPos - 1;
            for (offset = 0; offset >= 0 && offset < limitPos; offset += this.scan(chars.charAt(offset), offset == limitOffset)) {
                if (!this.found) continue;
                break;
            }
            return offset;
        }

        protected abstract int scan(char var1, boolean var2);
    }

    private static final class WholeWordsBwdFinder
    extends GenericBwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        boolean insideWord;
        boolean lastCharWordPart;
        boolean wordFound;
        int endInd;
        BaseDocument doc;

        public void setParams(BaseDocument doc, String s, boolean matchCase) {
            this.doc = doc;
            this.matchCase = matchCase;
            this.chars = (matchCase ? s : s.toLowerCase()).toCharArray();
            this.endInd = this.chars.length - 1;
            doc.isIdentifierPart(this.chars[this.endInd]);
        }

        public int getFoundLength() {
            return this.chars.length;
        }

        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = this.endInd;
        }

        protected int scan(char ch, boolean lastChar) {
            if (!this.matchCase) {
                ch = Character.toLowerCase(ch);
            }
            if (this.wordFound) {
                if (this.doc.isIdentifierPart(ch)) {
                    this.wordFound = false;
                    this.insideWord = this.lastCharWordPart;
                    this.stringInd = this.endInd;
                    return this.endInd;
                }
                this.found = true;
                return 1;
            }
            if (this.stringInd == this.endInd) {
                if (ch != this.chars[this.endInd] || this.insideWord) {
                    this.insideWord = this.doc.isIdentifierPart(ch);
                    return -1;
                }
                this.stringInd = this.endInd - 1;
                if (this.chars.length == 1) {
                    if (lastChar) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return -1;
                }
                return -1;
            }
            if (ch == this.chars[this.stringInd]) {
                --this.stringInd;
                if (this.stringInd == -1) {
                    if (lastChar) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return -1;
                }
                return -1;
            }
            int back = this.chars.length - 2 - this.stringInd;
            this.stringInd = this.endInd;
            this.insideWord = this.lastCharWordPart;
            return back;
        }
    }

    private static final class StringBlocksFinder
    extends AbstractBlocksFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;

        public void setParams(String s, boolean matchCase) {
            this.matchCase = matchCase;
            this.chars = (matchCase ? s : s.toLowerCase()).toCharArray();
        }

        public void reset() {
            super.reset();
            this.stringInd = 0;
        }

        public int find(int initOffset, CharSequence data) {
            int offset = 0;
            int endPos = data.length();
            while (offset >= 0 && offset < endPos) {
                char ch = data.charAt(offset);
                if (!this.matchCase) {
                    ch = Character.toLowerCase(ch);
                }
                if (ch == this.chars[this.stringInd]) {
                    ++this.stringInd;
                    if (this.stringInd == this.chars.length) {
                        int blkEnd = initOffset + offset + 1;
                        this.addBlock(blkEnd - this.stringInd, blkEnd);
                        this.stringInd = 0;
                    }
                    ++offset;
                    continue;
                }
                offset += 1 - this.stringInd;
                this.stringInd = 0;
            }
            return offset;
        }
    }

    private static final class WholeWordsBlocksFinder
    extends AbstractBlocksFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        boolean insideWord;
        boolean firstCharWordPart;
        boolean wordFound;
        BaseDocument doc;

        public void setParams(BaseDocument doc, String s, boolean matchCase) {
            this.matchCase = matchCase;
            this.doc = doc;
            this.chars = (matchCase ? s : s.toLowerCase()).toCharArray();
            this.firstCharWordPart = doc.isIdentifierPart(this.chars[0]);
        }

        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = 0;
        }

        public int find(int initOffset, CharSequence data) {
            int offset = 0;
            int limitPos = data.length();
            int limitOffset = limitPos - 1;
            while (offset >= 0 && offset < limitPos) {
                int blkEnd;
                char ch = data.charAt(offset);
                if (!this.matchCase) {
                    ch = Character.toLowerCase(ch);
                }
                if (this.wordFound) {
                    if (this.doc.isIdentifierPart(ch)) {
                        this.insideWord = this.firstCharWordPart;
                        offset -= this.chars.length - 1;
                    } else {
                        blkEnd = initOffset + offset;
                        this.addBlock(blkEnd - this.chars.length, blkEnd);
                        this.insideWord = false;
                        ++offset;
                    }
                    this.wordFound = false;
                    this.stringInd = 0;
                    continue;
                }
                if (this.stringInd == 0) {
                    if (ch != this.chars[0] || this.insideWord) {
                        this.insideWord = this.doc.isIdentifierPart(ch);
                        ++offset;
                        continue;
                    }
                    this.stringInd = 1;
                    if (this.chars.length == 1) {
                        if (offset == limitOffset) {
                            int blkStart = initOffset + offset;
                            this.addBlock(blkStart, blkStart + 1);
                        } else {
                            this.wordFound = true;
                        }
                    }
                    ++offset;
                    continue;
                }
                if (ch == this.chars[this.stringInd]) {
                    ++this.stringInd;
                    if (this.stringInd == this.chars.length) {
                        if (offset == limitOffset) {
                            blkEnd = initOffset + 1;
                            this.addBlock(blkEnd - this.stringInd, blkEnd);
                        } else {
                            this.wordFound = true;
                        }
                    }
                    ++offset;
                    continue;
                }
                offset += 1 - this.stringInd;
                this.stringInd = 0;
                this.insideWord = this.firstCharWordPart;
            }
            return offset;
        }
    }

    private static interface StringFinder
    extends DocFinder {
        public int getFoundLength();
    }

    private static abstract class AbstractFinder
    implements DocFinder {
        protected boolean found;

        private AbstractFinder() {
        }

        public final boolean isFound() {
            return this.found;
        }

        public void reset() {
            this.found = false;
        }
    }

    private static interface BlocksFinder
    extends DocFinder {
        public void setBlocks(int[] var1);

        public int[] getBlocks();
    }

    private static abstract class AbstractBlocksFinder
    extends AbstractFinder
    implements BlocksFinder {
        private static int[] EMPTY_INT_ARRAY = new int[0];
        private int[] blocks = EMPTY_INT_ARRAY;
        private int blocksInd;
        private boolean closed;

        private AbstractBlocksFinder() {
        }

        public void reset() {
            this.blocksInd = 0;
            this.closed = false;
        }

        public int[] getBlocks() {
            if (!this.closed) {
                this.closeBlocks();
                this.closed = true;
            }
            return this.blocks;
        }

        public void setBlocks(int[] blocks) {
            this.blocks = blocks;
            this.closed = false;
        }

        protected void addBlock(int blkStartPos, int blkEndPos) {
            if (this.blocksInd == this.blocks.length) {
                int[] dbl = new int[this.blocks.length * 2];
                System.arraycopy(this.blocks, 0, dbl, 0, this.blocks.length);
                this.blocks = dbl;
            }
            this.blocks[this.blocksInd++] = blkStartPos;
            this.blocks[this.blocksInd++] = blkEndPos;
        }

        protected void closeBlocks() {
            this.addBlock(-1, -1);
        }

        public String debugBlocks() {
            StringBuffer buf = new StringBuffer();
            int ind = 0;
            while (this.blocks[ind] != -1) {
                buf.append(ind / 2 + 1 + ": [" + this.blocks[ind] + ", " + this.blocks[ind + 1] + "]\n");
                ind += 2;
            }
            return buf.toString();
        }
    }

    private static class FalseFinder
    extends AbstractFinder
    implements StringFinder {
        private FalseFinder() {
        }

        public int find(int initOffset, CharSequence data) {
            return -1;
        }

        public int getFoundLength() {
            return 0;
        }
    }

    private static final class FalseBlocksFinder
    extends AbstractBlocksFinder {
        private FalseBlocksFinder() {
        }

        public int find(int initOffset, CharSequence data) {
            return -1;
        }
    }

    private static interface DocFinder {
        public int find(int var1, CharSequence var2);

        public boolean isFound();

        public void reset();
    }
}

