/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.support;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesFactory;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesImplementation;
import org.netbeans.modules.j2ee.persistenceapi.FileChangeSupport;
import org.netbeans.modules.j2ee.persistenceapi.FileChangeSupportEvent;
import org.netbeans.modules.j2ee.persistenceapi.FileChangeSupportListener;
import org.openide.filesystems.FileUtil;

public final class PersistenceScopesHelper {
    private final PersistenceScopes persistenceScopes = PersistenceScopesFactory.createPersistenceScopes(new PersistenceScopesImpl());
    private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private final FileListener fileListener = new FileListener();
    private PersistenceScope persistenceScope;
    private File persistenceXml;
    private boolean persistenceExists;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePersistenceScope(PersistenceScope newPersistenceScope, File newPersistenceXml) {
        boolean newPersistenceExists;
        PersistenceScope oldPersistenceScope;
        boolean oldPersistenceExists;
        if (newPersistenceScope == null && newPersistenceXml != null) {
            throw new IllegalArgumentException("The persistenceScope parameter cannot be null when newPersistenceXml is non-null");
        }
        PersistenceScopesHelper persistenceScopesHelper = this;
        synchronized (persistenceScopesHelper) {
            oldPersistenceExists = this.persistenceExists;
            oldPersistenceScope = this.persistenceScope;
            if (this.persistenceXml != null) {
                FileChangeSupport.DEFAULT.removeListener(this.fileListener, this.persistenceXml);
            }
            if (newPersistenceXml != null) {
                this.persistenceXml = newPersistenceXml;
                FileChangeSupport.DEFAULT.addListener(this.fileListener, this.persistenceXml);
            } else {
                this.persistenceXml = null;
            }
            this.persistenceScope = newPersistenceScope;
            this.persistenceXml = newPersistenceXml;
            this.change();
            newPersistenceExists = this.persistenceExists;
        }
        if (oldPersistenceExists != newPersistenceExists || oldPersistenceScope != newPersistenceScope && newPersistenceExists) {
            this.propChangeSupport.firePropertyChange("persistenceScopes", null, null);
        }
    }

    public PersistenceScopes getPersistenceScopes() {
        return this.persistenceScopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change() {
        PersistenceScopesHelper persistenceScopesHelper = this;
        synchronized (persistenceScopesHelper) {
            this.persistenceExists = false;
            if (this.persistenceXml != null) {
                this.persistenceExists = FileUtil.toFileObject((File)this.persistenceXml) != null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileEvent() {
        boolean newPersistenceExists;
        boolean oldPersistenceExists;
        PersistenceScopesHelper persistenceScopesHelper = this;
        synchronized (persistenceScopesHelper) {
            oldPersistenceExists = this.persistenceExists;
            this.change();
            newPersistenceExists = this.persistenceExists;
        }
        if (oldPersistenceExists != newPersistenceExists) {
            this.propChangeSupport.firePropertyChange("persistenceScopes", null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceScope[] getPersistenceScopeList() {
        PersistenceScopesHelper persistenceScopesHelper = this;
        synchronized (persistenceScopesHelper) {
            if (this.persistenceExists) {
                return new PersistenceScope[]{this.persistenceScope};
            }
            return new PersistenceScope[0];
        }
    }

    private void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    private void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    private class PersistenceScopesImpl
    implements PersistenceScopesImplementation {
        private PersistenceScopesImpl() {
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            PersistenceScopesHelper.this.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            PersistenceScopesHelper.this.removePropertyChangeListener(listener);
        }

        public PersistenceScope[] getPersistenceScopes() {
            return PersistenceScopesHelper.this.getPersistenceScopeList();
        }
    }

    private class FileListener
    implements FileChangeSupportListener {
        private FileListener() {
        }

        public void fileCreated(FileChangeSupportEvent event) {
            PersistenceScopesHelper.this.fileEvent();
        }

        public void fileDeleted(FileChangeSupportEvent event) {
            PersistenceScopesHelper.this.fileEvent();
        }

        public void fileModified(FileChangeSupportEvent event) {
        }
    }
}

