/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ant.freeform.spi.ProjectPropertiesPanel;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.web.freeform.WebProjectGenerator;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WebClasspathPanel
extends JPanel
implements HelpCtx.Provider {
    private DefaultListModel listModel;
    private File projectFolder = null;
    private File nbProjectFolder;
    private File lastChosenFile = null;
    private boolean isSeparateClasspath = true;
    private boolean ignoreEvent;
    private static String JAVA_SOURCES_CLASSPATH = NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"LBL_JAVA_SOURCE_CLASSPATH");
    private JButton addClasspath;
    private JList classpath;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JButton moveDown;
    private JButton moveUp;
    private JButton removeClasspath;

    public WebClasspathPanel() {
        this(true);
    }

    public WebClasspathPanel(boolean isWizard) {
        this.initComponents();
        this.jTextArea1.setBackground(this.getBackground());
        this.listModel = new DefaultListModel();
        this.listModel.add(0, JAVA_SOURCES_CLASSPATH);
        this.classpath.setModel(this.listModel);
        if (!isWizard) {
            this.jTextArea1.setText(NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"LBL_ClasspathPanel_Explanation"));
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WebClasspathPanel.class);
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.addClasspath = new JButton();
        this.removeClasspath = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.classpath = new JList();
        this.jPanel1 = new JPanel();
        this.moveUp = new JButton();
        this.moveDown = new JButton();
        this.jTextArea1 = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.classpath);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"LBL_ClasspathPanel_jLabel3"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_jLabel3"));
        Mnemonics.setLocalizedText((AbstractButton)this.addClasspath, (String)NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"BTN_ClasspathPanel_addClasspath"));
        this.addClasspath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebClasspathPanel.this.addClasspathActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.addClasspath, gridBagConstraints);
        this.addClasspath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_addClasspath"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeClasspath, (String)NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"BTN_ClasspathPanel_removeClasspath"));
        this.removeClasspath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebClasspathPanel.this.removeClasspathActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.removeClasspath, gridBagConstraints);
        this.removeClasspath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_removeClasspath"));
        this.classpath.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                WebClasspathPanel.this.classpathValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.classpath);
        this.classpath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_classpath"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.moveUp.setMnemonic(NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"LBL_MoveUp_MNE").charAt(0));
        this.moveUp.setText(NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"LBL_ClasspathPanel_Move_Up"));
        this.moveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebClasspathPanel.this.moveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.moveUp, gridBagConstraints);
        this.moveUp.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/freeform/ui/Bundle").getString("AD_ClasspathPanel_noveUp"));
        this.moveDown.setMnemonic(NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"LBL_MoveDown_MNE").charAt(0));
        this.moveDown.setText(NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"LBL_ClasspathPanel_Move_Down"));
        this.moveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebClasspathPanel.this.moveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.moveDown, gridBagConstraints);
        this.moveDown.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/freeform/ui/Bundle").getString("AD_ClasspathPanel_moveDown"));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setForeground(new Color(0, 0, 0));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"MSG_ClasspathPanel_jTextArea"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setDisabledTextColor(Color.black);
        this.jTextArea1.setEnabled(false);
        this.jTextArea1.setSelectedTextColor(new Color(0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextArea1.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"ACSN_ClasspathPanel_jTextArea"));
        this.jTextArea1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_jTextArea"));
    }

    private void classpathValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    private void moveDownActionPerformed(ActionEvent evt) {
        int[] indices = this.classpath.getSelectedIndices();
        if (indices.length == 0 || indices[indices.length - 1] == this.listModel.getSize() - 1) {
            return;
        }
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            Object o = this.listModel.remove(index);
            this.listModel.add(++index, o);
            indices[i] = index;
        }
        this.classpath.setSelectedIndices(indices);
        this.updateButtons();
    }

    private void moveUpActionPerformed(ActionEvent evt) {
        int[] indices = this.classpath.getSelectedIndices();
        if (indices.length == 0 || indices[0] == 0) {
            return;
        }
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            Object o = this.listModel.remove(index);
            this.listModel.add(--index, o);
            indices[i] = index;
        }
        this.classpath.setSelectedIndices(indices);
        this.updateButtons();
    }

    private void updateButtons() {
        int[] indices = this.classpath.getSelectedIndices();
        this.removeClasspath.setEnabled(this.listModel.getSize() > 0 && indices.length != 0 && indices[0] != 0);
        this.moveUp.setEnabled(indices.length > 0 && indices[0] > 1);
        this.moveDown.setEnabled(indices.length > 0 && indices[indices.length - 1] != this.listModel.getSize() - 1 && indices[0] != 0);
    }

    private void removeClasspathActionPerformed(ActionEvent evt) {
        int[] entries = this.classpath.getSelectedIndices();
        for (int i = 0; i < entries.length; ++i) {
            this.listModel.remove(entries[i] - i);
        }
        this.updateButtons();
    }

    private void addClasspathActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(true);
        if (this.lastChosenFile != null) {
            chooser.setSelectedFile(this.lastChosenFile);
        } else if (this.projectFolder != null) {
            chooser.setSelectedFile(this.projectFolder);
        }
        chooser.setDialogTitle(NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"LBL_Browse_Classpath"));
        SimpleFileFilter fileFilter = new SimpleFileFilter(NbBundle.getMessage((Class)WebClasspathPanel.class, (String)"LBL_ZipJarFolderFilter"), new String[]{"ZIP", "JAR"});
        chooser.setFileFilter(fileFilter);
        chooser.setAcceptAllFileFilterUsed(false);
        if (0 == chooser.showOpenDialog(this)) {
            File[] files = chooser.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = FileUtil.normalizeFile((File)files[i]);
                if (!((FileFilter)fileFilter).accept(file)) continue;
                this.listModel.addElement(file.getAbsolutePath());
                this.lastChosenFile = file;
            }
            this.updateButtons();
        }
    }

    public void setProjectFolders(File baseFolder, File nbProjectFolder) {
        this.projectFolder = baseFolder;
        this.nbProjectFolder = nbProjectFolder;
    }

    public String getClasspath() {
        StringBuffer sf = new StringBuffer();
        for (int i = 1; i < this.listModel.getSize(); ++i) {
            File f = new File((String)this.listModel.get(i));
            String path = Util.relativizeLocation((File)this.projectFolder, (File)this.nbProjectFolder, (File)f);
            sf.append(path);
            if (i >= this.listModel.getSize() - 1) continue;
            sf.append(File.pathSeparatorChar);
        }
        return sf.toString();
    }

    private void setClasspath(String classpath, PropertyEvaluator evaluator) {
        if (classpath == null) {
            return;
        }
        StringTokenizer ts = new StringTokenizer(classpath, "" + File.pathSeparatorChar);
        this.listModel.clear();
        this.listModel.addElement(JAVA_SOURCES_CLASSPATH);
        String[] cpa = PropertyUtils.tokenizePath((String)evaluator.evaluate(classpath));
        for (int i = 0; i < cpa.length; ++i) {
            String path = cpa[i];
            if ((path = PropertyUtils.resolveFile((File)this.nbProjectFolder, (String)path).getAbsolutePath()) == null) continue;
            this.listModel.addElement(path);
        }
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            try {
                return FileUtil.isArchiveFile((URL)f.toURI().toURL());
            }
            catch (MalformedURLException mue) {
                ErrorManager.getDefault().notify((Throwable)mue);
                return false;
            }
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class Panel
    implements ProjectPropertiesPanel {
        private WebClasspathPanel panel = null;
        private Project project;
        private AntProjectHelper projectHelper;
        private PropertyEvaluator projectEvaluator;
        private AuxiliaryConfiguration aux;

        public Panel(Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
            this.project = project;
            this.projectHelper = projectHelper;
            this.projectEvaluator = projectEvaluator;
            this.aux = aux;
        }

        public void storeValues() {
            if (this.panel == null) {
                return;
            }
            AuxiliaryConfiguration aux = Util.getAuxiliaryConfiguration((AntProjectHelper)this.projectHelper);
            List l = WebProjectGenerator.getWebmodules(this.projectHelper, aux);
            if (l != null) {
                WebProjectGenerator.WebModule wm = (WebProjectGenerator.WebModule)l.get(0);
                wm.classpath = this.panel.getClasspath();
                WebProjectGenerator.putWebModules(this.projectHelper, aux, l);
            }
            this.panel.updateButtons();
        }

        public String getDisplayName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$web$freeform$ui$WebClasspathPanel == null ? (class$org$netbeans$modules$web$freeform$ui$WebClasspathPanel = WebClasspathPanel.class$("org.netbeans.modules.web.freeform.ui.WebClasspathPanel")) : class$org$netbeans$modules$web$freeform$ui$WebClasspathPanel), (String)"LBL_ProjectCustomizer_Category_Classpath");
        }

        public JComponent getComponent() {
            if (this.panel == null) {
                this.panel = new WebClasspathPanel(false);
                List l = WebProjectGenerator.getWebmodules(this.projectHelper, this.aux);
                if (l != null) {
                    WebProjectGenerator.WebModule wm = (WebProjectGenerator.WebModule)l.get(0);
                    this.panel.setProjectFolders(Util.getProjectLocation((AntProjectHelper)this.projectHelper, (PropertyEvaluator)this.projectEvaluator), FileUtil.toFile((FileObject)this.projectHelper.getProjectDirectory()));
                    this.panel.setClasspath(wm.classpath, this.projectEvaluator);
                    this.panel.updateButtons();
                }
            }
            return this.panel;
        }

        public int getPreferredPosition() {
            return 250;
        }
    }
}

