/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.xmi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jmi.model.Association;
import javax.jmi.model.Attribute;
import javax.jmi.model.Feature;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;

public class ElementsCache {
    private HashMap structureFields_cache = new HashMap();
    private HashMap instanceAttributes_cache = new HashMap();
    private HashMap classAttributes_cache = new HashMap();
    private HashMap references_cache = new HashMap();
    private HashMap subtypes_cache = null;
    private RefPackage extent;
    private HashMap outermostPackages = null;
    private HashMap trackedPackages = null;
    private HashMap proxies_cache = new HashMap();

    public ElementsCache(RefPackage extent) {
        this.extent = extent;
    }

    private void findOutermostPackages(RefPackage pkg) {
        Iterator iter;
        if (this.trackedPackages.get(pkg) != null) {
            return;
        }
        MofPackage metaObj = (MofPackage)pkg.refMetaObject();
        if (metaObj.getContainer() == null) {
            iter = metaObj.getQualifiedName().iterator();
            String fqName = (String)iter.next();
            while (iter.hasNext()) {
                fqName = fqName.concat(".").concat((String)iter.next());
            }
            this.outermostPackages.put(fqName, pkg);
        }
        this.trackedPackages.put(pkg, pkg);
        iter = pkg.refAllPackages().iterator();
        while (iter.hasNext()) {
            this.findOutermostPackages((RefPackage)iter.next());
        }
    }

    private void cacheContainedElements(MofClass mofClass) {
        LinkedList temp = new LinkedList();
        List superClasses = mofClass.allSupertypes();
        Namespace namespace = null;
        Iterator it = superClasses.iterator();
        while (it.hasNext()) {
            namespace = (Namespace)it.next();
            temp.addAll(namespace.getContents());
        }
        temp.addAll(mofClass.getContents());
        LinkedList<RefObject> instanceAttributes = new LinkedList<RefObject>();
        LinkedList<RefObject> classAttributes = new LinkedList<RefObject>();
        LinkedList<RefObject> references = new LinkedList<RefObject>();
        it = temp.iterator();
        while (it.hasNext()) {
            Association assoc;
            RefObject refObject = (RefObject)it.next();
            if (!(refObject instanceof Feature)) continue;
            boolean instanceLevel = ((Feature)refObject).getScope().equals(ScopeKindEnum.INSTANCE_LEVEL);
            if (refObject instanceof Attribute && !((Attribute)refObject).isDerived()) {
                if (instanceLevel) {
                    instanceAttributes.add(refObject);
                    continue;
                }
                classAttributes.add(refObject);
                continue;
            }
            if (!(refObject instanceof Reference) || (assoc = (Association)((Reference)refObject).getReferencedEnd().getContainer()).isDerived()) continue;
            references.add(refObject);
        }
        this.instanceAttributes_cache.put(mofClass, instanceAttributes);
        this.classAttributes_cache.put(mofClass, classAttributes);
        this.references_cache.put(mofClass, references);
    }

    public List instanceAttributes(MofClass mofClass) {
        List list = (List)this.instanceAttributes_cache.get(mofClass);
        if (list == null) {
            this.cacheContainedElements(mofClass);
            list = (List)this.instanceAttributes_cache.get(mofClass);
        }
        return list;
    }

    public List localInstanceAttributes(MofClass mofClass) {
        Iterator it = mofClass.getContents().iterator();
        LinkedList result = new LinkedList();
        while (it.hasNext()) {
            boolean instanceLevel;
            Object refObject = it.next();
            if (!(refObject instanceof Feature) || !(instanceLevel = ((Feature)refObject).getScope().equals(ScopeKindEnum.INSTANCE_LEVEL)) || !(refObject instanceof Attribute) || ((Attribute)refObject).isDerived()) continue;
            result.add(refObject);
        }
        return result;
    }

    public List classAttributes(MofClass mofClass) {
        List list = (List)this.classAttributes_cache.get(mofClass);
        if (list == null) {
            this.cacheContainedElements(mofClass);
            list = (List)this.classAttributes_cache.get(mofClass);
        }
        return list;
    }

    public List references(MofClass mofClass) {
        List list = (List)this.references_cache.get(mofClass);
        if (list == null) {
            this.cacheContainedElements(mofClass);
            list = (List)this.references_cache.get(mofClass);
        }
        return list;
    }

    public List localReferences(MofClass mofClass) {
        Iterator it = mofClass.getContents().iterator();
        LinkedList result = new LinkedList();
        while (it.hasNext()) {
            Association assoc;
            boolean instanceLevel;
            Object refObject = it.next();
            if (!(refObject instanceof Feature) || !(instanceLevel = ((Feature)refObject).getScope().equals(ScopeKindEnum.INSTANCE_LEVEL)) || !(refObject instanceof Reference) || (assoc = (Association)((Reference)refObject).getReferencedEnd().getContainer()).isDerived()) continue;
            result.add(refObject);
        }
        return result;
    }

    public List structureFields(StructureType type) {
        LinkedList fields = (LinkedList)this.structureFields_cache.get(type);
        if (fields != null) {
            return fields;
        }
        fields = new LinkedList();
        Iterator content = type.getContents().iterator();
        while (content.hasNext()) {
            Object element = content.next();
            if (!(element instanceof StructureField)) continue;
            fields.add(element);
        }
        this.structureFields_cache.put(type, fields);
        return fields;
    }

    public RefBaseObject findProxy(ModelElement element) {
        RefBaseObject proxy;
        if (this.outermostPackages == null) {
            this.trackedPackages = new HashMap();
            this.outermostPackages = new HashMap();
            this.findOutermostPackages(this.extent);
        }
        if ((proxy = (RefBaseObject)this.proxies_cache.get(element)) != null) {
            return proxy;
        }
        LinkedList<Namespace> path = new LinkedList<Namespace>();
        for (Namespace container = element.getContainer(); container != null; container = container.getContainer()) {
            path.add(container);
        }
        MofPackage mofPackage = (MofPackage)path.removeLast();
        RefPackage refPackage = (RefPackage)this.outermostPackages.get(mofPackage.getName());
        if (refPackage == null) {
            Iterator iter = this.outermostPackages.entrySet().iterator();
            while (iter.hasNext()) {
                RefPackage ref = (RefPackage)iter.next().getValue();
                MofPackage meta = (MofPackage)ref.refMetaObject();
                if (!meta.allSupertypes().contains(mofPackage)) continue;
                refPackage = ref;
                break;
            }
        }
        if (refPackage == null) {
            return null;
        }
        if (path.size() == 0) {
            proxy = refPackage;
        }
        while (path.size() > 0) {
            ModelElement elem = (ModelElement)path.removeLast();
            if (elem instanceof MofPackage) {
                refPackage = refPackage.refPackage((RefObject)elem);
                if (path.size() != 0) continue;
                proxy = refPackage;
                continue;
            }
            if (!(elem instanceof MofClass) || path.size() != 0) break;
            RefClass refClass = refPackage.refClass((RefObject)elem);
            proxy = refClass;
        }
        if (proxy != null) {
            this.proxies_cache.put(element, proxy);
        }
        return proxy;
    }

    public Set getAllSubtypes(MofClass clazz) {
        if (this.subtypes_cache == null) {
            this.subtypes_cache = new HashMap();
            this.cacheSubtypes(this.extent);
        }
        return (Set)this.subtypes_cache.get(clazz);
    }

    private void cacheSubtypes(RefPackage pkg) {
        Iterator iter = pkg.refAllClasses().iterator();
        while (iter.hasNext()) {
            MofClass mofClass = (MofClass)((RefClass)iter.next()).refMetaObject();
            Iterator supertypes = mofClass.allSupertypes().iterator();
            while (supertypes.hasNext()) {
                MofClass superClass = (MofClass)supertypes.next();
                HashSet<MofClass> list = (HashSet<MofClass>)this.subtypes_cache.get(superClass);
                if (list == null) {
                    list = new HashSet<MofClass>();
                    this.subtypes_cache.put(superClass, list);
                }
                list.add(mofClass);
            }
            HashSet<MofClass> list = (HashSet<MofClass>)this.subtypes_cache.get(mofClass);
            if (list == null) {
                list = new HashSet<MofClass>();
                this.subtypes_cache.put(mofClass, list);
            }
            list.add(mofClass);
        }
        iter = pkg.refAllPackages().iterator();
        while (iter.hasNext()) {
            this.cacheSubtypes((RefPackage)iter.next());
        }
    }
}

