/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

public class BreakpointsReader
implements Properties.Reader {
    public String[] getSupportedClassNames() {
        return new String[]{AntBreakpoint.class.getName()};
    }

    public Object read(String typeID, Properties properties) {
        if (!typeID.equals(AntBreakpoint.class.getName())) {
            return null;
        }
        Line line = this.getLine(properties.getString("url", null), properties.getInt("lineNumber", 1));
        if (line == null) {
            return null;
        }
        return new AntBreakpoint(line);
    }

    public void write(Object object, Properties properties) {
        AntBreakpoint b = (AntBreakpoint)((Object)object);
        FileObject fo = (FileObject)b.getLine().getLookup().lookup(FileObject.class);
        try {
            properties.setString("url", fo.getURL().toString());
            properties.setInt("lineNumber", b.getLine().getLineNumber());
        }
        catch (FileStateInvalidException ex) {
            ex.printStackTrace();
        }
    }

    private Line getLine(String url, int lineNumber) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (file == null) {
            return null;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        if (dataObject == null) {
            return null;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return null;
        }
        Line.Set ls = lineCookie.getLineSet();
        if (ls == null) {
            return null;
        }
        try {
            return ls.getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return null;
    }
}

