/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.client;

import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.j2ee.dd.impl.common.ParseUtils;
import org.openide.filesystems.FileObject;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ClientParseUtils {
    public static String getVersion(InputStream is) throws IOException, SAXException {
        return ParseUtils.getVersion(is, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
    }

    public static String getVersion(InputSource is) throws IOException, SAXException {
        return ParseUtils.getVersion(is, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
    }

    public static SAXParseException parse(FileObject fo) throws SAXException, IOException {
        return ClientParseUtils.parse(new InputSource(fo.getInputStream()));
    }

    public static SAXParseException parse(InputSource is) throws SAXException, IOException {
        return ParseUtils.parseDD(is, DDResolver.getInstance());
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            if ("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN".equals(publicId)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/application-client_1_3.dtd");
            }
            if ("http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/application-client_1_4.xsd");
            }
            if ("http://java.sun.com/xml/ns/javaee/application-client_5.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/application-client_5.xsd");
            }
            return null;
        }
    }

    private static class VersionHandler
    extends DefaultHandler {
        private VersionHandler() {
        }

        public void startElement(String uri, String localName, String rawName, Attributes atts) throws SAXException {
            if ("application-client".equals(rawName)) {
                String version = atts.getValue("version");
                throw new SAXException("version:" + (version == null ? "1.3" : version));
            }
        }
    }
}

