/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport;

import java.awt.Container;
import java.awt.LayoutManager;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.layoutsupport.DefaultLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class LayoutSupportRegistry {
    private static Map containerToLayoutDelegate;
    private static Map layoutToLayoutDelegate;
    private static boolean needPaletteRescan;
    public static final String DEFAULT_SUPPORT = "<default>";
    private static FileChangeListener paletteListener;
    private static Map instanceMap;
    private Reference formModelRef;

    private LayoutSupportRegistry(FormModel formModel) {
        this.formModelRef = new WeakReference<FormModel>(formModel);
    }

    public static LayoutSupportRegistry getRegistry(FormModel formModel) {
        LayoutSupportRegistry reg;
        if (instanceMap == null) {
            instanceMap = new WeakHashMap();
            reg = null;
        } else {
            reg = (LayoutSupportRegistry)instanceMap.get(formModel);
        }
        if (reg == null) {
            reg = new LayoutSupportRegistry(formModel);
            instanceMap.put(formModel, reg);
        }
        return reg;
    }

    public Class getSupportClassForContainer(Class containerClass) {
        String className = (String)LayoutSupportRegistry.getContainersMap().get(containerClass.getName());
        if (className == null) {
            className = this.findSuperClass(LayoutSupportRegistry.getContainersMap(), containerClass);
        }
        return className != null ? this.loadClass(className) : null;
    }

    public String getSupportNameForContainer(String containerClassName) {
        Class containerClass;
        String className = (String)LayoutSupportRegistry.getContainersMap().get(containerClassName);
        if (className == null && (containerClass = this.loadClass(containerClassName)) != null) {
            className = this.findSuperClass(LayoutSupportRegistry.getContainersMap(), containerClass);
        }
        return className;
    }

    public Class getSupportClassForLayout(Class layoutClass) {
        String className = (String)LayoutSupportRegistry.getLayoutsMap().get(layoutClass.getName());
        if (className == null && needPaletteRescan) {
            className = LayoutSupportRegistry.scanPalette(layoutClass.getName());
        }
        if (className == null) {
            className = this.findSuperClass(LayoutSupportRegistry.getLayoutsMap(), layoutClass);
        }
        return className != null ? this.loadClass(className) : null;
    }

    public String getSupportNameForLayout(String layoutClassName) {
        Class layoutClass;
        String className = (String)LayoutSupportRegistry.getLayoutsMap().get(layoutClassName);
        if (className == null && needPaletteRescan) {
            className = LayoutSupportRegistry.scanPalette(layoutClassName);
        }
        if (className == null && (layoutClass = this.loadClass(layoutClassName)) != null) {
            className = this.findSuperClass(LayoutSupportRegistry.getLayoutsMap(), layoutClass);
        }
        return className;
    }

    public static void registerSupportForContainer(Class containerClass, Class layoutDelegateClass) {
        LayoutSupportRegistry.getContainersMap().put(containerClass.getName(), layoutDelegateClass.getName());
    }

    public static void registerSupportForContainer(String containerClassName, String layoutDelegateClassName) {
        LayoutSupportRegistry.getContainersMap().put(containerClassName, layoutDelegateClassName);
    }

    public static void registertSupportForLayout(Class layoutClass, Class layoutDelegateClass) {
        LayoutSupportRegistry.getLayoutsMap().put(layoutClass.getName(), layoutDelegateClass.getName());
    }

    public static void registerSupportForLayout(String layoutClassName, String layoutDelegateClassName) {
        LayoutSupportRegistry.getLayoutsMap().put(layoutClassName, layoutDelegateClassName);
    }

    public LayoutSupportDelegate createSupportForContainer(Class containerClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class delegateClass = this.getSupportClassForContainer(containerClass);
        if (delegateClass == null) {
            return null;
        }
        return (LayoutSupportDelegate)delegateClass.newInstance();
    }

    public LayoutSupportDelegate createSupportForLayout(Class layoutClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String delegateClassName = this.getSupportNameForLayout(layoutClass.getName());
        if (delegateClassName == null) {
            return null;
        }
        if (delegateClassName == DEFAULT_SUPPORT) {
            return new DefaultLayoutSupport(layoutClass);
        }
        return (LayoutSupportDelegate)this.loadClass(delegateClassName).newInstance();
    }

    public static LayoutSupportDelegate createSupportInstance(Class layoutDelegateClass) throws InstantiationException, IllegalAccessException {
        return (LayoutSupportDelegate)layoutDelegateClass.newInstance();
    }

    private String findSuperClass(Map map, Class subClass) {
        for (Map.Entry en : map.entrySet()) {
            String className = (String)en.getKey();
            Class keyClass = this.loadClass(className);
            if (keyClass == null || !keyClass.isAssignableFrom(subClass)) continue;
            return (String)en.getValue();
        }
        return null;
    }

    private static String scanPalette(String wantedClassName) {
        boolean newPaletteListener;
        FileObject paletteFolder = PaletteUtils.getPaletteFolder();
        boolean bl = newPaletteListener = paletteListener == null;
        if (newPaletteListener) {
            paletteListener = new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fe) {
                    needPaletteRescan = true;
                }

                public void fileFolderCreated(FileEvent fe) {
                    needPaletteRescan = true;
                    fe.getFile().addFileChangeListener((FileChangeListener)this);
                }

                public void fileDeleted(FileEvent fe) {
                    fe.getFile().removeFileChangeListener((FileChangeListener)this);
                }
            };
            paletteFolder.addFileChangeListener(paletteListener);
        }
        String foundSupportClassName = null;
        FileObject[] paletteCategories = paletteFolder.getChildren();
        for (int i = 0; i < paletteCategories.length; ++i) {
            FileObject categoryFolder = paletteCategories[i];
            if (!categoryFolder.isFolder()) continue;
            if (newPaletteListener) {
                categoryFolder.addFileChangeListener(paletteListener);
            }
            FileObject[] paletteItems = categoryFolder.getChildren();
            for (int j = 0; j < paletteItems.length; ++j) {
                Map map;
                Class supportedClass;
                Class delegateClass;
                block12: {
                    Class itemClass;
                    DataObject itemDO = null;
                    try {
                        itemDO = DataObject.find((FileObject)paletteItems[j]);
                    }
                    catch (DataObjectNotFoundException ex) {
                        continue;
                    }
                    PaletteItem item = (PaletteItem)itemDO.getCookie(PaletteItem.class);
                    if (item == null || !item.isLayout() || (itemClass = item.getComponentClass()) == null) continue;
                    delegateClass = null;
                    supportedClass = null;
                    if (LayoutSupportDelegate.class.isAssignableFrom(itemClass)) {
                        delegateClass = itemClass;
                        try {
                            LayoutSupportDelegate delegate = (LayoutSupportDelegate)delegateClass.newInstance();
                            supportedClass = delegate.getSupportedClass();
                            break block12;
                        }
                        catch (Exception ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                            continue;
                        }
                    }
                    if (LayoutManager.class.isAssignableFrom(itemClass)) {
                        supportedClass = itemClass;
                    }
                }
                if (supportedClass == null) continue;
                if (Container.class.isAssignableFrom(supportedClass)) {
                    map = LayoutSupportRegistry.getContainersMap();
                } else {
                    if (!LayoutManager.class.isAssignableFrom(supportedClass)) continue;
                    map = LayoutSupportRegistry.getLayoutsMap();
                }
                String supportedClassName = supportedClass.getName();
                if (map.get(supportedClassName) != null) continue;
                String delegateClassName = delegateClass != null ? delegateClass.getName() : DEFAULT_SUPPORT;
                map.put(supportedClassName, delegateClassName);
                if (!supportedClassName.equals(wantedClassName)) continue;
                foundSupportClassName = delegateClassName;
            }
        }
        needPaletteRescan = false;
        return foundSupportClassName;
    }

    private Class loadClass(String className) {
        try {
            return FormUtils.loadClass(className, (FormModel)this.formModelRef.get());
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (LinkageError ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return null;
    }

    private static Map getContainersMap() {
        if (containerToLayoutDelegate == null) {
            containerToLayoutDelegate = new HashMap();
            containerToLayoutDelegate.put("javax.swing.JScrollPane", "org.netbeans.modules.form.layoutsupport.delegates.JScrollPaneSupport");
            containerToLayoutDelegate.put("java.awt.ScrollPane", "org.netbeans.modules.form.layoutsupport.delegates.ScrollPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JSplitPane", "org.netbeans.modules.form.layoutsupport.delegates.JSplitPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JTabbedPane", "org.netbeans.modules.form.layoutsupport.delegates.JTabbedPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JLayeredPane", "org.netbeans.modules.form.layoutsupport.delegates.JLayeredPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JToolBar", "org.netbeans.modules.form.layoutsupport.delegates.JToolBarSupport");
        }
        return containerToLayoutDelegate;
    }

    private static Map getLayoutsMap() {
        if (layoutToLayoutDelegate == null) {
            layoutToLayoutDelegate = new HashMap();
            layoutToLayoutDelegate.put("java.awt.BorderLayout", "org.netbeans.modules.form.layoutsupport.delegates.BorderLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.FlowLayout", "org.netbeans.modules.form.layoutsupport.delegates.FlowLayoutSupport");
            layoutToLayoutDelegate.put("javax.swing.BoxLayout", "org.netbeans.modules.form.layoutsupport.delegates.BoxLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.GridBagLayout", "org.netbeans.modules.form.layoutsupport.delegates.GridBagLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.GridLayout", "org.netbeans.modules.form.layoutsupport.delegates.GridLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.CardLayout", "org.netbeans.modules.form.layoutsupport.delegates.CardLayoutSupport");
            layoutToLayoutDelegate.put("org.netbeans.lib.awtextra.AbsoluteLayout", "org.netbeans.modules.form.layoutsupport.delegates.AbsoluteLayoutSupport");
        }
        return layoutToLayoutDelegate;
    }

    static {
        needPaletteRescan = true;
    }
}

