/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.translators;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.tasklist.core.ColumnProperty;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.netbeans.modules.tasklist.core.export.ExportImportFormat;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.util.IconManager;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public abstract class HTMLSupport
implements ExportImportFormat {
    private ColumnProperty[] columns;
    private String[] headers;
    private Filter filter;
    private TaskListView view;
    private Writer writer;
    private boolean sortAscending = true;
    private boolean sortedByName = false;
    private boolean noSorting = true;
    private Node.Property sortedByProperty = null;
    private IconManager iconMap = null;

    public String getName() {
        return NbBundle.getMessage((Class)HTMLSupport.class, (String)"HTML");
    }

    public WizardDescriptor getWizard() {
        return null;
    }

    public boolean doExportImport(File dir, boolean interactive, OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "utf8");
        this.view = TaskListView.getCurrent();
        if (this.view == null) {
            return false;
        }
        this.filter = this.view.getFilter();
        this.writer = writer;
        if (interactive && dir != null) {
            IconManager icm = new IconManager(dir);
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)HTMLSupport.class, (String)"ExportIcons"), 0);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (NotifyDescriptor.YES_OPTION == result) {
                this.iconMap = icm;
            }
        }
        this.exportHTML();
        ((Writer)writer).flush();
        this.iconMap = null;
        return true;
    }

    protected void writeCSS(Writer writer) throws IOException {
        writer.write("    body { background-color:white; color:black }\n    td { text-align:left; vertical-align:text-top; background-color:#eeeeee }\n    th { text-align:center; background-color:#222288; color:white }\n    td.sum { text-align:left }\n    td.sumdone { text-align:left; background-color:#cccccc }\n    td.done { background-color:#cccccc }\n    td.subhead { text-align:center; background-color:#ccccff }\n    td.datehead { text-align:center; background-color:#ccccff }\n    td.space { background-color:white }\n    td.date { text-align:left }\n    td.dateholiday { text-align:left; color:red }\n");
    }

    private void exportHTML() throws IOException {
        TableColumn column;
        int j;
        TableColumnModel headerModel = this.view.getColumnModel();
        this.writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\" \"http://www.w3.org/TR/REC-html40/loose.dtd\">\n<HTML><HEAD>\n  <META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n  <TITLE>" + NbBundle.getMessage((Class)HTMLSupport.class, (String)"TaskListHeader") + "</TITLE>\n" + "  <style type=\"text/css\">\n");
        this.writeCSS(this.writer);
        this.writer.write("  </style>\n</HEAD><BODY>\n<H1>" + NbBundle.getMessage((Class)HTMLSupport.class, (String)"TaskListHeader") + "</H1>\n" + "<TABLE WIDTH=\"100%\" BORDER=0 CELLPADDING=3 CELLSPACING=3>\n");
        int headercols = headerModel.getColumnCount();
        this.writer.write("<TR>\n");
        int width = 0;
        for (j = 0; j < headercols; ++j) {
            column = headerModel.getColumn(j);
            width += column.getWidth();
        }
        this.headers = new String[headercols];
        for (j = 0; j < headercols; ++j) {
            column = headerModel.getColumn(j);
            int relativeWidth = column.getWidth() * 100 / width;
            if (j == 0) {
                this.writer.write("   <TH WIDTH=\"" + relativeWidth + "%\">");
            } else {
                this.writer.write("   <TH WIDTH=\"" + relativeWidth + "%\">");
            }
            this.headers[j] = column.getHeaderValue().toString();
            this.writer.write(TLUtils.toHTML(this.headers[j]));
            this.writer.write("</TH>\n");
        }
        this.writer.write("</TR>\n");
        this.sortedByProperty = null;
        this.sortAscending = true;
        this.sortedByName = false;
        this.noSorting = true;
        this.columns = this.view.getColumns();
        for (int i = 0; i < this.columns.length; ++i) {
            Boolean sorting = (Boolean)this.columns[i].getValue("SortingColumnTTV");
            if (sorting == null || !sorting.booleanValue()) continue;
            if (i == 0) {
                this.sortedByName = true;
            } else {
                this.sortedByProperty = this.columns[i];
            }
            Boolean desc = (Boolean)this.columns[i].getValue("DescendingOrderTTV");
            this.sortAscending = desc == null || desc == false;
        }
        Node n = this.view.getExplorerManager().getRootContext();
        this.exportOneNode(n, -1);
        this.writer.write("</TR>\n</TABLE>\n<P>" + NbBundle.getMessage((Class)HTMLSupport.class, (String)"PageCreatedBy", (Object)"<A HREF=\"http://www.netbeans.org\">NetBeans</A> <A HREF=\"http://tasklist.netbeans.org\">tasklist</A></P>") + DateFormat.getDateTimeInstance(1, 1).format(new Date()) + "<P>\n</BODY></HTML>\n");
    }

    private void exportOneNode(Node n, int level) throws IOException {
        Task t = TaskNode.getTask(n);
        if (t != null && this.filter != null && level != -1 && !this.filter.accept(t)) {
            return;
        }
        this.writer.write("<TR>\n");
        if (level >= 0) {
            this.writeOneTask(n, level);
        }
        List l = this.view.getSortedChildren(n, this.sortedByProperty, this.sortAscending, this.sortedByName, this.noSorting);
        ListIterator it = l.listIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            this.exportOneNode(node, level + 1);
        }
    }

    private void writeOneTask(Node n, int level) throws IOException {
        Boolean invisible = null;
        block0: for (int i = 0; i < this.headers.length; ++i) {
            int colidx;
            for (colidx = 0; colidx < this.columns.length; ++colidx) {
                if (!this.headers[i].equalsIgnoreCase(this.columns[colidx].getDisplayName())) continue;
                invisible = (Boolean)this.columns[colidx].getValue("InvisibleInTreeTableView");
                break;
            }
            if (colidx >= this.columns.length || invisible != null && invisible.booleanValue()) {
                colidx = 0;
            }
            Node.PropertySet[] propsets = n.getPropertySets();
            for (int j = 0; j < propsets.length; ++j) {
                int k;
                Node.Property[] props = propsets[j].getProperties();
                for (k = 0; k < props.length; ++k) {
                    String name = props[k].getName();
                    if (this.columns[colidx].getName().equals(name)) break;
                }
                if (k == props.length) continue block0;
                this.writeOneField(this.writer, j == 0, n, props[k], level);
            }
        }
        this.writer.write("</TR>\n");
    }

    protected void writeOneField(Writer writer, boolean first, Node node, Node.Property prop, int level) throws IOException {
        boolean subtable;
        boolean bl = subtable = level > 0;
        if (prop.getName().equals("taskDesc")) {
            writer.write("<TD>\n");
            if (subtable) {
                writer.write("<TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\" WIDTH=\"100%\">\n");
                writer.write("<TR>\n");
                writer.write("<TD WIDTH=\"" + 20 * level + "\"></TD>\n");
                writer.write("<TD CLASS=\"sum\">\n");
            }
            this.exportIcon(writer, first, node);
            try {
                writer.write(TLUtils.toHTML(prop.getValue().toString()));
            }
            catch (IllegalAccessException e) {
                writer.write("ERROR");
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (InvocationTargetException e) {
                writer.write("ERROR");
                ErrorManager.getDefault().notify((Throwable)e);
            }
            if (subtable) {
                writer.write("</TD>\n");
                writer.write("</TR>\n");
                writer.write("</TABLE>\n");
            }
            writer.write("</TD>\n");
        } else {
            writer.write("<TD>\n");
            try {
                String s;
                Object value = prop.getValue();
                String string = s = value == null ? "" : value.toString();
                if (s == null) {
                    s = "";
                }
                writer.write(TLUtils.toHTML(s));
            }
            catch (IllegalAccessException e) {
                writer.write("ERROR");
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (InvocationTargetException e) {
                writer.write("ERROR");
                ErrorManager.getDefault().notify((Throwable)e);
            }
            writer.write("</TD>\n");
        }
    }

    protected boolean exportIcon(Writer writer, boolean first, Node node) throws IOException {
        Image icon;
        String name;
        if (first && this.iconMap != null && (name = this.iconMap.getIcon(icon = node.getIcon(1))) != null) {
            writer.write("<IMG SRC=\"" + name + "\">&nbsp;\n");
            return true;
        }
        return false;
    }
}

