/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.columns;

import java.io.IOException;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.tasklist.core.columns.ColumnsConfiguration;
import org.netbeans.spi.settings.DOMConvertor;
import org.netbeans.spi.settings.Saver;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ColumnsConfigurationConvertor
extends DOMConvertor
implements ChangeListener {
    private Saver saver;

    private static Object create(FileObject fo) {
        ColumnsConfigurationConvertor conv = new ColumnsConfigurationConvertor();
        return conv;
    }

    public ColumnsConfigurationConvertor() {
        super("-//NetBeans org.netbeans.modules.tasklist//DTD Columns 1.0//EN", "http://tasklist.netbeans.org/dtd/columns-1_0.dtd", "columns");
    }

    protected Object readElement(Element element) {
        NodeList nl = element.getChildNodes();
        ArrayList<String> w = new ArrayList<String>();
        ArrayList<String> n = new ArrayList<String>();
        boolean ascending = true;
        String sortingColumn = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            Element node = (Element)nl.item(i);
            n.add(node.getAttribute("property"));
            w.add(node.getAttribute("width"));
            if (sortingColumn != null) continue;
            String sort = node.getAttribute("sort");
            if (sort.equals("ascending")) {
                sortingColumn = node.getAttribute("property");
                ascending = true;
                continue;
            }
            if (!sort.equals("descending")) continue;
            sortingColumn = node.getAttribute("property");
            ascending = false;
        }
        int[] ww = new int[w.size()];
        for (int i = 0; i < w.size(); ++i) {
            try {
                ww[i] = Integer.parseInt((String)w.get(i));
                continue;
            }
            catch (NumberFormatException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        String[] nn = n.toArray(new String[n.size()]);
        return new ColumnsConfiguration(nn, ww, sortingColumn, ascending);
    }

    protected void writeElement(Document doc, Element element, Object obj) {
        ColumnsConfiguration cw = (ColumnsConfiguration)obj;
        int[] w = cw.getWidths();
        String[] n = cw.getProperties();
        String sortingColumn = cw.getSortingColumn();
        boolean ascending = cw.getSortingOrder();
        for (int i = 0; i < n.length; ++i) {
            Element col = doc.createElement("column");
            col.setAttribute("property", n[i]);
            col.setAttribute("width", String.valueOf(w[i]));
            if (n[i].equals(sortingColumn)) {
                col.setAttribute("sort", ascending ? "ascending" : "descending");
            }
            element.appendChild(col);
        }
    }

    public void registerSaver(Object inst, Saver s) {
        this.saver = s;
        ((ColumnsConfiguration)inst).addChangeListener(this);
    }

    public void unregisterSaver(Object inst, Saver s) {
        if (s == null || s != this.saver) {
            ErrorManager.getDefault().notify(65536, (Throwable)new IllegalArgumentException("Wrong argument for unregisterSaver(Object=" + inst + ", Saver=" + s + ")"));
        }
        this.saver = null;
        ((ColumnsConfiguration)inst).removeChangeListener(this);
    }

    public void stateChanged(ChangeEvent ev) {
        try {
            this.saver.requestSave();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }
}

