/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.modules.tasklist.core.ObservableList;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskListener;

public class TaskList
implements ObservableList,
TaskListener {
    static final String USER_CATEGORY = "usertasks";
    private List tasks = new LinkedList();
    private List listCopy;
    private final ArrayList listeners = new ArrayList(67);
    protected boolean needSave = false;
    protected boolean dontSave = false;

    protected void setNeedSave(boolean b) {
        this.needSave = b;
    }

    protected void setDontSave(boolean b) {
        this.dontSave = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getTasks() {
        List list = this.tasks;
        synchronized (list) {
            if (this.listCopy == null) {
                this.listCopy = Collections.unmodifiableList(new ArrayList(this.tasks));
            }
            return this.listCopy;
        }
    }

    public void addRemove(List addList, List removeList, boolean append, Task parent, Task after) {
        Iterator it;
        this.setSilentUpdate(true, false);
        boolean modified = false;
        if (removeList != null) {
            it = removeList.iterator();
            while (it.hasNext()) {
                Task task = (Task)it.next();
                if (parent != null) {
                    parent.removeSubtask(task);
                    task.removeTaskListener(this);
                } else {
                    this.removeTask(task);
                }
                modified = true;
            }
        }
        if (addList != null && addList.size() > 0) {
            modified = true;
            if (parent != null) {
                it = addList.iterator();
                while (it.hasNext()) {
                    Task next = (Task)it.next();
                    next.addTaskListener(this);
                }
                parent.addSubtasks(addList, append, after);
            } else if (after != null) {
                this.addTasks(addList, after);
            } else {
                this.addTasks(addList, append);
            }
        }
        this.setSilentUpdate(false, modified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTasks(List tasks_, boolean append) {
        Iterator it = tasks_.iterator();
        int slot = 0;
        while (it.hasNext()) {
            List list;
            Task task = (Task)it.next();
            task.addTaskListener(this);
            if (append) {
                list = this.tasks;
                synchronized (list) {
                    this.tasks.add(task);
                    this.listCopy = null;
                }
            }
            list = this.tasks;
            synchronized (list) {
                this.tasks.add(slot++, task);
                this.listCopy = null;
            }
            this.fireAdded(task);
        }
    }

    private void addTasks(List tasks, Task after) {
        int index = tasks.indexOf(after);
        if (index == -1) {
            this.addTasks(tasks, true);
        } else {
            tasks.addAll(index + 1, tasks);
            Iterator it = tasks.iterator();
            while (it.hasNext()) {
                Task task = (Task)it.next();
                task.addTaskListener(this);
                this.fireAdded(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendTask(Task task) {
        task.addTaskListener(this);
        List list = this.tasks;
        synchronized (list) {
            this.tasks.add(task);
            this.listCopy = null;
        }
        this.fireAdded(task);
    }

    public final void removeTasks(List tasks) {
        Iterator it = tasks.iterator();
        while (it.hasNext()) {
            Task task = (Task)it.next();
            this.removeTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTask(Task task) {
        int index;
        task.removeTaskListener(this);
        boolean removed = false;
        List list = this.tasks;
        synchronized (list) {
            index = this.tasks.indexOf(task);
            removed = this.tasks.remove(task);
            this.listCopy = null;
        }
        if (removed) {
            this.fireRemoved(null, task, index);
        }
    }

    public void markChanged() {
        this.needSave = true;
        this.save();
    }

    public void save() {
        this.needSave = false;
    }

    final void setSilentUpdate(boolean silentUpdate, boolean saveOnFinish) {
        this.dontSave = silentUpdate;
        this.needSave = true;
        if (!this.dontSave && saveOnFinish) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(TaskListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(TaskListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAdded(Task task) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                TaskListener tl = (TaskListener)this.listeners.get(i);
                tl.addedTask(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStructureChanged(Task task) {
        TaskListener[] taskListeners;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            taskListeners = new TaskListener[this.listeners.size()];
            taskListeners = this.listeners.toArray(taskListeners);
        }
        for (int i = 0; i < taskListeners.length; ++i) {
            taskListeners[i].structureChanged(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRemoved(Task pt, Task task, int index) {
        TaskListener[] taskListeners;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            taskListeners = new TaskListener[this.listeners.size()];
            taskListeners = this.listeners.toArray(taskListeners);
        }
        for (int i = 0; i < taskListeners.length; ++i) {
            taskListeners[i].removedTask(pt, task, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List list = this.tasks;
        synchronized (list) {
            return TLUtils.recursiveCount(this.tasks.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List list = this.tasks;
        synchronized (list) {
            this.tasks.clear();
            this.listCopy = null;
        }
        this.fireStructureChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        System.err.println("\nTask List:\n-------------");
        List list = this.tasks;
        synchronized (list) {
            Iterator it = this.tasks.iterator();
            while (it.hasNext()) {
                Task next = (Task)it.next();
                this.recursivePrint(next, 0);
            }
        }
        System.err.println("\n\n");
    }

    private void recursivePrint(Task node, int depth) {
        if (depth > 20) {
            Thread.dumpStack();
            return;
        }
        for (int i = 0; i < depth; ++i) {
            System.err.print("   ");
        }
        System.err.println(node);
        if (node.getSubtasks() != null) {
            List l = node.getSubtasks();
            ListIterator it = l.listIterator();
            while (it.hasNext()) {
                Task task = (Task)it.next();
                this.recursivePrint(task, depth + 1);
            }
        }
    }

    public void selectedTask(Task t) {
    }

    public void warpedTask(Task t) {
    }

    public void addedTask(Task t) {
        this.fireAdded(t);
    }

    public void removedTask(Task pt, Task t, int index) {
        this.fireRemoved(pt, t, index);
    }

    public void structureChanged(Task t) {
        this.fireStructureChanged(t);
    }

    public boolean isEmpty() {
        return this.tasks.size() == 0;
    }
}

