/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting.impl;

import javax.faces.context.FacesContext;
import org.apache.shale.remoting.Mapping;
import org.apache.shale.remoting.Mappings;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.Processor;

public class MappingImpl
implements Mapping {
    private Mappings mappings = null;
    private String match = null;
    private Mechanism mechanism = null;
    private String pattern = null;
    private boolean prefix = true;
    private Processor processor = null;

    public MappingImpl() {
        this(null, null, null);
    }

    public MappingImpl(Mechanism mechanism, String pattern, Processor processor) {
        this.setMechanism(mechanism);
        this.setPattern(pattern);
        this.setProcessor(processor);
    }

    public Mappings getMappings() {
        return this.mappings;
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    public Mechanism getMechanism() {
        return this.mechanism;
    }

    public void setMechanism(Mechanism mechanism) {
        this.mechanism = mechanism;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (pattern == null) {
            this.match = null;
            this.pattern = null;
            return;
        }
        if (pattern.endsWith("/*")) {
            if (!pattern.startsWith("/")) {
                throw new IllegalArgumentException(pattern);
            }
            this.match = pattern.substring(0, pattern.length() - 1);
            this.pattern = pattern;
            this.prefix = true;
        } else if (pattern.startsWith("*.")) {
            int period = pattern.lastIndexOf(46);
            if (period != 1) {
                throw new IllegalArgumentException(pattern);
            }
            this.match = pattern.substring(1);
            this.pattern = pattern;
            this.prefix = false;
        } else {
            throw new IllegalArgumentException(pattern);
        }
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public String mapResourceId(FacesContext context, String resourceId) {
        String[] patterns = this.getMappings().getPatterns();
        String pattern = null;
        if (patterns != null && patterns.length > 0) {
            pattern = patterns[0];
        }
        StringBuffer sb = new StringBuffer();
        if (pattern != null) {
            sb.append(context.getExternalContext().getRequestContextPath());
        }
        if (pattern != null && pattern.endsWith("/*")) {
            sb.append(pattern.substring(0, pattern.length() - 2));
        }
        if (this.getPattern().endsWith("*")) {
            sb.append(this.getPattern().substring(0, this.getPattern().length() - 2));
        }
        sb.append(resourceId);
        if (this.getPattern().startsWith("*.")) {
            sb.append(this.getPattern().substring(1));
        }
        if (pattern != null && pattern.startsWith("*.")) {
            sb.append(pattern.substring(1));
        }
        if (pattern == null) {
            return context.getApplication().getViewHandler().getActionURL(context, sb.toString());
        }
        return sb.toString();
    }

    public String mapViewId(FacesContext context) {
        String viewId = this.viewId(context);
        if (viewId == null) {
            return null;
        }
        if (this.prefix) {
            if (viewId.startsWith(this.match) && !viewId.equals(this.match)) {
                return viewId.substring(this.match.length() - 1);
            }
            return null;
        }
        if (viewId.endsWith(this.match) && !viewId.equals(this.match)) {
            return viewId.substring(0, viewId.length() - this.match.length());
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Mapping)) {
            return false;
        }
        if (this.pattern == null) {
            return ((Mapping)object).getPattern() == null;
        }
        return this.pattern.equals(((Mapping)object).getPattern());
    }

    private String viewId(FacesContext context) {
        String viewId = context.getViewRoot().getViewId();
        String extension = this.mappings.getExtension();
        if (extension != null && viewId.endsWith(extension)) {
            return viewId.substring(0, viewId.length() - extension.length());
        }
        String[] patterns = this.mappings.getPatterns();
        if (patterns == null || patterns.length < 1) {
            return viewId;
        }
        for (int i = 0; i < patterns.length; ++i) {
            String match;
            if (!patterns[i].startsWith("*.") || !viewId.endsWith(match = patterns[i].substring(1))) continue;
            return viewId.substring(0, viewId.length() - match.length());
        }
        return viewId;
    }
}

