/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.junit.JUnitPluginTrampoline;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.junit.wizards.EmptyTestStepLocation;
import org.netbeans.modules.junit.wizards.StepProblemMessage;
import org.netbeans.modules.junit.wizards.Utils;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class EmptyTestCaseWizardIterator
implements TemplateWizard.Iterator {
    private static EmptyTestCaseWizardIterator instance;
    private TemplateWizard wizard;
    private static final int INDEX_TARGET = 2;
    private final String nameTarget = NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"LBL_panel_Target");
    private int current;
    private List changeListeners;
    private WizardDescriptor.Panel targetPanel;
    private Project lastSelectedProject = null;
    private WizardDescriptor.Panel optionsPanel;

    public void addChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList(2);
        }
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(l);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    private void fireChange() {
        if (this.changeListeners != null) {
            ChangeEvent e = new ChangeEvent(this);
            Iterator i = this.changeListeners.iterator();
            while (i.hasNext()) {
                ((ChangeListener)i.next()).stateChanged(e);
            }
        }
    }

    public boolean hasPrevious() {
        return this.current > 2;
    }

    public boolean hasNext() {
        return this.current < 2;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.current;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.current;
    }

    public WizardDescriptor.Panel current() {
        switch (this.current) {
            case 2: {
                return this.getTargetPanel();
            }
        }
        throw new IllegalStateException();
    }

    private WizardDescriptor.Panel getTargetPanel() {
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        if (this.targetPanel == null || project != this.lastSelectedProject) {
            Collection sourceGroups = Utils.getTestTargets(project, true);
            if (sourceGroups.isEmpty()) {
                this.targetPanel = new StepProblemMessage(project, NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"MSG_NoTestSourceGroup"));
            } else {
                SourceGroup[] testSrcGroups = new SourceGroup[sourceGroups.size()];
                sourceGroups.toArray(testSrcGroups);
                if (this.optionsPanel == null) {
                    this.optionsPanel = new EmptyTestStepLocation();
                }
                this.targetPanel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])testSrcGroups, (WizardDescriptor.Panel)this.optionsPanel);
            }
            this.lastSelectedProject = project;
        }
        return this.targetPanel;
    }

    public String name() {
        switch (this.current) {
            case 2: {
                return this.nameTarget;
            }
        }
        throw new AssertionError(this.current);
    }

    private void loadSettings(TemplateWizard wizard) {
        JUnitSettings settings = JUnitSettings.getDefault();
        wizard.putProperty("SetUp", (Object)settings.isGenerateSetUp());
        wizard.putProperty("TearDown", (Object)settings.isGenerateTearDown());
        wizard.putProperty("Comments", (Object)settings.isBodyComments());
    }

    private void saveSettings(TemplateWizard wizard) {
        JUnitSettings settings = JUnitSettings.getDefault();
        settings.setGenerateSetUp(Boolean.TRUE.equals(wizard.getProperty("SetUp")));
        settings.setGenerateTearDown(Boolean.TRUE.equals(wizard.getProperty("TearDown")));
        settings.setBodyComments(Boolean.TRUE.equals(wizard.getProperty("Comments")));
    }

    public void initialize(TemplateWizard wiz) {
        this.wizard = wiz;
        this.current = 2;
        this.loadSettings(wiz);
        String[] panelNames = new String[]{NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"LBL_panel_chooseFileType"), NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"LBL_panel_Target")};
        ((JComponent)this.getTargetPanel().getComponent()).putClientProperty("WizardPanel_contentData", panelNames);
        ((JComponent)this.getTargetPanel().getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
    }

    public void uninitialize(TemplateWizard wiz) {
        this.wizard = null;
        this.targetPanel = null;
        this.lastSelectedProject = null;
        this.optionsPanel = null;
        this.changeListeners = null;
    }

    public Set instantiate(TemplateWizard wizard) throws IOException {
        DataObject testDataObject;
        this.saveSettings(wizard);
        String name = Templates.getTargetName((WizardDescriptor)wizard);
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)wizard);
        Map<JUnitPlugin.CreateTestParam, Object> params = TestUtil.getSettingsMap(false);
        params.put(JUnitPlugin.CreateTestParam.CLASS_NAME, Templates.getTargetName((WizardDescriptor)wizard));
        JUnitPlugin plugin = TestUtil.getPluginForProject(Templates.getProject((WizardDescriptor)wizard));
        FileObject[] testFileObjects = JUnitPluginTrampoline.DEFAULT.createTests(plugin, null, targetFolder, params);
        if (testFileObjects == null) {
            throw new IOException();
        }
        try {
            testDataObject = DataObject.find((FileObject)testFileObjects[0]);
        }
        catch (DataObjectNotFoundException ex) {
            throw new IOException();
        }
        return Collections.singleton(testDataObject);
    }

    public static EmptyTestCaseWizardIterator singleton() {
        if (instance == null) {
            instance = new EmptyTestCaseWizardIterator();
        }
        return instance;
    }
}

