/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocTag;
import org.openide.src.JavaDocTagMemoryImpl;
import org.openide.src.SourceException;

class JavaDocMemoryImpl
implements JavaDoc,
Serializable {
    protected String rawText;
    private transient String text;
    private static final JavaDocTagMemoryImpl[] EMPTY_ARRAY = new JavaDocTagMemoryImpl[0];
    private static final String lineSeparator;
    private static final int lineSeparatorLength;
    private static final char LINEFEED = '\n';

    public JavaDocMemoryImpl(String rawText) {
        this.rawText = rawText;
    }

    public String getRawText() {
        return this.rawText;
    }

    public void setRawText(String s) throws SourceException {
        this.rawText = s;
    }

    public String getText() {
        if (this.rawText == null) {
            return "";
        }
        ArrayList tmp = new ArrayList();
        this.parseComment(tmp);
        return this.text;
    }

    public void setText(String s) throws SourceException {
        this.regenerateRawText(JavaDocMemoryImpl.convertNewLines(s), this.getTags(), this.getSeeTags());
    }

    public void clearJavaDoc() throws SourceException {
        this.rawText = null;
    }

    public boolean isEmpty() {
        return this.rawText == null;
    }

    public JavaDocTag[] getTags() {
        if (this.rawText == null) {
            return EMPTY_ARRAY;
        }
        ArrayList tagList = new ArrayList();
        this.parseComment(tagList);
        JavaDocTag[] tagArray = new JavaDocTag[tagList.size()];
        tagList.toArray(tagArray);
        return tagArray;
    }

    public JavaDocTag[] getTags(String name) {
        JavaDocTag[] allTags = this.getTags();
        ArrayList<JavaDocTag> resultList = new ArrayList<JavaDocTag>(allTags.length);
        for (int i = 0; i < allTags.length; ++i) {
            if (!allTags[i].name().equals(name)) continue;
            resultList.add(allTags[i]);
        }
        JavaDocTag[] result = new JavaDocTag[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    public synchronized void changeTags(JavaDocTag[] tags, int action) throws SourceException {
        StringBuffer sb = new StringBuffer();
        switch (action) {
            case 1: 
            case 3: {
                sb.append(action == 1 ? this.getRawText() : this.getText());
                for (int i = 0; i < tags.length; ++i) {
                    sb.append("\n").append(tags[i].toString());
                }
                this.setRawText(sb.toString());
                break;
            }
            case 2: {
                JavaDocTag[] currTags = this.getTags();
                sb.append(this.getText());
                for (int i = 0; i < currTags.length; ++i) {
                    boolean found = false;
                    String strTag = currTags[i].toString();
                    for (int j = 0; j < tags.length; ++j) {
                        if (!strTag.equals(tags[j].toString())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    sb.append("\n").append(strTag);
                }
                this.setRawText(sb.toString());
            }
        }
    }

    public JavaDocTag.See[] getSeeTags() {
        JavaDocTag[] allTags = this.getTags();
        ArrayList<JavaDocTag> resultList = new ArrayList<JavaDocTag>(allTags.length);
        for (int i = 0; i < allTags.length; ++i) {
            if (!(allTags[i] instanceof JavaDocTag.See)) continue;
            resultList.add(allTags[i]);
        }
        JavaDocTag.See[] result = new JavaDocTag.See[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    protected void regenerateRawText(String text, JavaDocTag[] tags, JavaDocTag.See[] seeTags) {
        int i;
        StringBuffer sb = new StringBuffer(text.length() + tags.length * 80 + seeTags.length * 80);
        sb.append(text);
        for (i = 0; i < tags.length; ++i) {
            sb.append(tags[i].toString());
        }
        for (i = 0; i < seeTags.length; ++i) {
            sb.append(seeTags[i].toString());
        }
        this.rawText = sb.toString();
    }

    private void parseComment(List tagList) {
        boolean IN_TEXT = true;
        int TAG_GAP = 2;
        int TAG_NAME = 3;
        int TAG_TEXT = 4;
        int state = 1;
        boolean newLine = true;
        String tagName = null;
        int tagStart = 0;
        int textStart = 0;
        int textEnd = 0;
        int lastNonWhite = -1;
        int len = this.rawText.length();
        for (int inx = 0; inx < len; ++inx) {
            char ch = this.rawText.charAt(inx);
            boolean isWhite = Character.isWhitespace(ch);
            switch (state) {
                case 1: {
                    if (!newLine || ch != '@') break;
                    this.parseCommentComponent(tagList, null, 0, textEnd);
                    tagStart = inx;
                    state = 3;
                    break;
                }
                case 3: {
                    if (!isWhite) break;
                    tagName = this.rawText.substring(tagStart, inx);
                    state = 2;
                    break;
                }
                case 2: {
                    if (isWhite) break;
                    textStart = inx;
                    state = 4;
                }
                case 4: {
                    if (!newLine || ch != '@') break;
                    this.parseCommentComponent(tagList, tagName, textStart, lastNonWhite + 1);
                    tagStart = inx;
                    state = 3;
                }
            }
            if (lineSeparator != null && inx + lineSeparatorLength <= len && this.rawText.regionMatches(inx, lineSeparator, 0, lineSeparatorLength)) {
                newLine = true;
                if (state == 1) {
                    textEnd = inx;
                }
                inx += lineSeparatorLength - 1;
                continue;
            }
            if (ch == '\n') {
                newLine = true;
                if (state != 1) continue;
                textEnd = inx;
                continue;
            }
            if (isWhite) continue;
            lastNonWhite = inx;
            newLine = false;
        }
        switch (state) {
            case 3: {
                tagName = this.rawText.substring(tagStart, len);
            }
            case 2: {
                textStart = len;
            }
            case 1: 
            case 4: {
                this.parseCommentComponent(tagList, tagName, textStart, lastNonWhite + 1);
            }
        }
    }

    private void parseCommentComponent(List tagList, String tagName, int from, int upto) {
        String tx;
        String string = tx = upto <= from ? "" : this.rawText.substring(from, upto);
        if (tagName == null) {
            this.text = tx;
        } else {
            JavaDocTagMemoryImpl tag;
            if (tagName.equals("@exception") || tagName.equals("@throws")) {
                this.warnIfEmpty(tagName, tx);
                tag = new JavaDocTagMemoryImpl.Throws(tagName, tx);
            } else if (tagName.equals("@param")) {
                this.warnIfEmpty(tagName, tx);
                tag = new JavaDocTagMemoryImpl.Param(tagName, tx);
            } else if (tagName.equals("@see")) {
                this.warnIfEmpty(tagName, tx);
                tag = new JavaDocTagMemoryImpl.See(tagName, tx);
            } else if (tagName.equals("@serialField")) {
                this.warnIfEmpty(tagName, tx);
                tag = new JavaDocTagMemoryImpl.SerialField(tagName, tx);
            } else if (tagName.equals("@return")) {
                this.warnIfEmpty(tagName, tx);
                tag = new JavaDocTagMemoryImpl(tagName, tx);
            } else if (tagName.equals("@author")) {
                this.warnIfEmpty(tagName, tx);
                tag = new JavaDocTagMemoryImpl(tagName, tx);
            } else if (tagName.equals("@version")) {
                this.warnIfEmpty(tagName, tx);
                tag = new JavaDocTagMemoryImpl(tagName, tx);
            } else {
                tag = new JavaDocTagMemoryImpl(tagName, tx);
            }
            tagList.add(tag);
        }
    }

    private void warnIfEmpty(String tagName, String tx) {
    }

    static String convertNewLines(String input) {
        if (lineSeparator == null) {
            return input;
        }
        int firstIndex = input.indexOf(lineSeparator);
        if (firstIndex == -1) {
            return input;
        }
        StringBuffer result = new StringBuffer();
        char[] contents = input.toCharArray();
        if (firstIndex > 0) {
            result.append(contents, 0, firstIndex);
        }
        result.append('\n');
        int lastPos = firstIndex += lineSeparatorLength;
        while (firstIndex < contents.length) {
            if ((firstIndex = input.indexOf(lineSeparator, firstIndex)) == -1) {
                result.append(contents, lastPos, contents.length - lastPos);
                return result.toString();
            }
            result.append(contents, lastPos, firstIndex - lastPos);
            result.append('\n');
            lastPos = firstIndex += lineSeparatorLength;
        }
        result.append(contents, lastPos, firstIndex - lastPos);
        return result.toString();
    }

    static {
        String sep = System.getProperty("line.separator");
        if (sep == null || sep.equals("\n")) {
            lineSeparator = null;
            lineSeparatorLength = 0;
        } else {
            lineSeparator = sep;
            lineSeparatorLength = sep.length();
        }
    }

    static class Method
    extends JavaDocMemoryImpl
    implements JavaDoc.Method {
        Method(String rawText) {
            super(rawText);
        }

        public JavaDocTag.Param[] getParamTags() {
            JavaDocTag[] allTags = this.getTags();
            ArrayList<JavaDocTag> resultList = new ArrayList<JavaDocTag>(allTags.length);
            for (int i = 0; i < allTags.length; ++i) {
                if (!(allTags[i] instanceof JavaDocTag.Param)) continue;
                resultList.add(allTags[i]);
            }
            JavaDocTag.Param[] result = new JavaDocTag.Param[resultList.size()];
            resultList.toArray(result);
            return result;
        }

        public JavaDocTag.Throws[] getThrowsTags() {
            JavaDocTag[] allTags = this.getTags();
            ArrayList<JavaDocTag> resultList = new ArrayList<JavaDocTag>(allTags.length);
            for (int i = 0; i < allTags.length; ++i) {
                if (!(allTags[i] instanceof JavaDocTag.Throws)) continue;
                resultList.add(allTags[i]);
            }
            JavaDocTag.Throws[] result = new JavaDocTag.Throws[resultList.size()];
            resultList.toArray(result);
            return result;
        }
    }

    static class Field
    extends JavaDocMemoryImpl
    implements JavaDoc.Field {
        Field(String rawText) {
            super(rawText);
        }

        public JavaDocTag.SerialField[] getSerialFieldTags() {
            JavaDocTag[] allTags = this.getTags();
            ArrayList<JavaDocTag> resultList = new ArrayList<JavaDocTag>(allTags.length);
            for (int i = 0; i < allTags.length; ++i) {
                if (!(allTags[i] instanceof JavaDocTag.SerialField)) continue;
                resultList.add(allTags[i]);
            }
            JavaDocTag.SerialField[] result = new JavaDocTag.SerialField[resultList.size()];
            resultList.toArray(result);
            return result;
        }
    }

    static class Class
    extends JavaDocMemoryImpl
    implements JavaDoc.Class {
        static final long serialVersionUID = 3206093459760846163L;

        Class(String rawText) {
            super(rawText);
        }
    }
}

