/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

public final class WinXPViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int TXT_X_PAD = 8;
    private static final int TXT_Y_PAD = 3;
    private static final int ICON_X_PAD = 2;
    private static final int ICON_Y_PAD = 7;
    private static final int BUMP_X_PAD = 3;
    private static final int BUMP_Y_PAD_UPPER = 5;
    private static final int BUMP_Y_PAD_BOTTOM = 3;
    private static final int HIGHLIGHTED_RAISE = 1;
    private static boolean colorsReady = false;
    private static Color unselFillBrightC;
    private static Color unselFillDarkC;
    private static Color selFillC;
    private static Color focusFillBrightC;
    private static Color focusFillDarkC;
    private static Color txtC;
    private static Color borderC;
    private static Color bottomBorderC;
    private static Color selBorderC;
    private static Color bgFillC;
    private static AbstractViewTabDisplayerUI.IconLoader closeIcon;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();

    private WinXPViewTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
        this.prefSize = new Dimension(100, 17);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WinXPViewTabDisplayerUI((TabDisplayer)c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        WinXPViewTabDisplayerUI.initColors();
        c.setOpaque(true);
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    public Dimension getPreferredSize(JComponent c) {
        FontMetrics fm = this.getTxtFontMetrics();
        int height = fm == null ? 17 : fm.getAscent() + 2 * fm.getDescent() + 3;
        Insets insets = c.getInsets();
        this.prefSize.height = height + insets.bottom + insets.top;
        return this.prefSize;
    }

    protected void paintTabContent(Graphics g, int index, String text, int x, int y, int width, int height) {
        FontMetrics fm = this.getTxtFontMetrics();
        g.setFont(this.getTxtFont());
        if (!this.isTabInFront(index) && this.isMoreThanOne()) {
            ++y;
            --height;
        }
        int txtWidth = width;
        if (this.isSelected(index)) {
            int space4pin;
            AbstractViewTabDisplayerUI.PinButton pin = this.configurePinButton(index);
            boolean showPin = pin != null && pin.getOrientation() != TabDisplayer.ORIENTATION_INVISIBLE;
            int n = space4pin = showPin ? this.pinButton.getWidth() + 1 : 0;
            if (this.displayer.isShowCloseButton()) {
                if (closeIcon == null) {
                    closeIcon = new AbstractViewTabDisplayerUI.IconLoader();
                }
                String iconPath = this.findIconPath(index);
                Icon icon = closeIcon.obtainIcon(iconPath);
                int iconWidth = icon.getIconWidth();
                int space4Icon = iconWidth + 4 + space4pin;
                txtWidth = width - 8 - space4Icon;
                this.getCloseIconRect(this.tempRect, index);
                icon.paintIcon(this.getDisplayer(), g, this.tempRect.x, this.tempRect.y);
            } else {
                txtWidth = width - 16 - space4pin;
                this.tempRect.x = x + (width - 2);
                int n2 = this.tempRect.y = !showPin ? 0 : this.displayer.getHeight() / 2 - this.pinButton.getPreferredSize().height / 2;
            }
            if (showPin) {
                if (this.tempRect.x - space4pin < x + 8 - 1) {
                    this.pinButton.setVisible(false);
                } else {
                    this.pinButton.setVisible(true);
                    this.pinButton.setLocation(this.tempRect.x - space4pin, this.tempRect.y);
                }
            } else {
                this.pinButton.setVisible(false);
            }
        } else {
            txtWidth = width - 16;
        }
        int highlightedRaiseCompensation = !this.isTabInFront(index) && this.isMoreThanOne() ? 1 : 0;
        ColorUtil.paintXpTabDragTexture(this.getDisplayer(), g, x + 3, y + 5, height - 8 + highlightedRaiseCompensation);
        HtmlRenderer.renderString((String)text, (Graphics)g, (int)(x + 8), (int)(y + fm.getAscent() + 3), (int)txtWidth, (int)height, (Font)this.getTxtFont(), (Color)txtC, (int)1, (boolean)true);
    }

    protected void paintTabBorder(Graphics g, int index, int x, int y, int width, int height) {
        boolean isFirst = index == 0;
        boolean isHighlighted = this.isTabHighlighted(index);
        g.translate(x, y);
        ColorUtil.paintXpTabHeader(isHighlighted ? 1 : 0, g, 0, 0, width);
        Color borderColor = isHighlighted ? selBorderC : borderC;
        g.setColor(borderColor);
        if (isFirst) {
            g.drawLine(0, 3, 0, height - 2);
        }
        g.drawLine(width - 1, 3, width - 1, height - 2);
        g.setColor(bottomBorderC);
        g.drawLine(0, height - 1, width - 1, height - 1);
        g.translate(-x, -y);
    }

    protected void paintTabBackground(Graphics g, int index, int x, int y, int width, int height) {
        y += 3;
        --width;
        height -= 4;
        boolean selected = this.isSelected(index);
        boolean focused = selected && this.isActive();
        boolean attention = this.isAttention(index);
        if (focused && !attention) {
            ColorUtil.xpFillRectGradient((Graphics2D)g, x, y, width, height, focusFillBrightC, focusFillDarkC);
        } else if (selected && this.isMoreThanOne() && !attention) {
            g.setColor(selFillC);
            g.fillRect(x, y, width, height);
        } else if (attention) {
            Color a = new Color(255, 255, 128);
            Color b = new Color(230, 200, 64);
            ColorUtil.xpFillRectGradient((Graphics2D)g, x, y, width, height, a, b);
        } else {
            ColorUtil.xpFillRectGradient((Graphics2D)g, x, y, width, height, unselFillBrightC, unselFillDarkC);
        }
    }

    protected Font getTxtFont() {
        Font font = super.getTxtFont();
        if (!font.isBold()) {
            font = font.deriveFont(1);
        }
        return font;
    }

    private String findIconPath(int index) {
        if (this.isFocused(index)) {
            if (((OwnController)this.getController()).isClosePressed() == index) {
                return "org/netbeans/swing/tabcontrol/resources/xp-close-focus-pressed.gif";
            }
            if (((OwnController)this.getController()).isMouseInCloseButton() == index) {
                return "org/netbeans/swing/tabcontrol/resources/xp-close-focus-rollover.gif";
            }
            return "org/netbeans/swing/tabcontrol/resources/xp-close-focus-normal.gif";
        }
        if (this.isSelected(index)) {
            if (((OwnController)this.getController()).isClosePressed() == index) {
                return "org/netbeans/swing/tabcontrol/resources/xp-close-sel-pressed.gif";
            }
            if (((OwnController)this.getController()).isMouseInCloseButton() == index) {
                return "org/netbeans/swing/tabcontrol/resources/xp-close-sel-rollover.gif";
            }
            return "org/netbeans/swing/tabcontrol/resources/xp-close-sel-normal.gif";
        }
        if (((OwnController)this.getController()).isClosePressed() == index) {
            return "org/netbeans/swing/tabcontrol/resources/xp-close-unsel-pressed.gif";
        }
        if (((OwnController)this.getController()).isMouseInCloseButton() == index) {
            return "org/netbeans/swing/tabcontrol/resources/xp-close-unsel-rollover.gif";
        }
        return "org/netbeans/swing/tabcontrol/resources/xp-close-unsel-normal.gif";
    }

    private boolean isTabHighlighted(int index) {
        if (((OwnController)this.getController()).getMouseIndex() == index) {
            return true;
        }
        return this.isTabInFront(index) && this.isMoreThanOne();
    }

    private boolean isTabInFront(int index) {
        return this.isSelected(index) && (this.isActive() || this.isMoreThanOne());
    }

    private boolean isMoreThanOne() {
        return this.getDataModel().size() > 1;
    }

    private static void initColors() {
        if (!colorsReady) {
            txtC = UIManager.getColor("TabbedPane.foreground");
            selFillC = UIManager.getColor("TabbedPane.highlight");
            focusFillBrightC = UIManager.getColor("tab_focus_fill_bright");
            focusFillDarkC = UIManager.getColor("tab_focus_fill_dark");
            unselFillBrightC = UIManager.getColor("tab_unsel_fill_bright");
            unselFillDarkC = UIManager.getColor("tab_unsel_fill_dark");
            borderC = UIManager.getColor("tab_border");
            bottomBorderC = UIManager.getColor("tab_bottom_border");
            selBorderC = UIManager.getColor("tab_sel_border");
            bgFillC = UIManager.getColor("workplace_fill");
            colorsReady = true;
        }
    }

    private Rectangle getCloseIconRect(Rectangle rect, int index) {
        TabLayoutModel tlm = this.getLayoutModel();
        int x = tlm.getX(index);
        int y = tlm.getY(index);
        int w = tlm.getW(index);
        int h = tlm.getH(index);
        String iconPath = this.findIconPath(index);
        if (closeIcon == null) {
            closeIcon = new AbstractViewTabDisplayerUI.IconLoader();
        }
        Icon icon = closeIcon.obtainIcon(iconPath);
        int iconWidth = icon.getIconWidth();
        int iconHeight = icon.getIconHeight();
        rect.x = x + w - iconWidth - 4;
        rect.y = this.getCenteredIconY(icon, index);
        rect.width = iconWidth;
        rect.height = iconHeight;
        return rect;
    }

    protected AbstractViewTabDisplayerUI.PinButton createPinButton() {
        HashMap<Object, String> normalIcons = new HashMap<Object, String>(6);
        normalIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-normal-east.gif");
        normalIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-normal-west.gif");
        normalIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-normal-south.gif");
        normalIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-normal-center.gif");
        HashMap<Object, String> pressedIcons = new HashMap<Object, String>(6);
        pressedIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-pressed-east.gif");
        pressedIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-pressed-west.gif");
        pressedIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-pressed-south.gif");
        pressedIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-pressed-center.gif");
        HashMap<Object, String> rolloverIcons = new HashMap<Object, String>(6);
        rolloverIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-rollover-east.gif");
        rolloverIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-rollover-west.gif");
        rolloverIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-rollover-south.gif");
        rolloverIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-rollover-center.gif");
        HashMap<Object, String> focusNormalIcons = new HashMap<Object, String>(6);
        focusNormalIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-normal-east.gif");
        focusNormalIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-normal-west.gif");
        focusNormalIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-normal-south.gif");
        focusNormalIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-normal-center.gif");
        HashMap<Object, String> focusPressedIcons = new HashMap<Object, String>(6);
        focusPressedIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-pressed-east.gif");
        focusPressedIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-pressed-west.gif");
        focusPressedIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-pressed-south.gif");
        focusPressedIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-pressed-center.gif");
        HashMap<Object, String> focusRolloverIcons = new HashMap<Object, String>(6);
        focusRolloverIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-rollover-east.gif");
        focusRolloverIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-rollover-west.gif");
        focusRolloverIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-rollover-south.gif");
        focusRolloverIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-rollover-center.gif");
        return new XPPinButton(this.displayer, focusNormalIcons, focusPressedIcons, focusRolloverIcons, normalIcons, pressedIcons, rolloverIcons);
    }

    protected static class XPPinButton
    extends AbstractViewTabDisplayerUI.PinButton {
        private Map focusedNormal;
        private Map focusedRollover;
        private Map focusedPressed;
        private TabDisplayer displayer;

        protected XPPinButton(TabDisplayer displayer, Map focusedNormal, Map focusedPressed, Map focusedRollover, Map selectNormal, Map selectPressed, Map selectRollover) {
            super(selectNormal, selectPressed, selectRollover);
            this.focusedPressed = focusedPressed;
            this.focusedRollover = focusedRollover;
            this.focusedNormal = focusedNormal;
            this.displayer = displayer;
        }

        public Icon getIcon() {
            if (this.displayer == null) {
                return null;
            }
            if (this.displayer.isActive()) {
                return AbstractViewTabDisplayerUI.iconCache.obtainIcon((String)this.focusedNormal.get(this.getOrientation()));
            }
            return super.getIcon();
        }

        public Icon getRolloverIcon() {
            if (this.displayer.isActive()) {
                return AbstractViewTabDisplayerUI.iconCache.obtainIcon((String)this.focusedRollover.get(this.getOrientation()));
            }
            return super.getRolloverIcon();
        }

        public Icon getPressedIcon() {
            if (this.displayer.isActive()) {
                return AbstractViewTabDisplayerUI.iconCache.obtainIcon((String)this.focusedPressed.get(this.getOrientation()));
            }
            return super.getPressedIcon();
        }
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private int lastIndex = -1;

        private OwnController() {
        }

        public int getMouseIndex() {
            return this.lastIndex;
        }

        protected int inCloseIconRect(Point point) {
            if (!WinXPViewTabDisplayerUI.this.displayer.isShowCloseButton()) {
                return -1;
            }
            int index = WinXPViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            if (index < 0 || !WinXPViewTabDisplayerUI.this.isSelected(index)) {
                return -1;
            }
            return WinXPViewTabDisplayerUI.this.getCloseIconRect(WinXPViewTabDisplayerUI.this.tempRect, index).contains(point) ? index : -1;
        }

        protected boolean inPinButtonRect(Point p) {
            if (!WinXPViewTabDisplayerUI.this.pinButton.isVisible()) {
                return false;
            }
            Point p2 = SwingUtilities.convertPoint(WinXPViewTabDisplayerUI.this.displayer, p, WinXPViewTabDisplayerUI.this.pinButton);
            return WinXPViewTabDisplayerUI.this.pinButton.contains(p2);
        }

        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            Point pos = e.getPoint();
            this.updateHighlight(WinXPViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(pos.x, pos.y));
        }

        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            this.updateHighlight(-1);
        }

        private void updateHighlight(int curIndex) {
            int h;
            int w;
            int y;
            int x;
            if (curIndex == this.lastIndex) {
                return;
            }
            TabLayoutModel tlm = WinXPViewTabDisplayerUI.this.getLayoutModel();
            Rectangle repaintRect = null;
            if (curIndex != -1) {
                x = tlm.getX(curIndex);
                y = tlm.getY(curIndex);
                w = tlm.getW(curIndex);
                h = tlm.getH(curIndex);
                repaintRect = new Rectangle(x, y, w, h);
            }
            if (this.lastIndex != -1 && this.lastIndex < WinXPViewTabDisplayerUI.this.getDataModel().size()) {
                x = tlm.getX(this.lastIndex);
                y = tlm.getY(this.lastIndex);
                w = tlm.getW(this.lastIndex);
                h = tlm.getH(this.lastIndex);
                repaintRect = repaintRect != null ? repaintRect.union(new Rectangle(x, y, w, h)) : new Rectangle(x, y, w, h);
            }
            if (repaintRect != null) {
                WinXPViewTabDisplayerUI.this.getDisplayer().repaint(repaintRect);
            }
            this.lastIndex = curIndex;
        }
    }
}

