/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.event.ArrayDiff;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.netbeans.swing.tabcontrol.event.VeryComplexListDataEvent;

final class DefaultTabSelectionModel
implements SingleSelectionModel,
ComplexListDataListener {
    TabDataModel dataModel;
    int sel = -1;
    private transient ArrayList changeListenerList;
    ChangeEvent ce = new ChangeEvent(this);

    public DefaultTabSelectionModel(TabDataModel tdm) {
        this.dataModel = tdm;
        this.attach();
    }

    public void attach() {
        this.dataModel.addComplexListDataListener(this);
    }

    public void detach() {
        this.dataModel.removeComplexListDataListener(this);
    }

    public void clearSelection() {
        this.sel = -1;
        this.fireStateChanged();
    }

    public int getSelectedIndex() {
        return this.sel;
    }

    public boolean isSelected() {
        return this.sel != -1;
    }

    public void setSelectedIndex(int index) {
        if (index != this.sel) {
            int oldIndex = this.sel;
            if (index < -1 || index >= this.dataModel.size()) {
                throw new IllegalArgumentException("Selected index set to " + index + " but model size is only " + this.dataModel.size());
            }
            this.sel = index;
            this.fireStateChanged();
        }
    }

    private void adjustSelectionForEvent(ListDataEvent e) {
        if (e.getType() == 0 || this.sel == -1) {
            return;
        }
        int start = e.getIndex0();
        int end = e.getIndex1() + 1;
        if (e.getType() == 2) {
            if (this.sel < start) {
                return;
            }
            if (this.sel >= start) {
                if (this.sel > end) {
                    this.sel -= end - start;
                } else {
                    this.sel = start;
                    if (this.sel >= this.dataModel.size()) {
                        this.sel = this.dataModel.size() - 1;
                    }
                }
                this.fireStateChanged();
            }
        } else {
            if (this.sel < start) {
                return;
            }
            if (this.sel >= start) {
                this.sel = end - 1 == start ? ++this.sel : (this.sel < end ? end + (this.sel - start) - 1 : (this.sel += end - start - 1));
                this.fireStateChanged();
            }
        }
    }

    public void contentsChanged(ListDataEvent e) {
        this.adjustSelectionForEvent(e);
    }

    public void intervalAdded(ListDataEvent e) {
        this.adjustSelectionForEvent(e);
    }

    public void intervalRemoved(ListDataEvent e) {
        this.adjustSelectionForEvent(e);
    }

    public void indicesAdded(ComplexListDataEvent e) {
        if (this.sel < 0) {
            return;
        }
        int[] indices = e.getIndices();
        Arrays.sort(indices);
        int offset = 0;
        for (int i = 0; i < indices.length && this.sel >= indices[i]; ++i) {
            ++offset;
        }
        if (offset > 0) {
            this.sel += offset;
            this.fireStateChanged();
        }
    }

    public void indicesRemoved(ComplexListDataEvent e) {
        if (this.sel < 0) {
            return;
        }
        int[] indices = e.getIndices();
        Arrays.sort(indices);
        int offset = -1;
        for (int i = 0; i < indices.length && this.sel > indices[i]; ++i) {
            --offset;
        }
        if (this.sel == this.dataModel.size()) {
            --this.sel;
            this.fireStateChanged();
            return;
        }
        if (this.dataModel.size() == 0) {
            this.sel = -1;
            this.fireStateChanged();
        } else if (offset != 0) {
            this.sel = Math.max(-1, Math.min(this.sel + offset, -1));
            this.fireStateChanged();
        }
    }

    public void indicesChanged(ComplexListDataEvent e) {
        if (this.sel < 0) {
            return;
        }
        if (e instanceof VeryComplexListDataEvent) {
            Integer curr;
            ArrayDiff dif = ((VeryComplexListDataEvent)e).getDiff();
            boolean changed = false;
            if (dif == null) {
                return;
            }
            Set deleted = dif.getDeletedIndices();
            Set added = dif.getAddedIndices();
            Integer idx = new Integer(this.getSelectedIndex());
            if (this.dataModel.size() == 0) {
                this.sel = -1;
                this.fireStateChanged();
                return;
            }
            Iterator i = deleted.iterator();
            int offset = 0;
            while (i.hasNext()) {
                curr = (Integer)i.next();
                if (curr.compareTo(idx) > 0) continue;
                ++offset;
            }
            i = added.iterator();
            while (i.hasNext()) {
                curr = (Integer)i.next();
                if (curr.compareTo(idx) < 0) continue;
                --offset;
            }
            this.sel -= offset;
            if (this.sel < 0) {
                int n = this.sel = this.dataModel.size() > 0 ? 0 : -1;
            }
            if (this.sel >= this.dataModel.size()) {
                this.sel = this.dataModel.size() - 1;
            }
            if (offset != 0) {
                this.fireStateChanged();
            }
        }
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (this.changeListenerList == null) {
            this.changeListenerList = new ArrayList();
        }
        this.changeListenerList.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (this.changeListenerList != null) {
            this.changeListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged() {
        ArrayList list;
        DefaultTabSelectionModel defaultTabSelectionModel = this;
        synchronized (defaultTabSelectionModel) {
            if (this.changeListenerList == null) {
                return;
            }
            list = (ArrayList)this.changeListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ChangeListener)list.get(i)).stateChanged(this.ce);
        }
    }
}

