/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class GlobalSourceForBinaryImpl
implements SourceForBinaryQueryImplementation {
    static boolean quiet = false;

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        try {
            String binaryRootS = binaryRoot.toExternalForm();
            if (binaryRootS.startsWith("jar:file:")) {
                FileObject resultFO;
                URL result = binaryRootS.endsWith("/xtest/lib/nbjunit.jar!/") ? new URL(binaryRootS.substring("jar:".length(), binaryRootS.length() - "/xtest/lib/nbjunit.jar!/".length()) + "/xtest/nbjunit/src/") : (binaryRootS.endsWith("/xtest/lib/nbjunit-ide.jar!/") ? new URL(binaryRootS.substring("jar:".length(), binaryRootS.length() - "/xtest/lib/nbjunit-ide.jar!/".length()) + "/xtest/nbjunit/src/") : (binaryRootS.endsWith("/xtest/lib/insanelib.jar!/") ? new URL(binaryRootS.substring("jar:".length(), binaryRootS.length() - "/xtest/lib/insanelib.jar!/".length()) + "/performance/insanelib/src/") : null));
                FileObject fileObject = resultFO = result != null ? URLMapper.findFileObject(result) : null;
                if (resultFO != null) {
                    return new SourceForBinaryQuery.Result(){

                        public FileObject[] getRoots() {
                            return new FileObject[]{resultFO};
                        }

                        public void addChangeListener(ChangeListener l) {
                        }

                        public void removeChangeListener(ChangeListener l) {
                        }
                    };
                }
            }
            NbPlatform supposedPlaf = null;
            Iterator it = NbPlatform.getPlatforms().iterator();
            while (it.hasNext()) {
                NbPlatform plaf = (NbPlatform)it.next();
                if (binaryRoot.toExternalForm().indexOf(plaf.getDestDir().toURI().toURL().toExternalForm()) == -1) continue;
                supposedPlaf = plaf;
                break;
            }
            if (supposedPlaf == null) {
                return null;
            }
            if (!binaryRoot.getProtocol().equals("jar")) {
                Util.err.log(binaryRoot + " is not an archive file.");
                return null;
            }
            File binaryRootF = new File(URI.create(FileUtil.getArchiveFile((URL)binaryRoot).toExternalForm()));
            FileObject fo = FileUtil.toFileObject((File)binaryRootF);
            if (fo == null) {
                Util.err.log("Cannot found FileObject for " + binaryRootF + "(" + binaryRoot + ")");
                return null;
            }
            String cnb = fo.getName().replace('-', '.');
            final ArrayList<FileObject> candidates = new ArrayList<FileObject>();
            URL[] roots = supposedPlaf.getSourceRoots();
            for (int i = 0; i < roots.length; ++i) {
                URL url;
                FileObject dir;
                if (roots[i].getProtocol().equals("jar")) {
                    URL u;
                    FileObject entryFO;
                    String pathInZip;
                    NetBeansSourcesParser nbsp;
                    File nbSrcF = new File(URI.create(FileUtil.getArchiveFile((URL)roots[i]).toExternalForm()));
                    if (!nbSrcF.exists()) continue;
                    try {
                        nbsp = NetBeansSourcesParser.getInstance(nbSrcF);
                    }
                    catch (ZipException e) {
                        if (quiet) continue;
                        Util.err.annotate((Throwable)e, 0, nbSrcF + " does not seem to be a valid ZIP file.", null, null, null);
                        Util.err.notify(1, (Throwable)e);
                        continue;
                    }
                    if (nbsp == null || (pathInZip = nbsp.findSourceRoot(cnb)) == null || (entryFO = URLMapper.findFileObject((URL)(u = new URL(roots[i], pathInZip)))) == null) continue;
                    candidates.add(entryFO);
                    continue;
                }
                String relPath = this.resolveSpecialNBSrcPath(binaryRoot);
                if (relPath == null || (dir = URLMapper.findFileObject((URL)(url = new URL(roots[i], relPath)))) == null) continue;
                candidates.add(dir);
            }
            return new SourceForBinaryQuery.Result(){

                public FileObject[] getRoots() {
                    return candidates.toArray(new FileObject[candidates.size()]);
                }

                public void addChangeListener(ChangeListener l) {
                }

                public void removeChangeListener(ChangeListener l) {
                }
            };
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private String resolveSpecialNBSrcPath(URL binaryRoot) throws MalformedURLException {
        String binaryRootS = binaryRoot.toExternalForm();
        String result = null;
        if (binaryRootS.startsWith("jar:file:")) {
            result = binaryRootS.endsWith("/testtools/modules/ext/nbjunit.jar!/") ? "xtest/nbjunit/src/" : (binaryRootS.endsWith("/testtools/modules/ext/nbjunit-ide.jar!/") ? "xtest/nbjunit/src/" : (binaryRootS.endsWith("/testtools/modules/ext/insanelib.jar!/") ? "performance/insanelib/src/" : null));
        }
        return result;
    }

    public static final class NetBeansSourcesParser {
        private static final Map instances = new HashMap();
        private static final String NBBUILD_ENTRY = "nbbuild/";
        private Map cnbToPrjDir;
        private ZipFile nbSrcZip;
        private String zipNBCVSRoot;

        public static NetBeansSourcesParser getInstance(File nbSrcZip) throws ZipException, IOException {
            ZipFile nbSrcZipFile;
            String zipNBCVSRoot;
            NetBeansSourcesParser nbsp = (NetBeansSourcesParser)instances.get(nbSrcZip);
            if (nbsp == null && (zipNBCVSRoot = NetBeansSourcesParser.findNBCVSRoot(nbSrcZipFile = new ZipFile(nbSrcZip))) != null) {
                nbsp = new NetBeansSourcesParser(nbSrcZipFile, zipNBCVSRoot);
                instances.put(nbSrcZip, nbsp);
            }
            return nbsp;
        }

        NetBeansSourcesParser(ZipFile nbSrcZip, String zipNBCVSRoot) {
            this.nbSrcZip = nbSrcZip;
            this.zipNBCVSRoot = zipNBCVSRoot;
        }

        String findSourceRoot(String cnb) {
            if (this.cnbToPrjDir == null) {
                try {
                    this.doScanZippedNetBeansOrgSources();
                }
                catch (IOException ex) {
                    Util.err.notify(16, (Throwable)ex);
                }
            }
            return (String)this.cnbToPrjDir.get(cnb);
        }

        private static String findNBCVSRoot(ZipFile nbSrcZip) {
            String nbRoot = null;
            Enumeration<? extends ZipEntry> en = nbSrcZip.entries();
            while (en.hasMoreElements()) {
                ZipEntry xmlEntry;
                String name;
                ZipEntry entry = en.nextElement();
                if (!entry.isDirectory() || !(name = entry.getName()).equals(NBBUILD_ENTRY) && (!name.endsWith(NBBUILD_ENTRY) || !name.substring(name.indexOf(47) + 1).equals(NBBUILD_ENTRY)) || (xmlEntry = nbSrcZip.getEntry(name + "nbproject/project.xml")) == null) continue;
                nbRoot = name.substring(0, name.length() - NBBUILD_ENTRY.length());
                break;
            }
            return nbRoot;
        }

        private void doScanZippedNetBeansOrgSources() throws IOException {
            this.cnbToPrjDir = new HashMap();
            Enumeration<? extends ZipEntry> en = this.nbSrcZip.entries();
            while (en.hasMoreElements()) {
                String cnb;
                ZipEntry projectXML;
                ZipEntry src;
                String name;
                StringTokenizer st;
                ZipEntry entry = en.nextElement();
                if (!entry.isDirectory()) continue;
                String path = entry.getName().substring(0, entry.getName().length() - 1);
                if (this.zipNBCVSRoot != null && (!path.startsWith(this.zipNBCVSRoot) || path.equals(this.zipNBCVSRoot)) || (st = new StringTokenizer(path, "/")).countTokens() > 3 || ModuleList.EXCLUDED_DIR_NAMES.contains(name = path.substring(path.lastIndexOf(47) + 1, path.length())) || (src = this.nbSrcZip.getEntry(entry.getName() + "src/")) == null || !src.isDirectory() || (projectXML = this.nbSrcZip.getEntry(entry.getName() + "nbproject/project.xml")) == null || (cnb = this.parseCNB(projectXML)) == null) continue;
                this.cnbToPrjDir.put(cnb, entry.getName() + "src/");
            }
        }

        private String parseCNB(ZipEntry projectXML) throws IOException {
            Element cfg;
            Element data;
            Document doc;
            InputStream is = this.nbSrcZip.getInputStream(projectXML);
            try {
                doc = XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)true, null, null);
            }
            catch (SAXException e) {
                throw (IOException)new IOException(projectXML + ": " + e.toString()).initCause(e);
            }
            finally {
                is.close();
            }
            Element docel = doc.getDocumentElement();
            Element type = Util.findElement(docel, "type", "http://www.netbeans.org/ns/project/1");
            String cnb = null;
            if (Util.findText(type).equals("org.netbeans.modules.apisupport.project") && (data = Util.findElement(cfg = Util.findElement(docel, "configuration", "http://www.netbeans.org/ns/project/1"), "data", "http://www.netbeans.org/ns/nb-module-project/2")) != null) {
                cnb = Util.findText(Util.findElement(data, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/2"));
            }
            return cnb;
        }
    }
}

