/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.jar.Manifest;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.Evaluator;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.queries.AccessibilityQueryImpl;
import org.netbeans.modules.apisupport.project.queries.AntArtifactProviderImpl;
import org.netbeans.modules.apisupport.project.queries.ClassPathProviderImpl;
import org.netbeans.modules.apisupport.project.queries.JavadocForBinaryImpl;
import org.netbeans.modules.apisupport.project.queries.ModuleProjectClassPathExtender;
import org.netbeans.modules.apisupport.project.queries.SourceForBinaryImpl;
import org.netbeans.modules.apisupport.project.queries.SourceLevelQueryImpl;
import org.netbeans.modules.apisupport.project.queries.SubprojectProviderImpl;
import org.netbeans.modules.apisupport.project.queries.UnitTestForSourceQueryImpl;
import org.netbeans.modules.apisupport.project.ui.ModuleActions;
import org.netbeans.modules.apisupport.project.ui.ModuleLogicalView;
import org.netbeans.modules.apisupport.project.ui.ModuleOperations;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;

public final class NbModuleProject
implements Project {
    public static final String NB_PROJECT_ICON_PATH = "org/netbeans/modules/apisupport/project/resources/module.gif";
    private static final Icon NB_PROJECT_ICON;
    private final AntProjectHelper helper;
    private final Evaluator eval;
    private final Lookup lookup;
    private Map extraCompilationUnits;
    private final GeneratedFilesHelper genFilesHelper;
    private final NbModuleTypeProviderImpl typeProvider;
    private LocalizedBundleInfo bundleInfo;
    private boolean manifestChanged;
    private final Map directoryCache = new WeakHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$queries$ClassPathProviderImpl;

    NbModuleProject(AntProjectHelper helper) throws IOException {
        this.helper = helper;
        this.genFilesHelper = new GeneratedFilesHelper(helper);
        Util.err.log("Loading project in " + this.getProjectDirectory());
        if (this.getCodeNameBase() == null) {
            throw new IOException("Misconfigured project in " + FileUtil.getFileDisplayName((FileObject)this.getProjectDirectory()) + " has no defined <code-name-base>");
        }
        this.typeProvider = new NbModuleTypeProviderImpl();
        if (this.typeProvider.getModuleType() == NbModuleTypeProvider.NETBEANS_ORG && ModuleList.findNetBeansOrg(FileUtil.toFile((FileObject)this.getProjectDirectory())) == null) {
            throw new IOException("netbeans.org-type module not in a complete netbeans.org source root: " + this);
        }
        this.eval = new Evaluator(this, this.typeProvider);
        FileBuiltQueryImplementation fileBuilt = this.supportsUnitTests() ? helper.createGlobFileBuiltQuery((PropertyEvaluator)this.eval, new String[]{"${src.dir}/*.java", "${test.unit.src.dir}/*.java"}, new String[]{"${build.classes.dir}/*.class", "${build.test.unit.classes.dir}/*.class"}) : helper.createGlobFileBuiltQuery((PropertyEvaluator)this.eval, new String[]{"${src.dir}/*.java"}, new String[]{"${build.classes.dir}/*.class"});
        final SourcesHelper sourcesHelper = new SourcesHelper(helper, (PropertyEvaluator)this.eval);
        sourcesHelper.addPrincipalSourceRoot("${src.dir}", NbBundle.getMessage((Class)NbModuleProject.class, (String)"LBL_source_packages"), null, null);
        sourcesHelper.addPrincipalSourceRoot("${test.unit.src.dir}", NbBundle.getMessage((Class)NbModuleProject.class, (String)"LBL_unit_test_packages"), null, null);
        sourcesHelper.addTypedSourceRoot("${src.dir}", "java", NbBundle.getMessage((Class)NbModuleProject.class, (String)"LBL_source_packages"), null, null);
        sourcesHelper.addTypedSourceRoot("${test.unit.src.dir}", "java", NbBundle.getMessage((Class)NbModuleProject.class, (String)"LBL_unit_test_packages"), null, null);
        sourcesHelper.addTypedSourceRoot("${test.qa-functional.src.dir}", "java", NbBundle.getMessage((Class)NbModuleProject.class, (String)"LBL_functional_test_packages"), null, null);
        sourcesHelper.addTypedSourceRoot("${test.qa-performance.src.dir}", "java", NbBundle.getMessage((Class)NbModuleProject.class, (String)"LBL_performance_test_packages"), null, null);
        FileObject testDir = helper.getProjectDirectory().getFileObject("test");
        if (testDir != null) {
            Enumeration kids = testDir.getChildren(false);
            while (kids.hasMoreElements()) {
                FileObject testSubdir = (FileObject)kids.nextElement();
                if (!testSubdir.isFolder()) continue;
                String name = testSubdir.getNameExt();
                if (testDir.getFileObject("build-" + name + ".xml") == null || name.equals("unit") || name.equals("qa-functional")) continue;
                sourcesHelper.addTypedSourceRoot("test/" + name + "/src", "java", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$NbModuleProject == null ? NbModuleProject.class$("org.netbeans.modules.apisupport.project.NbModuleProject") : class$org$netbeans$modules$apisupport$project$NbModuleProject), (String)"LBL_unknown_test_packages", (Object)name), null, null);
            }
        }
        if (helper.resolveFileObject("javahelp/manifest.mf") == null) {
            sourcesHelper.addTypedSourceRoot("javahelp", "javahelp", NbBundle.getMessage((Class)NbModuleProject.class, (String)"LBL_javahelp_packages"), null, null);
        }
        Iterator it = this.getExtraCompilationUnits().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Element ecu = (Element)entry.getValue();
            Element pkgrootEl = Util.findElement(ecu, "package-root", "http://www.netbeans.org/ns/nb-module-project/2");
            String pkgrootS = Util.findText(pkgrootEl);
            FileObject pkgroot = (FileObject)entry.getKey();
            sourcesHelper.addTypedSourceRoot(pkgrootS, "java", pkgroot.getNameExt(), null, null);
        }
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                sourcesHelper.registerExternalRoots(0);
            }
        });
        Manifest mf = this.getManifest();
        FileObject srcFO = this.getSourceDirectory();
        if (mf != null && srcFO != null) {
            this.bundleInfo = Util.findLocalizedBundleInfo(srcFO, this.getManifest());
        }
        Info info = new Info();
        if (this.bundleInfo != null) {
            this.bundleInfo.addPropertyChangeListener(info);
            this.getManifestFile().addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileChanged(FileEvent fe) {
                    NbModuleProject.this.manifestChanged = true;
                }
            });
        }
        this.lookup = Lookups.fixed((Object[])new Object[]{info, helper.createAuxiliaryConfiguration(), helper.createCacheDirectoryProvider(), new SavedHook(), new OpenedHook(), new ModuleActions(this), new ClassPathProviderImpl(this), new SourceForBinaryImpl(this), new JavadocForBinaryImpl(this), new UnitTestForSourceQueryImpl(this), new ModuleLogicalView(this), new SubprojectProviderImpl(this), fileBuilt, new AccessibilityQueryImpl(this), new SourceLevelQueryImpl(this), helper.createSharabilityQuery(this.evaluator(), new String[0], new String[]{"build"}), sourcesHelper.createSources(), new AntArtifactProviderImpl(this, helper, this.evaluator()), new CustomizerProviderImpl(this, this.getHelper(), this.evaluator()), new SuiteProviderImpl(), this.typeProvider, new PrivilegedTemplatesImpl(), new ModuleProjectClassPathExtender(this), new LocalizedBundleInfoProvider(), new ModuleOperations(this)});
    }

    public String toString() {
        return "NbModuleProject[" + this.getProjectDirectory() + "]";
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public String getSourceDirectoryPath() {
        return this.evaluator().getProperty("src.dir");
    }

    private NbModuleTypeProvider.NbModuleType getModuleType() {
        Element data = this.getHelper().getPrimaryConfigurationData(true);
        if (Util.findElement(data, "suite-component", "http://www.netbeans.org/ns/nb-module-project/2") != null) {
            return NbModuleTypeProvider.SUITE_COMPONENT;
        }
        if (Util.findElement(data, "standalone", "http://www.netbeans.org/ns/nb-module-project/2") != null) {
            return NbModuleTypeProvider.STANDALONE;
        }
        return NbModuleTypeProvider.NETBEANS_ORG;
    }

    public FileObject getManifestFile() {
        return this.helper.resolveFileObject(this.evaluator().getProperty("manifest.mf"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() {
        FileObject manifestFO = this.getManifestFile();
        if (manifestFO != null) {
            Manifest manifest;
            InputStream is = manifestFO.getInputStream();
            try {
                manifest = new Manifest(is);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e) {
                    Util.err.notify(1, (Throwable)e);
                }
            }
            is.close();
            return manifest;
        }
        return null;
    }

    public AntProjectHelper getHelper() {
        return this.helper;
    }

    public PropertyEvaluator evaluator() {
        return this.eval;
    }

    private FileObject getDir(String prop) {
        if (this.directoryCache.containsKey(prop)) {
            return (FileObject)this.directoryCache.get(prop);
        }
        String v = this.evaluator().getProperty(prop);
        if (!$assertionsDisabled && v == null) {
            throw new AssertionError((Object)("No value for " + prop));
        }
        FileObject f = this.helper.resolveFileObject(v);
        this.directoryCache.put(prop, f);
        return f;
    }

    public FileObject getSourceDirectory() {
        return this.getDir("src.dir");
    }

    public FileObject getTestSourceDirectory() {
        return this.getDir("test.unit.src.dir");
    }

    public FileObject getFunctionalTestSourceDirectory() {
        return this.getDir("test.qa-functional.src.dir");
    }

    public FileObject getPerformanceTestSourceDirectory() {
        return this.getDir("test.qa-performance.src.dir");
    }

    public File getClassesDirectory() {
        String classesDir = this.evaluator().getProperty("build.classes.dir");
        return this.helper.resolveFile(classesDir);
    }

    public File getTestClassesDirectory() {
        String testClassesDir = this.evaluator().getProperty("build.test.unit.classes.dir");
        return this.helper.resolveFile(testClassesDir);
    }

    public FileObject getJavaHelpDirectory() {
        if (this.helper.resolveFileObject("javahelp/manifest.mf") != null) {
            return null;
        }
        return this.helper.resolveFileObject("javahelp");
    }

    public File getModuleJarLocation() {
        return this.helper.resolveFile(this.evaluator().evaluate("${cluster}/${module.jar}"));
    }

    public String getCodeNameBase() {
        Element config = this.getHelper().getPrimaryConfigurationData(true);
        Element cnb = Util.findElement(config, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/2");
        if (cnb != null) {
            return Util.findText(cnb);
        }
        return null;
    }

    public String getSpecVersion() {
        String manVersion;
        Manifest m = this.getManifest();
        if (m != null && (manVersion = m.getMainAttributes().getValue("OpenIDE-Module-Specification-Version")) != null) {
            return NbModuleProject.stripExcessZeros(manVersion);
        }
        return NbModuleProject.stripExcessZeros(this.evaluator().getProperty("spec.version.base"));
    }

    private static String stripExcessZeros(String spec) {
        return spec != null ? spec.replaceAll("(\\.[0-9]+)\\.0$", "$1") : null;
    }

    public String getPathWithinNetBeansOrg() {
        FileObject nbroot = this.getNbrootFileObject(null);
        if (nbroot != null) {
            return FileUtil.getRelativePath((FileObject)nbroot, (FileObject)this.getProjectDirectory());
        }
        return null;
    }

    private File getNbroot() {
        return this.getNbroot(null);
    }

    private File getNbroot(PropertyEvaluator eval) {
        File dir = FileUtil.toFile((FileObject)this.getProjectDirectory());
        File nbroot = ModuleList.findNetBeansOrg(dir);
        if (nbroot != null) {
            return nbroot;
        }
        NbPlatform platform = this.getPlatform(eval);
        if (platform != null) {
            URL[] roots = platform.getSourceRoots();
            for (int i = 0; i < roots.length; ++i) {
                File f;
                if (!roots[i].getProtocol().equals("file") || !ModuleList.isNetBeansOrg(f = new File(URI.create(roots[i].toExternalForm())))) continue;
                return f;
            }
        }
        return null;
    }

    public File getNbrootFile(String path) {
        return this.getNbrootFile(path, null);
    }

    File getNbrootFile(String path, PropertyEvaluator eval) {
        File nbroot = this.getNbroot(eval);
        if (nbroot != null) {
            return new File(nbroot, path.replace('/', File.separatorChar));
        }
        return null;
    }

    public FileObject getNbrootFileObject(String path) {
        File f;
        File file = f = path != null ? this.getNbrootFile(path) : this.getNbroot();
        if (f != null) {
            return FileUtil.toFileObject((File)f);
        }
        return null;
    }

    public ModuleList getModuleList() throws IOException {
        NbPlatform p = this.getPlatform(false);
        if (p == null) {
            return ModuleList.getModuleList(FileUtil.toFile((FileObject)this.getProjectDirectory()), NbPlatform.getDefaultPlatform().getDestDir());
        }
        ModuleList ml = ModuleList.getModuleList(FileUtil.toFile((FileObject)this.getProjectDirectory()), p.getDestDir());
        if (ml.getEntry(this.getCodeNameBase()) == null) {
            ModuleList.refresh();
            ml = ModuleList.getModuleList(FileUtil.toFile((FileObject)this.getProjectDirectory()));
            if (ml.getEntry(this.getCodeNameBase()) == null) {
                Util.err.log(16, "Project in " + FileUtil.getFileDisplayName((FileObject)this.getProjectDirectory()) + " does not appear to be listed in its own module list; some sort of misconfiguration (e.g. not listed in its own suite)");
            }
        }
        return ml;
    }

    public NbPlatform getPlatform(boolean fallback) {
        NbPlatform p = this.getPlatform(null);
        if (fallback && (p == null || !p.isValid())) {
            p = NbPlatform.getDefaultPlatform();
        }
        return p;
    }

    private NbPlatform getPlatform(PropertyEvaluator eval) {
        String prop;
        if (eval == null) {
            eval = this.evaluator();
        }
        if ((prop = eval.getProperty("netbeans.dest.dir")) == null) {
            return null;
        }
        return NbPlatform.getPlatformByDestDir(this.getHelper().resolveFile(prop));
    }

    public boolean supportsJavadoc() {
        if (this.evaluator().getProperty("module.javadoc.packages") != null) {
            return true;
        }
        Element config = this.getHelper().getPrimaryConfigurationData(true);
        Element pubPkgs = Util.findElement(config, "public-packages", "http://www.netbeans.org/ns/nb-module-project/2");
        if (pubPkgs == null) {
            pubPkgs = Util.findElement(config, "friend-packages", "http://www.netbeans.org/ns/nb-module-project/2");
        }
        return pubPkgs != null && !Util.findSubElements(pubPkgs).isEmpty();
    }

    public boolean supportsUnitTests() {
        return this.getTestSourceDirectory() != null;
    }

    public Map getExtraCompilationUnits() {
        if (this.extraCompilationUnits == null) {
            this.extraCompilationUnits = new HashMap();
            Iterator ecuEls = Util.findSubElements(this.getHelper().getPrimaryConfigurationData(true)).iterator();
            while (ecuEls.hasNext()) {
                Element ecu = (Element)ecuEls.next();
                if (!ecu.getLocalName().equals("extra-compilation-unit")) continue;
                Element pkgrootEl = Util.findElement(ecu, "package-root", "http://www.netbeans.org/ns/nb-module-project/2");
                String pkgrootS = Util.findText(pkgrootEl);
                String pkgrootEval = this.evaluator().evaluate(pkgrootS);
                FileObject pkgroot = this.getHelper().resolveFileObject(pkgrootEval);
                if (pkgroot == null) {
                    Util.err.log(16, "Could not find package-root " + pkgrootEval + " for " + this.getCodeNameBase());
                    continue;
                }
                this.extraCompilationUnits.put(pkgroot, ecu);
            }
        }
        return this.extraCompilationUnits;
    }

    public String getJavacSource() {
        String javacSource = this.evaluator().getProperty("javac.source");
        if (!$assertionsDisabled && javacSource == null) {
            throw new AssertionError();
        }
        return javacSource;
    }

    public void open() {
        ((OpenedHook)((Object)this.getLookup().lookup(OpenedHook.class))).projectOpened();
    }

    public LocalizedBundleInfo getBundleInfo() {
        return this.bundleInfo;
    }

    public void setRunInAtomicAction(boolean runInAtomicAction) {
        this.eval.setRunInAtomicAction(runInAtomicAction);
    }

    public void notifyDeleting() {
        this.eval.removeListeners();
    }

    static {
        $assertionsDisabled = !NbModuleProject.class.desiredAssertionStatus();
        NB_PROJECT_ICON = new ImageIcon(Utilities.loadImage((String)NB_PROJECT_ICON_PATH));
    }

    private final class LocalizedBundleInfoProvider
    implements LocalizedBundleInfo.Provider {
        private LocalizedBundleInfoProvider() {
        }

        public LocalizedBundleInfo getLocalizedBundleInfo() {
            if (NbModuleProject.this.manifestChanged) {
                NbModuleProject.this.bundleInfo = Util.findLocalizedBundleInfo(NbModuleProject.this.getSourceDirectory(), NbModuleProject.this.getManifest());
                NbModuleProject.this.manifestChanged = false;
            }
            return NbModuleProject.this.bundleInfo;
        }
    }

    private static final class PrivilegedTemplatesImpl
    implements PrivilegedTemplates,
    RecommendedTemplates {
        private static final String[] PRIVILEGED_NAMES;
        private static final String[] RECOMMENDED_TYPES;
        static final /* synthetic */ boolean $assertionsDisabled;

        private PrivilegedTemplatesImpl() {
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }

        public String[] getRecommendedTypes() {
            return RECOMMENDED_TYPES;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$NbModuleProject == null ? (class$org$netbeans$modules$apisupport$project$NbModuleProject = NbModuleProject.class$("org.netbeans.modules.apisupport.project.NbModuleProject")) : class$org$netbeans$modules$apisupport$project$NbModuleProject).desiredAssertionStatus();
            PRIVILEGED_NAMES = new String[]{"Templates/Classes/Class.java", "Templates/Classes/Package", "Templates/Classes/Interface.java", "Templates/JUnit/SimpleJUnitTest.java", "Templates/NetBeansModuleDevelopment/newAction", "Templates/NetBeansModuleDevelopment/emptyLibraryDescriptor", "Templates/NetBeansModuleDevelopment/newLoader", "Templates/NetBeansModuleDevelopment/newProject", "Templates/NetBeansModuleDevelopment/newWindow", "Templates/NetBeansModuleDevelopment/newWizard"};
            if (!$assertionsDisabled && PRIVILEGED_NAMES.length > 10) {
                throw new AssertionError((Object)("Too many privileged templates to fit! extras will be ignored: " + Arrays.asList(PRIVILEGED_NAMES).subList(10, PRIVILEGED_NAMES.length)));
            }
            RECOMMENDED_TYPES = new String[]{"java-classes", "java-main-class", "java-forms", "java-beans", "oasis-XML-catalogs", "XML", "ant-script", "ant-task", "junit", "simple-files", "nbm-specific"};
        }
    }

    private class NbModuleTypeProviderImpl
    implements NbModuleTypeProvider,
    AntProjectListener {
        private NbModuleTypeProvider.NbModuleType type;

        public NbModuleTypeProviderImpl() {
            NbModuleProject.this.getHelper().addAntProjectListener((AntProjectListener)this);
        }

        public NbModuleTypeProvider.NbModuleType getModuleType() {
            if (this.type == null) {
                this.type = NbModuleProject.this.getModuleType();
            }
            return this.type;
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            if (ev.getPath().equals("nbproject/project.xml")) {
                this.type = null;
            }
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }
    }

    private final class SuiteProviderImpl
    implements SuiteProvider {
        private SuiteProviderImpl() {
        }

        public File getSuiteDirectory() {
            String suiteDir = NbModuleProject.this.evaluator().getProperty("suite.dir");
            return suiteDir == null ? null : NbModuleProject.this.helper.resolveFile(suiteDir);
        }
    }

    private final class SavedHook
    extends ProjectXmlSavedHook {
        SavedHook() {
        }

        protected void projectXmlSaved() throws IOException {
            if (NbModuleProject.this.getModuleType() != NbModuleTypeProvider.NETBEANS_ORG) {
                NbModuleProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", (class$org$netbeans$modules$apisupport$project$NbModuleProject == null ? (class$org$netbeans$modules$apisupport$project$NbModuleProject = NbModuleProject.class$("org.netbeans.modules.apisupport.project.NbModuleProject")) : class$org$netbeans$modules$apisupport$project$NbModuleProject).getResource("resources/build-impl.xsl"), false);
                NbModuleProject.this.genFilesHelper.refreshBuildScript("build.xml", (class$org$netbeans$modules$apisupport$project$NbModuleProject == null ? (class$org$netbeans$modules$apisupport$project$NbModuleProject = NbModuleProject.class$("org.netbeans.modules.apisupport.project.NbModuleProject")) : class$org$netbeans$modules$apisupport$project$NbModuleProject).getResource("resources/build.xsl"), false);
            }
        }
    }

    final class OpenedHook
    extends ProjectOpenedHook {
        private ClassPath[] boot;
        private ClassPath[] source;
        private ClassPath[] compile;
        static final /* synthetic */ boolean $assertionsDisabled;

        OpenedHook() {
        }

        protected void projectOpened() {
            if (NbModuleProject.this.getModuleType() == NbModuleTypeProvider.STANDALONE) {
                ProjectManager.mutex().writeAccess(new Mutex.Action(){

                    public Object run() {
                        String path = "nbproject/private/platform-private.properties";
                        EditableProperties ep = NbModuleProject.this.getHelper().getProperties(path);
                        File buildProperties = new File(System.getProperty("netbeans.user"), "build.properties");
                        ep.setProperty("user.properties.file", buildProperties.getAbsolutePath());
                        NbModuleProject.this.getHelper().putProperties(path, ep);
                        try {
                            ProjectManager.getDefault().saveProject((Project)NbModuleProject.this);
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                        return null;
                    }
                });
            }
            ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)NbModuleProject.this.lookup.lookup(class$org$netbeans$modules$apisupport$project$queries$ClassPathProviderImpl == null ? (class$org$netbeans$modules$apisupport$project$queries$ClassPathProviderImpl = NbModuleProject.class$("org.netbeans.modules.apisupport.project.queries.ClassPathProviderImpl")) : class$org$netbeans$modules$apisupport$project$queries$ClassPathProviderImpl);
            ClassPath[] _boot = cpProvider.getProjectClassPaths("classpath/boot");
            if (!$assertionsDisabled && _boot == null) {
                throw new AssertionError((Object)"No BOOT path");
            }
            ClassPath[] _source = cpProvider.getProjectClassPaths("classpath/source");
            if (!$assertionsDisabled && _source == null) {
                throw new AssertionError((Object)"No SOURCE path");
            }
            ClassPath[] _compile = cpProvider.getProjectClassPaths("classpath/compile");
            if (!$assertionsDisabled && _compile == null) {
                throw new AssertionError((Object)"No COMPILE path");
            }
            GlobalPathRegistry.getDefault().register("classpath/boot", _boot);
            GlobalPathRegistry.getDefault().register("classpath/source", _source);
            GlobalPathRegistry.getDefault().register("classpath/compile", _compile);
            this.boot = _boot;
            this.source = _source;
            this.compile = _compile;
            if (NbModuleProject.this.getModuleType() != NbModuleTypeProvider.NETBEANS_ORG) {
                try {
                    NbModuleProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", (class$org$netbeans$modules$apisupport$project$NbModuleProject == null ? (class$org$netbeans$modules$apisupport$project$NbModuleProject = NbModuleProject.class$("org.netbeans.modules.apisupport.project.NbModuleProject")) : class$org$netbeans$modules$apisupport$project$NbModuleProject).getResource("resources/build-impl.xsl"), true);
                    NbModuleProject.this.genFilesHelper.refreshBuildScript("build.xml", (class$org$netbeans$modules$apisupport$project$NbModuleProject == null ? (class$org$netbeans$modules$apisupport$project$NbModuleProject = NbModuleProject.class$("org.netbeans.modules.apisupport.project.NbModuleProject")) : class$org$netbeans$modules$apisupport$project$NbModuleProject).getResource("resources/build.xsl"), true);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        }

        protected void projectClosed() {
            try {
                ProjectManager.getDefault().saveProject((Project)NbModuleProject.this);
            }
            catch (IOException e) {
                Util.err.notify((Throwable)e);
            }
            if (!($assertionsDisabled || this.boot != null && this.source != null && this.compile != null)) {
                throw new AssertionError((Object)("#46802: project being closed which was never opened?? " + NbModuleProject.this));
            }
            GlobalPathRegistry.getDefault().unregister("classpath/boot", this.boot);
            GlobalPathRegistry.getDefault().unregister("classpath/source", this.source);
            GlobalPathRegistry.getDefault().unregister("classpath/compile", this.compile);
            this.boot = null;
            this.source = null;
            this.compile = null;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$NbModuleProject == null ? (class$org$netbeans$modules$apisupport$project$NbModuleProject = NbModuleProject.class$("org.netbeans.modules.apisupport.project.NbModuleProject")) : class$org$netbeans$modules$apisupport$project$NbModuleProject).desiredAssertionStatus();
        }
    }

    private final class Info
    implements ProjectInformation,
    PropertyChangeListener {
        private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
        private String displayName;
        static final /* synthetic */ boolean $assertionsDisabled;

        Info() {
            if (NbModuleProject.this.bundleInfo != null) {
                this.displayName = NbModuleProject.this.bundleInfo.getDisplayName();
            }
            if (this.displayName == null) {
                this.displayName = this.getName();
            }
        }

        public String getName() {
            String cnb = NbModuleProject.this.getCodeNameBase();
            return cnb != null ? cnb : NbModuleProject.this.getProjectDirectory().toString();
        }

        public String getDisplayName() {
            if (!$assertionsDisabled && this.displayName == null) {
                throw new AssertionError(NbModuleProject.this);
            }
            return this.displayName;
        }

        private void setDisplayName(String newDisplayName) {
            String oldDisplayName = this.displayName;
            this.displayName = newDisplayName == null ? this.getName() : newDisplayName;
            this.firePropertyChange("displayName", oldDisplayName, this.displayName);
        }

        public Icon getIcon() {
            return NB_PROJECT_ICON;
        }

        public Project getProject() {
            return NbModuleProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener pchl) {
            this.changeSupport.addPropertyChangeListener(pchl);
        }

        public void removePropertyChangeListener(PropertyChangeListener pchl) {
            this.changeSupport.removePropertyChangeListener(pchl);
        }

        private void firePropertyChange(String propName, Object oldValue, Object newValue) {
            this.changeSupport.firePropertyChange(propName, oldValue, newValue);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "displayName") {
                this.setDisplayName((String)evt.getNewValue());
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$NbModuleProject == null ? (class$org$netbeans$modules$apisupport$project$NbModuleProject = NbModuleProject.class$("org.netbeans.modules.apisupport.project.NbModuleProject")) : class$org$netbeans$modules$apisupport$project$NbModuleProject).desiredAssertionStatus();
        }
    }
}

