/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.netbeans.core.startup.AutomaticDependencies;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ManifestSection;
import org.netbeans.core.startup.ModuleHistory;
import org.netbeans.core.startup.ModuleList;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInstall;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.lookup.InstanceContent;
import org.xml.sax.SAXException;

final class NbInstaller
extends ModuleInstaller {
    private final Map sections = new HashMap(100);
    private final Map installs = new HashMap(100);
    private final Map layers = new HashMap(100);
    private boolean initializedFolderLookup = false;
    private final Events ev;
    private ModuleList moduleList;
    private ModuleManager mgr;
    private final Map kosherPackages = new HashMap(100);
    private static String[] specialResourcePrefixes;
    private final InstanceContent.Convertor convertor = new Convertor();
    private AutomaticDependencies autoDepsHandler = null;
    private static final String[] CLASSPATH_PACKAGES;
    private static boolean withoutOptimizations;
    private static final String[][] CLASSPATH_JARS;
    private File manifestCacheFile;
    private boolean usingManifestCache = Boolean.valueOf(System.getProperty("netbeans.cache.manifests", "true"));
    private Map manifestCache;
    private boolean manifestCacheDirty;
    static /* synthetic */ Class class$org$openide$modules$ModuleInstall;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NbInstaller(Events ev) {
        if (this.usingManifestCache) {
            String userdir = System.getProperty("netbeans.user");
            if (userdir != null) {
                this.manifestCacheFile = new File(new File(new File(new File(userdir), "var"), "cache"), "all-manifests.dat");
                Util.err.log("Using manifest cache in " + this.manifestCacheFile);
            } else {
                this.usingManifestCache = false;
                Util.err.log("Not using any manifest cache; no user directory");
            }
        } else {
            Util.err.log("Manifest cache disabled");
        }
        this.manifestCache = null;
        this.manifestCacheDirty = false;
        this.ev = ev;
    }

    void registerList(ModuleList list) {
        if (this.moduleList != null) {
            throw new IllegalStateException();
        }
        this.moduleList = list;
    }

    void registerManager(ModuleManager manager) {
        if (this.mgr != null) {
            throw new IllegalStateException();
        }
        this.mgr = manager;
    }

    public void prepare(Module m) throws InvalidException {
        URL layer;
        String layerResource;
        this.ev.log("prepare", (Object)m);
        HashSet<ManifestSection> mysections = null;
        Class<?> clazz = null;
        Iterator<Map.Entry<String, Attributes>> it = m.getManifest().getEntries().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Attributes> entry = it.next();
            ManifestSection section = ManifestSection.create(entry.getKey(), entry.getValue(), m);
            if (section == null) continue;
            if (mysections == null) {
                mysections = new HashSet<ManifestSection>(25);
            }
            mysections.add(section);
        }
        String installClass = m.getManifest().getMainAttributes().getValue("OpenIDE-Module-Install");
        if (installClass != null) {
            String installClassName;
            try {
                installClassName = Util.createPackageName((String)installClass);
            }
            catch (IllegalArgumentException iae) {
                InvalidException ie = new InvalidException(m, iae.toString());
                Util.err.annotate((Throwable)ie, (Throwable)iae);
                throw ie;
            }
            if (installClass.endsWith(".ser")) {
                throw new InvalidException(m, "Serialized module installs not supported: " + installClass);
            }
            try {
                Class<?> c;
                clazz = Class.forName(installClassName, false, m.getClassLoader());
                if (clazz.getClassLoader() != m.getClassLoader()) {
                    this.ev.log("wrongClassLoader", (Object)m, clazz, (Object)m.getClassLoader());
                }
                for (c = clazz; c != (class$org$openide$modules$ModuleInstall == null ? NbInstaller.class$("org.openide.modules.ModuleInstall") : class$org$openide$modules$ModuleInstall) && c != (class$java$lang$Object == null ? NbInstaller.class$("java.lang.Object") : class$java$lang$Object); c = c.getSuperclass()) {
                    try {
                        c.getDeclaredMethod("validate", new Class[0]);
                        ModuleInstall install = (ModuleInstall)SharedClassObject.findObject(clazz, (boolean)true);
                        install.validate();
                        continue;
                    }
                    catch (NoSuchMethodException nsme) {
                        // empty catch block
                    }
                }
                if (c == Object.class) {
                    throw new ClassCastException("Should extend ModuleInstall: " + clazz.getName());
                }
            }
            catch (Exception t) {
                InvalidException ie = new InvalidException(m, t.toString());
                Util.err.annotate((Throwable)ie, (Throwable)t);
                throw ie;
            }
            catch (LinkageError t) {
                InvalidException ie = new InvalidException(m, t.toString());
                Util.err.annotate((Throwable)ie, (Throwable)t);
                throw ie;
            }
        }
        if ((layerResource = m.getManifest().getMainAttributes().getValue("OpenIDE-Module-Layer")) != null && (layer = m.getClassLoader().getResource(layerResource)) == null) {
            throw new InvalidException(m, "Layer not found: " + layerResource);
        }
        String helpSetName = m.getManifest().getMainAttributes().getValue("OpenIDE-Module-Description");
        if (helpSetName != null) {
            Util.err.log(16, "Use of OpenIDE-Module-Description in " + m.getCodeNameBase() + " is deprecated.");
            Util.err.log(16, "(Please install help using an XML layer instead.)");
        }
        if (mysections != null) {
            this.sections.put(m, mysections);
        }
        if (clazz != null) {
            this.installs.put(m, clazz);
        }
        if (layerResource != null) {
            this.layers.put(m, layerResource);
        }
    }

    public void dispose(Module m) {
        Util.err.log("dispose: " + m);
        Set s = (Set)this.sections.remove(m);
        if (s != null) {
            Iterator it = s.iterator();
            while (it.hasNext()) {
                ManifestSection sect = (ManifestSection)it.next();
                sect.dispose();
            }
        }
        this.installs.remove(m);
        this.layers.remove(m);
        this.kosherPackages.remove(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(List modules) {
        Module m;
        this.ev.log("startLoad", (Object)modules);
        if (this.mgr != null) {
            MainLookup.systemClassLoaderChanged(this.mgr.getClassLoader());
        }
        this.ev.log("perfTick", (Object)"META-INF/services/ additions registered");
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            m = (Module)it.next();
            this.checkForDeprecations(m);
            NbInstaller.openideModuleEnabled(m);
        }
        this.loadLayers(modules, true);
        this.ev.log("perfTick", (Object)"layers loaded");
        it = modules.iterator();
        this.ev.log("perfStart", (Object)"NbInstaller.load - sections");
        this.ev.log("loadSection");
        CoreBridge.conditionallyLoaderPoolTransaction(true);
        try {
            while (it.hasNext()) {
                m = (Module)it.next();
                try {
                    this.loadSections(m, true);
                }
                catch (Exception t) {
                    Util.err.notify((Throwable)t);
                }
                catch (LinkageError le) {
                    Util.err.notify((Throwable)le);
                }
                this.ev.log("perfTick", (Object)("sections for " + m.getCodeName() + " loaded"));
            }
        }
        finally {
            CoreBridge.conditionallyLoaderPoolTransaction(false);
        }
        this.ev.log("perfEnd", (Object)"NbInstaller.load - sections");
        if (!this.initializedFolderLookup) {
            Util.err.log("modulesClassPathInitialized");
            MainLookup.modulesClassPathInitialized();
            this.initializedFolderLookup = true;
        }
        Main.initUICustomizations();
        it = modules.iterator();
        this.ev.log("perfStart", (Object)"NbInstaller.load - ModuleInstalls");
        while (it.hasNext()) {
            m = (Module)it.next();
            try {
                this.loadCode(m, true);
            }
            catch (Exception t) {
                Util.err.notify((Throwable)t);
            }
            catch (LinkageError le) {
                Util.err.notify((Throwable)le);
            }
            catch (AssertionError e) {
                Util.err.notify((Throwable)((Object)e));
            }
            this.ev.log("perfTick", (Object)("ModuleInstall for " + m.getCodeName() + " called"));
        }
        this.ev.log("perfEnd", (Object)"NbInstaller.load - ModuleInstalls");
        this.ev.log("finishLoad", (Object)modules);
        this.maybeSaveManifestCache();
        if (Boolean.getBoolean("netbeans.preresolve.classes")) {
            this.preresolveClasses(modules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(List modules) {
        block16: {
            Module m;
            this.ev.log("startUnload", (Object)modules);
            Iterator it = modules.iterator();
            while (it.hasNext()) {
                m = (Module)it.next();
                try {
                    this.loadCode(m, false);
                }
                catch (Exception t) {
                    Util.err.notify((Throwable)t);
                }
                catch (LinkageError le) {
                    Util.err.notify((Throwable)le);
                }
            }
            it = modules.iterator();
            CoreBridge.conditionallyLoaderPoolTransaction(true);
            block14: while (true) {
                while (it.hasNext()) {
                    m = (Module)it.next();
                    try {
                        this.loadSections(m, false);
                        continue block14;
                    }
                    catch (Exception t) {
                        Util.err.notify((Throwable)t);
                    }
                    catch (LinkageError le) {
                        Util.err.notify((Throwable)le);
                    }
                }
                break block16;
                {
                    continue block14;
                    break;
                }
                break;
            }
            finally {
                try {
                    CoreBridge.conditionallyLoaderPoolTransaction(false);
                }
                catch (RuntimeException e) {
                    Util.err.notify((Throwable)e);
                }
            }
        }
        this.loadLayers(modules, false);
        this.ev.log("finishUnload", (Object)modules);
    }

    private void loadCode(Module m, boolean load) throws Exception {
        Class instClazz = (Class)this.installs.get(m);
        if (instClazz != null) {
            ModuleInstall inst = (ModuleInstall)SharedClassObject.findObject((Class)instClazz, (boolean)true);
            if (load) {
                Object history;
                if (this.moduleList != null) {
                    this.moduleList.installPrepare(m, inst);
                }
                if ((history = m.getHistory()) instanceof ModuleHistory) {
                    ModuleHistory h = (ModuleHistory)history;
                    if (h.isPreviouslyInstalled()) {
                        SpecificationVersion oldSpec = h.getOldSpecificationVersion();
                        SpecificationVersion nueSpec = m.getSpecificationVersion();
                        if (m.getCodeNameRelease() != h.getOldMajorVersion() || oldSpec == null ^ nueSpec == null || oldSpec != null && nueSpec != null && oldSpec.compareTo((Object)nueSpec) != 0) {
                            this.ev.log("update", (Object)m);
                            inst.updated(h.getOldMajorVersion(), oldSpec == null ? null : oldSpec.toString());
                        } else {
                            this.ev.log("restore", (Object)m);
                            inst.restored();
                        }
                    } else {
                        this.ev.log("install", (Object)m);
                        inst.installed();
                    }
                } else {
                    this.ev.log("restore", (Object)m);
                    inst.restored();
                }
                if (this.moduleList != null) {
                    this.moduleList.installPostpare(m, inst);
                }
            } else {
                this.ev.log("uninstall", (Object)m);
                inst.uninstalled();
                if (m.getHistory() instanceof ModuleHistory) {
                    ((ModuleHistory)m.getHistory()).resetHistory();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSections(Module m, boolean load) throws Exception {
        Set s = (Set)this.sections.get(m);
        if (s == null) {
            return;
        }
        boolean attachedToMA = false;
        try {
            Main.incrementSplashProgressBar();
            Iterator it = s.iterator();
            while (it.hasNext()) {
                ManifestSection sect = (ManifestSection)it.next();
                if (sect instanceof ManifestSection.ActionSection) {
                    if (!attachedToMA) {
                        Object category = m.getLocalizedAttribute("OpenIDE-Module-Display-Category");
                        if (category == null) {
                            category = m.getCodeNameBase();
                        }
                        CoreBridge.getDefault().attachToCategory(category);
                        attachedToMA = true;
                    }
                    CoreBridge.getDefault().loadActionSection((ManifestSection.ActionSection)sect, load);
                    continue;
                }
                if (sect instanceof ManifestSection.ClipboardConvertorSection) {
                    this.loadGenericSection(sect, load);
                    continue;
                }
                if (sect instanceof ManifestSection.DebuggerSection) {
                    this.loadGenericSection(sect, load);
                    continue;
                }
                if (sect instanceof ManifestSection.LoaderSection) {
                    CoreBridge.getDefault().loadLoaderSection((ManifestSection.LoaderSection)sect, load);
                    continue;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError(sect);
                }
            }
        }
        finally {
            if (attachedToMA) {
                CoreBridge.getDefault().attachToCategory(null);
            }
        }
    }

    private void loadGenericSection(ManifestSection s, boolean load) {
        CoreBridge.getDefault().loadDefaultSection(s, this.convertor, load);
    }

    private void loadLayers(List modules, boolean load) {
        this.ev.log(load ? "loadLayers" : "unloadLayers", (Object)modules);
        modules = new ArrayList(modules);
        Collections.reverse(modules);
        HashMap urls = new HashMap(5);
        Iterator<Object> it = modules.iterator();
        while (it.hasNext()) {
            String ext;
            String base;
            Module m = (Module)it.next();
            String s = (String)this.layers.get(m);
            if (s == null) continue;
            Util.err.log("loadLayer: " + s + " load=" + load);
            int idx = s.lastIndexOf(46);
            if (idx == -1) {
                base = s;
                ext = "";
            } else {
                base = s.substring(0, idx);
                ext = s.substring(idx);
            }
            ClassLoader cl = m.getClassLoader();
            Iterator locit = NbBundle.getLocalizingSuffixes();
            ModuleLayeredFileSystem host = m.isReloadable() ? ModuleLayeredFileSystem.getUserModuleLayer() : ModuleLayeredFileSystem.getInstallationModuleLayer();
            ArrayList<URL> theseurls = (ArrayList<URL>)urls.get((Object)host);
            if (theseurls == null) {
                theseurls = new ArrayList<URL>(100);
                urls.put(host, theseurls);
            }
            boolean foundSomething = false;
            while (locit.hasNext()) {
                String suffix = (String)locit.next();
                String resource = base + suffix + ext;
                URL u = cl.getResource(resource);
                if (u == null) continue;
                theseurls.add(u);
                foundSomething = true;
            }
            if (foundSomething) continue;
            Util.err.log("Module layer not found: " + s);
        }
        it = urls.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            ModuleLayeredFileSystem host = (ModuleLayeredFileSystem)((Object)entry.getKey());
            List theseurls = (List)entry.getValue();
            Util.err.log("Adding/removing layer URLs: host=" + (Object)((Object)host) + " urls=" + theseurls);
            try {
                if (load) {
                    host.addURLs(theseurls);
                    continue;
                }
                host.removeURLs(theseurls);
            }
            catch (Exception e) {
                Util.err.notify((Throwable)e);
            }
        }
    }

    private void checkForDeprecations(Module m) {
        if (!Boolean.valueOf((String)m.getAttribute("OpenIDE-Module-Deprecated")).booleanValue()) {
            Dependency[] deps = m.getDependenciesArray();
            for (int i = 0; i < deps.length; ++i) {
                if (deps[i].getType() != 1) continue;
                String cnb = (String)Util.parseCodeName((String)deps[i].getName())[0];
                Module o = this.mgr.get(cnb);
                if (o == null) {
                    throw new IllegalStateException("No such module: " + cnb);
                }
                if (!Boolean.valueOf((String)o.getAttribute("OpenIDE-Module-Deprecated")).booleanValue()) continue;
                String message = (String)o.getLocalizedAttribute("OpenIDE-Module-Deprecation-Message");
                if (message != null) {
                    Util.err.log(16, "Warning: the module " + m.getCodeNameBase() + " uses " + cnb + " which is deprecated: " + message);
                    continue;
                }
                Util.err.log(16, "Warning: the module " + m.getCodeNameBase() + " uses " + cnb + " which is deprecated.");
            }
        }
    }

    public boolean closing(List modules) {
        Util.err.log("closing: " + modules);
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            Module m = (Module)it.next();
            Class instClazz = (Class)this.installs.get(m);
            if (instClazz == null) continue;
            try {
                ModuleInstall inst = (ModuleInstall)SharedClassObject.findObject((Class)instClazz, (boolean)true);
                if (inst.closing()) continue;
                Util.err.log("Module " + m + " refused to close");
                return false;
            }
            catch (RuntimeException re) {
                Util.err.notify((Throwable)re);
            }
            catch (LinkageError le) {
                Util.err.notify((Throwable)le);
            }
        }
        return true;
    }

    public void close(List modules) {
        Util.err.log("close: " + modules);
        this.ev.log("close");
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            Module m = (Module)it.next();
            Class instClazz = (Class)this.installs.get(m);
            if (instClazz == null) continue;
            try {
                ModuleInstall inst = (ModuleInstall)SharedClassObject.findObject((Class)instClazz, (boolean)true);
                if (inst == null) {
                    throw new IllegalStateException("Inconsistent state: " + instClazz);
                }
                inst.close();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                Util.err.notify(t);
            }
        }
    }

    public void refineDependencies(Module m, Set dependencies) {
        AutomaticDependencies.Report rep;
        if (Boolean.getBoolean("org.netbeans.core.modules.NbInstaller.noAutoDeps")) {
            return;
        }
        if (this.autoDepsHandler == null) {
            FileObject depsFolder = Repository.getDefault().getDefaultFileSystem().findResource("ModuleAutoDeps");
            if (depsFolder != null) {
                FileObject[] kids = depsFolder.getChildren();
                ArrayList<URL> urls = new ArrayList<URL>(Math.max(kids.length, 1));
                for (int i = 0; i < kids.length; ++i) {
                    if (!kids[i].hasExt("xml")) continue;
                    try {
                        urls.add(kids[i].getURL());
                        continue;
                    }
                    catch (FileStateInvalidException e) {
                        Util.err.notify((Throwable)e);
                    }
                }
                try {
                    this.autoDepsHandler = AutomaticDependencies.parse(urls.toArray(new URL[urls.size()]));
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
                catch (SAXException e) {
                    Util.err.notify((Throwable)e);
                }
            }
            if (this.autoDepsHandler == null) {
                this.autoDepsHandler = AutomaticDependencies.empty();
            }
            if (Util.err.isLoggable(1)) {
                Util.err.log(1, "Auto deps: " + this.autoDepsHandler);
            }
        }
        if ((rep = this.autoDepsHandler.refineDependenciesAndReport(m.getCodeNameBase(), dependencies)).isModified()) {
            Util.err.log(16, "Warning - had to upgrade dependencies for module " + m.getCodeNameBase() + ": added = " + rep.getAdded() + " removed = " + rep.getRemoved() + "; details: " + rep.getMessages());
        }
    }

    public String[] refineProvides(Module m) {
        if (m.getCodeNameBase().equals("org.openide.modules")) {
            boolean isOS2;
            ArrayList<String> arr = new ArrayList<String>(4);
            boolean isMac = (Utilities.getOperatingSystem() & 0x1000) != 0;
            boolean bl = isOS2 = (Utilities.getOperatingSystem() & 0x800) != 0;
            if (Utilities.isUnix()) {
                arr.add("org.openide.modules.os.Unix");
                if (!isMac) {
                    arr.add("org.openide.modules.os.PlainUnix");
                }
            }
            if (Utilities.isWindows()) {
                arr.add("org.openide.modules.os.Windows");
            }
            if (isMac) {
                arr.add("org.openide.modules.os.MacOSX");
            }
            if (isOS2) {
                arr.add("org.openide.modules.os.OS2");
            }
            arr.add("org.openide.modules.ModuleFormat1");
            return arr.toArray(new String[0]);
        }
        return null;
    }

    private void addLoadersRecursively(List parents, Dependency[] deps, Set parentModules, Module master, Set addedParentNames) {
        for (int i = 0; i < deps.length; ++i) {
            if (deps[i].getType() != 1) continue;
            String cnb = (String)Util.parseCodeName((String)deps[i].getName())[0];
            Module parent = this.mgr.get(cnb);
            if (parent == null) {
                throw new IllegalStateException("No such parent module of " + master + ": " + cnb);
            }
            if (!parentModules.add(parent)) continue;
            if (!parents.contains(parent.getClassLoader())) {
                if (Util.err.isLoggable(1)) {
                    Util.err.log("#27853: adding virtual dependency from " + master + ": " + parent);
                }
                parents.add(parent.getClassLoader());
                addedParentNames.add(cnb);
            }
            this.addLoadersRecursively(parents, parent.getDependenciesArray(), parentModules, master, addedParentNames);
        }
    }

    public boolean shouldDelegateResource(Module m, Module parent, String pkg) {
        if (parent == null) {
            for (int i = 0; i < CLASSPATH_PACKAGES.length; ++i) {
                if (!pkg.startsWith(CLASSPATH_PACKAGES[i]) || this.findKosher(m).contains(CLASSPATH_PACKAGES[i])) continue;
                if (Util.err.isLoggable(1)) {
                    Util.err.log("Refusing to load classpath package " + pkg + " for " + m.getCodeNameBase() + " without a proper dependency");
                }
                return false;
            }
        }
        return true;
    }

    private Set findKosher(Module m) {
        Set<String> s = (HashSet)this.kosherPackages.get(m);
        if (s == null) {
            s = new HashSet();
            Dependency[] deps = m.getDependenciesArray();
            SpecificationVersion openide = Util.getModuleDep((Set)m.getDependencies(), (String)"org.openide");
            boolean pre27853 = openide == null || openide.compareTo((Object)new SpecificationVersion("1.3.12")) < 0;
            for (int i = 0; i < deps.length; ++i) {
                String req;
                if (deps[i].getType() == 1 && deps[i].getName().equals("org.netbeans.core.startup/1")) {
                    s.add("org/netbeans/core/startup/");
                    continue;
                }
                if (pre27853 && deps[i].getType() == 1) {
                    Module other;
                    String name = deps[i].getName();
                    int idx = name.indexOf(47);
                    if (idx != -1) {
                        name = name.substring(0, idx);
                    }
                    if ((other = this.mgr.get(name)) == null) {
                        throw new IllegalStateException("Should have found dep " + deps[i] + " from " + m);
                    }
                    s.addAll(this.findKosher(other));
                    continue;
                }
                if (deps[i].getType() != 2) continue;
                String depname = deps[i].getName();
                int idx = depname.indexOf(91);
                if (idx == -1) {
                    req = depname.replace('.', '/').concat("/");
                } else if (idx == 0) {
                    int idx2 = depname.lastIndexOf(46);
                    req = depname.substring(1, idx2).replace('.', '/').concat("/");
                } else {
                    req = depname.substring(0, idx).replace('.', '/').concat("/");
                }
                for (int j = 0; j < CLASSPATH_PACKAGES.length; ++j) {
                    if (!req.startsWith(CLASSPATH_PACKAGES[j])) continue;
                    s.add(CLASSPATH_PACKAGES[j]);
                }
            }
            if (s.isEmpty()) {
                s = Collections.EMPTY_SET;
            }
            this.kosherPackages.put(m, s);
        }
        return s;
    }

    static void openideModuleEnabled(Module module) {
        String m = module.getCodeNameBase();
        if (!m.startsWith("org.openide.")) {
            return;
        }
        if ("org.openide.util".equals(m)) {
            return;
        }
        if ("org.openide.actions".equals(m)) {
            return;
        }
        if ("org.openide.awt".equals(m)) {
            return;
        }
        if ("org.openide.modules".equals(m)) {
            return;
        }
        if ("org.openide.nodes".equals(m)) {
            return;
        }
        if ("org.openide.windows".equals(m)) {
            return;
        }
        if ("org.openide.explorer".equals(m)) {
            return;
        }
        if ("org.openide.util.enumerations".equals(m)) {
            return;
        }
        if ("org.openide.execution".equals(m)) {
            return;
        }
        if ("org.openide.options".equals(m)) {
            return;
        }
        if ("org.openide.execution".equals(m)) {
            return;
        }
        if ("org.openide.loaders".equals(m)) {
            return;
        }
        if ("org.openide.dialogs".equals(m)) {
            return;
        }
        if ("org.openide.filesystems".equals(m)) {
            return;
        }
        if ("org.openide.io".equals(m)) {
            return;
        }
        if ("org.openide.text".equals(m)) {
            return;
        }
        if ("org.openide.src".equals(m)) {
            return;
        }
        Util.err.log(16, "Disabling openide load optimizations due to use of " + m);
        withoutOptimizations = true;
    }

    public boolean isSpecialResource(String pkg) {
        if (pkg.startsWith("org/openide/")) {
            if ("org/openide/".equals(pkg)) {
                return true;
            }
            if ("org/openide/actions/".equals(pkg)) {
                return true;
            }
            if ("org/openide/awt/".equals(pkg)) {
                return true;
            }
            if ("org/openide/cookies/".equals(pkg)) {
                return true;
            }
            if ("org/openide/resources/".equals(pkg)) {
                return true;
            }
            if ("org/openide/explorer/propertysheet/editors/".equals(pkg)) {
                return true;
            }
            if ("org/openide/windows/".equals(pkg)) {
                return true;
            }
            if ("org/openide/text/".equals(pkg)) {
                return true;
            }
            if ("org/openide/util/actions/".equals(pkg)) {
                return true;
            }
            if (withoutOptimizations) {
                if ("org/openide/explorer/".equals(pkg)) {
                    return true;
                }
                if ("org/openide/util/".equals(pkg)) {
                    return true;
                }
            }
        }
        if (this.isSpecialResourceFromSystemProperty(pkg)) {
            return true;
        }
        if (pkg.equals("org/w3c/dom/")) {
            return true;
        }
        if (pkg.equals("org/w3c/dom/ls/")) {
            return true;
        }
        return super.isSpecialResource(pkg);
    }

    private boolean isSpecialResourceFromSystemProperty(String pkg) {
        String[] prefixes = NbInstaller.getSpecialResourcePrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            if (!pkg.startsWith(prefixes[i])) continue;
            return true;
        }
        return false;
    }

    private static String[] getSpecialResourcePrefixes() {
        if (specialResourcePrefixes == null) {
            String sysProp = System.getProperty("org.netbeans.core.startup.specialResource");
            specialResourcePrefixes = sysProp != null ? sysProp.split(",") : new String[0];
        }
        return specialResourcePrefixes;
    }

    String getEffectiveClasspath(Module m) {
        if (!m.isEnabled()) {
            return "";
        }
        ArrayList l = new ArrayList(100);
        NbInstaller.createBootClassPath(l);
        Set kosher = m.isFixed() ? null : this.findKosher(m);
        StringTokenizer tok = new StringTokenizer(System.getProperty("java.class.path", ""), File.pathSeparator);
        while (tok.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(tok.nextToken()), l, kosher);
        }
        tok = new StringTokenizer(System.getProperty("netbeans.dynamic.classpath", ""), File.pathSeparator);
        while (tok.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(tok.nextToken()), l, kosher);
        }
        HashSet modulesConsidered = new HashSet(50);
        HashSet<String> implDeps = new HashSet<String>(10);
        Dependency[] deps = m.getDependenciesArray();
        for (int i = 0; i < deps.length; ++i) {
            if (deps[i].getType() != 1 || deps[i].getComparison() != 2) continue;
            implDeps.add(deps[i].getName());
        }
        SpecificationVersion openide = Util.getModuleDep((Set)m.getDependencies(), (String)"org.openide");
        boolean pre27853 = openide == null || openide.compareTo((Object)new SpecificationVersion("1.3.12")) < 0;
        this.addModuleClasspathEntries(m, m, modulesConsidered, implDeps, l, pre27853 ? Integer.MAX_VALUE : 1);
        StringBuffer buf = new StringBuffer(l.size() * 100 + 1);
        Iterator it = l.iterator();
        while (it.hasNext()) {
            if (buf.length() > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append((String)it.next());
        }
        return buf.toString();
    }

    private static void createBootClassPath(List l) {
        String extensions;
        String boot = System.getProperty("sun.boot.class.path");
        if (boot != null) {
            StringTokenizer tok = new StringTokenizer(boot, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                l.add(tok.nextToken());
            }
        }
        if ((extensions = System.getProperty("java.ext.dirs")) != null) {
            StringTokenizer st = new StringTokenizer(extensions, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File dir = new File(st.nextToken());
                File[] entries = dir.listFiles();
                if (entries == null) continue;
                for (int i = 0; i < entries.length; ++i) {
                    String name = entries[i].getName().toLowerCase(Locale.US);
                    if (!name.endsWith(".zip") && !name.endsWith(".jar")) continue;
                    l.add(entries[i].getAbsolutePath());
                }
            }
        }
    }

    private static void addStartupClasspathEntry(File cpEntry, List cp, Set kosher) {
        if (cpEntry.isDirectory()) {
            cp.add(cpEntry.getAbsolutePath());
            return;
        }
        String name = cpEntry.getName();
        for (int j = 0; j < CLASSPATH_JARS.length; ++j) {
            if (kosher == null || !name.startsWith(CLASSPATH_JARS[j][0])) continue;
            StringBuffer entry = null;
            for (int k = 1; k < CLASSPATH_JARS[j].length; ++k) {
                String pkg = CLASSPATH_JARS[j][k];
                if (!kosher.contains(pkg)) continue;
                if (entry == null) {
                    entry = new StringBuffer(100);
                    entry.append(cpEntry.getAbsolutePath());
                    entry.append('[');
                } else {
                    entry.append(',');
                }
                entry.append(pkg.replace('/', '.'));
                entry.append("**");
            }
            if (entry != null) {
                entry.append(']');
                cp.add(entry.toString());
            }
            return;
        }
        cp.add(cpEntry.getAbsolutePath());
    }

    private void addModuleClasspathEntries(Module m, Module orig, Set considered, Set implDeps, List cp, int depth) {
        if (!considered.add(m)) {
            return;
        }
        Dependency[] deps = m.getDependenciesArray();
        for (int i = 0; i < deps.length; ++i) {
            if (deps[i].getType() != 1) continue;
            String cnb = (String)Util.parseCodeName((String)deps[i].getName())[0];
            Module next = this.mgr.get(cnb);
            if (next == null) {
                throw new IllegalStateException("No such module: " + cnb);
            }
            if (depth <= 0) continue;
            this.addModuleClasspathEntries(next, orig, considered, implDeps, cp, depth - 1);
        }
        boolean friend = m == orig || implDeps.contains(m.getCodeName());
        Module.PackageExport[] exports = friend ? null : m.getPublicPackages();
        String qualification = "";
        if (exports != null) {
            if (exports.length == 0) {
                return;
            }
            StringBuffer b = new StringBuffer(100);
            b.append('[');
            for (int i = 0; i < exports.length; ++i) {
                if (i > 0) {
                    b.append(',');
                }
                b.append(exports[i].pkg.replace('/', '.'));
                b.append(exports[i].recursive ? "**" : "*");
            }
            b.append(']');
            qualification = b.toString();
        }
        List jars = m.getAllJars();
        Iterator it = jars.iterator();
        while (it.hasNext()) {
            cp.add(((File)it.next()).getAbsolutePath() + qualification);
        }
    }

    public Manifest loadManifest(File jar) throws IOException {
        Object[] entry;
        if (!this.usingManifestCache) {
            return super.loadManifest(jar);
        }
        if (this.manifestCache == null) {
            this.manifestCache = this.loadManifestCache(this.manifestCacheFile);
        }
        if ((entry = (Object[])this.manifestCache.get(jar)) != null) {
            if (((Date)entry[0]).getTime() == jar.lastModified()) {
                Util.err.log("Found manifest for " + jar + " in cache");
                return (Manifest)entry[1];
            }
            Util.err.log("Wrong timestamp for " + jar + " in manifest cache");
        } else {
            Util.err.log("No entry for " + jar + " in manifest cache");
        }
        Manifest m = super.loadManifest(jar);
        this.manifestCache.put(jar, new Object[]{new Date(jar.lastModified()), m});
        this.manifestCacheDirty = true;
        return m;
    }

    private void maybeSaveManifestCache() {
        if (this.usingManifestCache && this.manifestCacheDirty) {
            try {
                this.saveManifestCache(this.manifestCache, this.manifestCacheFile);
            }
            catch (IOException ioe) {
                Util.err.notify(16, (Throwable)ioe);
            }
            this.usingManifestCache = false;
            this.manifestCacheDirty = false;
            this.manifestCache = null;
            this.manifestCacheFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveManifestCache(Map manifestCache, File manifestCacheFile) throws IOException {
        Util.err.log("Saving manifest cache");
        manifestCacheFile.getParentFile().mkdirs();
        OutputStream os = new FileOutputStream(manifestCacheFile);
        try {
            try {
                os = new BufferedOutputStream(os);
                Iterator it = manifestCache.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    File jar = (File)e.getKey();
                    Object[] v = (Object[])e.getValue();
                    long time = ((Date)v[0]).getTime();
                    Manifest m = (Manifest)v[1];
                    os.write(jar.getAbsolutePath().getBytes("UTF-8"));
                    os.write(0);
                    for (int i = 7; i >= 0; --i) {
                        os.write((int)(time >> i * 8 & 0xFFL));
                    }
                    m.write(os);
                    os.write(0);
                }
            }
            finally {
                os.close();
            }
        }
        catch (IOException ioe) {
            manifestCacheFile.delete();
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadManifestCache(File manifestCacheFile) {
        HashMap hashMap;
        if (!manifestCacheFile.canRead()) {
            Util.err.log("No manifest cache found at " + manifestCacheFile);
            return new HashMap(200);
        }
        this.ev.log("perfStart", (Object)"NbInstaller - loadManifestCache");
        FileInputStream is = new FileInputStream(manifestCacheFile);
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            HashMap m = new HashMap(200);
            ByteArrayOutputStream baos = new ByteArrayOutputStream((int)manifestCacheFile.length());
            FileUtil.copy((InputStream)bis, (OutputStream)baos);
            byte[] data = baos.toByteArray();
            NbInstaller.readManifestCacheEntries(data, m);
            hashMap = m;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
                this.ev.log("perfEnd", (Object)"NbInstaller - loadManifestCache");
                throw throwable;
            }
            catch (IOException ioe) {
                Util.err.annotate((Throwable)ioe, 0, "While reading: " + manifestCacheFile, null, null, null);
                Util.err.notify(16, (Throwable)ioe);
                return new HashMap(200);
            }
        }
        ((InputStream)is).close();
        this.ev.log("perfEnd", (Object)"NbInstaller - loadManifestCache");
        return hashMap;
    }

    private static int findNullByte(byte[] data, int start) {
        int len = data.length;
        for (int i = start; i < len; ++i) {
            if (data[i] != 0) continue;
            return i;
        }
        return -1;
    }

    private static void readManifestCacheEntries(byte[] data, Map m) throws IOException {
        int pos = 0;
        while (pos != data.length) {
            Manifest mani;
            int end = NbInstaller.findNullByte(data, pos);
            if (end == -1) {
                throw new IOException("Could not find next manifest JAR name from " + pos);
            }
            File jar = new File(new String(data, pos, end - pos, "UTF-8"));
            long time = 0L;
            if (end + 8 >= data.length) {
                throw new IOException("Ran out of space for timestamp for " + jar);
            }
            for (int i = 0; i < 8; ++i) {
                long b = data[end + i + 1];
                if (b < 0L) {
                    b += 256L;
                }
                int exponent = 7 - i;
                long addin = b << exponent * 8;
                time |= addin;
            }
            pos = end + 9;
            if ((end = NbInstaller.findNullByte(data, pos)) == -1) {
                throw new IOException("Could not find manifest body for " + jar);
            }
            try {
                mani = new Manifest(new ByteArrayInputStream(data, pos, end - pos));
            }
            catch (IOException ioe) {
                Util.err.annotate((Throwable)ioe, 0, "While in entry for " + jar, null, null, null);
                throw ioe;
            }
            m.put(jar, new Object[]{new Date(time), mani});
            if (Util.err.isLoggable(1)) {
                Util.err.log("Manifest cache entry: jar=" + jar + " date=" + new Date(time) + " codename=" + mani.getMainAttributes().getValue("OpenIDE-Module"));
            }
            pos = end + 1;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preresolveClasses(List modules) {
        Util.err.log(256, "Pre-resolving classes for all loaded modules...be sure you have not specified -J-Xverify:none in ide.cfg");
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            Module m = (Module)it.next();
            if (m.isFixed() || m.getJarFile() == null) continue;
            File jar = m.getJarFile();
            try {
                JarFile j = new JarFile(jar, true);
                try {
                    Enumeration<JarEntry> e = j.entries();
                    while (e.hasMoreElements()) {
                        JarEntry entry = e.nextElement();
                        String name = entry.getName();
                        if (!name.endsWith(".class")) continue;
                        String clazz = name.substring(0, name.length() - 6).replace('/', '.');
                        try {
                            Class.forName(clazz, false, m.getClassLoader());
                        }
                        catch (ClassNotFoundException cnfe) {
                            Util.err.annotate((Throwable)cnfe, 0, "From " + clazz + " in " + m.getCodeNameBase() + " with effective classpath " + this.getEffectiveClasspath(m), null, null, null);
                            Util.err.notify(1, (Throwable)cnfe);
                        }
                        catch (LinkageError le) {
                            Util.err.annotate((Throwable)le, 0, "From " + clazz + " in " + m.getCodeNameBase() + " with effective classpath " + this.getEffectiveClasspath(m), null, null, null);
                            Util.err.notify(1, (Throwable)le);
                        }
                        catch (RuntimeException re) {
                            Util.err.annotate((Throwable)re, 0, "From " + clazz + " in " + m.getCodeNameBase() + " with effective classpath " + this.getEffectiveClasspath(m), null, null, null);
                            Util.err.notify(1, (Throwable)re);
                        }
                    }
                }
                finally {
                    j.close();
                }
            }
            catch (IOException ioe) {
                Util.err.notify(1, (Throwable)ioe);
            }
        }
    }

    static {
        $assertionsDisabled = !NbInstaller.class.desiredAssertionStatus();
        specialResourcePrefixes = null;
        CLASSPATH_PACKAGES = new String[]{"org/netbeans/core/startup/", "org/apache/crimson/", "org/apache/xalan/", "org/apache/xpath/", "org/apache/xml/dtm/", "org/apache/xml/utils/"};
        CLASSPATH_JARS = new String[][]{{"core", "org/netbeans/core/", "org/netbeans/beaninfo/"}, {"boot"}};
    }

    private final class Convertor
    implements InstanceContent.Convertor {
        Convertor() {
        }

        public Object convert(Object obj) {
            ManifestSection s = (ManifestSection)obj;
            try {
                return s.getInstance();
            }
            catch (Exception e) {
                Util.err.notify((Throwable)e);
                NbInstaller.this.loadGenericSection(s, false);
                return null;
            }
        }

        public Class type(Object obj) {
            ManifestSection s = (ManifestSection)obj;
            return s.getSuperclass();
        }

        public String id(Object obj) {
            return obj.toString();
        }

        public String displayName(Object obj) {
            return obj.toString();
        }
    }
}

