/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.scanning;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.modules.javacore.scanning.FileInfo;
import org.netbeans.modules.javacore.scanning.ZipDirInfo;

class ZipArchiveInfo {
    ZipFile zipFile;
    String offset;
    Map directoryMap = new HashMap(1000);
    ZipDirInfo rootInfo;

    ZipArchiveInfo(File f, String offset) throws IOException {
        this.zipFile = new ZipFile(f);
        this.offset = offset;
        this.rootInfo = new ZipDirInfo("", "");
    }

    void close() throws IOException {
        if (this.zipFile != null) {
            this.zipFile.close();
        }
    }

    FileInfo getRootFileInfo() {
        Enumeration<? extends ZipEntry> en = this.zipFile.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (this.offset != null) {
                if (!name.startsWith(this.offset)) continue;
                name = name.substring(this.offset.length());
            }
            int lastSlashIndex = name.lastIndexOf(47);
            String directoryName = "";
            String shortName = name;
            if (lastSlashIndex > -1) {
                directoryName = name.substring(0, lastSlashIndex);
                shortName = name.substring(lastSlashIndex + 1);
            }
            this.getDirectory(directoryName).addEntry(this.zipFile, entry, shortName, name);
        }
        return this.rootInfo;
    }

    private ZipDirInfo getDirectory(String dirName) {
        ZipDirInfo zipDir = (ZipDirInfo)this.directoryMap.get(dirName);
        if (zipDir == null) {
            ZipDirInfo parentInfo;
            int lastSlashIndex = dirName.lastIndexOf(47);
            String shortName = dirName;
            if (lastSlashIndex > -1) {
                String parentDirName = dirName.substring(0, lastSlashIndex);
                shortName = dirName.substring(lastSlashIndex + 1);
                parentInfo = this.getDirectory(parentDirName);
            } else {
                parentInfo = this.rootInfo;
            }
            zipDir = new ZipDirInfo(dirName, shortName);
            parentInfo.addDir(zipDir);
            this.directoryMap.put(dirName, zipDir);
        }
        return zipDir;
    }
}

