/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.modules.javacore.internalapi.GuardedResolver;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.parser.MDRParser;
import org.openide.text.PositionBounds;

public final class FileGuardedResolver
implements GuardedResolver {
    private static final String GEN_BEGIN = "//GEN-BEGIN";
    private static final String GEN_END = "//GEN-END";
    private static final String GEN_HEADER = "//GEN-HEADER";
    private static final String GEN_HEADEREND = "//GEN-HEADEREND";
    private static final String GEN_LINE = "//GEN-LINE";
    private static final String GEN_FIRST = "//GEN-FIRST";
    private static final String GEN_LAST = "//GEN-LAST";
    private static final int GUARDED_BEGIN = 0;
    private static final int GUARDED_END = 1;
    private static final int GUARDED_LINE = 2;
    private static final int GUARDED_NONE = -1;
    private static FileGuardedResolver instance = null;

    private FileGuardedResolver() {
    }

    public static synchronized FileGuardedResolver getDefault() {
        if (instance == null) {
            instance = new FileGuardedResolver();
        }
        return instance;
    }

    public final boolean isSectionGuarded(Resource resource, PositionBounds bounds) {
        MDRParser parser = ((ResourceImpl)resource).getParser();
        if (parser.guardedBlocksBorders == null) {
            parser.guardedBlocksBorders = this.findGuardedBlocks(resource);
        }
        return this.isGuarded(parser.guardedBlocksBorders, bounds.getBegin().getOffset()) || this.isGuarded(parser.guardedBlocksBorders, bounds.getEnd().getOffset());
    }

    private int[] findGuardedBlocks(Resource resource) {
        MDRParser provider = ((ResourceImpl)resource).getParser();
        int lastTokenIndex = 0;
        ASTree tree = provider.getASTree();
        if (tree != null) {
            lastTokenIndex = tree.getLastToken();
        }
        ArrayList<Integer> borders = new ArrayList<Integer>();
        int lineStart = 0;
        for (int x = 0; x <= lastTokenIndex; ++x) {
            Token token = provider.getToken(x);
            Token[] pads = token.getPadding();
            if (pads == null) continue;
            block6: for (int y = 0; y < pads.length; ++y) {
                int padType = pads[y].getType();
                if (padType == 366) {
                    lineStart = pads[y].getEndOffset();
                    continue;
                }
                if (padType != 363) continue;
                String text = provider.getText(pads[y]);
                int gid = this.guardedId(text);
                switch (gid) {
                    case 0: {
                        borders.add(new Integer(lineStart));
                        continue block6;
                    }
                    case 1: {
                        borders.add(new Integer(pads[y].getEndOffset()));
                        continue block6;
                    }
                    case 2: {
                        borders.add(new Integer(lineStart));
                        borders.add(new Integer(pads[y].getEndOffset()));
                    }
                }
            }
        }
        int[] result = new int[borders.size()];
        Iterator iter = borders.iterator();
        int x = 0;
        while (iter.hasNext()) {
            result[x] = (Integer)iter.next();
            ++x;
        }
        return result.length > 0 ? provider.getDocumentOffsets(result) : result;
    }

    private int guardedId(String text) {
        if (text == null) {
            return -1;
        }
        if (text.indexOf(GEN_BEGIN) > -1 || text.indexOf(GEN_HEADER) > -1) {
            return 0;
        }
        if (text.indexOf(GEN_END) > -1 || text.indexOf(GEN_HEADEREND) > -1) {
            return 1;
        }
        if (text.indexOf(GEN_LINE) > -1 || text.indexOf(GEN_FIRST) > -1 || text.indexOf(GEN_LAST) > -1) {
            return 2;
        }
        return -1;
    }

    private boolean isGuarded(int[] borders, int start, int end) {
        int index;
        if (borders.length == 0) {
            return false;
        }
        if (start < borders[0]) {
            return end < borders[0];
        }
        for (index = 0; index < borders.length && borders[index] < start; ++index) {
        }
        if (index == borders.length) {
            return false;
        }
        if (borders[index] == start) {
            return true;
        }
        if (index % 2 == 0) {
            return end < borders[index];
        }
        return true;
    }

    private boolean isGuarded(int[] borders, int offset) {
        if (borders.length == 0 || offset < borders[0]) {
            return false;
        }
        for (int x = 0; x < borders.length / 2; ++x) {
            if (offset < borders[2 * x] || offset > borders[2 * x + 1]) continue;
            return true;
        }
        return false;
    }
}

