/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.text.Position;
import org.netbeans.modules.java.bridge.Binding;
import org.netbeans.modules.java.codegen.ContainerImpl;
import org.netbeans.modules.java.codegen.ElementBinding;
import org.netbeans.modules.java.codegen.ExceptionRunnable;
import org.netbeans.modules.java.codegen.PositionComparator;
import org.netbeans.modules.java.codegen.SourceText;
import org.netbeans.modules.java.codegen.TextBinding;
import org.openide.src.Element;
import org.openide.src.MultiPropertyChangeEvent;
import org.openide.src.SourceException;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

class ContainerSupport
implements TextBinding.Container,
ContainerImpl {
    TreeSet children;
    ElementBinding parent;
    SourceText source;
    boolean separateMembers;
    private static final Comparator CHILD_COMPARATOR = new PositionComparator();
    private static final boolean DEBUG = false;
    public static final int OP_REORDER = 0;
    public static final int OP_INSERT = 1;
    public static final int OP_REPLACE = 2;
    public static final int OP_REMOVE = 3;

    public ContainerSupport(SourceText s, ElementBinding parent) {
        this.source = s;
        this.parent = parent;
        this.children = this.createSet(null);
        this.separateMembers = true;
    }

    private Element getElement() {
        return this.parent.getElement();
    }

    public boolean isEmpty() {
        return this.children == null || this.children.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionRef getFirstPosition() {
        ElementBinding first;
        ContainerSupport containerSupport = this;
        synchronized (containerSupport) {
            if (this.children.isEmpty()) {
                return null;
            }
            first = (ElementBinding)this.children.first();
        }
        return first.wholeBounds.getBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionRef getLastPosition() {
        ElementBinding last;
        ContainerSupport containerSupport = this;
        synchronized (containerSupport) {
            if (this.children.isEmpty()) {
                return null;
            }
            last = (ElementBinding)this.children.last();
        }
        return last.wholeBounds.getEnd();
    }

    protected PositionBounds getContainerBounds() {
        return this.parent.findContainerBounds(this);
    }

    protected TreeSet createSet(Collection c) {
        TreeSet s = new TreeSet(CHILD_COMPARATOR);
        if (c != null) {
            s.addAll(c);
        }
        return s;
    }

    public void updateChildren(Collection c) {
        ElementBinding last = null;
        ElementBinding first = null;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            ElementBinding b = (ElementBinding)it.next();
            if (first == null) {
                first = b;
            }
            b.containerRef = this;
            last = b;
        }
        this.children = this.createSet(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ElementBinding findNext(ElementBinding b) {
        SortedSet<ElementBinding> s;
        if (b == null) {
            if (this.children.isEmpty()) {
                return null;
            }
            return (ElementBinding)this.children.first();
        }
        Object object = this.source.getTreeLock();
        synchronized (object) {
            s = this.children.tailSet(b);
        }
        if (s.size() < 2) {
            return null;
        }
        Iterator it = s.iterator();
        it.next();
        return (ElementBinding)it.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ElementBinding findPrevious(ElementBinding b) {
        SortedSet<ElementBinding> s;
        if (b == null) {
            if (this.children.isEmpty()) {
                return null;
            }
            return (ElementBinding)this.children.last();
        }
        Object object = this.source.getTreeLock();
        synchronized (object) {
            s = this.children.headSet(b);
        }
        if (s.size() < 1) {
            return null;
        }
        return s.last();
    }

    public ElementBinding findBindingAt(int pos) {
        Integer posObj = new Integer(pos);
        SortedSet<Integer> s = this.children.tailSet(posObj);
        if (s == null || s.isEmpty()) {
            return null;
        }
        return ((ElementBinding)s.iterator().next()).findBindingAt(pos);
    }

    public ElementBinding findParent() {
        return this.parent;
    }

    public boolean canInsertAfter(Binding b) {
        PositionRef last;
        ElementBinding next;
        PositionRef first;
        if (!this.source.isAtomicAsUser()) {
            return true;
        }
        ElementBinding previous = (ElementBinding)b;
        PositionBounds cb = this.getContainerBounds();
        if (!this.source.isGeneratorEnabled() || cb == null) {
            return true;
        }
        if (previous == null) {
            first = this.source.createPos(cb.getBegin().getOffset(), Position.Bias.Forward);
            next = this.children.isEmpty() ? null : (ElementBinding)this.children.first();
        } else {
            if (!previous.canInsertAfter()) {
                return false;
            }
            first = this.source.createPos(previous.wholeBounds.getEnd().getOffset(), Position.Bias.Forward);
            SortedSet<ElementBinding> s = this.children.tailSet(previous);
            Iterator it = s.iterator();
            it.next();
            next = it.hasNext() ? (ElementBinding)it.next() : null;
        }
        if (next != null) {
            last = this.source.createPos(next.wholeBounds.getBegin().getOffset() - 1, Position.Bias.Forward);
        } else {
            int endOffset = cb.getEnd().getOffset();
            if (endOffset != 0) {
                --endOffset;
            }
            last = this.source.createPos(endOffset, Position.Bias.Forward);
        }
        return this.source.canWriteInside(new PositionBounds(first, last));
    }

    public void reorder(Map fromToMap) throws SourceException {
    }

    public void replace(Binding oldBinding, Binding newBinding) throws SourceException {
    }

    public void insert(Binding toInitialize, Binding previous) throws SourceException {
    }

    public void insertChild(ElementBinding n, ElementBinding previous, ElementBinding next, PositionBounds bounds) throws SourceException {
        boolean emptyBefore;
        boolean emptyAfter;
        if (this.separateMembers) {
            emptyAfter = true;
            emptyBefore = true;
        } else {
            emptyBefore = previous == null;
            emptyAfter = next == null;
        }
        n.create(this, previous, next, bounds, emptyBefore, emptyAfter);
    }

    public void insertChild(ElementBinding n, ElementBinding previous, ElementBinding next) throws SourceException {
        PositionBounds cb = this.getContainerBounds();
        if (cb == null) {
            PositionRef upperBound = this.parent.getEndPosition();
            cb = new PositionBounds(upperBound, upperBound);
        }
        this.insertChild(n, previous, next, cb);
    }

    private void doReorder(Map reorderMap) throws SourceException {
        ArrayList<PositionRef> refPositions = new ArrayList<PositionRef>(reorderMap.size());
        Iterator it = reorderMap.keySet().iterator();
        while (it.hasNext()) {
            ElementBinding impl = (ElementBinding)it.next();
            refPositions.add(impl.prepareInsert(null, false));
        }
        Iterator it2 = refPositions.iterator();
        Iterator it3 = reorderMap.entrySet().iterator();
        while (it3.hasNext()) {
            Map.Entry en = it3.next();
            ElementBinding b2 = (ElementBinding)en.getValue();
            PositionRef refPos = (PositionRef)it2.next();
        }
    }

    private void performRemove(MultiPropertyChangeEvent evt) throws SourceException {
        if (evt == null) {
            return;
        }
        Collection elems = evt.getAffectedItems();
        int[] removeIndices = evt.getIndices();
        boolean empty = ((Object[])evt.getNewValue()).length == 0;
        int pos = 0;
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            ElementBinding victim = this.source.findBinding(e);
            boolean collapse = this.separateMembers ? true : empty;
            victim.remove(collapse, collapse);
            ++pos;
        }
    }

    private void performReorder(MultiPropertyChangeEvent evt, int[] offsets) throws SourceException {
        int i;
        if (evt == null) {
            return;
        }
        Element[] oldEls = (Element[])evt.getOldValue();
        Element[] newEls = (Element[])evt.getNewValue();
        int[] indices = evt.getIndices();
        ArrayList refPositions = new ArrayList(oldEls.length);
        ArrayList items = new ArrayList(oldEls.length);
        ElementBinding[] toMove = new ElementBinding[newEls.length];
        int count = 0;
        Object refBinding = null;
        for (i = 0; i < indices.length; ++i) {
            if (indices[i] == -1) continue;
            toMove[indices[i]] = this.source.findBinding(oldEls[i]);
            ++count;
        }
        for (i = 0; i < newEls.length; ++i) {
            if (toMove[i] == null) continue;
            ElementBinding moving = toMove[i];
            ElementBinding previous = i > 0 ? this.source.findBinding(newEls[i - 1]) : null;
            ElementBinding next = i < newEls.length - 1 ? this.source.findBinding(newEls[i + 1]) : null;
            moving.moveTo(previous, next);
        }
    }

    private void performInsert(MultiPropertyChangeEvent evt) throws SourceException {
        if (evt == null) {
            return;
        }
        Collection inserted = evt.getAffectedItems();
        int[] indexes = evt.getIndices();
        Iterator it = inserted.iterator();
        Element[] newEls = (Element[])evt.getNewValue();
        int indexPos = 0;
        int existingPos = -1;
        Element[] allElems = (Element[])evt.getNewValue();
        for (int i = 0; i < inserted.size(); ++i) {
            ElementBinding previous;
            ElementBinding nextBinding;
            int idx;
            Element n = (Element)it.next();
            ElementBinding b = this.source.findBinding(n);
            if (existingPos < (idx = indexes[indexPos++])) {
                int tempIndex = indexPos;
                for (existingPos = idx + 1; existingPos < allElems.length && tempIndex < indexes.length && existingPos == indexes[tempIndex]; ++existingPos, ++tempIndex) {
                }
            }
            if (existingPos >= allElems.length) {
                nextBinding = null;
            } else {
                nextBinding = this.source.findBinding(allElems[existingPos]);
                PositionRef positionRef = nextBinding.wholeBounds.getBegin();
            }
            if (idx == 0) {
                previous = null;
            } else {
                Element ref = newEls[idx - 1];
                previous = this.source.findBinding(ref);
            }
            this.insertChild(b, previous, nextBinding);
        }
    }

    public void changeMembers(final MultiPropertyChangeEvent evt) throws SourceException {
        if (!this.source.isGeneratorEnabled()) {
            return;
        }
        this.source.runAtomic(this.parent.getElement(), new ExceptionRunnable(){

            public void run() throws Exception {
                ContainerSupport.this.performChangeMembers(evt);
            }
        });
    }

    private void performChangeMembers(MultiPropertyChangeEvent evt) throws SourceException {
        int[] offsets;
        List<MultiPropertyChangeEvent> evs;
        if (evt.getEventType() == 5) {
            evs = evt.getComponents();
            offsets = evt.getIndices();
        } else {
            evs = Collections.singletonList(evt);
            offsets = null;
        }
        MultiPropertyChangeEvent insertEv = null;
        MultiPropertyChangeEvent reorderEv = null;
        MultiPropertyChangeEvent removeEv = null;
        Iterator it = evs.iterator();
        block5: while (it.hasNext()) {
            MultiPropertyChangeEvent tmp = (MultiPropertyChangeEvent)it.next();
            switch (tmp.getEventType()) {
                case 1: {
                    insertEv = tmp;
                    continue block5;
                }
                case 2: {
                    removeEv = tmp;
                    continue block5;
                }
                case 4: {
                    reorderEv = tmp;
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown operation " + tmp.getEventType());
        }
        this.performRemove(removeEv);
        this.performInsert(insertEv);
        this.performReorder(reorderEv, offsets);
        this.computeChildren((Element[])evt.getNewValue());
    }

    private void computeChildren(Element[] els) {
        ElementBinding[] bindings = new ElementBinding[els.length];
        for (int i = 0; i < els.length; ++i) {
            bindings[i] = this.source.findBinding(els[i]);
        }
        this.updateChildren(Arrays.asList(bindings));
    }

    private class Writer
    implements ExceptionRunnable {
        int operation;
        Map reorderMap;
        ElementBinding previous;
        ElementBinding current;

        Writer(Map reorder) {
            this.operation = 0;
            this.reorderMap = reorder;
        }

        Writer(ElementBinding prev, ElementBinding toinsert) {
            this.previous = prev;
            this.current = toinsert;
            this.operation = 1;
        }

        public void run() throws Exception {
            if (!ContainerSupport.this.source.isGeneratorEnabled()) {
                return;
            }
            switch (this.operation) {
                case 0: 
                case 1: {
                    ContainerSupport.this.doReorder(this.reorderMap);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown operation :" + this.operation);
                }
            }
        }
    }
}

