/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.FileStorage;
import org.netbeans.editor.ext.StringCache;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCClassProvider;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaCompletion;

public class JCFileProvider
extends JavaCompletion.AbstractProvider {
    static final int VERSION = 2;
    static final int OPCODE_ADD = 1;
    static final int OPCODE_REMOVE = 2;
    public static final String SKEL_FILE_EXT = "jcs";
    public static final String BODY_FILE_EXT = "jcb";
    protected static final StringCache strCache = new StringCache(200, 5003);
    private boolean valid = true;
    protected FileStorage skels;
    protected FileStorage bodies;
    HashMap classes;
    int fileVersion;

    protected JCFileProvider() {
    }

    public JCFileProvider(String fileNamePrefix) {
        this(fileNamePrefix + "." + SKEL_FILE_EXT, fileNamePrefix + "." + BODY_FILE_EXT);
    }

    public JCFileProvider(String fileNameSkels, String fileNameBodies) {
        this(new FileStorage(fileNameSkels, strCache), new FileStorage(fileNameBodies, strCache));
    }

    public JCFileProvider(FileStorage skels, FileStorage bodies) {
        this.skels = skels;
        this.bodies = bodies;
    }

    public void invalidate() {
        this.valid = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        boolean passedOK = false;
        try {
            this.skels.resetFile();
            this.bodies.resetFile();
            this.skels.open(true);
            this.skels.setVersion(1);
            this.skels.putInteger(2);
            this.fileVersion = 2;
            this.setVersion(this.fileVersion);
            this.skels.write();
            this.skels.close();
            this.bodies.open(true);
            this.bodies.setVersion(1);
            this.bodies.putInteger(2);
            this.setVersion(this.fileVersion);
            this.bodies.write();
            this.bodies.close();
            passedOK = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (!passedOK) {
                this.skels.resetBytes();
                this.bodies.resetBytes();
            }
        }
    }

    private void setVersion(int ver) {
        this.skels.setVersion(ver);
        this.bodies.setVersion(ver);
    }

    protected boolean appendClass(JCClass c) {
        try {
            this.skels.putInteger(1);
            this.writeClass(c);
            this.skels.write();
            this.bodies.write();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean removeClass(JCClass c) {
        try {
            this.skels.putInteger(2);
            this.skels.putString(c.toString());
            this.skels.write();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(JCClassProvider cp) {
        boolean ok2;
        boolean passedOK = false;
        try {
            if (this.skels.getFileLength() <= 0) {
                this.reset();
            }
            this.skels.open(true);
            if (!super.remove(cp)) {
                boolean bl = false;
                return bl;
            }
            passedOK = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            System.err.println("Error occurred during updating Code Completion DB: " + this);
            t.printStackTrace();
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            boolean ok2 = true;
            try {
                this.skels.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                ok2 = false;
            }
            if (!passedOK || !ok2) {
                this.skels.resetBytes();
            }
        }
        return passedOK && ok2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean append(JCClassProvider cp) {
        boolean ok2;
        boolean passedOK = false;
        try {
            if (this.skels.getFileLength() <= 0) {
                this.reset();
            }
            this.skels.open(true);
            this.bodies.open(true);
            if (!super.append(cp)) {
                boolean bl = false;
                return bl;
            }
            passedOK = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            System.err.println("Error occurred during updating Code Completion DB: " + this);
            t.printStackTrace();
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            boolean ok2 = true;
            try {
                this.skels.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                ok2 = false;
            }
            try {
                this.bodies.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                ok2 = false;
            }
            if (!passedOK || !ok2) {
                this.skels.resetBytes();
                this.bodies.resetBytes();
            }
        }
        return ok2 && passedOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Iterator getClasses() {
        int skelsFileLen;
        boolean opened = false;
        try {
            this.skels.open(false);
            opened = true;
            this.skels.seek(0);
            skelsFileLen = this.skels.getFileLength();
            if (skelsFileLen < 4) {
                Iterator iterator = new ArrayList().iterator();
                return iterator;
            }
            this.skels.read(skelsFileLen);
        }
        catch (IOException e) {
            if (!this.skels.fileNotFound) {
                Utilities.runInEventDispatchThread((Runnable)new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(Utilities.getLastActiveComponent(), MessageFormat.format(LocaleSupport.getString((String)"pd-file-not-found"), JCFileProvider.this.bodies.toString()), LocaleSupport.getString((String)"pd-file-not-found-title"), 2);
                    }
                });
                this.skels.fileNotFound = true;
            }
            Iterator e2 = new ArrayList().iterator();
            return e2;
        }
        finally {
            if (opened) {
                try {
                    this.skels.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.setVersion(1);
        this.fileVersion = this.skels.getInteger();
        this.setVersion(this.fileVersion);
        ArrayList<JCClass> deletedClassesList = new ArrayList<JCClass>();
        HashSet<Cls> clsSet = new HashSet<Cls>(Math.max(skelsFileLen / 38, 16));
        while (this.skels.getOffset() < skelsFileLen) {
            int opcode = this.skels.getInteger();
            if (opcode == 1) {
                Cls cls = new Cls();
                if (!clsSet.add(cls)) {
                    clsSet.remove(cls);
                    clsSet.add(cls);
                }
                deletedClassesList.remove(cls);
                if (!cls.fullName.equals(JavaCompletion.OBJECT_CLASS.fullName)) continue;
                clsSet.add(cls.makeClone());
                continue;
            }
            if (opcode != 2) break;
            String removedClassName = this.skels.getString();
            JCClass removedClass = JavaCompletion.createSimpleClass(removedClassName);
            if (deletedClassesList.contains(removedClassName)) continue;
            deletedClassesList.add(removedClass);
        }
        ArrayList allClassesList = new ArrayList(clsSet);
        allClassesList.removeAll(deletedClassesList);
        this.skels.resetBytes();
        return allClassesList.iterator();
    }

    void writeClass(JCClass c) throws IOException {
        this.bodies.putInteger(c.getTagOffset());
        this.writeClassName(c.getSuperclass(), this.bodies);
        JCClass[] interfaces = c.getInterfaces();
        this.bodies.putInteger(interfaces.length);
        for (int i = 0; i < interfaces.length; ++i) {
            this.writeClassName(interfaces[i], this.bodies);
        }
        JCField[] fields = c.getFields();
        this.bodies.putInteger(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            this.writeField(fields[i]);
        }
        JCConstructor[] constructors = c.getConstructors();
        this.bodies.putInteger(constructors.length);
        for (int i = 0; i < constructors.length; ++i) {
            this.writeConstructor(constructors[i]);
        }
        JCMethod[] methods = c.getMethods();
        this.bodies.putInteger(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            this.writeMethod(methods[i]);
        }
        this.writeClassName(c, this.skels);
        int modifiers = c.getModifiers();
        this.skels.putInteger(modifiers);
        this.skels.putInteger(this.bodies.getFilePointer());
        this.skels.putInteger(this.bodies.getOffset());
    }

    void writeType(JCType t) {
        this.writeClassName(t.getClazz(), this.bodies);
        this.bodies.putInteger(t.getArrayDepth());
    }

    void writeParameter(JCParameter p) {
        this.bodies.putString(p.getName());
        this.writeType(p.getType());
    }

    void writeField(JCField f) {
        this.bodies.putString(f.getName());
        this.writeType(f.getType());
        this.bodies.putInteger(f.getTagOffset());
        this.bodies.putInteger(f.getModifiers());
    }

    void writeConstructor(JCConstructor c) {
        this.bodies.putInteger(c.getTagOffset());
        this.bodies.putInteger(c.getModifiers());
        JCParameter[] parameters = c.getParameters();
        this.bodies.putInteger(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            this.writeParameter(parameters[i]);
        }
        JCClass[] exceptions = c.getExceptions();
        this.bodies.putInteger(exceptions.length);
        for (int i = 0; i < exceptions.length; ++i) {
            this.writeClassName(exceptions[i], this.bodies);
        }
    }

    void writeMethod(JCMethod m) {
        this.writeConstructor(m);
        this.bodies.putString(m.getName());
        this.writeType(m.getReturnType());
    }

    void writeClassName(JCClass c, FileStorage fs) {
        fs.putString(c.getFullName());
        fs.putInteger(c.getPackageName().length());
    }

    private JCClass getSimpleClass(String fullName, int packageNameLen, boolean addToCache) {
        JCClass c = null;
        if (packageNameLen == 0) {
            c = JavaCompletion.getPrimitiveClass(fullName);
        }
        if (c == null) {
            String fullNameIntern = fullName.intern();
            if (fullName != fullNameIntern) {
                strCache.putSurviveString(fullNameIntern);
            }
            c = fullNameIntern.length() > 0 ? (addToCache ? JavaCompletion.getSimpleClass(fullNameIntern, packageNameLen) : new JavaCompletion.SimpleClass(fullNameIntern, packageNameLen, true)) : JavaCompletion.INVALID_CLASS;
        }
        return c;
    }

    JCClass readSimpleClass(FileStorage fs, boolean addToCache) {
        String fullName = fs.getString();
        int packageNameLen = fs.getInteger();
        return this.getSimpleClass(fullName, packageNameLen, addToCache);
    }

    JCClass readSimpleClass(FileStorage fs) {
        return this.readSimpleClass(fs, true);
    }

    private void readBC(JavaCompletion.BaseConstructor bc) {
        int i;
        bc.tagOffset = this.bodies.getInteger();
        bc.modifiers = this.bodies.getInteger();
        int cnt = this.bodies.getInteger();
        bc.parameters = cnt > 0 ? new JCParameter[cnt] : JavaCompletion.EMPTY_PARAMETERS;
        for (i = 0; i < cnt; ++i) {
            bc.parameters[i] = new Prm();
        }
        cnt = this.bodies.getInteger();
        bc.exceptions = cnt > 0 ? new JCClass[cnt] : JavaCompletion.EMPTY_CLASSES;
        for (i = 0; i < cnt; ++i) {
            bc.exceptions[i] = this.readSimpleClass(this.bodies);
        }
    }

    public String toString() {
        return "Skeleton: " + this.skels + " , Body: " + this.bodies;
    }

    static {
        strCache.putSurviveString("");
        Iterator i = JavaCompletion.getPrimitiveClassIterator();
        while (i.hasNext()) {
            strCache.putSurviveString(((JCClass)i.next()).getName());
        }
    }

    public class Prm
    extends JavaCompletion.BaseParameter {
        Prm() {
            this.name = JCFileProvider.this.bodies.getString();
            this.type = new Typ();
        }
    }

    final class Mtd
    extends JavaCompletion.BaseMethod {
        Mtd(JCClass clazz) {
            this.clazz = clazz;
            JCFileProvider.this.readBC(this);
            this.name = JCFileProvider.this.bodies.getString();
            this.returnType = new Typ();
        }
    }

    final class Ctr
    extends JavaCompletion.BaseConstructor {
        Ctr(JCClass clazz) {
            this.clazz = clazz;
            JCFileProvider.this.readBC(this);
        }
    }

    final class Fld
    extends JavaCompletion.BaseField {
        Fld(JCClass clazz) {
            this.clazz = clazz;
            this.name = JCFileProvider.this.bodies.getString();
            this.type = new Typ();
            this.tagOffset = JCFileProvider.this.bodies.getInteger();
            this.modifiers = JCFileProvider.this.bodies.getInteger();
        }
    }

    final class Typ
    extends JavaCompletion.BaseType {
        Typ() {
            this.clazz = JCFileProvider.this.readSimpleClass(JCFileProvider.this.bodies);
            this.arrayDepth = JCFileProvider.this.bodies.getInteger();
        }
    }

    final class Cls
    extends JavaCompletion.AbstractClass {
        int bodySeekPointer;
        int bodyLen;
        boolean isInterface = false;

        public Cls() {
            JCClass c = JCFileProvider.this.readSimpleClass(JCFileProvider.this.skels, false);
            this.fullName = c.getFullName();
            this.name = c.getName();
            this.packageName = c.getPackageName();
            this.modifiers = JCFileProvider.this.skels.getInteger();
            this.bodySeekPointer = JCFileProvider.this.skels.getInteger();
            this.bodyLen = JCFileProvider.this.skels.getInteger();
        }

        public Cls(JCClass c, int seekPointer, int len) {
            this.fullName = c.getFullName();
            this.name = c.getName();
            this.packageName = c.getPackageName();
            this.modifiers = c.getModifiers();
            this.isInterface = c.isInterface();
            this.bodySeekPointer = seekPointer;
            this.bodyLen = len;
        }

        private Cls(Cls original) {
            this.fullName = JavaCompletion.OBJECT_CLASS_ARRAY.fullName;
            this.name = JavaCompletion.OBJECT_CLASS_ARRAY.name;
            this.packageName = JavaCompletion.OBJECT_CLASS_ARRAY.packageName;
            this.body = new JavaCompletion.AbstractClass.Body();
            original.init();
            this.body.superClass = original.body.superClass;
            this.body.interfaces = original.body.interfaces;
            this.body.constructors = original.body.constructors;
            this.body.methods = original.body.methods;
            this.body.fields = new JCField[1];
            this.body.fields[0] = new JavaCompletion.BaseField(this, "length", JavaCompletion.INT_TYPE, 17);
        }

        public boolean isInterface() {
            if (this.isInterface) {
                return true;
            }
            return super.isInterface();
        }

        public Cls makeClone() {
            return new Cls(this);
        }

        private void invalidateBody() {
            this.body.tagOffset = -1;
            this.body.superClass = JavaCompletion.INVALID_CLASS;
            this.body.interfaces = JavaCompletion.EMPTY_CLASSES;
            this.body.fields = JavaCompletion.EMPTY_FIELDS;
            this.body.constructors = JavaCompletion.EMPTY_CONSTRUCTORS;
            this.body.methods = JavaCompletion.EMPTY_METHODS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void init() {
            JCFileProvider jCFileProvider = JCFileProvider.this;
            synchronized (jCFileProvider) {
                int i;
                this.body = new JavaCompletion.AbstractClass.Body();
                try {
                    if (!JCFileProvider.this.valid) {
                        this.invalidateBody();
                        return;
                    }
                    JCFileProvider.this.bodies.open(false);
                    JCFileProvider.this.bodies.seek(this.bodySeekPointer);
                    JCFileProvider.this.bodies.read(this.bodyLen);
                    JCFileProvider.this.bodies.close();
                }
                catch (IOException e) {
                    if (!JCFileProvider.this.bodies.fileNotFound) {
                        JOptionPane.showMessageDialog(Utilities.getLastActiveComponent(), MessageFormat.format(LocaleSupport.getString((String)"pd-file-not-found"), JCFileProvider.this.bodies.toString()), LocaleSupport.getString((String)"pd-file-not-found-title"), 2);
                        JCFileProvider.this.bodies.fileNotFound = true;
                        JCFileProvider.this.skels.fileNotFound = true;
                    }
                    this.invalidateBody();
                    return;
                }
                this.body.tagOffset = JCFileProvider.this.bodies.getInteger();
                this.body.superClass = JCFileProvider.this.readSimpleClass(JCFileProvider.this.bodies);
                int cnt = JCFileProvider.this.bodies.getInteger();
                this.body.interfaces = cnt > 0 ? new JCClass[cnt] : JavaCompletion.EMPTY_CLASSES;
                for (i = 0; i < cnt; ++i) {
                    this.body.interfaces[i] = JCFileProvider.this.readSimpleClass(JCFileProvider.this.bodies);
                }
                cnt = JCFileProvider.this.bodies.getInteger();
                this.body.fields = cnt > 0 ? new JCField[cnt] : JavaCompletion.EMPTY_FIELDS;
                for (i = 0; i < cnt; ++i) {
                    this.body.fields[i] = new Fld(this);
                }
                cnt = JCFileProvider.this.bodies.getInteger();
                this.body.constructors = cnt > 0 ? new JCConstructor[cnt] : JavaCompletion.EMPTY_CONSTRUCTORS;
                for (i = 0; i < cnt; ++i) {
                    this.body.constructors[i] = new Ctr(this);
                }
                cnt = JCFileProvider.this.bodies.getInteger();
                this.body.methods = cnt > 0 ? new JCMethod[cnt] : JavaCompletion.EMPTY_METHODS;
                for (i = 0; i < cnt; ++i) {
                    this.body.methods[i] = new Mtd(this);
                }
                try {
                    JCFileProvider.this.bodies.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

