/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.navigation.ClassMemberModel;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.base.ModelBusyListener;
import org.netbeans.modules.java.navigation.base.NavigatorJList;
import org.netbeans.modules.java.navigation.spi.NavigatorListModel;
import org.netbeans.modules.java.navigation.spi.RelatedItemProvider;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

public final class ClassMemberPanel
implements NavigatorPanel,
LookupListener,
ModelBusyListener,
RelatedItemProvider.RelatedItemListener {
    static final Lookup.Template JDOS = new Lookup.Template(JavaDataObject.class);
    private ClassMemberPanelUI panelUI;
    private ClassMemberModel curModel;
    private Lookup.Result curContext;
    private JavaDataObject curData;

    public String getDisplayName() {
        return NbBundle.getBundle((Class)ClassMemberPanel.class).getString("LBL_members");
    }

    public String getDisplayHint() {
        return null;
    }

    public JComponent getComponent() {
        return this.getPanelUI();
    }

    public void panelActivated(Lookup context) {
        this.curContext = context.lookup(JDOS);
        this.curData = (JavaDataObject)((List)this.curContext.allInstances()).get(0);
        this.setNewContent(this.curData);
        this.curContext.addLookupListener((LookupListener)this);
    }

    public void panelDeactivated() {
        this.curContext.removeLookupListener((LookupListener)this);
        this.curContext = null;
        this.detachFromModel(this.curModel);
        this.curModel = null;
        this.curData = null;
    }

    public void resultChanged(LookupEvent ev) {
        JavaDataObject jdo;
        Collection data = ((Lookup.Result)ev.getSource()).allInstances();
        if (!data.isEmpty() && !(jdo = (JavaDataObject)data.iterator().next()).equals(this.curData)) {
            this.detachFromModel(this.curModel);
            this.curData = jdo;
            this.setNewContent(jdo);
        }
    }

    public Lookup getLookup() {
        return null;
    }

    public void busyStart() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getPanelUI().setBusyState(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClassMemberPanel.this.getPanelUI().setBusyState(true);
                }
            });
        }
    }

    public void busyEnd() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getPanelUI().setBusyState(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClassMemberPanel.this.getPanelUI().setBusyState(false);
                }
            });
        }
    }

    public void newContentReady() {
        this.getPanelUI().newContentReady();
    }

    public void itemsChanged(RelatedItemProvider.RelatedItemEvent evt) {
        Rectangle r;
        Object sel = evt.getNewPrimary();
        Object oldSel = evt.getOldPrimary();
        NavigatorJList list = this.getPanelUI().getContent();
        NavigatorListModel mdl = (NavigatorListModel)list.getModel();
        int idx = sel == null ? -1 : mdl.indexOf(sel);
        list.setSelectedIndex(sel == null ? -1 : idx);
        if (idx != -1) {
            list.ensureIndexIsVisible(idx);
            list.repaint(list.getCellBounds(idx, idx));
        }
        int n = idx = oldSel == null ? -1 : mdl.indexOf(oldSel);
        if (idx != -1) {
            list.repaint(list.getCellBounds(idx, idx));
        }
        Iterator i = evt.getPreviousRelatedItems().iterator();
        while (i.hasNext()) {
            idx = mdl.indexOf(i.next());
            if (idx == -1) continue;
            r = list.getCellBounds(idx, idx);
            list.repaint(r);
        }
        i = evt.getRelatedItems().iterator();
        while (i.hasNext()) {
            idx = mdl.indexOf(i.next());
            if (idx == -1) continue;
            r = list.getCellBounds(idx, idx);
            list.repaint(r);
        }
    }

    public void itemsCleared(RelatedItemProvider.RelatedItemEvent evt) {
        this.getPanelUI().getContent().repaint();
    }

    private void setNewContent(JavaDataObject jdo) {
        ClassMemberPanelUI ui = this.getPanelUI();
        this.curModel = new ClassMemberModel(jdo, ui, this);
        ui.getContent().setModel(this.curModel);
        ui.setFilters(this.curModel.getFilters());
        try {
            this.curModel.addBusyListener(this);
        }
        catch (TooManyListenersException exc) {
            ErrorManager.getDefault().notify((Throwable)exc);
        }
        this.curModel.addNotify();
    }

    private void detachFromModel(ClassMemberModel model) {
        model.removeBusyListener(this);
        model.removeNotify();
    }

    private ClassMemberPanelUI getPanelUI() {
        if (this.panelUI == null) {
            this.panelUI = new ClassMemberPanelUI();
        }
        return this.panelUI;
    }
}

