/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.ui;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.options.ui.TabbedPanelModel;

public abstract class TableTPModel
extends TabbedPanelModel {
    private TableCellRenderer renderer;
    private int layoutOrientation;
    private boolean useScrolls;
    private Map categoryToTableModel = new HashMap();

    public TableTPModel(boolean useScrolls) {
        this.layoutOrientation = this.layoutOrientation;
        this.useScrolls = useScrolls;
    }

    public JComponent getPanel(String category) {
        JTable t = new JTable(this.getTableModel(category));
        t.setTableHeader(null);
        if (this.useScrolls) {
            JScrollPane scrollPane = new JScrollPane(t, 20, 31);
            scrollPane.setBorder(null);
            return scrollPane;
        }
        t.setBorder(null);
        return t;
    }

    public TableModel getTableModel(String category) {
        WeakReference wr = (WeakReference)this.categoryToTableModel.get(category);
        MyTableModel result = null;
        if (wr != null) {
            result = (MyTableModel)wr.get();
        }
        if (result == null) {
            result = new MyTableModel(category);
            this.categoryToTableModel.put(category, new WeakReference<MyTableModel>(result));
        }
        return result;
    }

    public int getRowCount(String category) {
        return 0;
    }

    public int getColumnCount(String category) {
        return 0;
    }

    public Object getValueAt(String category, int row, int column) {
        return null;
    }

    public boolean isCellEditable(String category, int row, int column) {
        return false;
    }

    public void setValueAt(String category, Object value, int row, int column) {
    }

    public void fireTableRowsInserted(String category, int firstRow, int lastRow) {
        ((MyTableModel)this.getTableModel(category)).fireTableRowsInserted(firstRow, lastRow);
    }

    public void fireTableRowsDeleted(String category, int firstRow, int lastRow) {
        ((MyTableModel)this.getTableModel(category)).fireTableRowsDeleted(firstRow, lastRow);
    }

    private class MyTableModel
    extends AbstractTableModel {
        private String category;

        private MyTableModel(String category) {
            this.category = category;
        }

        public int getRowCount() {
            return TableTPModel.this.getRowCount(this.category);
        }

        public int getColumnCount() {
            return TableTPModel.this.getColumnCount(this.category);
        }

        public boolean isCellEditable(int row, int col) {
            return TableTPModel.this.isCellEditable(this.category, row, col);
        }

        public void setValueAt(Object value, int row, int column) {
            TableTPModel.this.setValueAt(this.category, value, row, column);
        }

        public Object getValueAt(int row, int column) {
            return TableTPModel.this.getValueAt(this.category, row, column);
        }
    }
}

