/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePair;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.MailPropertyPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.PropertiesTableModel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigData;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelper;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.setFocus;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.WizardConstants;
import org.openide.util.NbBundle;

public class MailPropertyVisualPanel
extends JPanel
implements WizardConstants,
TableModelListener {
    private final MailPropertyPanel panel;
    private FieldGroup generalGroup;
    private FieldGroup propertiesGroup;
    private PropertiesTableModel tableModel;
    private ResourceConfigHelper helper;
    private TableColumn propNameColumn;
    private TableColumn propValueColumn;
    private JButton addButton;
    private JPanel buttonsPane;
    private JTextArea descriptionTextArea;
    private JScrollPane jScrollPane1;
    private JLabel propertyInfo;
    private JTable propertyTable;
    private JButton removeButton;

    public MailPropertyVisualPanel(MailPropertyPanel panel) {
        this.panel = panel;
        this.helper = panel.getHelper();
        this.generalGroup = panel.getFieldGroup("general");
        this.propertiesGroup = panel.getFieldGroup("properties");
        this.tableModel = new PropertiesTableModel(this.helper.getData());
        this.initComponents();
        this.setPropTableCellEditor();
        this.tableModel.addTableModelListener(this);
        this.propertyTable.setSelectionMode(0);
        this.propertyTable.setRowSelectionAllowed(true);
        this.setName(NbBundle.getMessage((Class)MailPropertyVisualPanel.class, (String)"TITLE_MailPropertyPanel"));
    }

    private void initComponents() {
        this.descriptionTextArea = new JTextArea();
        this.propertyInfo = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.propertyTable = new JTable();
        this.buttonsPane = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(627, 305));
        this.setPreferredSize(new Dimension(627, 305));
        this.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("TITLE_MailPropertyPanel"));
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("MailPropertyPanel_Description"));
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setText(NbBundle.getMessage((Class)MailPropertyVisualPanel.class, (String)"MailPropertyPanel_Description", (Object)this.helper.getData().getString("jndi-name")));
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setMinimumSize(new Dimension(500, 17));
        this.descriptionTextArea.setOpaque(false);
        this.descriptionTextArea.setPreferredSize(new Dimension(500, 17));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 11);
        this.add((Component)this.descriptionTextArea, gridBagConstraints);
        this.descriptionTextArea.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("MailPropertyPanel_Description"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("MailPropertyPanel_Description"));
        this.propertyInfo.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("LBL_properties_Mnemonic").charAt(0));
        this.propertyInfo.setLabelFor(this.propertyTable);
        this.propertyInfo.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("LBL_properties"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 11);
        this.add((Component)this.propertyInfo, gridBagConstraints);
        this.propertyInfo.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("LBL_properties"));
        this.propertyInfo.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("ACS_propTableMail_A11yDesc"));
        this.jScrollPane1.setPreferredSize(new Dimension(453, 17));
        this.propertyTable.setModel(this.tableModel);
        this.jScrollPane1.setViewportView(this.propertyTable);
        this.propertyTable.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("LBL_AddProperty"));
        this.propertyTable.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("ACS_propTableMail_A11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 12, 10, 11);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane1.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("LBL_properties"));
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("ACS_propTableMail_A11yDesc"));
        this.buttonsPane.setLayout(new GridBagLayout());
        this.addButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("LBL_Add_Mnemonic").charAt(0));
        this.addButton.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("LBL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MailPropertyVisualPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 12, 12);
        this.buttonsPane.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("ACS_AddButtonA11yDesc"));
        this.removeButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("LBL_Remove_Mnemonic").charAt(0));
        this.removeButton.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("LBL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MailPropertyVisualPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.buttonsPane.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("ACS_RemoveButtonA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipady = 150;
        this.add((Component)this.buttonsPane, gridBagConstraints);
        this.buttonsPane.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("LBL_properties"));
        this.buttonsPane.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/sunresources/wizards/Bundle").getString("ACS_propTableMail_A11yDesc"));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.propertyTable.editingStopped(new ChangeEvent(this));
        ResourceConfigData data = this.helper.getData();
        data.addProperty(new NameValuePair());
        this.tableModel.fireTableDataChanged();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.propertyTable.getSelectedRow();
        if (selectedRow != -1) {
            this.propertyTable.editingStopped(new ChangeEvent(this));
            this.helper.getData().removeProperty(selectedRow);
            this.tableModel.fireTableDataChanged();
        }
    }

    public void tableChanged(TableModelEvent evt) {
        this.setPropTableCellEditor();
        this.panel.fireChange(evt.getSource());
    }

    public void setPropTableCellEditor() {
        JComboBox<String> propNameComboBox = new JComboBox<String>();
        String[] remainingProperties = FieldHelper.getRemainingFieldNames(this.propertiesGroup, this.helper.getData().getPropertyNames());
        for (int i = 0; i < remainingProperties.length; ++i) {
            propNameComboBox.addItem(remainingProperties[i]);
        }
        propNameComboBox.setEditable(true);
        this.propNameColumn = this.propertyTable.getColumnModel().getColumn(0);
        this.propNameColumn.setCellEditor(new DefaultCellEditor(propNameComboBox));
        this.propValueColumn = this.propertyTable.getColumnModel().getColumn(1);
        DefaultCellEditor editor = new DefaultCellEditor(new JTextField());
        editor.setClickCountToStart(1);
        this.propValueColumn.setCellEditor(editor);
    }

    public void refreshFields() {
        ResourceConfigData data = this.helper.getData();
        ((PropertiesTableModel)this.propertyTable.getModel()).setData(this.helper.getData());
        this.descriptionTextArea.setText(NbBundle.getMessage((Class)MailPropertyVisualPanel.class, (String)"MailPropertyPanel_Description", (Object)data.getString("jndi-name")));
    }

    public void setInitialFocus() {
        new setFocus(this.addButton);
    }
}

