/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.ErrorMessageDB;
import org.netbeans.modules.j2ee.sun.share.configbean.ServletVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.StorageBeanFactory;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BaseCustomizer;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppCachePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppClassloaderPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppGeneralPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppLocalePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppMessagesPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppPropertiesPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppSessionConfigPanel;

public class WebAppRootCustomizer
extends BaseCustomizer
implements PropertyChangeListener {
    public static final String CACHE_HELPER_LIST_CHANGED = "CacheHelperListChanged";
    public static final String SERVLET_LIST_CHANGED = "ServletListChanged";
    private static final ResourceBundle webappBundle;
    private static final int NUM_SERVLET24_PANELS = 1;
    private static final int NUM_AS81_PANELS = 1;
    private static final int PROPERTIES_TAB_INDEX = 2;
    private static final int MESSAGE_TAB_INDEX = 4;
    private WebAppRoot theBean;
    private boolean servlet24FeaturesVisible;
    private boolean as81FeaturesVisible;
    private JTabbedPane webAppTabbedPanel;
    private WebAppGeneralPanel generalPanel;
    private WebAppClassloaderPanel classloaderPanel;
    private WebAppPropertiesPanel propertiesPanel;
    private WebAppSessionConfigPanel sessionConfigPanel;
    private WebAppMessagesPanel messagesPanel;
    private WebAppLocalePanel localeMappingPanel;
    private WebAppCachePanel cachePanel;
    static GenericTableModel.ParentPropertyFactory webPropertyFactory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WebAppRootCustomizer() {
        this.initComponents();
        this.initUserComponents();
    }

    public WebAppRoot getBean() {
        return this.theBean;
    }

    private void initComponents() {
        this.webAppTabbedPanel = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        this.webAppTabbedPanel.setTabPlacement(3);
        this.webAppTabbedPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                WebAppRootCustomizer.this.webAppTabbedPanelStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.webAppTabbedPanel, gridBagConstraints);
    }

    private void webAppTabbedPanelStateChanged(ChangeEvent evt) {
        this.showErrors();
    }

    private void initUserComponents() {
        this.as81FeaturesVisible = true;
        this.addTitlePanel(webappBundle.getString("TITLE_SunWebApplication"));
        this.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_SunWebApplication"));
        this.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_SunWebApplication"));
        this.generalPanel = new WebAppGeneralPanel(this);
        this.webAppTabbedPanel.addTab(webappBundle.getString("GENERAL_TAB"), this.generalPanel);
        this.classloaderPanel = new WebAppClassloaderPanel(this);
        this.webAppTabbedPanel.addTab(webappBundle.getString("CLASSLOADER_TAB"), this.classloaderPanel);
        this.propertiesPanel = new WebAppPropertiesPanel(this);
        this.webAppTabbedPanel.addTab(webappBundle.getString("PROPERTIES_TAB"), this.propertiesPanel);
        this.sessionConfigPanel = new WebAppSessionConfigPanel(this);
        this.webAppTabbedPanel.addTab(webappBundle.getString("SESSION_CONFIG_TAB"), this.sessionConfigPanel);
        this.servlet24FeaturesVisible = true;
        this.messagesPanel = new WebAppMessagesPanel(this);
        this.webAppTabbedPanel.addTab(webappBundle.getString("MESSAGES_TAB"), this.messagesPanel);
        this.localeMappingPanel = new WebAppLocalePanel(this);
        this.webAppTabbedPanel.addTab(webappBundle.getString("LOCALE_TAB"), this.localeMappingPanel);
        this.cachePanel = new WebAppCachePanel(this);
        this.webAppTabbedPanel.addTab(webappBundle.getString("CACHE_TAB"), this.cachePanel);
        this.addErrorPanel();
    }

    protected void initFields() {
        this.generalPanel.initFields(this.theBean);
        this.classloaderPanel.initFields(this.theBean);
        if (ASDDVersion.SUN_APPSERVER_8_1.compareTo(this.theBean.getAppServerVersion()) <= 0) {
            this.showAS81Panels();
            this.propertiesPanel.initFields(this.theBean);
        } else {
            this.hideAS81Panels();
        }
        this.sessionConfigPanel.initFields(this.theBean);
        if (this.theBean.getJ2EEModuleVersion().compareTo(ServletVersion.SERVLET_2_4) >= 0) {
            this.showServlet24Panels();
            this.messagesPanel.initFields(this.theBean);
        } else {
            this.hideServlet24Panels();
        }
        this.localeMappingPanel.initFields(this.theBean);
        this.cachePanel.initFields(this.theBean);
    }

    private void showServlet24Panels() {
        if (!this.servlet24FeaturesVisible) {
            this.webAppTabbedPanel.insertTab(webappBundle.getString("MESSAGES_TAB"), null, this.messagesPanel, null, this.getMessagesTabIndex());
            this.servlet24FeaturesVisible = true;
        }
    }

    private void hideServlet24Panels() {
        if (this.servlet24FeaturesVisible) {
            this.webAppTabbedPanel.removeTabAt(this.getMessagesTabIndex());
            this.servlet24FeaturesVisible = false;
        }
    }

    private void showAS81Panels() {
        if (!this.as81FeaturesVisible) {
            this.webAppTabbedPanel.insertTab(webappBundle.getString("PROPERTIES_TAB"), null, this.propertiesPanel, null, 2);
            this.as81FeaturesVisible = true;
        }
    }

    private void hideAS81Panels() {
        if (this.as81FeaturesVisible) {
            this.webAppTabbedPanel.removeTabAt(2);
            this.as81FeaturesVisible = false;
        }
    }

    public void addListeners() {
        super.addListeners();
        this.generalPanel.addListeners();
        this.classloaderPanel.addListeners();
        this.propertiesPanel.addListeners();
        this.sessionConfigPanel.addListeners();
        this.messagesPanel.addListeners();
        this.localeMappingPanel.addListeners();
        this.cachePanel.addListeners();
        this.theBean.addPropertyChangeListener(this);
    }

    public void removeListeners() {
        super.removeListeners();
        this.cachePanel.removeListeners();
        this.localeMappingPanel.removeListeners();
        this.messagesPanel.removeListeners();
        this.sessionConfigPanel.removeListeners();
        this.propertiesPanel.removeListeners();
        this.classloaderPanel.removeListeners();
        this.generalPanel.removeListeners();
        this.theBean.removePropertyChangeListener(this);
    }

    public void partitionStateChanged(ErrorMessageDB.PartitionState oldState, ErrorMessageDB.PartitionState newState) {
        if (newState.getPartition() == this.getPartition()) {
            this.showErrors();
        }
        if (oldState.hasMessages() != newState.hasMessages()) {
            this.webAppTabbedPanel.setIconAt(newState.getPartition().getTabIndex(), newState.hasMessages() ? panelErrorIcon : null);
        }
    }

    protected boolean setBean(Object bean) {
        boolean result = super.setBean(bean);
        if (bean instanceof WebAppRoot) {
            this.theBean = (WebAppRoot)bean;
            result = true;
        } else {
            if (!$assertionsDisabled && result) {
                throw new AssertionError((Object)"WebAppRootCustomizer was passed wrong bean type in setBean(Object bean)");
            }
            this.theBean = null;
            result = false;
        }
        return result;
    }

    private int getMessagesTabIndex() {
        int result = 4;
        if (!this.as81FeaturesVisible) {
            --result;
        }
        return result;
    }

    private int getAdjustedTabIndex() {
        int selectedTabIndex = this.webAppTabbedPanel.getSelectedIndex();
        if (!this.as81FeaturesVisible && selectedTabIndex >= 2) {
            ++selectedTabIndex;
        }
        if (!this.servlet24FeaturesVisible && selectedTabIndex >= 4) {
            ++selectedTabIndex;
        }
        return selectedTabIndex;
    }

    public String getHelpId() {
        String result = "AS_CFG_WebAppGeneral";
        switch (this.getAdjustedTabIndex()) {
            case 6: {
                result = this.cachePanel.getHelpId();
                break;
            }
            case 5: {
                result = "AS_CFG_WebAppLocale";
                break;
            }
            case 4: {
                result = "AS_CFG_WebAppMessages";
                break;
            }
            case 3: {
                result = this.sessionConfigPanel.getHelpId();
                break;
            }
            case 2: {
                result = "AS_CFG_WebAppProperties";
                break;
            }
            case 1: {
                result = "AS_CFG_WebAppClassloader";
            }
        }
        return result;
    }

    public ValidationError.Partition getPartition() {
        switch (this.getAdjustedTabIndex()) {
            case 6: {
                return this.cachePanel.getPartition();
            }
            case 5: {
                return ValidationError.PARTITION_WEB_LOCALE;
            }
            case 4: {
                return ValidationError.PARTITION_WEB_MESSAGES;
            }
            case 3: {
                return this.sessionConfigPanel.getPartition();
            }
            case 2: {
                return ValidationError.PARTITION_WEB_PROPERTIES;
            }
            case 1: {
                return ValidationError.PARTITION_WEB_CLASSLOADER;
            }
        }
        return ValidationError.PARTITION_WEB_GENERAL;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SERVLET_LIST_CHANGED.equals(propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WebAppRootCustomizer.this.firePropertyChange(WebAppRootCustomizer.SERVLET_LIST_CHANGED, false, true);
                }
            });
        }
    }

    static {
        $assertionsDisabled = !WebAppRootCustomizer.class.desiredAssertionStatus();
        webappBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");
        webPropertyFactory = new GenericTableModel.ParentPropertyFactory(){

            public CommonDDBean newParentProperty(ASDDVersion asVersion) {
                return StorageBeanFactory.getStorageBeanFactory(asVersion).createWebProperty();
            }
        };
    }
}

