/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.valve;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.webapp.admin.valve.ValveForm;
import org.apache.webapp.admin.valve.ValveUtil;

public final class RemoteAddrValveForm
extends ValveForm {
    private String allow = "";
    private String deny = "";
    private Pattern[] allows = new Pattern[0];
    private Pattern[] denies = new Pattern[0];

    public String getAllow() {
        return this.allow;
    }

    public void setAllow(String allow) {
        this.allow = allow;
    }

    public String getDeny() {
        return this.deny;
    }

    public void setDeny(String deny) {
        this.deny = deny;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.allow = null;
        this.deny = null;
        this.allows = null;
        this.denies = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RemoteAddrValveForm[adminAction=");
        sb.append(this.getAdminAction());
        sb.append("',valveType=");
        sb.append(this.getValveType());
        sb.append(",allow=");
        sb.append(this.getAllow());
        sb.append(",deny=");
        sb.append(this.getDeny());
        sb.append("',objectName='");
        sb.append(this.getObjectName());
        sb.append("]");
        return sb.toString();
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        String submit = request.getParameter("submit");
        if (!(this.allow != null && this.allow.length() >= 1 || this.deny != null && this.deny.length() >= 1)) {
            errors.add("allow", new ActionError("error.allow.deny.required"));
        }
        try {
            this.allows = ValveUtil.precalculate(this.allow);
        }
        catch (IllegalArgumentException e) {
            errors.add("allow", new ActionError("error.syntax"));
            return errors;
        }
        try {
            this.denies = ValveUtil.precalculate(this.deny);
        }
        catch (IllegalArgumentException e) {
            errors.add("allow", new ActionError("error.syntax"));
            return errors;
        }
        String ip = request.getRemoteAddr();
        if (ip == null) {
            return errors;
        }
        for (int i = 0; i < this.denies.length; ++i) {
            if (!this.denies[i].matcher(ip).matches()) continue;
            if (this.allows.length < 1) {
                errors.add("deny", new ActionError("error.denyIP"));
            }
            for (int j = 0; j < this.allows.length; ++j) {
                if (this.allows[j].matcher(ip).matches()) continue;
                errors.add("deny", new ActionError("error.denyIP"));
            }
        }
        boolean allowMatch = true;
        if (this.allows.length > 0) {
            allowMatch = false;
        }
        for (int i = 0; i < this.allows.length; ++i) {
            if (!this.allows[i].matcher(ip).matches()) continue;
            allowMatch = true;
        }
        if (!allowMatch) {
            errors.add("allow", new ActionError("error.allowIP"));
        }
        return errors;
    }
}

