/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.realm;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.TomcatTreeBuilder;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;
import org.apache.webapp.admin.realm.JNDIRealmForm;
import org.apache.webapp.admin.valve.ValveUtil;

public final class SaveJNDIRealmAction
extends Action {
    private String[] createStandardRealmTypes = new String[]{"java.lang.String"};
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        JNDIRealmForm rform = (JNDIRealmForm)form;
        String adminAction = rform.getAdminAction();
        String rObjectName = rform.getObjectName();
        if ("Create".equals(adminAction)) {
            String operation = null;
            Object[] values = null;
            try {
                String parent = rform.getParentObjectName();
                String objectName = ValveUtil.getObjectName(parent, ":type=Realm");
                ObjectName pname = new ObjectName(parent);
                StringBuffer sb = new StringBuffer(pname.getDomain());
                try {
                    if ("Service".equalsIgnoreCase(pname.getKeyProperty("type"))) {
                        sb.append(":type=Engine");
                        parent = sb.toString();
                    }
                }
                catch (Exception e) {
                    String message = resources.getMessage("error.engineName.bad", (Object)sb.toString());
                    this.getServlet().log(message);
                    response.sendError(400, message);
                    return null;
                }
                ObjectName oname = new ObjectName(objectName);
                if (this.mBServer.isRegistered(oname)) {
                    ActionErrors errors = new ActionErrors();
                    errors.add("realmName", new ActionError("error.realmName.exists"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                String domain = oname.getDomain();
                ObjectName fname = TomcatTreeBuilder.getMBeanFactory();
                rObjectName = (String)this.mBServer.invoke(fname, operation = "createJNDIRealm", values = new String[]{parent}, this.createStandardRealmTypes);
                if (rObjectName == null) {
                    request.setAttribute("warning", (Object)"error.jndirealm");
                    return mapping.findForward("Save Unsuccessful");
                }
                TreeControl control = (TreeControl)session.getAttribute("treeControlTest");
                if (control != null) {
                    TreeControlNode parentNode = control.findNode(rform.getParentObjectName());
                    if (parentNode != null) {
                        String nodeLabel = rform.getNodeLabel();
                        String encodedName = URLEncoder.encode(rObjectName, "UTF-8");
                        TreeControlNode childNode = new TreeControlNode(rObjectName, "Realm.gif", nodeLabel, "EditRealm.do?select=" + encodedName, "content", true, domain);
                        parentNode.addChild(childNode);
                    } else {
                        this.getServlet().log("Cannot find parent node '" + parent + "'");
                    }
                } else {
                    this.getServlet().log("Cannot find TreeControlNode!");
                }
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.invoke", operation), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.invoke", operation));
                return null;
            }
        }
        String attribute = null;
        try {
            ObjectName roname = new ObjectName(rObjectName);
            attribute = "connectionName";
            String connectionName = rform.getConnectionName();
            if (connectionName != null && connectionName.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("connectionName", connectionName));
            }
            attribute = "connectionPassword";
            String connectionPassword = rform.getConnectionPassword();
            if (connectionPassword != null && connectionPassword.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("connectionPassword", connectionPassword));
            }
            attribute = "connectionURL";
            String connectionURL = rform.getConnectionURL();
            if (connectionURL != null && connectionURL.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("connectionURL", connectionURL));
            }
            attribute = "contextFactory";
            String contextFactory = rform.getContextFactory();
            if (contextFactory != null && contextFactory.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("contextFactory", contextFactory));
            }
            attribute = "digest";
            String digest = rform.getDigest();
            if (digest != null && digest.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("digest", digest));
            }
            attribute = "roleBase";
            String roleBase = rform.getRoleBase();
            if (roleBase != null && roleBase.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("roleBase", roleBase));
            }
            attribute = "roleName";
            String roleName = rform.getRoleName();
            if (roleName != null && roleName.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("roleName", roleName));
            }
            attribute = "roleSearch";
            String rolePattern = rform.getRolePattern();
            if (rolePattern != null && rolePattern.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("roleSearch", rolePattern));
            }
            attribute = "roleSubtree";
            String roleSubtree = rform.getRoleSubtree();
            if (roleSubtree != null && roleSubtree.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("roleSubtree", new Boolean(roleSubtree)));
            }
            attribute = "userBase";
            String userBase = rform.getUserBase();
            if (userBase != null && userBase.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("userBase", userBase));
            }
            attribute = "userPassword";
            String userPassword = rform.getUserPassword();
            if (userPassword != null && userPassword.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("userPassword", userPassword));
            }
            attribute = "userPattern";
            String userPattern = rform.getUserPattern();
            if (userPattern != null && userPattern.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("userPattern", userPattern));
            }
            attribute = "userRoleName";
            String userRoleName = rform.getUserRoleName();
            if (userRoleName != null && userRoleName.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("userRoleName", userRoleName));
            }
            attribute = "userSearch";
            String userSearch = rform.getUserSearch();
            if (userSearch != null && userSearch.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("userSearch", userSearch));
            }
            attribute = "userSubtree";
            String userSubtree = rform.getUserSubtree();
            if (userSubtree != null && userSubtree.length() > 0) {
                this.mBServer.setAttribute(roname, new Attribute("userSubtree", new Boolean(userSubtree)));
            }
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.set", (Object)attribute), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.set", (Object)attribute));
            return null;
        }
        session.removeAttribute(mapping.getAttribute());
        return mapping.findForward("Save Successful");
    }
}

