/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.text.MessageFormat;
import java.util.Vector;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverListener;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.DatabaseOption;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverOperations;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class DriverListNodeInfo
extends DatabaseNodeInfo
implements DriverOperations {
    static final long serialVersionUID = -7948529055260667590L;
    private JDBCDriverListener listener = new JDBCDriverListener(){

        public void driversChanged() {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        DriverListNodeInfo.this.refreshChildren();
                    }
                    catch (DatabaseException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
            });
        }
    };

    protected void initChildren(Vector children) throws DatabaseException {
        JDBCDriver[] drvs = JDBCDriverManager.getDefault().getDrivers();
        boolean win = Utilities.isWindows();
        for (int i = 0; i < drvs.length; ++i) {
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < drvs[i].getURLs().length; ++j) {
                if (j != 0) {
                    sb.append(", ");
                }
                String file = drvs[i].getURLs()[j].getFile();
                if (win) {
                    file = file.substring(1);
                }
                sb.append(file);
            }
            DatabaseDriver drv = new DatabaseDriver(drvs[i].getDisplayName(), drvs[i].getClassName(), sb.toString(), drvs[i]);
            DriverNodeInfo chinfo = (DriverNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "driver");
            if (chinfo == null || drv == null) continue;
            chinfo.setDatabaseDriver(drv);
            children.add(chinfo);
        }
    }

    public void addDriver(DatabaseDriver drv) throws DatabaseException {
        DatabaseOption option = RootNode.getOption();
        Vector drvs = option.getAvailableDrivers();
        if (drvs.contains(drv)) {
            String message = MessageFormat.format(DriverListNodeInfo.bundle().getString("EXC_DriverAlreadyExists"), drv.toString());
            throw new DatabaseException(message);
        }
        drvs.add(drv);
        DatabaseNodeChildren chld = (DatabaseNodeChildren)this.getNode().getChildren();
        DriverNodeInfo ninfo = (DriverNodeInfo)DriverListNodeInfo.createNodeInfo(this, "driver");
        ninfo.setDatabaseDriver(drv);
        chld.createSubnode(ninfo, true);
    }

    public void setNode(DatabaseNode node) {
        super.setNode(node);
        JDBCDriverManager.getDefault().addDriverListener(this.listener);
    }
}

