/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.project.libraries.LibraryDeclarationHandler;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.ErrorManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LibraryDeclarationHandlerImpl
implements LibraryDeclarationHandler {
    private LibraryImplementation library;
    private String libraryType;
    private String libraryDescription;
    private String libraryName;
    private String localizingBundle;
    private Map contentTypes = new HashMap();
    private List cpEntries;
    private String contentType;
    private boolean inVolume = false;
    public static final boolean DEBUG = false;

    public void start_volume(Attributes meta) throws SAXException {
        this.cpEntries = new ArrayList();
        this.inVolume = true;
    }

    public void end_volume() throws SAXException {
        this.contentTypes.put(this.contentType, this.cpEntries);
        this.inVolume = false;
        this.contentType = null;
    }

    public void handle_type(String data, Attributes meta) throws SAXException {
        if (data == null || data.length() == 0) {
            throw new SAXException("Empty value of type element");
        }
        if (this.inVolume) {
            this.contentType = data;
        } else {
            this.libraryType = data;
        }
    }

    public void start_library(Attributes meta) throws SAXException {
        if (!"1.0".equals(meta.getValue("version"))) {
            throw new SAXException("Invalid librray descriptor version");
        }
    }

    public void end_library() throws SAXException {
        boolean update;
        if (this.library != null) {
            if (this.libraryType == null || !this.libraryType.equals(this.library.getType())) {
                throw new SAXParseException("Changing library type of library: " + this.libraryName + " from: " + this.library.getType() + " to: " + this.libraryType, null);
            }
            update = true;
        } else {
            LibraryTypeProvider provider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(this.libraryType);
            if (provider == null) {
                ErrorManager.getDefault().log(16, "LibraryDeclarationHandlerImpl: Cannot create library: " + this.libraryName + " of unknown type: " + this.libraryType);
                return;
            }
            this.library = provider.createLibrary();
            update = false;
        }
        if (!update || !LibraryDeclarationHandlerImpl.safeEquals(this.library.getLocalizingBundle(), this.localizingBundle)) {
            this.library.setLocalizingBundle(this.localizingBundle);
        }
        if (!update || !LibraryDeclarationHandlerImpl.safeEquals(this.library.getName(), this.libraryName)) {
            this.library.setName(this.libraryName);
        }
        if (!update || !LibraryDeclarationHandlerImpl.safeEquals(this.library.getDescription(), this.libraryDescription)) {
            this.library.setDescription(this.libraryDescription);
        }
        Iterator it = this.contentTypes.keySet().iterator();
        while (it.hasNext()) {
            String contentType = (String)it.next();
            List cp = (List)this.contentTypes.get(contentType);
            try {
                if (update && LibraryDeclarationHandlerImpl.safeEquals(this.library.getContent(contentType), cp)) continue;
                this.library.setContent(contentType, cp);
            }
            catch (IllegalArgumentException e) {
                throw (SAXException)new SAXException(e.toString()).initCause(e);
            }
        }
        this.libraryName = null;
        this.libraryDescription = null;
        this.libraryType = null;
        this.localizingBundle = null;
        this.contentTypes.clear();
    }

    public void handle_resource(URL data, Attributes meta) throws SAXException {
        if (data != null) {
            this.cpEntries.add(data);
        }
    }

    public void handle_name(String data, Attributes meta) throws SAXException {
        this.libraryName = data;
    }

    public void handle_description(String data, Attributes meta) throws SAXException {
        this.libraryDescription = data;
    }

    public void handle_localizingBundle(String data, Attributes meta) throws SAXException {
        this.localizingBundle = data;
    }

    public void setLibrary(LibraryImplementation library) {
        this.library = library;
    }

    public LibraryImplementation getLibrary() {
        LibraryImplementation lib = this.library;
        this.library = null;
        return lib;
    }

    private static boolean safeEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }
}

