/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableOpenSupport;

public class JSFConfigEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie,
CloseCookie {
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            JSFConfigDataObject obj = (JSFConfigDataObject)JSFConfigEditorSupport.this.getDataObject();
            JSFConfigEditorSupport.this.restartTimer();
            obj.parsingDocument();
            if (obj.isDocumentValid()) {
                JSFConfigEditorSupport.this.saveDocument();
            } else {
                DialogDescriptor dialog = new DialogDescriptor((Object)NbBundle.getMessage(JSFConfigEditorSupport.class, (String)"MSG_invalidXmlWarning"), NbBundle.getMessage(JSFConfigEditorSupport.class, (String)"TTL_invalidXmlWarning"));
                Dialog d = DialogDisplayer.getDefault().createDialog(dialog);
                d.setVisible(true);
                if (dialog.getValue() == DialogDescriptor.OK_OPTION) {
                    JSFConfigEditorSupport.this.saveDocument();
                }
            }
        }
    };
    private JSFConfigDataObject dataObject;
    private RequestProcessor.Task parsingDocumentTask;
    private static final int AUTO_PARSING_DELAY = 2000;

    public JSFConfigEditorSupport(JSFConfigDataObject dobj) {
        super((DataObject)dobj, (CloneableEditorSupport.Env)new XmlEnv(dobj));
        this.dataObject = dobj;
        this.setMIMEType("text/x-jsf+xml");
        this.initialize();
    }

    private void initialize() {
        final DocumentListener docListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.change(e);
            }

            public void changedUpdate(DocumentEvent e) {
            }

            public void removeUpdate(DocumentEvent e) {
                this.change(e);
            }

            private void change(DocumentEvent e) {
                if (!JSFConfigEditorSupport.this.dataObject.isNodeDirty()) {
                    JSFConfigEditorSupport.this.restartTimer();
                }
            }
        };
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("document".equals(evt.getPropertyName()) && JSFConfigEditorSupport.this.isDocumentLoaded() && JSFConfigEditorSupport.this.getDocument() != null) {
                    JSFConfigEditorSupport.this.getDocument().addDocumentListener(docListener);
                }
            }
        });
    }

    public void saveDocument() throws IOException {
        final StyledDocument doc = this.getDocument();
        String defaultEncoding = "UTF-8";
        String enc = EncodingUtil.detectEncoding((Document)doc);
        boolean changeEncodingToDefault = false;
        if (enc == null) {
            enc = defaultEncoding;
        }
        if (!this.isSupportedEncoding(enc)) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JSFConfigEditorSupport.class, (String)"MSG_BadEncodingDuringSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), enc, defaultEncoding}), 0, 2);
            nd.setValue(NotifyDescriptor.NO_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
            changeEncodingToDefault = true;
        }
        if (!changeEncodingToDefault) {
            try {
                CharsetEncoder coder = Charset.forName(enc).newEncoder();
                if (!coder.canEncode(doc.getText(0, doc.getLength()))) {
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JSFConfigEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), enc}), 0, 2);
                    nd.setValue(NotifyDescriptor.NO_OPTION);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                        return;
                    }
                }
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            super.saveDocument();
            this.getDataObject().setModified(false);
        } else {
            try {
                int MAX_PROLOG = 1000;
                int maxPrologLen = Math.min(1000, doc.getLength());
                final char[] prolog = doc.getText(0, maxPrologLen).toCharArray();
                int prologLen = 0;
                if (prolog[0] == '<' && prolog[1] == '?' && prolog[2] == 'x') {
                    for (int i = 3; i < maxPrologLen; ++i) {
                        if (prolog[i] != '?' || prolog[i + 1] != '>') continue;
                        prologLen = i + 1;
                        break;
                    }
                }
                final int passPrologLen = prologLen;
                Runnable edit = new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                doc.remove(0, passPrologLen + 1);
                                doc.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?> \n<!-- was: " + new String(prolog, 0, passPrologLen + 1) + " -->", null);
                            }
                            catch (BadLocationException e) {
                                if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                                e.printStackTrace();
                            }
                        }
                    }
                };
                NbDocument.runAtomic((StyledDocument)doc, (Runnable)edit);
                super.saveDocument();
                this.getDataObject().setModified(false);
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    private boolean isSupportedEncoding(String encoding) {
        boolean supported;
        try {
            supported = Charset.isSupported(encoding);
        }
        catch (IllegalCharsetNameException e) {
            supported = false;
        }
        return supported;
    }

    public void restartTimer() {
        if (this.parsingDocumentTask == null || this.parsingDocumentTask.isFinished() || this.parsingDocumentTask.cancel()) {
            this.dataObject.setDocumentDirty(true);
            Runnable r = new Runnable(){

                public void run() {
                    JSFConfigEditorSupport.this.dataObject.parsingDocument();
                }
            };
            this.parsingDocumentTask = this.parsingDocumentTask != null ? RequestProcessor.getDefault().post(r, 2000) : RequestProcessor.getDefault().post(r, 100);
        }
    }

    protected boolean notifyModified() {
        boolean notif = super.notifyModified();
        if (!notif) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    private void addSaveCookie() {
        if (this.dataObject.getCookie(SaveCookie.class) == null) {
            this.dataObject.getCookieSet0().add((Node.Cookie)this.saveCookie);
            this.dataObject.setModified(true);
        }
    }

    private void removeSaveCookie() {
        JSFConfigDataObject obj = (JSFConfigDataObject)this.getDataObject();
        Node.Cookie cookie = obj.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.getCookieSet0().remove((Node.Cookie)this.saveCookie);
            obj.setModified(false);
        }
    }

    public void open() {
        super.open();
        this.restartTimer();
    }

    private static class XmlEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -800036748848958489L;

        public XmlEnv(JSFConfigDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((JSFConfigDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (JSFConfigEditorSupport)this.getDataObject().getCookie(JSFConfigEditorSupport.class);
        }
    }
}

