/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.moveclass;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.moveclass.AbstractMoveClassRefactoringElement;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class WebXmlMoveClassRefactoring {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.rename");

    public Problem prepare(MoveClassRefactoring moveClassRefactor, Collection resources, RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        for (Resource resource : resources) {
            FileObject fo = JavaModel.getFileObject((Resource)resource);
            err.log("resource package name:  " + resource.getPackageName());
            err.log("resource: name " + resource.getName());
            Collection wmodules = Utility.getRelevantWebModules(fo);
            Iterator wmIter = null;
            if (wmodules != null) {
                wmIter = wmodules.iterator();
            }
            if (wmIter == null) continue;
            while (wmIter.hasNext()) {
                Problem newProblem;
                WebModule wm = (WebModule)wmIter.next();
                WebModule wmNew = null;
                if (wm == null) continue;
                Project prj1 = FileOwnerQuery.getOwner((FileObject)wm.getDeploymentDescriptor());
                Project prj2 = null;
                FileObject target = moveClassRefactor.getTargetClassPathRoot();
                if (target != null) {
                    prj2 = FileOwnerQuery.getOwner((FileObject)target);
                }
                boolean moveToAnotherProject = false;
                if (prj2 != null) {
                    boolean bl = moveToAnotherProject = !prj1.equals(prj2);
                }
                if (moveToAnotherProject) {
                    wmNew = WebModule.getWebModule((FileObject)target);
                }
                if (moveToAnotherProject && wmNew == null) continue;
                FileObject webXmlFO = wm.getDeploymentDescriptor();
                FileObject newWebXmlFO = null;
                WebApp webXmlDD = null;
                WebApp newWebXmlDD = null;
                try {
                    webXmlDD = DDProvider.getDefault().getDDRoot(webXmlFO);
                    if (moveToAnotherProject) {
                        newWebXmlFO = wmNew.getDeploymentDescriptor();
                        newWebXmlDD = DDProvider.getDefault().getDDRoot(newWebXmlFO);
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (webXmlDD != null && webXmlDD.getStatus() != 2) {
                    if (moveToAnotherProject && newWebXmlDD == null) {
                        newProblem = new Problem(false, NbBundle.getMessage(WebXmlMoveClassRefactoring.class, (String)"TXT_WebXmlMoveClassInvalidProblem"));
                        problem = Utility.addProblemsToEnd(problem, newProblem);
                        continue;
                    }
                    List classes = resource.getClassifiers();
                    err.log("Classes in resource: " + classes);
                    for (int j = 0; j < classes.size(); ++j) {
                        EjbLocalRef[] localRefs;
                        AbstractMoveClassRefactoringElement elem;
                        EjbRef[] refs;
                        Filter[] filters;
                        Listener[] listeners;
                        JavaClass jClass = (JavaClass)classes.get(j);
                        err.log("javaclass: " + jClass);
                        String name = jClass.getName();
                        err.log("name: " + name);
                        String targetPackage = moveClassRefactor.getTargetPackageName(resource);
                        err.log("targetPackage: " + targetPackage);
                        String newName = targetPackage + "." + jClass.getSimpleName();
                        err.log("newname: " + newName);
                        Servlet[] servlets = webXmlDD.getServlet();
                        if (servlets != null && servlets.length > 0) {
                            for (int s = 0; s < servlets.length; ++s) {
                                AbstractMoveClassRefactoringElement elem2;
                                Servlet servlet = servlets[s];
                                err.log("Servlet: " + servlet);
                                String servletClass = servlet.getServletClass();
                                err.log("Servlet class: " + servletClass);
                                if (servletClass == null || !servletClass.equals(name)) continue;
                                if (!moveToAnotherProject) {
                                    elem2 = new WebXmlServletMoveClassRefactoringElement(webXmlDD, name, newName, webXmlFO);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem2);
                                    continue;
                                }
                                elem2 = new WebXmlServletReferenceMoveClassOtherProjectRefactoringElement(webXmlDD, newWebXmlDD, name, newName, webXmlFO, newWebXmlFO);
                                refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem2);
                            }
                        }
                        if ((listeners = webXmlDD.getListener()) != null && listeners.length > 0) {
                            for (int s = 0; s < listeners.length; ++s) {
                                AbstractMoveClassRefactoringElement elem3;
                                Listener listener = listeners[s];
                                err.log("Listener: " + listener);
                                String listenerClass = listener.getListenerClass();
                                err.log("Listener class: " + listenerClass);
                                if (listenerClass == null || !listenerClass.equals(name)) continue;
                                if (!moveToAnotherProject) {
                                    elem3 = new WebXmlListenerMoveClassRefactoringElement(webXmlDD, name, newName, webXmlFO);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem3);
                                    continue;
                                }
                                elem3 = new WebXmlListenerReferenceMoveClassOtherProjectRefactoringElement(webXmlDD, newWebXmlDD, name, newName, webXmlFO, newWebXmlFO);
                                refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem3);
                            }
                        }
                        if ((filters = webXmlDD.getFilter()) != null && filters.length > 0) {
                            for (int s = 0; s < filters.length; ++s) {
                                AbstractMoveClassRefactoringElement elem4;
                                Filter filter = filters[s];
                                err.log("Filter: " + filter);
                                String filterClass = filter.getFilterClass();
                                err.log("Filter class: " + filterClass);
                                if (filterClass == null || !filterClass.equals(name)) continue;
                                if (!moveToAnotherProject) {
                                    elem4 = new WebXmlFilterMoveClassRefactoringElement(webXmlDD, name, newName, webXmlFO);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem4);
                                    continue;
                                }
                                elem4 = new WebXmlFilterReferenceMoveClassOtherProjectRefactoringElement(webXmlDD, newWebXmlDD, name, newName, webXmlFO, newWebXmlFO);
                                refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem4);
                            }
                        }
                        if ((refs = webXmlDD.getEjbRef()) != null && refs.length > 0) {
                            for (int l = 0; l < refs.length; ++l) {
                                EjbRef ref = refs[l];
                                err.log("EJB ref: " + ref);
                                String refHome = ref.getHome();
                                err.log("home ref: " + refHome);
                                if (refHome != null && refHome.equals(name)) {
                                    WebXmlRefHomeMoveClassRefactoringElement elem5 = new WebXmlRefHomeMoveClassRefactoringElement(webXmlDD, name, newName, webXmlFO);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem5);
                                }
                                String refRemote = ref.getRemote();
                                err.log("localHome ref: " + refRemote);
                                if (refRemote == null || !refRemote.equals(name)) continue;
                                elem = new WebXmlRefRemoteMoveClassRefactoringElement(webXmlDD, name, newName, webXmlFO);
                                refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem);
                            }
                        }
                        if ((localRefs = webXmlDD.getEjbLocalRef()) == null || localRefs.length <= 0) continue;
                        for (int l = 0; l < localRefs.length; ++l) {
                            EjbLocalRef localRef = localRefs[l];
                            err.log("EJB local ref: " + localRef);
                            String refLocal = localRef.getLocal();
                            err.log("local ref: " + refLocal);
                            if (refLocal != null && refLocal.equals(name)) {
                                elem = new WebXmlRefLocalMoveClassRefactoringElement(webXmlDD, name, newName, webXmlFO);
                                refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem);
                            }
                            String refLocalHome = localRef.getLocalHome();
                            err.log("localHome ref: " + refLocalHome);
                            if (refLocalHome == null || !refLocalHome.equals(name)) continue;
                            WebXmlRefLocalHomeMoveClassRefactoringElement elem6 = new WebXmlRefLocalHomeMoveClassRefactoringElement(webXmlDD, name, newName, webXmlFO);
                            refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem6);
                        }
                    }
                    continue;
                }
                newProblem = new Problem(false, NbBundle.getMessage(WebXmlMoveClassRefactoring.class, (String)"TXT_WebXmlMoveClassInvalidProblem"));
                problem = Utility.addProblemsToEnd(problem, newProblem);
            }
        }
        return problem;
    }

    public final class WebXmlRefLocalHomeMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;

        public WebXmlRefLocalHomeMoveClassRefactoringElement(WebApp webXmlDD, String oldName, String newName, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, (String)"TXT_WebXmlRefLocalHomeMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EjbLocalRef[] refs = this.webXmlDD.getEjbLocalRef();
            EjbLocalRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String refStr = refs[i].getLocalHome();
                if (!this.oldName.equals(refStr)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setLocalHome(this.newName);
                try {
                    this.webXmlDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, ioe.getMessage());
                }
            }
        }

        public void undoExternalChange() {
            EjbLocalRef[] refs = this.webXmlDD.getEjbLocalRef();
            EjbLocalRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String refStr = refs[i].getLocalHome();
                if (!this.newName.equals(refStr)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setLocalHome(this.oldName);
                try {
                    this.webXmlDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, ioe.getMessage());
                }
            }
        }
    }

    public final class WebXmlRefLocalMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;

        public WebXmlRefLocalMoveClassRefactoringElement(WebApp webXmlDD, String oldName, String newName, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, (String)"TXT_WebXmlRefLocalMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EjbLocalRef[] refs = this.webXmlDD.getEjbLocalRef();
            EjbLocalRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String refStr = refs[i].getLocal();
                if (!this.oldName.equals(refStr)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setLocal(this.newName);
                try {
                    this.webXmlDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, ioe.getMessage());
                }
            }
        }

        public void undoExternalChange() {
            EjbLocalRef[] refs = this.webXmlDD.getEjbLocalRef();
            EjbLocalRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String refStr = refs[i].getLocal();
                if (!this.newName.equals(refStr)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setLocal(this.oldName);
                try {
                    this.webXmlDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, ioe.getMessage());
                }
            }
        }
    }

    public final class WebXmlRefRemoteMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;

        public WebXmlRefRemoteMoveClassRefactoringElement(WebApp webXmlDD, String oldName, String newName, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, (String)"TXT_WebXmlRefRemoteMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EjbRef[] refs = this.webXmlDD.getEjbRef();
            EjbRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String refStr = refs[i].getRemote();
                if (!this.oldName.equals(refStr)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setRemote(this.newName);
                try {
                    this.webXmlDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, ioe.getMessage());
                }
            }
        }

        public void undoExternalChange() {
            EjbRef[] refs = this.webXmlDD.getEjbRef();
            EjbRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String refStr = refs[i].getRemote();
                if (!this.newName.equals(refStr)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setRemote(this.oldName);
                try {
                    this.webXmlDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, ioe.getMessage());
                }
            }
        }
    }

    public final class WebXmlRefHomeMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;

        public WebXmlRefHomeMoveClassRefactoringElement(WebApp webXmlDD, String oldName, String newName, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, (String)"TXT_WebXmlRefHomeMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EjbRef[] refs = this.webXmlDD.getEjbRef();
            EjbRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String refStr = refs[i].getHome();
                if (!this.oldName.equals(refStr)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setHome(this.newName);
                try {
                    this.webXmlDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, ioe.getMessage());
                }
            }
        }

        public void undoExternalChange() {
            EjbRef[] refs = this.webXmlDD.getEjbRef();
            EjbRef ref = null;
            for (int i = 0; i < refs.length; ++i) {
                String refStr = refs[i].getHome();
                if (!this.newName.equals(refStr)) continue;
                ref = refs[i];
                break;
            }
            if (ref != null) {
                ref.setHome(this.oldName);
                try {
                    this.webXmlDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, ioe.getMessage());
                }
            }
        }
    }

    public final class WebXmlFilterReferenceMoveClassOtherProjectRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;
        protected WebApp newWebXmlDD;
        protected FileObject newXmlFO;
        private Filter filter = null;
        private List filterMappings = null;

        public WebXmlFilterReferenceMoveClassOtherProjectRefactoringElement(WebApp webXmlDD, WebApp newWebXmlDD, String oldName, String newName, FileObject parentFile, FileObject newXmlFO) {
            this.webXmlDD = webXmlDD;
            this.newWebXmlDD = newWebXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
            this.newXmlFO = newXmlFO;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.parentFile.getPath(), this.newXmlFO.getPath()};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, (String)"TXT_WebXmlFilterReferenceMoveClassOtherProject"), args);
        }

        public void performExternalChange() {
            this.filter = (Filter)this.webXmlDD.findBeanByName("Filter", "FilterClass", this.oldName);
            List mappingsToMove = this.getFilterMappings(this.webXmlDD, this.filter.getFilterName());
            for (int i = 0; i < mappingsToMove.size(); ++i) {
                FilterMapping mapping = (FilterMapping)mappingsToMove.get(i);
                this.webXmlDD.removeFilterMapping(mapping);
                this.newWebXmlDD.addFilterMapping(mapping);
            }
            this.filter.setFilterClass(this.newName);
            this.webXmlDD.removeFilter(this.filter);
            this.newWebXmlDD.addFilter(this.filter);
            try {
                this.webXmlDD.write(this.parentFile);
                this.newWebXmlDD.write(this.newXmlFO);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().log(1, ioe.getMessage());
            }
        }

        public void undoExternalChange() {
            if (this.filterMappings != null) {
                for (int i = 0; i < this.filterMappings.size(); ++i) {
                    this.newWebXmlDD.removeFilterMapping((FilterMapping)this.filterMappings.get(i));
                    this.webXmlDD.addFilterMapping((FilterMapping)this.filterMappings.get(i));
                }
            }
            this.filter.setFilterClass(this.oldName);
            this.newWebXmlDD.removeFilter(this.filter);
            this.webXmlDD.addFilter(this.filter);
            try {
                this.webXmlDD.write(this.parentFile);
                this.newWebXmlDD.write(this.newXmlFO);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().log(1, ioe.getMessage());
            }
        }

        private List getFilterMappings(WebApp webApp, String filterName) {
            if (filterName == null) {
                return null;
            }
            FilterMapping[] oldMaps = webApp.getFilterMapping();
            ArrayList<FilterMapping> toMove = new ArrayList<FilterMapping>();
            for (int i = 0; i < oldMaps.length; ++i) {
                if (!filterName.equals(oldMaps[i].getFilterName())) continue;
                toMove.add(oldMaps[i]);
            }
            return toMove;
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }
    }

    public final class WebXmlFilterMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;

        public WebXmlFilterMoveClassRefactoringElement(WebApp webXmlDD, String oldName, String newName, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, (String)"TXT_WebXmlFilterMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            Filter filter = (Filter)this.webXmlDD.findBeanByName("Filter", "FilterClass", this.oldName);
            if (filter != null) {
                filter.setFilterClass(this.newName);
                try {
                    this.webXmlDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, ioe.getMessage());
                }
            }
        }

        public void undoExternalChange() {
            Filter filter = (Filter)this.webXmlDD.findBeanByName("Filter", "FilterClass", this.newName);
            if (filter != null) {
                filter.setFilterClass(this.oldName);
                try {
                    this.webXmlDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, ioe.getMessage());
                }
            }
        }
    }

    public final class WebXmlListenerReferenceMoveClassOtherProjectRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;
        protected WebApp newWebXmlDD;
        protected FileObject newXmlFO;
        private Listener listener = null;

        public WebXmlListenerReferenceMoveClassOtherProjectRefactoringElement(WebApp webXmlDD, WebApp newWebXmlDD, String oldName, String newName, FileObject parentFile, FileObject newXmlFO) {
            this.webXmlDD = webXmlDD;
            this.newWebXmlDD = newWebXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
            this.newXmlFO = newXmlFO;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.parentFile.getPath(), this.newXmlFO.getPath()};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, (String)"TXT_WebXmlListenerReferenceMoveClassOtherProject"), args);
        }

        public void performExternalChange() {
            this.listener = (Listener)this.webXmlDD.findBeanByName("Listener", "ListenerClass", this.oldName);
            this.listener.setListenerClass(this.newName);
            this.webXmlDD.removeListener(this.listener);
            this.newWebXmlDD.addListener(this.listener);
            try {
                this.webXmlDD.write(this.parentFile);
                this.newWebXmlDD.write(this.newXmlFO);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().log(1, ioe.getMessage());
            }
        }

        public void undoExternalChange() {
            this.listener.setListenerClass(this.oldName);
            this.newWebXmlDD.removeListener(this.listener);
            this.webXmlDD.addListener(this.listener);
            try {
                this.webXmlDD.write(this.parentFile);
                this.newWebXmlDD.write(this.newXmlFO);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().log(1, ioe.getMessage());
            }
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }
    }

    public final class WebXmlListenerMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;

        public WebXmlListenerMoveClassRefactoringElement(WebApp webXmlDD, String oldName, String newName, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, (String)"TXT_WebXmlListenerMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            Listener listener = (Listener)this.webXmlDD.findBeanByName("Listener", "ListenerClass", this.oldName);
            if (listener != null) {
                listener.setListenerClass(this.newName);
                try {
                    this.webXmlDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, ioe.getMessage());
                }
            }
        }

        public void undoExternalChange() {
            Listener listener = (Listener)this.webXmlDD.findBeanByName("Listener", "ListenerClass", this.newName);
            if (listener != null) {
                listener.setListenerClass(this.oldName);
                try {
                    this.webXmlDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, ioe.getMessage());
                }
            }
        }
    }

    public final class WebXmlServletReferenceMoveClassOtherProjectRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;
        protected WebApp newWebXmlDD;
        protected FileObject newXmlFO;
        private Servlet servlet = null;
        private List servletMappings = null;

        public WebXmlServletReferenceMoveClassOtherProjectRefactoringElement(WebApp webXmlDD, WebApp newWebXmlDD, String oldName, String newName, FileObject parentFile, FileObject newXmlFO) {
            this.webXmlDD = webXmlDD;
            this.newWebXmlDD = newWebXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
            this.newXmlFO = newXmlFO;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.parentFile.getPath(), this.newXmlFO.getPath()};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, (String)"TXT_WebXmlServletReferenceMoveClassOtherProject"), args);
        }

        public void performExternalChange() {
            this.servlet = (Servlet)this.webXmlDD.findBeanByName("Servlet", "ServletClass", this.oldName);
            List mappingsToMove = this.getServletMappings(this.webXmlDD, this.servlet.getServletName());
            for (int i = 0; i < mappingsToMove.size(); ++i) {
                this.webXmlDD.removeServletMapping((ServletMapping)mappingsToMove.get(i));
                this.newWebXmlDD.addServletMapping((ServletMapping)mappingsToMove.get(i));
            }
            this.servlet.setServletClass(this.newName);
            this.webXmlDD.removeServlet(this.servlet);
            this.newWebXmlDD.addServlet(this.servlet);
            try {
                this.webXmlDD.write(this.parentFile);
                this.newWebXmlDD.write(this.newXmlFO);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().log(1, ioe.getMessage());
            }
        }

        public void undoExternalChange() {
            if (this.servletMappings != null) {
                for (int i = 0; i < this.servletMappings.size(); ++i) {
                    this.newWebXmlDD.removeServletMapping((ServletMapping)this.servletMappings.get(i));
                    this.webXmlDD.addServletMapping((ServletMapping)this.servletMappings.get(i));
                }
            }
            this.servlet.setServletClass(this.oldName);
            this.newWebXmlDD.removeServlet(this.servlet);
            this.webXmlDD.addServlet(this.servlet);
            try {
                this.webXmlDD.write(this.parentFile);
                this.newWebXmlDD.write(this.newXmlFO);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().log(1, ioe.getMessage());
            }
        }

        private List getServletMappings(WebApp webApp, String servletName) {
            if (servletName == null) {
                return null;
            }
            ServletMapping[] oldMaps = webApp.getServletMapping();
            ArrayList<ServletMapping> toMove = new ArrayList<ServletMapping>();
            for (int i = 0; i < oldMaps.length; ++i) {
                if (!servletName.equals(oldMaps[i].getServletName())) continue;
                toMove.add(oldMaps[i]);
            }
            return toMove;
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }
    }

    public final class WebXmlServletMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;

        public WebXmlServletMoveClassRefactoringElement(WebApp webXmlDD, String oldName, String newName, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlMoveClassRefactoring.class, (String)"TXT_WebXmlServletMoveClass"), args);
        }

        public void performExternalChange() {
            Servlet servlet = (Servlet)this.webXmlDD.findBeanByName("Servlet", "ServletClass", this.oldName);
            if (servlet != null) {
                servlet.setServletClass(this.newName);
                try {
                    this.webXmlDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, ioe.getMessage());
                }
            }
        }

        public void undoExternalChange() {
            Servlet servlet = (Servlet)this.webXmlDD.findBeanByName("Servlet", "ServletClass", this.newName);
            if (servlet != null) {
                servlet.setServletClass(this.oldName);
                try {
                    this.webXmlDD.write(this.parentFile);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, ioe.getMessage());
                }
            }
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }
    }
}

