/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.jaxwssupport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.netbeans.modules.websvc.api.jaxws.project.config.EndpointsProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModelProvider;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxWsXmlRefactoringSupport {
    protected static final String WS_ANNOTATION = "WebService";
    protected static final String WSDL_LOCATION_ELEMENT = "wsdlLocation";

    protected JaxWsXmlRefactoringSupport() {
    }

    protected JaxWsModel getModel(JavaClass javaClass) {
        JaxWsModelProvider provider = JaxWsModelProvider.getDefault();
        FileObject fo = JavaModel.getFileObject((Resource)javaClass.getResource());
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        FileObject jaxWsXml = project.getProjectDirectory().getFileObject("nbproject/jax-ws.xml");
        if (jaxWsXml == null) {
            return null;
        }
        JaxWsModel model = null;
        try {
            model = provider.getJaxWsModel(jaxWsXml);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return model;
    }

    protected boolean isWebSvcFromWsdl(JavaClass javaClass) {
        for (Object elem : javaClass.getAnnotations()) {
            Annotation ann = (Annotation)elem;
            if (ann.getTypeName() == null || !ann.getTypeName().getName().equals(WS_ANNOTATION)) continue;
            for (Object elem2 : ann.getAttributeValues()) {
                AttributeValue value = (AttributeValue)elem2;
                if (!value.getName().equals(WSDL_LOCATION_ELEMENT)) continue;
                return true;
            }
        }
        return false;
    }

    protected List<Endpoint> getEndpoints(JavaClass javaClass) {
        Endpoints endpoints = this.getEndpointsModel(javaClass);
        if (endpoints == null) {
            return Collections.emptyList();
        }
        ArrayList<Endpoint> result = new ArrayList<Endpoint>();
        for (Endpoint each : endpoints.getEndpoints()) {
            if (!javaClass.getName().equals(each.getImplementation())) continue;
            result.add(each);
        }
        return result;
    }

    protected Endpoints getEndpointsModel(JavaClass javaClass) {
        FileObject sunjaxwsFile = this.getSunJaxWsXmlFile(javaClass);
        if (sunjaxwsFile == null) {
            return null;
        }
        Endpoints endpoints = null;
        try {
            endpoints = EndpointsProvider.getDefault().getEndpoints(sunjaxwsFile);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return endpoints;
    }

    protected FileObject getSunJaxWsXmlFile(JavaClass javaClass) {
        FileObject javaClassFO = JavaModel.getFileObject((Resource)javaClass.getResource());
        JAXWSSupport jaxwssupport = JAXWSSupport.getJAXWSSupport((FileObject)javaClassFO);
        FileObject folder = jaxwssupport.getDeploymentDescriptorFolder();
        return folder.getFileObject("sun-jaxws.xml");
    }
}

