/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class DeleteWsDialog
extends JPanel {
    public static final String DELETE_NOTHING = "deleteNothing";
    public static final String DELETE_ALL = "deleteALL";
    public static final String DELETE_WS = "deleteWebService";
    public static final String DELETE_PACKAGE = "deletePackage";
    public static final String DELETE_WSDL = "deleteWsdl";
    private String wsName;
    private String packageName;
    private String wsdlName;
    private JCheckBox deletePackageCheckBox;
    private JCheckBox deleteWsdlCheckBox;
    private JLabel jLabel1;

    private DeleteWsDialog(String wsName, String packageName, String wsdlName) {
        this.wsName = wsName;
        this.packageName = packageName;
        this.wsdlName = wsdlName;
        this.initComponents();
        if (wsdlName == null) {
            this.deleteWsdlCheckBox.setVisible(false);
        }
    }

    public static String open(String wsName, String packageName, String wsdlName) {
        String title = NbBundle.getMessage(DeleteWsDialog.class, (String)"MSG_ConfirmDeleteObjectTitle");
        DeleteWsDialog delDialog = new DeleteWsDialog(wsName, packageName, wsdlName);
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)delDialog, title, 0);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (result.equals(NotifyDescriptor.CLOSED_OPTION)) {
            return DELETE_NOTHING;
        }
        if (result.equals(NotifyDescriptor.NO_OPTION)) {
            return DELETE_NOTHING;
        }
        if (delDialog.deletePackage() && delDialog.deleteWsdl()) {
            return DELETE_ALL;
        }
        if (delDialog.deletePackage()) {
            return DELETE_PACKAGE;
        }
        if (delDialog.deleteWsdl()) {
            return DELETE_WSDL;
        }
        return DELETE_WS;
    }

    private boolean deletePackage() {
        return this.deletePackageCheckBox.isSelected();
    }

    private boolean deleteWsdl() {
        if (this.wsdlName == null) {
            return false;
        }
        return this.deleteWsdlCheckBox.isSelected();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.deletePackageCheckBox = new JCheckBox();
        this.deleteWsdlCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText(NbBundle.getMessage(DeleteWsDialog.class, (String)"MSG_ConfirmDeleteObject", (Object[])new Object[]{this.wsName}));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.deletePackageCheckBox.setMnemonic(NbBundle.getMessage(DeleteWsDialog.class, (String)"MSG_DeletePackage_mnem").charAt(0));
        this.deletePackageCheckBox.setText(NbBundle.getMessage(DeleteWsDialog.class, (String)"MSG_DeletePackage", (Object[])new Object[]{this.packageName}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.deletePackageCheckBox, gridBagConstraints);
        this.deleteWsdlCheckBox.setMnemonic(NbBundle.getMessage(DeleteWsDialog.class, (String)"MSG_DeleteWsdl_mnem").charAt(0));
        this.deleteWsdlCheckBox.setSelected(true);
        this.deleteWsdlCheckBox.setText(NbBundle.getMessage(DeleteWsDialog.class, (String)"MSG_DeleteWsdl", (Object[])new Object[]{this.wsdlName}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.deleteWsdlCheckBox, gridBagConstraints);
    }
}

