/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.util.transform;

import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import com.sun.xml.messaging.saaj.util.XMLDeclarationParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class EfficientStreamingTransformer
extends Transformer {
    protected static TransformerFactory transformerFactory = null;
    private Transformer m_realTransformer = null;

    public void clearParameters() {
        if (this.m_realTransformer != null) {
            this.m_realTransformer.clearParameters();
        }
    }

    private void materialize() throws TransformerException {
        if (this.m_realTransformer == null) {
            this.m_realTransformer = EfficientStreamingTransformer.newTransformer();
        }
    }

    public Properties getOutputProperties() {
        try {
            this.materialize();
            return this.m_realTransformer.getOutputProperties();
        }
        catch (TransformerException e) {
            return null;
        }
    }

    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        try {
            this.materialize();
            this.m_realTransformer.setOutputProperties(properties);
        }
        catch (TransformerException e) {}
    }

    public ErrorListener getErrorListener() {
        try {
            this.materialize();
            return this.m_realTransformer.getErrorListener();
        }
        catch (TransformerException e) {
            return null;
        }
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        try {
            this.materialize();
            this.m_realTransformer.setErrorListener(errorListener);
        }
        catch (TransformerException e) {}
    }

    public static Transformer newTransformer() {
        Transformer t = null;
        if (transformerFactory == null) {
            transformerFactory = new TransformerFactoryImpl();
        }
        try {
            t = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException tex) {}
        return t;
    }

    public URIResolver getURIResolver() {
        try {
            this.materialize();
            return this.m_realTransformer.getURIResolver();
        }
        catch (TransformerException e) {
            return null;
        }
    }

    public void setURIResolver(URIResolver uRIResolver) {
        try {
            this.materialize();
            this.m_realTransformer.setURIResolver(uRIResolver);
        }
        catch (TransformerException e) {}
    }

    private InputStream getInputStreamFromSource(StreamSource s) throws TransformerException {
        InputStream stream = s.getInputStream();
        if (stream != null) {
            return stream;
        }
        if (s.getReader() != null) {
            return null;
        }
        String systemId = s.getSystemId();
        if (systemId != null) {
            try {
                String fileURL = systemId;
                if (systemId.startsWith("file:///")) {
                    String driveDesignatedPath;
                    String absolutePath = systemId.substring(7);
                    boolean hasDriveDesignator = absolutePath.indexOf(":") > 0;
                    fileURL = hasDriveDesignator ? (driveDesignatedPath = absolutePath.substring(1)) : absolutePath;
                }
                return new FileInputStream(fileURL);
            }
            catch (IOException e) {
                throw new TransformerException(e.toString());
            }
        }
        throw new TransformerException("Unexpected StreamSource object");
    }

    public Object getParameter(String str) {
        try {
            this.materialize();
            return this.m_realTransformer.getParameter(str);
        }
        catch (TransformerException e) {
            return null;
        }
    }

    public void setParameter(String str, Object obj) {
        try {
            this.materialize();
            this.m_realTransformer.setParameter(str, obj);
        }
        catch (TransformerException e) {}
    }

    public String getOutputProperty(String str) throws IllegalArgumentException {
        try {
            this.materialize();
            return this.m_realTransformer.getOutputProperty(str);
        }
        catch (TransformerException e) {
            return null;
        }
    }

    public void setOutputProperty(String str, String str1) throws IllegalArgumentException {
        try {
            this.materialize();
            this.m_realTransformer.setOutputProperty(str, str1);
        }
        catch (TransformerException e) {}
    }

    /*
     * WARNING - void declaration
     */
    public void transform(Source source, Result result) throws TransformerException {
        if (source instanceof StreamSource && result instanceof StreamResult) {
            block13: {
                try {
                    int num;
                    StreamSource streamSource = (StreamSource)source;
                    InputStream is = this.getInputStreamFromSource(streamSource);
                    OutputStream os = ((StreamResult)result).getOutputStream();
                    if (os == null) {
                        throw new TransformerException("Unexpected StreamResult object contains null OutputStream");
                    }
                    if (is != null) {
                        int num2;
                        if (is.markSupported()) {
                            is.mark(Integer.MAX_VALUE);
                        }
                        byte[] b = new byte[8192];
                        while ((num2 = is.read(b)) != -1) {
                            void var6_9;
                            os.write(b, 0, (int)var6_9);
                        }
                        if (is.markSupported()) {
                            is.reset();
                        }
                        return;
                    }
                    Reader reader = streamSource.getReader();
                    if (reader == null) break block13;
                    if (reader.markSupported()) {
                        reader.mark(Integer.MAX_VALUE);
                    }
                    PushbackReader pushbackReader = new PushbackReader(reader, 10);
                    XMLDeclarationParser ev = new XMLDeclarationParser(pushbackReader);
                    try {
                        ev.parse();
                    }
                    catch (Exception ex) {
                        throw new TransformerException("Unable to run the JAXP transformer on a stream " + ex.getMessage());
                    }
                    OutputStreamWriter writer = new OutputStreamWriter(os, ev.getEncoding());
                    ev.writeTo(writer);
                    char[] ac = new char[8192];
                    while ((num = pushbackReader.read(ac)) != -1) {
                        void var10_15;
                        ((Writer)writer).write(ac, 0, (int)var10_15);
                    }
                    ((Writer)writer).flush();
                    if (reader.markSupported()) {
                        reader.reset();
                    }
                    return;
                }
                catch (IOException e) {
                    throw new TransformerException(e.toString());
                }
            }
            throw new TransformerException("Unexpected StreamSource object");
        }
        this.materialize();
        this.m_realTransformer.transform(source, result);
    }
}

