/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform;

import java.io.IOException;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.modules.ModuleInstall;

public class J2SEPlatformModule
extends ModuleInstall {
    public void restored() {
        super.restored();
        J2SEPlatformModule.updateBuildProperties();
    }

    public static void updateBuildProperties() {
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EditableProperties ep = PropertyUtils.getGlobalProperties();
                    boolean save = J2SEPlatformModule.updateSourceLevel(ep);
                    if (save |= J2SEPlatformModule.updateBuildProperties(ep)) {
                        PropertyUtils.putGlobalProperties((EditableProperties)ep);
                    }
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        });
    }

    private static boolean updateSourceLevel(EditableProperties ep) {
        JavaPlatform platform = JavaPlatformManager.getDefault().getDefaultPlatform();
        String ver = platform.getSpecification().getVersion().toString();
        if (!ver.equals(ep.getProperty("default.javac.source"))) {
            ep.setProperty("default.javac.source", ver);
            ep.setProperty("default.javac.target", ver);
            return true;
        }
        return false;
    }

    private static boolean updateBuildProperties(EditableProperties ep) {
        boolean changed = false;
        JavaPlatform[] installedPlatforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < installedPlatforms.length; ++i) {
            String systemName;
            String key;
            if (installedPlatforms[i].equals(JavaPlatformManager.getDefault().getDefaultPlatform()) || !(installedPlatforms[i] instanceof J2SEPlatformImpl) || ep.containsKey((Object)(key = PlatformConvertor.createName(systemName = ((J2SEPlatformImpl)installedPlatforms[i]).getAntName(), "home")))) continue;
            try {
                PlatformConvertor.generatePlatformProperties(installedPlatforms[i], systemName, ep);
                changed = true;
                continue;
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
        return changed;
    }
}

