/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.view.TreeViewDropSupport;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

final class DragDropUtilities {
    static final boolean dragAndDropEnabled;
    static final int NODE_UP = -1;
    static final int NODE_CENTRAL = 0;
    static final int NODE_DOWN = 1;
    static final Point CURSOR_CENTRAL_POINT;
    static Runnable postDropRun;
    static final int NoDrag = 0;
    static final int NoDrop = 1;
    static final /* synthetic */ boolean $assertionsDisabled;

    private DragDropUtilities() {
    }

    private static boolean isDragAndDropEnabled() {
        if (System.getProperty("netbeans.dnd.enabled") != null) {
            return Boolean.getBoolean("netbeans.dnd.enabled");
        }
        return true;
    }

    static Cursor chooseCursor(Component comp, int dragAction, boolean canDrop) {
        try {
            String name;
            Image image;
            switch (dragAction) {
                case 1: {
                    if (canDrop) {
                        image = Utilities.loadImage((String)"org/openide/resources/cursorscopysingle.gif");
                        name = "ACTION_COPY";
                        break;
                    }
                    image = Utilities.loadImage((String)"org/openide/resources/cursorsnone.gif");
                    name = "NO_ACTION_COPY";
                    break;
                }
                case 2: 
                case 3: {
                    if (canDrop) {
                        image = Utilities.loadImage((String)"org/openide/resources/cursorsmovesingle.gif");
                        name = "ACTION_MOVE";
                        break;
                    }
                    image = Utilities.loadImage((String)"org/openide/resources/cursorsnone.gif");
                    name = "NO_ACTION_MOVE";
                    break;
                }
                case 0x40000000: {
                    if (canDrop) {
                        image = Utilities.loadImage((String)"org/openide/resources/cursorsunknownsingle.gif");
                        name = "ACTION_LINK";
                        break;
                    }
                    image = Utilities.loadImage((String)"org/openide/resources/cursorsnone.gif");
                    name = "NO_ACTION_LINK";
                    break;
                }
                default: {
                    image = Utilities.loadImage((String)"org/openide/resources/cursorsnone.gif");
                    name = "ACTION_NONE";
                }
            }
            return Utilities.createCustomCursor((Component)comp, (Image)image, (String)name);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return DragSource.DefaultMoveNoDrop;
        }
    }

    static boolean checkNodeForAction(Node node, int dragAction) {
        if (node.canCut() && (dragAction == 2 || dragAction == 3)) {
            return true;
        }
        return node.canCopy() && (dragAction == 1 || dragAction == 3 || dragAction == 0x40000000 || dragAction == 0x40000000);
    }

    static Transferable getNodeTransferable(Node[] nodes, int dragAction) throws IOException {
        Transferable[] tArray = new Transferable[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            tArray[i] = (dragAction & 2) != 0 ? nodes[i].clipboardCut() : nodes[i].drag();
        }
        Transferable result = tArray.length == 1 ? tArray[0] : new ExTransferable.Multi(tArray);
        Clipboard c = DragDropUtilities.getClipboard();
        if (c instanceof ExClipboard) {
            return ((ExClipboard)c).convert(result);
        }
        return result;
    }

    static Transferable getNodeTransferable(Node node, int dragAction) throws IOException {
        return DragDropUtilities.getNodeTransferable(new Node[]{node}, dragAction);
    }

    static void setPostDropRun(Runnable run) {
        postDropRun = run;
    }

    private static void invokePostDropRun() {
        if (postDropRun != null) {
            SwingUtilities.invokeLater(postDropRun);
            postDropRun = null;
        }
    }

    static Node[] performPaste(PasteType type, Node targetFolder) {
        try {
            if (targetFolder == null) {
                type.paste();
                return new Node[0];
            }
            Node[] preNodes = targetFolder.getChildren().getNodes(true);
            type.paste();
            Node[] postNodes = targetFolder.getChildren().getNodes(true);
            List<Node> pre = Arrays.asList(preNodes);
            List<Node> post = Arrays.asList(postNodes);
            Iterator<Node> it = post.iterator();
            ArrayList<Node> diff = new ArrayList<Node>();
            while (it.hasNext()) {
                Node n = it.next();
                if (pre.contains(n)) continue;
                diff.add(n);
            }
            return diff.toArray(new Node[diff.size()]);
        }
        catch (UserCancelException exc) {
            return new Node[0];
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return new Node[0];
        }
    }

    static PasteType[] getPasteTypes(Node node, Transferable trans) {
        if (!trans.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            PasteType[] pt = null;
            try {
                pt = node.getPasteTypes(trans);
            }
            catch (NullPointerException npe) {
                ErrorManager.getDefault().notify((Throwable)npe);
            }
            return pt;
        }
        try {
            MultiTransferObject obj = (MultiTransferObject)trans.getTransferData(ExTransferable.multiFlavor);
            int count = obj.getCount();
            Transferable[] t = new Transferable[count];
            PasteType[] p = new PasteType[count];
            PasteType[] curTypes = null;
            for (int i = 0; i < count; ++i) {
                t[i] = obj.getTransferableAt(i);
                curTypes = node.getPasteTypes(t[i]);
                if (curTypes.length == 0) {
                    return curTypes;
                }
                p[i] = curTypes[0];
            }
            return new PasteType[]{new MultiPasteType(t, p)};
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new PasteType[0];
    }

    static PasteType getDropType(Node node, Transferable trans, int action, int dropIndex) {
        if (!trans.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            PasteType pt = null;
            try {
                pt = node.getDropType(trans, action, dropIndex);
            }
            catch (NullPointerException npe) {
                ErrorManager.getDefault().notify((Throwable)npe);
            }
            return pt;
        }
        try {
            MultiTransferObject obj = (MultiTransferObject)trans.getTransferData(ExTransferable.multiFlavor);
            int count = obj.getCount();
            Transferable[] t = new Transferable[count];
            PasteType[] p = new PasteType[count];
            PasteType pt = null;
            for (int i = 0; i < count; ++i) {
                t[i] = obj.getTransferableAt(i);
                pt = node.getDropType(t[i], action, dropIndex);
                if (pt == null) {
                    return pt;
                }
                p[i] = pt;
            }
            return new MultiPasteType(t, p);
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    static void dropNotSuccesfull() {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)TreeViewDropSupport.class).getString("MSG_NoPasteTypes"), 2));
    }

    private static Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    static Node secureFindNode(Object o) {
        if (!$assertionsDisabled && !(o instanceof TreeNode)) {
            throw new AssertionError((Object)("Object " + o + " is instanceof TreeNode"));
        }
        try {
            return Visualizer.findNode(o);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return null;
        }
    }

    static JPopupMenu createDropFinishPopup(final TreeSet pasteTypes) {
        JPopupMenu menu = new JPopupMenu();
        final JMenuItem[] items_ = new JMenuItem[pasteTypes.size()];
        ActionListener aListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem source = (JMenuItem)e.getSource();
                Iterator it = pasteTypes.iterator();
                int i = 0;
                while (it.hasNext()) {
                    PasteType action = (PasteType)it.next();
                    if (items_[i].equals(source)) {
                        DragDropUtilities.performPaste(action, null);
                        DragDropUtilities.invokePostDropRun();
                        break;
                    }
                    ++i;
                }
            }
        };
        Iterator it = pasteTypes.iterator();
        int i = 0;
        while (it.hasNext()) {
            items_[i] = new JMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)items_[i], (String)((PasteType)it.next()).getName());
            items_[i].addActionListener(aListener);
            menu.add(items_[i]);
            ++i;
        }
        menu.addSeparator();
        JMenuItem abortItem = new JMenuItem(NbBundle.getBundle((Class)DragDropUtilities.class).getString("MSG_ABORT"));
        menu.add(abortItem);
        return menu;
    }

    static {
        $assertionsDisabled = !DragDropUtilities.class.desiredAssertionStatus();
        dragAndDropEnabled = DragDropUtilities.isDragAndDropEnabled();
        CURSOR_CENTRAL_POINT = new Point(10, 10);
        postDropRun = null;
    }

    static final class MultiPasteType
    extends PasteType {
        Transferable[] t;
        PasteType[] p;

        MultiPasteType(Transferable[] t, PasteType[] p) {
            this.t = t;
            this.p = p;
        }

        public Transferable paste() throws IOException {
            int size = this.p.length;
            Transferable[] arr = new Transferable[size];
            for (int i = 0; i < size; ++i) {
                arr[i] = this.p[i].paste();
            }
            return new ExTransferable.Multi(arr);
        }
    }
}

