/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.nodes.Node;

class NodePropertyModel
implements ExPropertyModel {
    private Node.Property prop;
    private Object[] beans;
    private PropertyChangeSupport sup = new PropertyChangeSupport(this);
    String beanName = null;

    public NodePropertyModel(Node.Property property, Object[] beans) {
        this.prop = property;
        this.beans = beans;
    }

    String getBeanName() {
        if (this.beans != null && this.beans.length == 1 && this.beans[0] instanceof Node.Property) {
            return ((Node.Property)this.beans[0]).getDisplayName();
        }
        return null;
    }

    public Object getValue() throws InvocationTargetException {
        try {
            return this.prop.getValue();
        }
        catch (IllegalAccessException iae) {
            throw this.annotateException(iae);
        }
        catch (InvocationTargetException ite) {
            throw this.annotateException(ite);
        }
        catch (ProxyNode.DifferentValuesException dve) {
            return null;
        }
    }

    public void setValue(Object v) throws InvocationTargetException {
        try {
            this.prop.setValue(v);
            this.sup.firePropertyChange("value", null, null);
        }
        catch (IllegalAccessException iae) {
            throw this.annotateException(iae);
        }
        catch (IllegalArgumentException iaae) {
            throw this.annotateException(iaae);
        }
        catch (InvocationTargetException ite) {
            throw this.annotateException(ite);
        }
    }

    private InvocationTargetException annotateException(Exception exception) {
        if (exception instanceof InvocationTargetException) {
            return (InvocationTargetException)exception;
        }
        return new InvocationTargetException(exception);
    }

    public Class getPropertyType() {
        return this.prop.getValueType();
    }

    public Class getPropertyEditorClass() {
        PropertyEditor ed = this.prop.getPropertyEditor();
        if (ed != null) {
            return ed.getClass();
        }
        return null;
    }

    public PropertyEditor getPropertyEditor() {
        return PropUtils.getPropertyEditor(this.prop);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.sup.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.sup.removePropertyChangeListener(l);
    }

    public Object[] getBeans() {
        return this.beans;
    }

    public FeatureDescriptor getFeatureDescriptor() {
        return this.prop;
    }

    void fireValueChanged() {
        this.sup.firePropertyChange("value", null, null);
    }

    Node.Property getProperty() {
        return this.prop;
    }
}

