/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Image;
import java.util.StringTokenizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class NestedNode
extends AbstractNode {
    private static final Image IMAGE_GET = Utilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/get.gif");
    private static final Image IMAGE_POST = Utilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/post.gif");
    private static final Image IMAGE_OTHER = Utilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/other.gif");
    private static final Image INFO_BADGE = Utilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/infoBadge.gif");
    private static final Image WARNING_BADGE = Utilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/warningBadge.gif");
    private static final Image ERROR_BADGE = Utilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/errorBadge.gif");
    private static final Image IMAGE_GET_INFO = Utilities.mergeImages((Image)IMAGE_GET, (Image)INFO_BADGE, (int)0, (int)0);
    private static final Image IMAGE_POST_INFO = Utilities.mergeImages((Image)IMAGE_POST, (Image)INFO_BADGE, (int)0, (int)0);
    private static final Image IMAGE_OTHER_INFO = Utilities.mergeImages((Image)IMAGE_OTHER, (Image)INFO_BADGE, (int)0, (int)0);
    private static final Image IMAGE_GET_WARNING = Utilities.mergeImages((Image)IMAGE_GET, (Image)WARNING_BADGE, (int)0, (int)0);
    private static final Image IMAGE_POST_WARNING = Utilities.mergeImages((Image)IMAGE_POST, (Image)WARNING_BADGE, (int)0, (int)0);
    private static final Image IMAGE_OTHER_WARNING = Utilities.mergeImages((Image)IMAGE_OTHER, (Image)WARNING_BADGE, (int)0, (int)0);
    private static final Image IMAGE_GET_ERROR = Utilities.mergeImages((Image)IMAGE_GET, (Image)ERROR_BADGE, (int)0, (int)0);
    private static final Image IMAGE_POST_ERROR = Utilities.mergeImages((Image)IMAGE_POST, (Image)ERROR_BADGE, (int)0, (int)0);
    private static final Image IMAGE_OTHER_ERROR = Utilities.mergeImages((Image)IMAGE_OTHER, (Image)ERROR_BADGE, (int)0, (int)0);
    private String resource = null;
    private String method = null;
    private int statusCode;
    private int[] index;
    private static final boolean debug = false;

    public NestedNode(String resource, String method, int[] index, int statusCode) {
        super(Children.LEAF);
        this.resource = resource;
        this.method = method;
        this.index = index;
        this.statusCode = statusCode;
        this.setProperties();
    }

    public NestedNode(String resource, String method, Children ch, int[] index, int statusCode) {
        super(ch);
        this.resource = resource;
        this.method = method;
        this.index = index;
        this.statusCode = statusCode;
        this.setProperties();
    }

    public String getLongName() {
        return this.getName();
    }

    public Image getIcon(int type) {
        if (this.method.equals("GET")) {
            if (this.statusCode >= 400 || this.statusCode < 0) {
                return IMAGE_GET_ERROR;
            }
            if (this.statusCode >= 300) {
                return IMAGE_GET_WARNING;
            }
            if (this.statusCode >= 200) {
                return IMAGE_GET;
            }
            return IMAGE_GET_INFO;
        }
        if (this.method.equals("POST")) {
            if (this.statusCode >= 400 || this.statusCode < 0) {
                return IMAGE_POST_ERROR;
            }
            if (this.statusCode >= 300) {
                return IMAGE_POST_WARNING;
            }
            if (this.statusCode >= 200) {
                return IMAGE_POST;
            }
            return IMAGE_POST_INFO;
        }
        if (this.statusCode >= 400 || this.statusCode < 0) {
            return IMAGE_OTHER_ERROR;
        }
        if (this.statusCode >= 300) {
            return IMAGE_OTHER_WARNING;
        }
        if (this.statusCode >= 200) {
            return IMAGE_OTHER;
        }
        return IMAGE_OTHER_INFO;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getResource() {
        return this.resource;
    }

    public int[] getIndex() {
        return this.index;
    }

    protected SystemAction[] createActions() {
        return new SystemAction[0];
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    private void setProperties() {
        this.setNameString();
    }

    public void setNameString() {
        String name = null;
        if (this.resource.equals("/")) {
            name = this.resource;
        } else {
            StringTokenizer st = new StringTokenizer(this.resource, "/");
            while (st.hasMoreTokens()) {
                name = st.nextToken();
            }
        }
        this.setName(name);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("NestedNode: ");
        buf.append(this.getName());
        buf.append(", resource=");
        buf.append(this.resource);
        buf.append(", index=");
        for (int i = 0; i < this.index.length; ++i) {
            buf.append(this.index[i]);
            buf.append(",");
        }
        return buf.toString();
    }
}

