/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.settings;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.netbeans.modules.versioning.system.cvss.FileStatusProvider;
import org.openide.options.SystemOption;
import org.openide.util.Lookup;

public class CvsModuleConfig
extends SystemOption {
    private static final long serialVersionUID = 1L;
    public static final String PROP_IGNORED_FILEPATTERNS = "ignoredFilePatterns";
    public static final String PROP_COMMIT_EXCLUSIONS = "commitExclusions";
    public static final String PROP_DEFAULT_VALUES = "defaultValues";
    public static final String PROP_TEXT_ANNOTATIONS_FORMAT = "textAnnotations";
    static int id;

    public static CvsModuleConfig getDefault() {
        return (CvsModuleConfig)CvsModuleConfig.findObject((Class)CvsModuleConfig.class, (boolean)true);
    }

    public String getTextAnnotationsFormat() {
        return (String)this.getProperty(PROP_TEXT_ANNOTATIONS_FORMAT);
    }

    public void setTextAnnotationsFormat(String format) {
        this.putProperty(PROP_TEXT_ANNOTATIONS_FORMAT, format, true);
    }

    public Map getDefaultValues() {
        Map values = (Map)this.getProperty(PROP_DEFAULT_VALUES);
        if (values == null) {
            values = new PersistentHashMap(0);
            this.putProperty(PROP_DEFAULT_VALUES, values, false);
        }
        return values;
    }

    public Object getDefaultValue(String name, Object defaultValue) {
        Object value = this.getDefaultValues().get(name);
        return value != null ? value : defaultValue;
    }

    public String getDefaultValue(String name, String defaultValue) {
        Object value = this.getDefaultValues().get(name);
        return value != null ? (String)value : defaultValue;
    }

    public boolean getDefaultValue(String name, boolean defaultValue) {
        Object value = this.getDefaultValues().get(name);
        return value != null ? (Boolean)value : defaultValue;
    }

    public void setDefaultValue(String name, Object value) {
        Map values = this.getDefaultValues();
        Object oldValue = values.get(name);
        if (oldValue == value || value != null && value.equals(oldValue)) {
            return;
        }
        if (value == null) {
            values.remove(name);
        } else {
            values.put(name, value);
        }
        this.setDefaultValues(new PersistentHashMap(values));
    }

    public void setDefaultValue(String name, boolean value) {
        this.setDefaultValue(name, (Object)value);
    }

    public void setDefaultValues(Map values) {
        this.putProperty(PROP_DEFAULT_VALUES, values, true);
    }

    public Pattern[] getIgnoredFilePatterns() {
        Pattern[] patterns = (Pattern[])this.getProperty(PROP_IGNORED_FILEPATTERNS);
        if (patterns == null) {
            patterns = CvsModuleConfig.getDefaultFilePatterns();
            this.putProperty(PROP_IGNORED_FILEPATTERNS, patterns, false);
        }
        return patterns;
    }

    public void setIgnoredFilePatterns(Pattern[] filePatterns) {
        this.putProperty(PROP_IGNORED_FILEPATTERNS, filePatterns, true);
    }

    public Set getCommitExclusions() {
        Set exclusions = (Set)this.getProperty(PROP_COMMIT_EXCLUSIONS);
        if (exclusions == null) {
            exclusions = new PersistentHashSet(0);
            this.putProperty(PROP_COMMIT_EXCLUSIONS, exclusions, false);
        }
        return exclusions;
    }

    public void setCommitExclusions(Set exclusions) {
        this.putProperty(PROP_COMMIT_EXCLUSIONS, exclusions, true);
    }

    public boolean isExcludedFromCommit(String path) {
        return this.getCommitExclusions().contains(path);
    }

    public void addExclusionPath(String path) {
        Set exclusions = this.getCommitExclusions();
        if (exclusions.add(path)) {
            this.setCommitExclusions(new PersistentHashSet((Collection)exclusions));
            FileStatusProvider statusProvider = (FileStatusProvider)Lookup.getDefault().lookup(FileStatusProvider.class);
            File f = new File(path);
            statusProvider.fireFileStatusEvent(f);
        }
    }

    public void removeExclusionPath(String path) {
        Set exclusions = this.getCommitExclusions();
        if (exclusions.remove(path)) {
            this.setCommitExclusions(new PersistentHashSet((Collection)exclusions));
            FileStatusProvider statusProvider = (FileStatusProvider)Lookup.getDefault().lookup(FileStatusProvider.class);
            File f = new File(path);
            statusProvider.fireFileStatusEvent(f);
        }
    }

    private static Pattern[] getDefaultFilePatterns() {
        return new Pattern[]{Pattern.compile("cvslog\\..*"), Pattern.compile("\\.make\\.state"), Pattern.compile("\\.nse_depinfo"), Pattern.compile(".*~"), Pattern.compile("#.*"), Pattern.compile("\\.#.*"), Pattern.compile(",.*"), Pattern.compile("_\\$.*"), Pattern.compile(".*\\$"), Pattern.compile(".*\\.old"), Pattern.compile(".*\\.bak"), Pattern.compile(".*\\.BAK"), Pattern.compile(".*\\.orig"), Pattern.compile(".*\\.rej"), Pattern.compile(".*\\.del-.*"), Pattern.compile(".*\\.a"), Pattern.compile(".*\\.olb"), Pattern.compile(".*\\.o"), Pattern.compile(".*\\.obj"), Pattern.compile(".*\\.so"), Pattern.compile(".*\\.exe"), Pattern.compile(".*\\.Z"), Pattern.compile(".*\\.elc"), Pattern.compile(".*\\.ln")};
    }

    public String displayName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private static final class PersistentHashMap
    extends HashMap {
        private static final long serialVersionUID = 1L;

        public PersistentHashMap() {
        }

        public PersistentHashMap(Map m) {
            super(m);
        }

        public PersistentHashMap(int initialCapacity) {
            super(initialCapacity);
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(Object o) {
            return this == o;
        }
    }

    private static final class PersistentHashSet
    extends HashSet {
        private static final long serialVersionUID = 1L;

        public PersistentHashSet() {
        }

        public PersistentHashSet(int initialCapacity) {
            super(initialCapacity);
        }

        public PersistentHashSet(Collection c) {
            super(c);
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(Object o) {
            return this == o;
        }
    }
}

