/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.net.SocketFactory;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.importcmd.ImportCommand;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ExtConnection;
import org.netbeans.lib.cvsclient.connection.LocalConnection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.connection.PasswordsFile;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.modules.proxy.ClientSocketFactory;
import org.netbeans.modules.proxy.ConnectivitySettings;
import org.netbeans.modules.versioning.system.cvss.CommandRunnable;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.IllegalCommandException;
import org.netbeans.modules.versioning.system.cvss.SSHConnection;
import org.netbeans.modules.versioning.system.cvss.settings.CvsRootSettings;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ProxyDescriptor;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;

public class ClientRuntime {
    private final String cvsRoot;
    private RequestProcessor requestProcessor;
    private InputOutput log;
    static final /* synthetic */ boolean $assertionsDisabled;

    ClientRuntime(String root) {
        this.cvsRoot = root;
        this.requestProcessor = new RequestProcessor("CVS: " + this.cvsRoot);
        this.log = IOProvider.getDefault().getIO(this.cvsRoot, false);
    }

    private void ensureValidCommand(File[] files) throws IllegalCommandException {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                String root = Utils.getCVSRootFor(file);
                if (root.equals(this.cvsRoot)) continue;
                throw new IllegalCommandException("#63547 command includes files from different CVS root.\n Expected: " + this.cvsRoot + "\nGot:     " + root);
            }
            catch (IOException e) {
                throw new IllegalCommandException("Missing or invalid CVS/Root for: " + file);
            }
        }
    }

    public RequestProcessor.Task createTask(Command cmd, GlobalOptions globalOptions, final ExecutorSupport mgr) throws IllegalCommandException {
        File[] files = this.getCommandFiles(cmd);
        if (!(cmd instanceof CheckoutCommand) && !(cmd instanceof RlogCommand)) {
            this.ensureValidCommand(files);
        }
        if (globalOptions.getCVSRoot() == null) {
            globalOptions = (GlobalOptions)globalOptions.clone();
            globalOptions.setCVSRoot(this.cvsRoot);
        }
        Client client = this.createClient();
        if (!(cmd instanceof RlogCommand)) {
            if (cmd instanceof CheckoutCommand) {
                BasicCommand bc = (BasicCommand)cmd;
                if (bc.getFiles() != null) {
                    String path = bc.getFiles()[0].getAbsolutePath();
                    client.setLocalPath(path);
                } else {
                    client.setLocalPath(System.getProperty("user.dir"));
                }
            } else if (cmd instanceof ImportCommand) {
                client.setLocalPath(((ImportCommand)cmd).getImportDirectory());
            } else {
                this.setLocalDirectory(client, files);
            }
        }
        client.getEventManager().addCVSListener((CVSListener)mgr);
        final CommandRunnable cr = new CommandRunnable(client, globalOptions, cmd, mgr);
        mgr.commandEnqueued(cr);
        RequestProcessor.Task task = this.requestProcessor.create((Runnable)cr);
        task.addTaskListener(new TaskListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void taskFinished(Task task) {
                try {
                    mgr.commandTerminated(new TerminationEvent((Object)new Result(cr)));
                }
                catch (Throwable e) {
                    ErrorManager.getDefault().notify(16, e);
                }
                finally {
                    ClientRuntime.this.log.getOut().close();
                    ClientRuntime.this.log = IOProvider.getDefault().getIO(ClientRuntime.this.cvsRoot, false);
                }
            }
        });
        return task;
    }

    public void log(String message) {
        this.log(message, null);
    }

    public void log(String message, OutputListener hyperlinkListener) {
        if (this.log.isClosed()) {
            this.log = IOProvider.getDefault().getIO(this.cvsRoot, false);
            try {
                this.log.getOut().reset();
            }
            catch (IOException e) {
                ErrorManager err = ErrorManager.getDefault();
                err.notify((Throwable)e);
            }
        }
        if (hyperlinkListener != null) {
            try {
                this.log.getOut().println(message, hyperlinkListener);
            }
            catch (IOException e) {
                this.log.getOut().write(message);
            }
        } else {
            this.log.getOut().write(message);
        }
    }

    public void logError(Throwable e) {
        e.printStackTrace((PrintWriter)this.log.getOut());
    }

    void focusLog() {
        this.log.select();
    }

    public void flushLog() {
        this.log.getOut().close();
    }

    private File[] getCommandFiles(Command cmd) {
        if (cmd instanceof AddCommand) {
            AddCommand c = (AddCommand)cmd;
            return c.getFiles();
        }
        if (cmd instanceof BasicCommand) {
            BasicCommand c = (BasicCommand)cmd;
            return c.getFiles();
        }
        return new File[0];
    }

    private void setLocalDirectory(Client client, File[] files) throws IllegalCommandException {
        if (files.length == 0) {
            return;
        }
        File commonParent = files[0].isDirectory() ? files[0].getParentFile() : files[0].getParentFile();
        for (int i = 1; i < files.length; ++i) {
            if (Utils.isParentOrEqual(commonParent, files[i])) continue;
            do {
                if ((commonParent = commonParent.getParentFile()) != null) continue;
                throw new IllegalCommandException("Files do not have common parent!");
            } while (!Utils.isParentOrEqual(commonParent, files[i]));
        }
        client.setLocalPath(commonParent.getAbsolutePath());
    }

    private Client createClient() {
        Connection connection = ClientRuntime.setupConnection(CVSRoot.parse((String)this.cvsRoot), null);
        Client client = new Client(connection, CvsVersioningSystem.getInstance().getAdminHandler());
        client.setUncompressedFileHandler(CvsVersioningSystem.getInstance().getFileHandler());
        client.setGzipFileHandler(CvsVersioningSystem.getInstance().getGzippedFileHandler());
        return client;
    }

    public static Connection setupConnection(CVSRoot cvsRoot, ProxyDescriptor proxy) throws IllegalArgumentException {
        String method;
        String t9yRoot = System.getProperty("netbeans.t9y.cvs.connection.CVSROOT");
        CVSRoot patchedCvsRoot = cvsRoot;
        if (t9yRoot != null && t9yRoot.length() > 0) {
            int idx = t9yRoot.indexOf(44);
            if (idx != -1) {
                System.setProperty("netbeans.t9y.cvs.connection.CVSROOT", t9yRoot.substring(idx + 1));
                t9yRoot = t9yRoot.substring(0, idx);
            }
            try {
                patchedCvsRoot = CVSRoot.parse((String)t9yRoot);
                if (!$assertionsDisabled && !patchedCvsRoot.getRepository().equals(cvsRoot.getRepository())) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && patchedCvsRoot.getHostName() != cvsRoot.getHostName() && !patchedCvsRoot.getHostName().equals(cvsRoot.getHostName())) {
                    throw new AssertionError();
                }
                ErrorManager.getDefault().log(1, "CVS.ClientRuntime: using patched CVSROOT " + t9yRoot);
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().annotate((Throwable)ex, "While parsing: " + t9yRoot);
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        if (cvsRoot.isLocal()) {
            LocalConnection con = new LocalConnection();
            con.setRepository(cvsRoot.getRepository());
            return con;
        }
        if (proxy == null) {
            proxy = CvsRootSettings.getProxyFor(cvsRoot);
        }
        SocketFactory factory = SocketFactory.getDefault();
        if (proxy.needsProxy(cvsRoot.getHostName())) {
            factory = new ClientSocketFactory(ClientRuntime.toConnectivitySettings(proxy));
        }
        if ("pserver".equals(method = cvsRoot.getMethod())) {
            PServerConnection con = new PServerConnection(patchedCvsRoot, factory);
            String password = PasswordsFile.findPassword((String)cvsRoot.toString());
            con.setEncodedPassword(password);
            return con;
        }
        if ("ext".equals(method)) {
            CvsRootSettings.ExtSettings extSettings = CvsRootSettings.getExtSettingsFor(cvsRoot);
            String userName = cvsRoot.getUserName();
            String host = cvsRoot.getHostName();
            if (extSettings.extUseInternalSsh) {
                int port = patchedCvsRoot.getPort();
                port = port == 0 ? 22 : port;
                String password = extSettings.extPassword;
                if (password == null) {
                    password = "\n";
                }
                SSHConnection sshConnection = new SSHConnection(factory, host, port, userName, password);
                sshConnection.setRepository(cvsRoot.getRepository());
                return sshConnection;
            }
            String command = extSettings.extCommand;
            String cvs_server = System.getProperty("Env-CVS_SERVER", "cvs") + " server";
            String userOption = "";
            if (userName != null) {
                userOption = " -l " + userName;
            }
            command = command + " " + host + userOption + " " + cvs_server;
            ExtConnection connection = new ExtConnection(command);
            connection.setRepository(cvsRoot.getRepository());
            return connection;
        }
        throw new IllegalArgumentException("Unrecognized CVS Root: " + cvsRoot);
    }

    public static ConnectivitySettings toConnectivitySettings(ProxyDescriptor pd) {
        ConnectivitySettings cs = new ConnectivitySettings();
        String pasword = pd.getPassword();
        int port = pd.getPort();
        switch (pd.getType()) {
            case 0: {
                break;
            }
            case 1: {
                if (port <= 0) {
                    ErrorManager.getDefault().log("Assuming default port 8080 for " + pd.getHost() + " HTTP proxy.");
                    port = 8080;
                }
                cs.setProxy(2, pd.getHost(), port, pd.getUserName(), pasword == null ? null : pasword.toCharArray());
                break;
            }
            case 2: {
                if (port <= 0) {
                    ErrorManager.getDefault().log("Assuming default port 1080 for " + pd.getHost() + " SOCKS proxy.");
                    port = 1080;
                }
                cs.setProxy(1, pd.getHost(), port, pd.getUserName(), pasword == null ? null : pasword.toCharArray());
                break;
            }
        }
        return cs;
    }

    public String toString() {
        return "ClientRuntime queue=" + this.cvsRoot + " processor=" + this.requestProcessor;
    }

    static {
        $assertionsDisabled = !ClientRuntime.class.desiredAssertionStatus();
    }

    public static class Result {
        private final CommandRunnable runnable;

        public Result(CommandRunnable runnable) {
            this.runnable = runnable;
        }

        public Throwable getError() {
            return this.runnable.getFailure();
        }

        public boolean isAborted() {
            return this.runnable.isAborted();
        }
    }
}

