/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.esd;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.tritonus.sampled.mixer.esd.EsdSourceDataLine;
import org.tritonus.sampled.mixer.esd.EsdTargetDataLine;
import org.tritonus.share.GlobalInfo;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.mixer.TMixer;
import org.tritonus.share.sampled.mixer.TMixerInfo;
import org.tritonus.share.sampled.mixer.TSoftClip;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EsdMixer
extends TMixer {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static AudioFormat[] FORMATS = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, 1, 1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, 1, 1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, 2, 2, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, 2, 2, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, 1, 1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, 1, 1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, 2, 2, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, 2, 2, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true)};
    private static Line.Info[] SOURCE_LINE_INFOS;
    private static Line.Info[] TARGET_LINE_INFOS;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;
    static /* synthetic */ Class class$javax$sound$sampled$TargetDataLine;
    static /* synthetic */ Class class$javax$sound$sampled$Mixer;

    public void open() {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.open(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.open(): end");
        }
    }

    public void close() {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.close(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.close(): end");
        }
    }

    public int getMaxLines(Line.Info info) {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getMaxLines(): begin");
        }
        int n = 0;
        if (info instanceof DataLine.Info) {
            Class clazz = info.getLineClass();
            Class clazz2 = class$javax$sound$sampled$SourceDataLine;
            if (clazz2 == null) {
                clazz2 = class$javax$sound$sampled$SourceDataLine = EsdMixer.class("[Ljavax.sound.sampled.SourceDataLine;", false);
            }
            if (clazz == clazz2) {
                n = 32;
            } else {
                Class clazz3 = class$javax$sound$sampled$TargetDataLine;
                if (clazz3 == null) {
                    clazz3 = class$javax$sound$sampled$TargetDataLine = EsdMixer.class("[Ljavax.sound.sampled.TargetDataLine;", false);
                }
                if (clazz == clazz3) {
                    n = 1;
                }
            }
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getMaxLines(): end");
        }
        return n;
    }

    protected SourceDataLine getSourceDataLine(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getSourceDataLine(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getSourceDataLine(): format: " + audioFormat);
            TDebug.out("EsdMixer.getSourceDataLine(): buffer size: " + n);
        }
        if (n < 1) {
            n = 32768;
        }
        EsdSourceDataLine esdSourceDataLine = new EsdSourceDataLine((TMixer)this, audioFormat, n);
        esdSourceDataLine.start();
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getSourceDataLine(): returning: " + esdSourceDataLine);
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getSourceDataLine(): end");
        }
        return esdSourceDataLine;
    }

    protected TargetDataLine getTargetDataLine(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getTargetDataLine(): begin");
        }
        int n2 = n * audioFormat.getFrameSize();
        EsdTargetDataLine esdTargetDataLine = new EsdTargetDataLine((TMixer)this, audioFormat, n2);
        esdTargetDataLine.start();
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getTargetDataLine(): returning: " + esdTargetDataLine);
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getTargetDataLine(): end");
        }
        return esdTargetDataLine;
    }

    protected Clip getClip(AudioFormat audioFormat) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getClip(): begin");
        }
        TSoftClip tSoftClip = new TSoftClip((Mixer)this, audioFormat);
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getClip(): end");
        }
        return tSoftClip;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public EsdMixer() {
        TMixerInfo tMixerInfo = new TMixerInfo("Esd Mixer", GlobalInfo.getVendor(), "Mixer for the Enlightened Sound Daemon (esd) running on the local machine", GlobalInfo.getVersion());
        Class clazz = class$javax$sound$sampled$Mixer;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$Mixer = EsdMixer.class("[Ljavax.sound.sampled.Mixer;", false);
        }
        super(tMixerInfo, new Line.Info(clazz), Arrays.asList(FORMATS), Arrays.asList(FORMATS), Arrays.asList(SOURCE_LINE_INFOS), Arrays.asList(TARGET_LINE_INFOS));
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.<init>: begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.<init>: end");
        }
    }

    static {
        Line.Info[] infoArray = new Line.Info[1];
        Class clazz = class$javax$sound$sampled$SourceDataLine;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$SourceDataLine = EsdMixer.class("[Ljavax.sound.sampled.SourceDataLine;", false);
        }
        infoArray[0] = new DataLine.Info(clazz, FORMATS, -1, -1);
        SOURCE_LINE_INFOS = infoArray;
        Line.Info[] infoArray2 = new Line.Info[1];
        Class clazz2 = class$javax$sound$sampled$TargetDataLine;
        if (clazz2 == null) {
            clazz2 = class$javax$sound$sampled$TargetDataLine = EsdMixer.class("[Ljavax.sound.sampled.TargetDataLine;", false);
        }
        infoArray2[0] = new DataLine.Info(clazz2, FORMATS, -1, -1);
        TARGET_LINE_INFOS = infoArray2;
    }
}

