/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import org.tritonus.sampled.file.WaveTool;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioOutputStream;
import org.tritonus.share.sampled.file.TDataOutputStream;

public class WaveAudioOutputStream
extends TAudioOutputStream {
    private static final int LENGTH_NOT_KNOWN = -1;
    private int formatCode;

    protected void writeHeader() throws IOException {
        if (TDebug.TraceAudioOutputStream) {
            TDebug.out("WaveAudioOutputStream.writeHeader()");
        }
        AudioFormat audioFormat = this.getFormat();
        long l = this.getLength();
        int n = 0;
        if (this.formatCode == 49) {
            n += 2;
        }
        int n2 = 46 + n;
        if (this.formatCode != 1) {
            n2 += 12;
        }
        if (l != (long)-1 && l + (long)n2 > 0xFFFFFFFFL) {
            l = 0xFFFFFFFFL - (long)n2;
        }
        long l2 = l + l % (long)2;
        TDataOutputStream tDataOutputStream = this.getDataOutputStream();
        tDataOutputStream.writeInt(1380533830);
        tDataOutputStream.writeLittleEndian32((int)(l2 + (long)n2 - 8L & (long)-1));
        tDataOutputStream.writeInt(1463899717);
        int n3 = 18 + n;
        short s = (short)audioFormat.getSampleSizeInBits();
        int n4 = 1;
        if (this.formatCode == 49) {
            n4 = audioFormat.getFrameSize() == 33 ? 320 : (audioFormat.getFrameSize() == 65 ? 320 : (int)((float)audioFormat.getFrameSize() * 4.923077f));
            s = 0;
        }
        int n5 = (int)audioFormat.getSampleRate() / n4 * audioFormat.getFrameSize();
        tDataOutputStream.writeInt(1718449184);
        tDataOutputStream.writeLittleEndian32(n3);
        tDataOutputStream.writeLittleEndian16((short)this.formatCode);
        tDataOutputStream.writeLittleEndian16((short)audioFormat.getChannels());
        tDataOutputStream.writeLittleEndian32((int)audioFormat.getSampleRate());
        tDataOutputStream.writeLittleEndian32(n5);
        tDataOutputStream.writeLittleEndian16((short)audioFormat.getFrameSize());
        tDataOutputStream.writeLittleEndian16(s);
        tDataOutputStream.writeLittleEndian16((short)n);
        if (this.formatCode == 49) {
            tDataOutputStream.writeLittleEndian16((short)n4);
        }
        if (this.formatCode != 1) {
            long l3 = 0L;
            if (l != (long)-1) {
                l3 = l / (long)audioFormat.getFrameSize() * (long)n4;
            }
            if (l3 > 0xFFFFFFFFL) {
                l3 = 0xFFFFFFFFL / (long)n4 * (long)n4;
            }
            tDataOutputStream.writeInt(1717658484);
            tDataOutputStream.writeLittleEndian32(4);
            tDataOutputStream.writeLittleEndian32((int)(l3 & (long)-1));
        }
        tDataOutputStream.writeInt(1684108385);
        tDataOutputStream.writeLittleEndian32(l != (long)-1 ? (int)l : -1);
    }

    protected void patchHeader() throws IOException {
        TDataOutputStream tDataOutputStream = this.getDataOutputStream();
        tDataOutputStream.seek(0L);
        this.setLengthFromCalculatedLength();
        this.writeHeader();
    }

    public void close() throws IOException {
        long l = this.getCalculatedLength();
        if (l % (long)2 == 1L) {
            if (TDebug.TraceAudioOutputStream) {
                TDebug.out("WaveOutputStream.close(): adding padding byte");
            }
            TDataOutputStream tDataOutputStream = this.getDataOutputStream();
            tDataOutputStream.writeByte(0);
        }
        super.close();
    }

    public WaveAudioOutputStream(AudioFormat audioFormat, long l, TDataOutputStream tDataOutputStream) {
        boolean bl = false;
        if (l == (long)-1 && tDataOutputStream.supportsSeek()) {
            bl = true;
        }
        super(audioFormat, l, tDataOutputStream, bl);
        if (l != (long)-1 && l + 46L > 0xFFFFFFFFL) {
            if (TDebug.TraceAudioOutputStream) {
                TDebug.out("WaveAudioOutputStream: Length exceeds 4GB: " + l + "=0x" + Long.toHexString(l) + " with header=" + (l + 46L) + "=0x" + Long.toHexString(l + 46L));
            }
            throw new IllegalArgumentException("Wave files cannot be larger than 4GB.");
        }
        this.formatCode = WaveTool.getFormatCode(this.getFormat());
        if (this.formatCode == 0) {
            throw new IllegalArgumentException("Unknown encoding/format for this wave file.");
        }
    }
}

